/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.Force;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.Spring;

public abstract class AbstractForce
implements Force {
    protected float[] params;
    protected float[] minValues;
    protected float[] maxValues;

    public void init(ForceSimulator forceSimulator) {
    }

    public int getParameterCount() {
        return this.params == null ? 0 : this.params.length;
    }

    public float getParameter(int n) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.params[n];
    }

    public float getMinValue(int n) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.minValues[n];
    }

    public float getMaxValue(int n) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.maxValues[n];
    }

    public String getParameterName(int n) {
        String[] stringArray = this.getParameterNames();
        if (n < 0 || stringArray == null || n >= stringArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return stringArray[n];
    }

    public void setParameter(int n, float f) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.params[n] = f;
    }

    public void setMinValue(int n, float f) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.minValues[n] = f;
    }

    public void setMaxValue(int n, float f) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.maxValues[n] = f;
    }

    protected abstract String[] getParameterNames();

    public boolean isItemForce() {
        return false;
    }

    public boolean isSpringForce() {
        return false;
    }

    public void getForce(ForceItem forceItem) {
        throw new UnsupportedOperationException("This class does not support this operation");
    }

    public void getForce(Spring spring) {
        throw new UnsupportedOperationException("This class does not support this operation");
    }
}

