/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import prefuse.Visualization;
import prefuse.data.CascadedTable;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.expression.Predicate;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTupleSet;
import prefuse.visual.tuple.TableVisualItem;

public class VisualTable
extends CascadedTable
implements VisualTupleSet {
    private Visualization m_vis;
    private String m_group;

    public VisualTable(Table table, Visualization visualization, String string) {
        this(table, visualization, string, null, VisualItem.SCHEMA);
    }

    public VisualTable(Table table, Visualization visualization, String string, Predicate predicate) {
        this(table, visualization, string, predicate, VisualItem.SCHEMA);
    }

    public VisualTable(Table table, Visualization visualization, String string, Predicate predicate, Schema schema) {
        super(table, predicate, null, TableVisualItem.class);
        this.init(visualization, string, schema);
    }

    public VisualTable(Visualization visualization, String string) {
        super(TableVisualItem.class);
        this.init(visualization, string, VisualItem.SCHEMA);
    }

    public VisualTable(Visualization visualization, String string, Schema schema) {
        super(TableVisualItem.class);
        this.init(visualization, string, schema);
    }

    public VisualTable(Visualization visualization, String string, Schema schema, Class clazz) {
        super(clazz);
        this.init(visualization, string, schema);
    }

    protected void init(Visualization visualization, String string, Schema schema) {
        this.setVisualization(visualization);
        this.setGroup(string);
        this.addColumns(schema);
        if (this.canGetBoolean(VisualItem.VISIBLE)) {
            this.index(VisualItem.VISIBLE);
        }
        if (this.canGetBoolean(VisualItem.STARTVISIBLE)) {
            this.index(VisualItem.STARTVISIBLE);
        }
        if (this.canGetBoolean(VisualItem.VALIDATED)) {
            this.index(VisualItem.VALIDATED);
        }
    }

    protected void fireTableEvent(int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            if (n3 != VisualItem.IDX_VALIDATED) {
                for (int i = n; i <= n2; ++i) {
                    this.setValidated(i, false);
                }
            } else {
                for (int i = n; i <= n2; ++i) {
                    if (this.isValidated(i)) continue;
                    this.m_vis.damageReport(this.getItem(i), this.getBounds(i));
                }
            }
        } else if (n4 == -1 && n3 == -1) {
            for (int i = n; i <= n2; ++i) {
                if (!this.isVisible(i) || !this.isValidated(i)) continue;
                VisualItem visualItem = (VisualItem)this.getTuple(i);
                this.m_vis.damageReport(visualItem, this.getBounds(i));
            }
        }
        super.fireTableEvent(n, n2, n3, n4);
    }

    public Visualization getVisualization() {
        return this.m_vis;
    }

    public void setVisualization(Visualization visualization) {
        this.m_vis = visualization;
    }

    public String getGroup() {
        return this.m_group;
    }

    public void setGroup(String string) {
        this.m_group = string;
    }

    public VisualItem getItem(int n) {
        return (VisualItem)this.getTuple(n);
    }

    public VisualItem addItem() {
        return this.getItem(this.addRow());
    }

    public boolean isValidated(int n) {
        return this.getBoolean(n, VisualItem.VALIDATED);
    }

    public void setValidated(int n, boolean bl) {
        this.setBoolean(n, VisualItem.VALIDATED, bl);
    }

    public boolean isVisible(int n) {
        return this.getBoolean(n, VisualItem.VISIBLE);
    }

    public void setVisible(int n, boolean bl) {
        this.setBoolean(n, VisualItem.VISIBLE, bl);
    }

    public boolean isStartVisible(int n) {
        return this.getBoolean(n, VisualItem.STARTVISIBLE);
    }

    public void setStartVisible(int n, boolean bl) {
        this.setBoolean(n, VisualItem.STARTVISIBLE, bl);
    }

    public boolean isEndVisible(int n) {
        return this.getBoolean(n, VisualItem.ENDVISIBLE);
    }

    public void setEndVisible(int n, boolean bl) {
        this.setBoolean(n, VisualItem.ENDVISIBLE, bl);
    }

    public boolean isInteractive(int n) {
        return this.getBoolean(n, VisualItem.INTERACTIVE);
    }

    public void setInteractive(int n, boolean bl) {
        this.setBoolean(n, VisualItem.INTERACTIVE, bl);
    }

    public boolean isExpanded(int n) {
        return this.getBoolean(n, VisualItem.EXPANDED);
    }

    public void setExpanded(int n, boolean bl) {
        this.setBoolean(n, VisualItem.EXPANDED, bl);
    }

    public boolean isFixed(int n) {
        return this.getBoolean(n, VisualItem.FIXED);
    }

    public void setFixed(int n, boolean bl) {
        this.setBoolean(n, VisualItem.FIXED, bl);
    }

    public boolean isHighlighted(int n) {
        return this.getBoolean(n, VisualItem.HIGHLIGHT);
    }

    public void setHighlighted(int n, boolean bl) {
        this.setBoolean(n, VisualItem.HIGHLIGHT, bl);
    }

    public boolean isHover(int n) {
        return this.getBoolean(n, VisualItem.HOVER);
    }

    public void setHover(int n, boolean bl) {
        this.setBoolean(n, VisualItem.HOVER, bl);
    }

    public double getX(int n) {
        return this.getDouble(n, VisualItem.X);
    }

    public void setX(int n, double d) {
        this.setDouble(n, VisualItem.X, d);
    }

    public double getY(int n) {
        return this.getDouble(n, VisualItem.Y);
    }

    public void setY(int n, double d) {
        this.setDouble(n, VisualItem.Y, d);
    }

    public double getStartX(int n) {
        return this.getDouble(n, VisualItem.STARTX);
    }

    public void setStartX(int n, double d) {
        this.setDouble(n, VisualItem.STARTX, d);
    }

    public double getStartY(int n) {
        return this.getDouble(n, VisualItem.STARTY);
    }

    public void setStartY(int n, double d) {
        this.setDouble(n, VisualItem.STARTY, d);
    }

    public double getEndX(int n) {
        return this.getDouble(n, VisualItem.ENDX);
    }

    public void setEndX(int n, double d) {
        this.setDouble(n, VisualItem.ENDX, d);
    }

    public double getEndY(int n) {
        return this.getDouble(n, VisualItem.ENDY);
    }

    public void setEndY(int n, double d) {
        this.setDouble(n, VisualItem.ENDY, d);
    }

    public Rectangle2D getBounds(int n) {
        return (Rectangle2D)this.get(n, VisualItem.BOUNDS);
    }

    public void setBounds(int n, double d, double d2, double d3, double d4) {
        this.getBounds(n).setRect(d, d2, d3, d4);
        this.fireTableEvent(n, n, this.getColumnNumber(VisualItem.BOUNDS), 0);
    }

    public int getStrokeColor(int n) {
        return this.getInt(n, VisualItem.STROKECOLOR);
    }

    public void setStrokeColor(int n, int n2) {
        this.setInt(n, VisualItem.STROKECOLOR, n2);
    }

    public int getStartStrokeColor(int n) {
        return this.getInt(n, VisualItem.STARTSTROKECOLOR);
    }

    public void setStartStrokeColor(int n, int n2) {
        this.setInt(n, VisualItem.STARTSTROKECOLOR, n2);
    }

    public int getEndStrokeColor(int n) {
        return this.getInt(n, VisualItem.ENDSTROKECOLOR);
    }

    public void setEndStrokeColor(int n, int n2) {
        this.setInt(n, VisualItem.ENDSTROKECOLOR, n2);
    }

    public int getFillColor(int n) {
        return this.getInt(n, VisualItem.FILLCOLOR);
    }

    public void setFillColor(int n, int n2) {
        this.setInt(n, VisualItem.FILLCOLOR, n2);
    }

    public int getStartFillColor(int n) {
        return this.getInt(n, VisualItem.STARTFILLCOLOR);
    }

    public void setStartFillColor(int n, int n2) {
        this.setInt(n, VisualItem.STARTFILLCOLOR, n2);
    }

    public int getEndFillColor(int n) {
        return this.getInt(n, VisualItem.ENDFILLCOLOR);
    }

    public void setEndFillColor(int n, int n2) {
        this.setInt(n, VisualItem.ENDFILLCOLOR, n2);
    }

    public int getTextColor(int n) {
        return this.getInt(n, VisualItem.TEXTCOLOR);
    }

    public void setTextColor(int n, int n2) {
        this.setInt(n, VisualItem.TEXTCOLOR, n2);
    }

    public int getStartTextColor(int n) {
        return this.getInt(n, VisualItem.STARTTEXTCOLOR);
    }

    public void setStartTextColor(int n, int n2) {
        this.setInt(n, VisualItem.STARTTEXTCOLOR, n2);
    }

    public int getEndTextColor(int n) {
        return this.getInt(n, VisualItem.ENDTEXTCOLOR);
    }

    public void setEndTextColor(int n, int n2) {
        this.setInt(n, VisualItem.ENDTEXTCOLOR, n2);
    }

    public double getSize(int n) {
        return this.getDouble(n, VisualItem.SIZE);
    }

    public void setSize(int n, double d) {
        this.setDouble(n, VisualItem.SIZE, d);
    }

    public double getStartSize(int n) {
        return this.getDouble(n, VisualItem.STARTSIZE);
    }

    public void setStartSize(int n, double d) {
        this.setDouble(n, VisualItem.STARTSIZE, d);
    }

    public double getEndSize(int n) {
        return this.getDouble(n, VisualItem.ENDSIZE);
    }

    public void setEndSize(int n, double d) {
        this.setDouble(n, VisualItem.ENDSIZE, d);
    }

    public int getShape(int n) {
        return this.getInt(n, VisualItem.SHAPE);
    }

    public void setShape(int n, int n2) {
        this.setInt(n, VisualItem.SHAPE, n2);
    }

    public BasicStroke getStroke(int n) {
        return (BasicStroke)this.get(n, VisualItem.STROKE);
    }

    public void setStroke(int n, BasicStroke basicStroke) {
        this.set(n, VisualItem.STROKE, (Object)basicStroke);
    }

    public Font getFont(int n) {
        return (Font)this.get(n, VisualItem.FONT);
    }

    public void setFont(int n, Font font) {
        this.set(n, VisualItem.FONT, (Object)font);
    }

    public Font getStartFont(int n) {
        return (Font)this.get(n, VisualItem.STARTFONT);
    }

    public void setStartFont(int n, Font font) {
        this.set(n, VisualItem.STARTFONT, (Object)font);
    }

    public Font getEndFont(int n) {
        return (Font)this.get(n, VisualItem.ENDFONT);
    }

    public void setEndFont(int n, Font font) {
        this.set(n, VisualItem.ENDFONT, (Object)font);
    }

    public double getDOI(int n) {
        return this.getDouble(n, VisualItem.DOI);
    }

    public void setDOI(int n, double d) {
        this.setDouble(n, VisualItem.DOI, d);
    }
}

