/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.expression;

import prefuse.Visualization;
import prefuse.data.Tuple;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.Expression;
import prefuse.data.search.SearchTupleSet;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;

public class SearchPredicate
extends InGroupPredicate {
    private Expression m_incEmpty;
    private int paramCount = 0;

    public SearchPredicate() {
        this(Visualization.SEARCH_ITEMS, true);
        this.paramCount = 0;
    }

    public SearchPredicate(boolean bl) {
        this(Visualization.SEARCH_ITEMS, bl);
    }

    public SearchPredicate(String string, boolean bl) {
        super(string);
        this.m_incEmpty = new BooleanLiteral(bl);
        this.paramCount = 2;
    }

    public boolean getBoolean(Tuple tuple) {
        String string = this.getGroup(tuple);
        if (string == null) {
            return false;
        }
        boolean bl = this.m_incEmpty.getBoolean(tuple);
        VisualItem visualItem = (VisualItem)tuple;
        Visualization visualization = visualItem.getVisualization();
        SearchTupleSet searchTupleSet = (SearchTupleSet)visualization.getGroup(string);
        if (searchTupleSet == null && bl) {
            return true;
        }
        String string2 = searchTupleSet.getQuery();
        return bl && (string2 == null || string2.length() == 0) || visualization.isInGroup(visualItem, string);
    }

    public void addParameter(Expression expression) {
        if (this.paramCount == 0) {
            super.addParameter(expression);
        } else if (this.paramCount == 1) {
            this.m_incEmpty = expression;
        } else {
            throw new IllegalStateException("This function takes only 2 parameters.");
        }
    }

    public String getName() {
        return "MATCH";
    }

    public int getParameterCount() {
        return 2;
    }

    public String toString() {
        return this.getName() + "(" + this.m_group + ", " + this.m_incEmpty + ")";
    }
}

