/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.NumberConverter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

public class NaturalNumberConverter
extends NumberConverter {
    public static ConverterContext CONTEXT = new ConverterContext("Natural Nunber");

    public NaturalNumberConverter() {
        this(DecimalFormat.getIntegerInstance());
    }

    public NaturalNumberConverter(NumberFormat numberFormat) {
        super(numberFormat);
    }

    public Object fromString(String string, ConverterContext converterContext) {
        try {
            int n = this.getNumberFormat().parse(string).intValue();
            if (n < 0) {
                return new Integer(0);
            }
            return new Integer(Integer.parseInt(string));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }
}

