/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.plaf.CollapsiblePaneUI;
import com.jidesoft.plaf.basic.BasicCollapsiblePaneTitlePane;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.a;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicCollapsiblePaneUI
extends CollapsiblePaneUI {
    protected CollapsiblePane _pane;
    protected PropertyChangeListener _propertyChangeListener;
    protected LayoutManager _collapsiblePaneLayout;
    protected JComponent _northPane;
    protected JComponent _southPane;
    protected JComponent _westPane;
    protected JComponent _eastPane;
    protected JComponent _titlePane;
    private boolean a = false;
    private boolean b = false;
    private ThemePainter c;
    private AnimatorListener d;
    private AnimatorListener e;
    protected Action _collapseAction;
    protected String _collapseText;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicCollapsiblePaneUI((CollapsiblePane)jComponent);
    }

    public BasicCollapsiblePaneUI() {
    }

    public BasicCollapsiblePaneUI(CollapsiblePane collapsiblePane) {
        this._pane = collapsiblePane;
    }

    public void installUI(JComponent jComponent) {
        this._pane = (CollapsiblePane)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this._pane) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + jComponent + " when it only knows about " + this._pane + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this._pane.setCursor(Cursor.getPredefinedCursor(0));
        this._pane = null;
    }

    protected void installDefaults() {
        Color color;
        this.c = (ThemePainter)UIManager.get("Theme.painter");
        JComponent jComponent = this._pane.getContentPane();
        if (jComponent != null && (color = jComponent.getBackground()) instanceof UIResource) {
            jComponent.setBackground(null);
        }
        this._collapsiblePaneLayout = this.createLayoutManager();
        this._pane.setLayout(this._collapsiblePaneLayout);
        LookAndFeel.installBorder((JComponent)this._pane, "CollapsiblePane.border");
        if (this._pane.isEmphasized()) {
            LookAndFeel.installColors((JComponent)this._pane, "CollapsiblePane.emphasizedBackground", "CollapsiblePane.emphasizedForeground");
        } else {
            LookAndFeel.installColors((JComponent)this._pane, "CollapsiblePane.background", "CollapsiblePane.foreground");
        }
        this._collapseText = com.jidesoft.plaf.basic.a.a.getString("CollapsiblePane.collapseText");
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this._pane.getStyle() != 2) {
            Rectangle rectangle = this._pane.getActualComponent().getBounds();
            graphics.setColor(this._pane.getBackground());
            graphics.drawRect(rectangle.x - 1, rectangle.y, rectangle.width + 1, rectangle.height);
            graphics.setColor(this.getPainter().getCollapsiblePaneContentBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void uninstallDefaults() {
        Icon icon = this._pane.getIcon();
        if (icon instanceof UIResource) {
            this._pane.setIcon(null);
        }
        this._collapsiblePaneLayout = null;
        this._pane.setLayout(null);
        LookAndFeel.uninstallBorder((JComponent)this._pane);
        LookAndFeel.uninstallBorder(this._pane.getContentPane());
        this.c = null;
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.a();
        SwingUtilities.replaceUIActionMap((JComponent)this._pane, actionMap);
    }

    ActionMap a() {
        ActionMap actionMap;
        block4: {
            ActionMap actionMap2;
            block5: {
                int n = BasicJideTabbedPaneUI.t;
                actionMap = actionMap2 = (ActionMap)UIManager.get("CollapsiblePane.actionMap");
                if (n != 0) break block4;
                if (actionMap != null) break block5;
                actionMap = actionMap2 = this.b();
                if (n != 0) break block4;
                if (actionMap != null) {
                    UIManager.getLookAndFeelDefaults().put("CollapsiblePane.actionMap", actionMap2);
                }
            }
            actionMap = actionMap2;
        }
        return actionMap;
    }

    ActionMap b() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        return actionMapUIResource;
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this._pane));
        this.setSouthPane(this.createSouthPane(this._pane));
        this.setEastPane(this.createEastPane(this._pane));
        this.setWestPane(this.createWestPane(this._pane));
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
        this._titlePane = null;
    }

    protected void installListeners() {
        this._propertyChangeListener = this.createPropertyChangeListener();
        this._pane.addPropertyChangeListener(this._propertyChangeListener);
        this._collapseAction = new CollapseAction();
        this.d();
    }

    protected void uninstallListeners() {
        this._pane.removePropertyChangeListener(this._propertyChangeListener);
        this._propertyChangeListener = null;
        this._collapseAction = null;
        this.d = null;
        this.e = null;
    }

    InputMap a(int n) {
        if (n == 2) {
            return this.b(n);
        }
        return null;
    }

    InputMap b(int n) {
        Object[] objectArray;
        if (n == 2 && (objectArray = (Object[])UIManager.get("CollapsiblePane.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap((JComponent)this._pane, objectArray);
        }
        return null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap((JComponent)this._pane, 2, null);
        SwingUtilities.replaceUIActionMap((JComponent)this._pane, null);
    }

    public Component getTitlePane() {
        return this._northPane;
    }

    protected LayoutManager createLayoutManager() {
        return new CollapsiblePaneLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new CollapsiblePanePropertyChangeListener();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this._pane == jComponent) {
            return this._pane.getLayout().preferredLayoutSize(jComponent);
        }
        return new Dimension(100, 100);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this._pane == jComponent) {
            return this._pane.getLayout().minimumLayoutSize(jComponent);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        int n = BasicJideTabbedPaneUI.t;
        Component component = jComponent;
        if (n == 0) {
            if (component != null) {
                this._pane.remove((Component)jComponent);
            }
            component = jComponent2;
        }
        if (n == 0 && component != null) {
            component = this._pane.add((Component)jComponent2);
        }
    }

    protected JComponent createNorthPane(CollapsiblePane collapsiblePane) {
        if (collapsiblePane.isShowTitleBar() && collapsiblePane.getSlidingDirection() == 5) {
            this._titlePane = this.createTitlePane(collapsiblePane);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createTitlePane(CollapsiblePane collapsiblePane) {
        return new BasicCollapsiblePaneTitlePane(collapsiblePane);
    }

    protected JComponent createSouthPane(CollapsiblePane collapsiblePane) {
        if (collapsiblePane.isShowTitleBar() && collapsiblePane.getSlidingDirection() == 1) {
            this._titlePane = this.createTitlePane(collapsiblePane);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createWestPane(CollapsiblePane collapsiblePane) {
        if (collapsiblePane.isShowTitleBar() && collapsiblePane.getSlidingDirection() == 3) {
            this._titlePane = this.createTitlePane(collapsiblePane);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createEastPane(CollapsiblePane collapsiblePane) {
        if (collapsiblePane.isShowTitleBar() && collapsiblePane.getSlidingDirection() == 7) {
            this._titlePane = this.createTitlePane(collapsiblePane);
            return this._titlePane;
        }
        return null;
    }

    protected final boolean isKeyBindingRegistered() {
        return this.a;
    }

    protected final void setKeyBindingRegistered(boolean bl) {
        this.a = bl;
    }

    public final boolean isKeyBindingActive() {
        return this.b;
    }

    protected final void setKeyBindingActive(boolean bl) {
        this.b = bl;
    }

    protected void setupMenuOpenKey() {
        InputMap inputMap = this.a(2);
        SwingUtilities.replaceUIInputMap((JComponent)this._pane, 2, inputMap);
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this._northPane;
    }

    protected void setNorthPane(JComponent jComponent) {
        block4: {
            BasicCollapsiblePaneUI basicCollapsiblePaneUI;
            block5: {
                int n = BasicJideTabbedPaneUI.t;
                basicCollapsiblePaneUI = this;
                if (n != 0) break block4;
                if (basicCollapsiblePaneUI._northPane == null) break block5;
                basicCollapsiblePaneUI = this;
                if (n != 0) break block4;
                if (basicCollapsiblePaneUI._northPane instanceof BasicCollapsiblePaneTitlePane) {
                    ((BasicCollapsiblePaneTitlePane)this._northPane).uninstallDefaults();
                    ((BasicCollapsiblePaneTitlePane)this._northPane).uninstallListeners();
                }
            }
            this.replacePane(this._northPane, jComponent);
            basicCollapsiblePaneUI = this;
        }
        basicCollapsiblePaneUI._northPane = jComponent;
    }

    public JComponent getSouthPane() {
        return this._southPane;
    }

    protected void setSouthPane(JComponent jComponent) {
        block4: {
            BasicCollapsiblePaneUI basicCollapsiblePaneUI;
            block5: {
                int n = BasicJideTabbedPaneUI.t;
                basicCollapsiblePaneUI = this;
                if (n != 0) break block4;
                if (basicCollapsiblePaneUI._southPane == null) break block5;
                basicCollapsiblePaneUI = this;
                if (n != 0) break block4;
                if (basicCollapsiblePaneUI._southPane instanceof BasicCollapsiblePaneTitlePane) {
                    ((BasicCollapsiblePaneTitlePane)this._southPane).uninstallDefaults();
                    ((BasicCollapsiblePaneTitlePane)this._southPane).uninstallListeners();
                }
            }
            this.replacePane(this._southPane, jComponent);
            basicCollapsiblePaneUI = this;
        }
        basicCollapsiblePaneUI._southPane = jComponent;
    }

    public JComponent getWestPane() {
        return this._westPane;
    }

    protected void setWestPane(JComponent jComponent) {
        block4: {
            BasicCollapsiblePaneUI basicCollapsiblePaneUI;
            block5: {
                int n = BasicJideTabbedPaneUI.t;
                basicCollapsiblePaneUI = this;
                if (n != 0) break block4;
                if (basicCollapsiblePaneUI._westPane == null) break block5;
                basicCollapsiblePaneUI = this;
                if (n != 0) break block4;
                if (basicCollapsiblePaneUI._westPane instanceof BasicCollapsiblePaneTitlePane) {
                    ((BasicCollapsiblePaneTitlePane)this._westPane).uninstallDefaults();
                    ((BasicCollapsiblePaneTitlePane)this._westPane).uninstallListeners();
                }
            }
            this.replacePane(this._westPane, jComponent);
            basicCollapsiblePaneUI = this;
        }
        basicCollapsiblePaneUI._westPane = jComponent;
    }

    public JComponent getEastPane() {
        return this._eastPane;
    }

    protected void setEastPane(JComponent jComponent) {
        block4: {
            BasicCollapsiblePaneUI basicCollapsiblePaneUI;
            block5: {
                int n = BasicJideTabbedPaneUI.t;
                basicCollapsiblePaneUI = this;
                if (n != 0) break block4;
                if (basicCollapsiblePaneUI._eastPane == null) break block5;
                basicCollapsiblePaneUI = this;
                if (n != 0) break block4;
                if (basicCollapsiblePaneUI._eastPane instanceof BasicCollapsiblePaneTitlePane) {
                    ((BasicCollapsiblePaneTitlePane)this._eastPane).uninstallDefaults();
                    ((BasicCollapsiblePaneTitlePane)this._eastPane).uninstallListeners();
                }
            }
            this.replacePane(this._eastPane, jComponent);
            basicCollapsiblePaneUI = this;
        }
        basicCollapsiblePaneUI._eastPane = jComponent;
    }

    private int c() {
        Object object;
        if (this._pane != null && (object = this._pane.getClientProperty((Object)"percentageVisible")) != null && object instanceof Integer) {
            return (Integer)object;
        }
        return 100;
    }

    public ThemePainter getPainter() {
        return this.c;
    }

    private void d() {
        this.e = new AnimatorListener(){

            public void animationStarts(Component component) {
                BasicCollapsiblePaneUI.this.c(100);
                BasicCollapsiblePaneUI.this._pane.fireCollapsiblePaneEvent(5101);
            }

            public void animationFrame(Component component, int n, int n2) {
                BasicCollapsiblePaneUI.this.c(100 - 100 * n2 / n);
                BasicCollapsiblePaneUI.this._pane.invalidate();
                if (BasicCollapsiblePaneUI.this._pane.getParent() != null) {
                    BasicCollapsiblePaneUI.this._pane.getParent().validate();
                }
                if (BasicCollapsiblePaneUI.this._pane.getActualComponent() instanceof JScrollPane) {
                    ((JScrollPane)BasicCollapsiblePaneUI.this._pane.getActualComponent()).getVerticalScrollBar().setValue(((JScrollPane)BasicCollapsiblePaneUI.this._pane.getActualComponent()).getVerticalScrollBar().getMaximum());
                }
            }

            public void animationEnds(Component component) {
                try {
                    BasicCollapsiblePaneUI.this._pane.setCollapsed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        };
        this.d = new AnimatorListener(){

            public void animationStarts(Component component) {
                BasicCollapsiblePaneUI.this.c(0);
                BasicCollapsiblePaneUI.this._pane.fireCollapsiblePaneEvent(5099);
            }

            public void animationFrame(Component component, int n, int n2) {
                BasicCollapsiblePaneUI.this.c(100 * n2 / n);
                BasicCollapsiblePaneUI.this._pane.invalidate();
                if (BasicCollapsiblePaneUI.this._pane.getParent() != null) {
                    BasicCollapsiblePaneUI.this._pane.getParent().validate();
                }
                if (BasicCollapsiblePaneUI.this._pane.getActualComponent() instanceof JScrollPane) {
                    ((JScrollPane)BasicCollapsiblePaneUI.this._pane.getActualComponent()).getVerticalScrollBar().setValue(((JScrollPane)BasicCollapsiblePaneUI.this._pane.getActualComponent()).getVerticalScrollBar().getMaximum());
                }
            }

            public void animationEnds(Component component) {
                try {
                    BasicCollapsiblePaneUI.this._pane.setCollapsed(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        };
    }

    private void c(int n) {
        this._pane.putClientProperty((Object)"percentageVisible", (Object)new Integer(n));
    }

    public Action getToggleAction() {
        return this._collapseAction;
    }

    public class CollapseAction
    extends AbstractAction {
        Rectangle a;
        Animator b;

        public CollapseAction() {
            super(BasicCollapsiblePaneUI.this._collapseText);
            this.a = null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!BasicCollapsiblePaneUI.this._pane.isCollapsed()) {
                if (this.b != null && this.b.isRunning()) {
                    this.b.interrupt();
                }
                this.b = new Animator((Component)BasicCollapsiblePaneUI.this._pane, BasicCollapsiblePaneUI.this._pane.getInitDelay(), BasicCollapsiblePaneUI.this._pane.getStepDelay(), BasicCollapsiblePaneUI.this._pane.getSteps());
                this.b.setAnimatorListener(BasicCollapsiblePaneUI.this.e);
                this.b.start();
            } else {
                if (this.b != null && this.b.isRunning()) {
                    this.b.interrupt();
                }
                this.b = new Animator((Component)BasicCollapsiblePaneUI.this._pane, BasicCollapsiblePaneUI.this._pane.getInitDelay(), BasicCollapsiblePaneUI.this._pane.getStepDelay(), BasicCollapsiblePaneUI.this._pane.getSteps());
                this.b.setAnimatorListener(BasicCollapsiblePaneUI.this.d);
                this.b.start();
            }
        }
    }

    public class CollapsiblePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Cloneable cloneable;
            Dimension dimension = new Dimension();
            int n = BasicCollapsiblePaneUI.this.c();
            if (BasicCollapsiblePaneUI.this._pane.getSlidingDirection() == 1 || BasicCollapsiblePaneUI.this._pane.getSlidingDirection() == 5) {
                dimension.height = BasicCollapsiblePaneUI.this._pane.getContentPaneHeight() * n / 100 + 1;
                dimension.width = BasicCollapsiblePaneUI.this._pane.getContentPane().getPreferredSize().width + 2;
            } else {
                dimension.height = BasicCollapsiblePaneUI.this._pane.getContentPane().getPreferredSize().height + 2;
                dimension.width = BasicCollapsiblePaneUI.this._pane.getContentPaneWidth() * n / 100 + 1;
            }
            if ((!(BasicCollapsiblePaneUI.this.getNorthPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getNorthPane() != null) {
                cloneable = BasicCollapsiblePaneUI.this.getNorthPane().getPreferredSize();
                dimension.height += cloneable.height;
                dimension.width = Math.max(cloneable.width, dimension.width);
            }
            if ((!(BasicCollapsiblePaneUI.this.getSouthPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getSouthPane() != null) {
                cloneable = BasicCollapsiblePaneUI.this.getSouthPane().getPreferredSize();
                dimension.height += cloneable.height;
                dimension.width = Math.max(cloneable.width, dimension.width);
            }
            if ((!(BasicCollapsiblePaneUI.this.getEastPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getEastPane() != null) {
                cloneable = BasicCollapsiblePaneUI.this.getEastPane().getPreferredSize();
                dimension.height = Math.max(cloneable.height, dimension.height);
                dimension.width += cloneable.width;
            }
            if ((!(BasicCollapsiblePaneUI.this.getWestPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getWestPane() != null) {
                cloneable = BasicCollapsiblePaneUI.this.getWestPane().getPreferredSize();
                dimension.height = Math.max(cloneable.height, dimension.height);
                dimension.width += cloneable.width;
            }
            cloneable = BasicCollapsiblePaneUI.this._pane.getInsets();
            dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            if ((!(BasicCollapsiblePaneUI.this.getNorthPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getNorthPane() != null) {
                dimension = new Dimension(BasicCollapsiblePaneUI.this.getNorthPane().getMinimumSize());
                dimension.width = Math.max(dimension.width, BasicCollapsiblePaneUI.this._pane.getContentPane().getMinimumSize().width);
            } else if ((!(BasicCollapsiblePaneUI.this.getSouthPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getSouthPane() != null) {
                dimension = new Dimension(BasicCollapsiblePaneUI.this.getSouthPane().getMinimumSize());
                dimension.width = Math.max(dimension.width, BasicCollapsiblePaneUI.this._pane.getContentPane().getMinimumSize().width);
            } else if ((!(BasicCollapsiblePaneUI.this.getEastPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getEastPane() != null) {
                dimension = new Dimension(BasicCollapsiblePaneUI.this.getEastPane().getMinimumSize());
                dimension.height = Math.max(dimension.height, BasicCollapsiblePaneUI.this._pane.getContentPane().getMinimumSize().height);
            } else if ((!(BasicCollapsiblePaneUI.this.getWestPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getWestPane() != null) {
                dimension = new Dimension(BasicCollapsiblePaneUI.this.getWestPane().getMinimumSize());
                dimension.height = Math.max(dimension.height, BasicCollapsiblePaneUI.this._pane.getContentPane().getMinimumSize().height);
            }
            Insets insets = BasicCollapsiblePaneUI.this._pane.getInsets();
            dimension.width = 0;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Insets insets = BasicCollapsiblePaneUI.this._pane.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = BasicCollapsiblePaneUI.this._pane.getWidth() - insets.left - insets.right;
            int n4 = BasicCollapsiblePaneUI.this._pane.getHeight() - insets.top - insets.bottom;
            if (BasicCollapsiblePaneUI.this.getNorthPane() != null) {
                if (!(BasicCollapsiblePaneUI.this.getNorthPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) {
                    dimension = BasicCollapsiblePaneUI.this.getNorthPane().getPreferredSize();
                    BasicCollapsiblePaneUI.this.getNorthPane().setBounds(n, n2, n3, dimension.height);
                    n2 += dimension.height;
                    n4 -= dimension.height;
                } else {
                    BasicCollapsiblePaneUI.this.getNorthPane().setBounds(0, 0, 0, 0);
                }
            } else if (BasicCollapsiblePaneUI.this.getWestPane() != null) {
                if (!(BasicCollapsiblePaneUI.this.getWestPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) {
                    dimension = BasicCollapsiblePaneUI.this.getWestPane().getPreferredSize();
                    BasicCollapsiblePaneUI.this.getWestPane().setBounds(n, n2, dimension.width, n4);
                    n3 -= dimension.width;
                    n += dimension.width;
                } else {
                    BasicCollapsiblePaneUI.this.getWestPane().setBounds(0, 0, 0, 0);
                }
            }
            if (BasicCollapsiblePaneUI.this.getSouthPane() != null) {
                if (!(BasicCollapsiblePaneUI.this.getSouthPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) {
                    dimension = BasicCollapsiblePaneUI.this.getSouthPane().getPreferredSize();
                    BasicCollapsiblePaneUI.this.getSouthPane().setBounds(n, BasicCollapsiblePaneUI.this._pane.getHeight() - insets.bottom - dimension.height, n3, dimension.height);
                    n4 -= dimension.height;
                } else {
                    BasicCollapsiblePaneUI.this.getSouthPane().setBounds(0, 0, 0, 0);
                }
            } else if (BasicCollapsiblePaneUI.this.getEastPane() != null) {
                if (!(BasicCollapsiblePaneUI.this.getEastPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) {
                    dimension = BasicCollapsiblePaneUI.this.getEastPane().getPreferredSize();
                    BasicCollapsiblePaneUI.this.getEastPane().setBounds(n3 - dimension.width, n2, dimension.width, n4);
                    n3 -= dimension.width;
                } else {
                    BasicCollapsiblePaneUI.this.getEastPane().setBounds(0, 0, 0, 0);
                }
            }
            if (BasicCollapsiblePaneUI.this._pane.getActualComponent() != null) {
                switch (BasicCollapsiblePaneUI.this._pane.getSlidingDirection()) {
                    case 7: {
                        int n5 = BasicCollapsiblePaneUI.this._pane.getContentPaneWidth() * BasicCollapsiblePaneUI.this.c() / 100;
                        BasicCollapsiblePaneUI.this._pane.getActualComponent().setBounds(n, n2 + 1, n5, n3 - 2);
                        n += n5;
                        break;
                    }
                    case 3: {
                        int n6 = BasicCollapsiblePaneUI.this._pane.getContentPaneWidth() * BasicCollapsiblePaneUI.this.c() / 100;
                        BasicCollapsiblePaneUI.this._pane.getActualComponent().setBounds(n, n2 + 1, n6, n3 - 2);
                        n += n6;
                        break;
                    }
                    case 1: {
                        int n7 = Math.min(n4, BasicCollapsiblePaneUI.this._pane.getContentPaneHeight() * BasicCollapsiblePaneUI.this.c() / 100);
                        BasicCollapsiblePaneUI.this._pane.getActualComponent().setBounds(n + 1, n2, n3 - 2, n7);
                        BasicCollapsiblePaneUI.this._pane.getContentPane().setPreferredSize(new Dimension(n3 - 2, n7));
                        n2 += n7;
                        break;
                    }
                    default: {
                        int n8 = Math.min(n4, BasicCollapsiblePaneUI.this._pane.getContentPaneHeight() * BasicCollapsiblePaneUI.this.c() / 100);
                        BasicCollapsiblePaneUI.this._pane.getActualComponent().setBounds(n + 1, n2, n3 - 2, n8);
                        n2 += n8;
                    }
                }
            }
        }
    }

    public class CollapsiblePanePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            CollapsiblePane collapsiblePane = (CollapsiblePane)propertyChangeEvent.getSource();
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            if ("collapsed".equals(string)) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    BasicCollapsiblePaneUI.this.c(0);
                } else {
                    BasicCollapsiblePaneUI.this.c(100);
                }
            } else if ("enabled".equals(string)) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    BasicCollapsiblePaneUI.this._collapseAction.setEnabled(true);
                } else {
                    BasicCollapsiblePaneUI.this._collapseAction.setEnabled(false);
                }
            } else if (!"contentPane".equals(string)) {
                if ("showTitleBar".equals(string)) {
                    BasicCollapsiblePaneUI.this._pane.invalidate();
                    BasicCollapsiblePaneUI.this._pane.updateUI();
                } else if ("emphasized".equals(string)) {
                    if (BasicCollapsiblePaneUI.this._pane.isEmphasized()) {
                        LookAndFeel.installColors((JComponent)BasicCollapsiblePaneUI.this._pane, "CollapsiblePane.emphasizedBackground", "CollapsiblePane.emphasizedForeground");
                    } else {
                        LookAndFeel.installColors((JComponent)BasicCollapsiblePaneUI.this._pane, "CollapsiblePane.background", "CollapsiblePane.foreground");
                    }
                } else if ("style".equals(string)) {
                    BasicCollapsiblePaneUI.this._pane.updateUI();
                } else if ("title".equals(string)) {
                    Dimension dimension = BasicCollapsiblePaneUI.this._pane.getMinimumSize();
                    Dimension dimension2 = BasicCollapsiblePaneUI.this._pane.getSize();
                    if (dimension.width > dimension2.width) {
                        BasicCollapsiblePaneUI.this._pane.setSize(dimension.width, dimension2.height);
                    }
                }
            }
        }
    }
}

