/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.plaf.DockableFrameUI;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.plaf.basic.ThemePainter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicDockableFrameUI
extends DockableFrameUI {
    protected DockableFrame _frame;
    protected PropertyChangeListener _propertyChangeListener;
    protected LayoutManager _dockablelFrameLayout;
    protected JComponent _northPane;
    protected JComponent _southPane;
    protected JComponent _westPane;
    protected JComponent _eastPane;
    protected BasicDockableFrameTitlePane _titlePane;
    private boolean a = false;
    private boolean b = false;
    private ThemePainter c;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDockableFrameUI((DockableFrame)jComponent);
    }

    public BasicDockableFrameUI() {
    }

    public BasicDockableFrameUI(DockableFrame dockableFrame) {
        this._frame = dockableFrame;
    }

    public void installUI(JComponent jComponent) {
        this._frame = (DockableFrame)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
        this._frame.setOpaque(true);
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this._frame) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + jComponent + " when it only knows about " + this._frame + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this._frame.setCursor(Cursor.getPredefinedCursor(0));
        this._frame = null;
    }

    protected void installDefaults() {
        this.c = (ThemePainter)UIManager.get("Theme.painter");
        JComponent jComponent = (JComponent)this._frame.getContentPane();
        if (jComponent != null) {
            jComponent.setOpaque(false);
        }
        this._dockablelFrameLayout = this.createLayoutManager();
        this._frame.setLayout(this._dockablelFrameLayout);
        this._frame.setBackground(UIManager.getColor("DockableFrame.background"));
        LookAndFeel.installBorder((JComponent)this._frame, "DockableFrame.border");
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.a();
        SwingUtilities.replaceUIActionMap((JComponent)this._frame, actionMap);
    }

    ActionMap a() {
        ActionMap actionMap;
        block4: {
            ActionMap actionMap2;
            block5: {
                int n = BasicJideTabbedPaneUI.t;
                actionMap = actionMap2 = (ActionMap)UIManager.get("DockableFrame.actionMap");
                if (n != 0) break block4;
                if (actionMap != null) break block5;
                actionMap = actionMap2 = this.b();
                if (n != 0) break block4;
                if (actionMap != null) {
                    UIManager.getLookAndFeelDefaults().put("DockableFrame.actionMap", actionMap2);
                }
            }
            actionMap = actionMap2;
        }
        return actionMap;
    }

    ActionMap b() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        return actionMapUIResource;
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this._frame));
        this.setSouthPane(this.createSouthPane(this._frame));
        this.setEastPane(this.createEastPane(this._frame));
        this.setWestPane(this.createWestPane(this._frame));
    }

    protected void installListeners() {
        this._propertyChangeListener = this.createPropertyChangeListener();
        this._frame.addPropertyChangeListener(this._propertyChangeListener);
    }

    InputMap a(int n) {
        if (n == 2) {
            return this.b(n);
        }
        return null;
    }

    InputMap b(int n) {
        Object[] objectArray;
        if (n == 2 && (objectArray = (Object[])UIManager.get("DockableFrame.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap((JComponent)this._frame, objectArray);
        }
        return null;
    }

    protected void uninstallDefaults() {
        Icon icon = this._frame.getFrameIcon();
        if (icon instanceof UIResource) {
            this._frame.setFrameIcon(null);
        }
        this._dockablelFrameLayout = null;
        this._frame.setLayout(null);
        LookAndFeel.uninstallBorder((JComponent)this._frame);
        this.c = null;
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
        this._titlePane = null;
    }

    protected void uninstallListeners() {
        this._frame.removePropertyChangeListener(this._propertyChangeListener);
        this._propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap((JComponent)this._frame, 2, null);
        SwingUtilities.replaceUIActionMap((JComponent)this._frame, null);
    }

    public Component getTitlePane() {
        return this._northPane;
    }

    protected LayoutManager createLayoutManager() {
        return new DockableFrameLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new DockableFramePropertyChangeListener();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this._frame == jComponent) {
            return this._frame.getLayout().preferredLayoutSize(jComponent);
        }
        return new Dimension(100, 100);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this._frame == jComponent) {
            return this._frame.getLayout().minimumLayoutSize(jComponent);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        block6: {
            block5: {
                int n = BasicJideTabbedPaneUI.t;
                Component component = jComponent;
                if (n == 0) {
                    if (component != null) {
                        this.deinstallMouseHandlers(jComponent);
                        this._frame.remove((Component)jComponent);
                    }
                    component = jComponent2;
                }
                if (n != 0) break block5;
                if (component == null) break block6;
                component = this._frame.add((Component)jComponent2);
            }
            this.installMouseHandlers(jComponent2);
        }
    }

    protected void deinstallMouseHandlers(JComponent jComponent) {
    }

    protected void installMouseHandlers(JComponent jComponent) {
    }

    protected JComponent createNorthPane(DockableFrame dockableFrame) {
        this._titlePane = new BasicDockableFrameTitlePane(dockableFrame);
        return this._titlePane;
    }

    protected JComponent createSouthPane(DockableFrame dockableFrame) {
        return null;
    }

    protected JComponent createWestPane(DockableFrame dockableFrame) {
        return null;
    }

    protected JComponent createEastPane(DockableFrame dockableFrame) {
        return null;
    }

    protected final boolean isKeyBindingRegistered() {
        return this.a;
    }

    protected final void setKeyBindingRegistered(boolean bl) {
        this.a = bl;
    }

    public final boolean isKeyBindingActive() {
        return this.b;
    }

    protected final void setKeyBindingActive(boolean bl) {
        this.b = bl;
    }

    protected void setupMenuOpenKey() {
        InputMap inputMap = this.a(2);
        SwingUtilities.replaceUIInputMap((JComponent)this._frame, 2, inputMap);
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this._northPane;
    }

    protected void setNorthPane(JComponent jComponent) {
        block4: {
            BasicDockableFrameUI basicDockableFrameUI;
            block5: {
                int n = BasicJideTabbedPaneUI.t;
                basicDockableFrameUI = this;
                if (n != 0) break block4;
                if (basicDockableFrameUI._northPane == null) break block5;
                basicDockableFrameUI = this;
                if (n != 0) break block4;
                if (basicDockableFrameUI._northPane instanceof BasicDockableFrameTitlePane) {
                    ((BasicDockableFrameTitlePane)this._northPane).uninstallListeners();
                }
            }
            this.replacePane(this._northPane, jComponent);
            basicDockableFrameUI = this;
        }
        basicDockableFrameUI._northPane = jComponent;
    }

    public JComponent getSouthPane() {
        return this._southPane;
    }

    protected void setSouthPane(JComponent jComponent) {
        this._southPane = jComponent;
    }

    public JComponent getWestPane() {
        return this._westPane;
    }

    protected void setWestPane(JComponent jComponent) {
        this._westPane = jComponent;
    }

    public JComponent getEastPane() {
        return this._eastPane;
    }

    protected void setEastPane(JComponent jComponent) {
        this._eastPane = jComponent;
    }

    protected DockingManager getdockingmanager() {
        if (this._frame.getDockingManager() != null && this._frame.getDockingManager() != null) {
            return this._frame.getDockingManager();
        }
        System.err.println("Warning: Orphan frame + " + this._frame);
        return null;
    }

    public ThemePainter getPainter() {
        return this.c;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        block4: {
            JComponent jComponent2;
            block2: {
                block3: {
                    int n = BasicJideTabbedPaneUI.t;
                    jComponent2 = jComponent;
                    if (n != 0) break block2;
                    if (!jComponent2.isOpaque()) break block3;
                    this.getPainter().paintDockableFrameBackground(jComponent, graphics, new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()), 0, 0);
                    if (n == 0) break block4;
                }
                jComponent2 = jComponent;
            }
            Insets insets = jComponent2.getInsets();
            this.getPainter().paintDockableFrameBackground(jComponent, graphics, new Rectangle(insets.left, insets.top, jComponent.getWidth() - insets.left - insets.right, jComponent.getHeight() - insets.top - insets.bottom), 0, 0);
        }
    }

    public class DockableFrameLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            Insets insets = BasicDockableFrameUI.this._frame.getInsets();
            Dimension dimension2 = new Dimension(BasicDockableFrameUI.this._frame.getRootPane().getPreferredSize());
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            if (BasicDockableFrameUI.this.getNorthPane() != null && BasicDockableFrameUI.this._frame.isShowTitleBar()) {
                dimension = BasicDockableFrameUI.this.getNorthPane().getPreferredSize();
                dimension2.width = Math.max(dimension.width, dimension2.width);
                dimension2.height += dimension.height;
            }
            if (BasicDockableFrameUI.this.getSouthPane() != null) {
                dimension = BasicDockableFrameUI.this.getSouthPane().getPreferredSize();
                dimension2.width = Math.max(dimension.width, dimension2.width);
                dimension2.height += dimension.height;
            }
            if (BasicDockableFrameUI.this.getEastPane() != null) {
                dimension = BasicDockableFrameUI.this.getEastPane().getPreferredSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension.height, dimension2.height);
            }
            if (BasicDockableFrameUI.this.getWestPane() != null) {
                dimension = BasicDockableFrameUI.this.getWestPane().getPreferredSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension2;
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            if (BasicDockableFrameUI.this._frame.isShowTitleBar() && BasicDockableFrameUI.this.getNorthPane() != null && BasicDockableFrameUI.this.getNorthPane() instanceof BasicDockableFrameTitlePane) {
                dimension = new Dimension(BasicDockableFrameUI.this.getNorthPane().getMinimumSize());
            }
            Dimension dimension2 = BasicDockableFrameUI.this._frame.getContentPane().getMinimumSize();
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            dimension.height += dimension2.height;
            Insets insets = BasicDockableFrameUI.this._frame.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Insets insets = BasicDockableFrameUI.this._frame.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = BasicDockableFrameUI.this._frame.getWidth() - insets.left - insets.right;
            int n4 = BasicDockableFrameUI.this._frame.getHeight() - insets.top - insets.bottom;
            if (BasicDockableFrameUI.this.getNorthPane() != null && !BasicDockableFrameUI.this._frame.isShowTitleBar()) {
                BasicDockableFrameUI.this.getNorthPane().setVisible(false);
            } else if (BasicDockableFrameUI.this.getNorthPane() != null && BasicDockableFrameUI.this._frame.isShowTitleBar()) {
                BasicDockableFrameUI.this.getNorthPane().setVisible(true);
                dimension = BasicDockableFrameUI.this.getNorthPane().getPreferredSize();
                BasicDockableFrameUI.this.getNorthPane().setBounds(n, n2, n3, dimension.height);
                n2 += dimension.height;
                n4 -= dimension.height;
            }
            if (BasicDockableFrameUI.this.getSouthPane() != null) {
                dimension = BasicDockableFrameUI.this.getSouthPane().getPreferredSize();
                BasicDockableFrameUI.this.getSouthPane().setBounds(n, BasicDockableFrameUI.this._frame.getHeight() - insets.bottom - dimension.height, n3, dimension.height);
                n4 -= dimension.height;
            }
            if (BasicDockableFrameUI.this.getWestPane() != null) {
                dimension = BasicDockableFrameUI.this.getWestPane().getPreferredSize();
                BasicDockableFrameUI.this.getWestPane().setBounds(n, n2, dimension.width, n4);
                n3 -= dimension.width;
                n += dimension.width;
            }
            if (BasicDockableFrameUI.this.getEastPane() != null) {
                dimension = BasicDockableFrameUI.this.getEastPane().getPreferredSize();
                BasicDockableFrameUI.this.getEastPane().setBounds(n3 - dimension.width, n2, dimension.width, n4);
                n3 -= dimension.width;
            }
            if (BasicDockableFrameUI.this._frame.getRootPane() != null) {
                BasicDockableFrameUI.this._frame.getRootPane().setBounds(n, n2, n3, n4);
            }
        }
    }

    public class DockableFramePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            DockableFrame dockableFrame = (DockableFrame)propertyChangeEvent.getSource();
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            if (!"hidden".equals(string)) {
                if ("docked".equals(string)) {
                    if (object == Boolean.TRUE) {
                        LookAndFeel.installBorder((JComponent)BasicDockableFrameUI.this._frame, "DockableFrame.border");
                    }
                } else if (!"autohide".equals(string) && !"floated".equals(string)) {
                    if ("autohideShowing".equals(string)) {
                        if (object == Boolean.TRUE && dockableFrame.isSlidingAutohide()) {
                            switch (dockableFrame.getContext().getCurrentDockSide()) {
                                case 1: {
                                    LookAndFeel.installBorder((JComponent)BasicDockableFrameUI.this._frame, "DockableFrame.slidingNorthBorder");
                                    break;
                                }
                                case 2: {
                                    LookAndFeel.installBorder((JComponent)BasicDockableFrameUI.this._frame, "DockableFrame.slidingSouthBorder");
                                    break;
                                }
                                case 4: {
                                    LookAndFeel.installBorder((JComponent)BasicDockableFrameUI.this._frame, "DockableFrame.slidingEastBorder");
                                    break;
                                }
                                case 8: {
                                    LookAndFeel.installBorder((JComponent)BasicDockableFrameUI.this._frame, "DockableFrame.slidingWestBorder");
                                }
                            }
                        }
                    } else if ("active".equals(string)) {
                        if (!object2.equals(object)) {
                            BasicDockableFrameUI.this._frame.repaint();
                        }
                    } else if ("title".equals(string)) {
                        Dimension dimension = BasicDockableFrameUI.this._frame.getMinimumSize();
                        Dimension dimension2 = BasicDockableFrameUI.this._frame.getSize();
                        if (dimension.width > dimension2.width) {
                            BasicDockableFrameUI.this._frame.setSize(dimension.width, dimension2.height);
                        }
                    }
                }
            }
        }
    }
}

