/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.GripperUI;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class BasicGripperUI
extends GripperUI {
    private int a;
    protected ThemePainter _painter;
    protected Painter _gripperPainter;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicGripperUI();
    }

    public void installUI(JComponent jComponent) {
        this._painter = (ThemePainter)UIManager.get("Theme.painter");
        this._gripperPainter = (Painter)UIManager.get("Gripper.painter");
        this.installDefaults((Gripper)jComponent);
        this.installListeners((Gripper)jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this._painter = null;
        this._gripperPainter = null;
        this.uninstallDefaults((Gripper)jComponent);
        this.uninstallListeners((Gripper)jComponent);
    }

    protected void installDefaults(Gripper gripper) {
        this.a = UIManager.getInt("Gripper.size");
    }

    protected void uninstallDefaults(Gripper gripper) {
    }

    protected MouseListener createMouseListener() {
        return new a_();
    }

    protected void installListeners(Gripper gripper) {
        block3: {
            MouseListener mouseListener;
            block2: {
                mouseListener = this.createMouseListener();
                if (BasicJideTabbedPaneUI.t != 0) break block2;
                if (mouseListener == null) break block3;
                gripper.putClientProperty(this, mouseListener);
            }
            gripper.addMouseListener(mouseListener);
        }
    }

    protected void uninstallListeners(Gripper gripper) {
        block3: {
            Gripper gripper2;
            MouseListener mouseListener;
            block2: {
                mouseListener = (MouseListener)gripper.getClientProperty(this);
                gripper2 = gripper;
                if (BasicJideTabbedPaneUI.t != 0) break block2;
                gripper2.putClientProperty(this, null);
                if (mouseListener == null) break block3;
                gripper2 = gripper;
            }
            gripper2.removeMouseListener(mouseListener);
        }
    }

    protected void paintBackground(Graphics graphics, Gripper gripper) {
        block6: {
            boolean bl;
            Rectangle rectangle;
            block7: {
                int n;
                block4: {
                    block5: {
                        n = BasicJideTabbedPaneUI.t;
                        rectangle = new Rectangle(0, 0, gripper.getWidth(), gripper.getHeight());
                        bl = gripper.isRollover();
                        if (n != 0) break block4;
                        if (!bl) break block5;
                        this.getPainter().paintButtonBackground(gripper, graphics, rectangle, 0, 2);
                        if (n == 0) break block6;
                    }
                    bl = gripper.isOpaque();
                }
                if (n != 0) break block7;
                if (!bl) break block6;
                this.getPainter().paintButtonBackground(gripper, graphics, rectangle, 0, 0, false);
                bl = "true".equals(SecurityUtils.getProperty("shadingtheme", "false"));
            }
            if (bl) {
                JideSwingUtilities.fillGradient(graphics, rectangle, 0);
            }
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        block4: {
            Painter painter;
            Gripper gripper;
            block2: {
                block3: {
                    int n = BasicJideTabbedPaneUI.t;
                    gripper = (Gripper)jComponent;
                    this.paintBackground(graphics, gripper);
                    painter = this._gripperPainter;
                    if (n != 0) break block2;
                    if (painter != null) break block3;
                    this.getPainter().paintGripper(jComponent, graphics, new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()), gripper.getOrientation(), 0);
                    if (n == 0) break block4;
                }
                painter = this._gripperPainter;
            }
            painter.paint(jComponent, graphics, new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()), gripper.getOrientation(), 0);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(this.a, this.a);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Gripper gripper = (Gripper)jComponent;
        if (gripper.getOrientation() == 0) {
            return new Dimension(this.a, jComponent.getParent().getHeight());
        }
        return new Dimension(jComponent.getParent().getWidth(), this.a);
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    class a_
    extends MouseAdapter {
        a_() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            block3: {
                Gripper gripper;
                block4: {
                    boolean bl;
                    block2: {
                        int n = BasicJideTabbedPaneUI.t;
                        super.mouseEntered(mouseEvent);
                        bl = mouseEvent.getSource() instanceof Gripper;
                        if (n != 0) break block2;
                        if (!bl) break block3;
                        gripper = (Gripper)mouseEvent.getSource();
                        if (n != 0) break block4;
                        bl = gripper.isRolloverEnabled();
                    }
                    if (!bl) break block3;
                    gripper = (Gripper)mouseEvent.getSource();
                }
                gripper.setRollover(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            block3: {
                Gripper gripper;
                block4: {
                    boolean bl;
                    block2: {
                        int n = BasicJideTabbedPaneUI.t;
                        super.mouseExited(mouseEvent);
                        bl = mouseEvent.getSource() instanceof Gripper;
                        if (n != 0) break block2;
                        if (!bl) break block3;
                        gripper = (Gripper)mouseEvent.getSource();
                        if (n != 0) break block4;
                        bl = gripper.isRolloverEnabled();
                    }
                    if (!bl) break block3;
                    gripper = (Gripper)mouseEvent.getSource();
                }
                gripper.setRollover(false);
            }
        }
    }
}

