/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.Query;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ComparisonQuery
extends Query {
    private String op;
    private Field field;
    private Object value;
    private Graph g;

    public ComparisonQuery(Graph graph, String op, Field field, Object value, int type) {
        super(graph, type);
        this.op = op;
        this.field = field;
        this.value = value;
        this.g = graph;
    }

    @Override
    public Set getStates(Set init) {
        if (init == null) {
            init = new HashSet<String>();
        }
        if (this.field.getType() == 1) {
            if (this.field.getState() == null) {
                init.add("nodes");
            } else {
                init.add("nodes_" + this.field.getState());
            }
        } else if (this.field.getState() == null) {
            init.add("edges");
        } else {
            init.add("edges_" + this.field.getState());
        }
        if (this.value instanceof Field) {
            Field temp = (Field)this.value;
            if (temp.getType() == 1) {
                if (temp.getState() == null) {
                    init.add("nodes");
                } else {
                    init.add("nodes_" + temp.getState());
                }
            } else if (temp.getState() == null) {
                init.add("edges");
            } else {
                init.add("edges_" + temp.getState());
            }
        }
        return init;
    }

    @Override
    public String toSQLString() {
        String sqlOp = this.op;
        if (this.op.equals("==")) {
            sqlOp = "=";
        }
        if (this.value instanceof Field) {
            this.value = ((Field)this.value).toSQLString();
        }
        if (this.field.getSQLType() == 12 || this.field.getSQLType() == 1 || this.field.getSQLType() == 91 || this.field.getSQLType() == 92 || this.field.getSQLType() == 93 || this.field.getSQLType() == -1) {
            return this.field.toSQLString() + " " + sqlOp + " '" + this.value + "'";
        }
        return this.field.toSQLString() + " " + sqlOp + " " + this.value;
    }

    @Override
    protected void forceQuery() {
        if (this.field.needsUpdate(this.g)) {
            if (this.field.getType() == 1) {
                Iterator it = this.g.getNodes().iterator();
                if (it.hasNext()) {
                    Node n = (Node)it.next();
                    n.__getattr__(this.field.getName());
                }
            } else {
                Iterator it = this.g.getEdges().iterator();
                if (it.hasNext()) {
                    Edge n = (Edge)it.next();
                    n.__getattr__(this.field.getName());
                }
            }
        }
        this.annotation = this.toSQLString();
        super.forceQuery();
    }

    @Override
    public boolean describes(GraphElement element) {
        double value2;
        Object fieldValue = element.__getattr__(this.field.getName());
        if (this.op.equals("==") || this.op.equals("like")) {
            return fieldValue.equals(this.value);
        }
        if (this.op.equals("!=")) {
            return !fieldValue.equals(this.value);
        }
        double value1 = (Double)fieldValue;
        if (this.value instanceof Double) {
            value2 = (Double)this.value;
        } else if (this.value instanceof Integer) {
            value2 = ((Integer)this.value).intValue();
        } else {
            throw new Error("Invalid number type:  " + this.value.getClass());
        }
        if (this.op.equals("<")) {
            return value1 < value2;
        }
        if (this.op.equals(">")) {
            return value1 > value2;
        }
        if (this.op.equals("<=")) {
            return value1 <= value2;
        }
        if (this.op.equals(">=")) {
            return value1 >= value2;
        }
        throw new Error("Invalid operation:  " + this.op);
    }
}

