/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Query;
import java.util.HashSet;
import java.util.Set;

public class CompoundQuery
extends Query {
    private String op;
    private Query query1;
    private Query query2;

    @Override
    public Set getStates(Set init) {
        if (init == null) {
            init = new HashSet();
        }
        this.query1.getStates(init);
        this.query2.getStates(init);
        return init;
    }

    public CompoundQuery(Graph graph, String op, Query query1, Query query2, int type) {
        super(graph, type);
        this.op = op;
        this.query1 = query1;
        this.query2 = query2;
    }

    @Override
    public String toSQLString() {
        if (this.op.equals("&")) {
            this.op = "AND";
        } else if (this.op.equals("|")) {
            this.op = "OR";
        }
        return "(" + this.query1.toSQLString() + ") " + this.op + " (" + this.query2.toSQLString() + ")";
    }

    @Override
    public boolean describes(GraphElement element) {
        if (this.op.equals("&")) {
            return this.query1.describes(element) && this.query2.describes(element);
        }
        if (this.op.equals("|")) {
            return this.query1.describes(element) || this.query2.describes(element);
        }
        throw new Error("Invalid operation:  " + this.op);
    }
}

