/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.EdgeSchema;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.StateQuery;
import com.hp.hpl.guess.storage.StorageFactory;
import com.hp.hpl.guess.ui.EdgeListener;
import com.hp.hpl.guess.ui.GraphElementListener;
import com.hp.hpl.guess.ui.VisFactory;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.AbstractSparseEdge;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;

public abstract class Edge
extends AbstractSparseEdge
implements GraphElement {
    private EdgeListener rep = null;
    private double weight = 0.0;
    private int id;
    private static int maxID = 0;
    private Object _scratch = null;
    protected String label = null;
    private Node __lastT = null;
    private Node __firstT = null;

    public static int getMaxID() {
        return maxID;
    }

    public int getID() {
        return this.id;
    }

    public double edgeWeight() {
        return this.weight;
    }

    public void updateColumn(String fName, Object o) {
        StorageFactory.getSL().updateColumn(this, this.getSchema().getField(fName), o);
    }

    public Edge(int id, Node node1, Node node2) {
        super((Vertex)node1, (Vertex)node2);
        this.id = id;
        if (id > maxID) {
            maxID = id;
        }
        this.rep = VisFactory.getFactory().generateEdge(this);
    }

    public Edge(Node node1, Node node2) {
        this(maxID + 1, node1, node2);
    }

    public PyObject __getitem__(int key) {
        if (StorageFactory.getSL().containsEdge(this, "" + key)) {
            return new PyJavaInstance(new StateQuery(this, "" + key));
        }
        return null;
    }

    public PyObject __getitem__(PyObject key) {
        if (StorageFactory.getSL().containsEdge(this, key.toString())) {
            return new PyJavaInstance(new StateQuery(this, key.toString()));
        }
        return null;
    }

    @Override
    public Object __getattr__(String fieldName) {
        if ((fieldName = fieldName.toLowerCase()).equals("_scratch")) {
            return this._scratch;
        }
        EdgeSchema schema = this.getSchema();
        if (fieldName.equals("id")) {
            return new Integer(this.id);
        }
        if (fieldName.equals("__edgeid")) {
            return new Integer(this.id);
        }
        if (fieldName.equals("weight")) {
            return new Double(this.weight);
        }
        if (fieldName.equals("betweenness")) {
            ((Graph)this.getGraph()).computeBetweennessCentrality();
        } else if (fieldName.equals("pagerank")) {
            ((Graph)this.getGraph()).computePageRank();
        } else if (fieldName.equals("hits")) {
            ((Graph)this.getGraph()).computeHITS();
        } else if (fieldName.equals("degrank")) {
            ((Graph)this.getGraph()).computeDegreeDistributionRank();
        } else if (fieldName.equals("rwbetweenness")) {
            ((Graph)this.getGraph()).computeRandomWalkBetweenness();
        }
        Object value = this.rep.get(fieldName);
        if (value != null) {
            return value;
        }
        Field field = this.getSchema().getField(fieldName);
        if (field == null) {
            throw new Error("Invalid property:  " + fieldName);
        }
        return StorageFactory.getSL().getColumn(this, field);
    }

    @Override
    public void __setattr__(String name, Object value) {
        if ((name = name.toLowerCase()).equals("_scratch")) {
            this._scratch = value;
            return;
        }
        Field field = this.getSchema().getField(name);
        if (field == null) {
            throw new Error("Invalid property:  " + name);
        }
        value = field.toJava(value);
        if (name.equals("__edgeid")) {
            throw new Error("Cannot modify __edgeid");
        }
        if (name.equals("node1")) {
            throw new Error("Cannot modify node1");
        }
        if (name.equals("node2")) {
            throw new Error("Cannot modify node2");
        }
        if (name.equals("directed")) {
            throw new Error("Cannot modify directed");
        }
        if (name.equals("weight")) {
            this.weight = (Double)value;
        } else if (this.rep.get(name) != null) {
            this.rep.set(name, value);
        }
        if (name.equals("label")) {
            this.label = (String)value;
        }
        if (name.equals("visible") && value == Boolean.TRUE) {
            Node a = this.getNode1();
            Node b = this.getNode2();
            if ((Boolean)a.__getattr__("visible") != Boolean.TRUE) {
                a.__setattr__("visible", Boolean.TRUE);
            }
            if (b != a && (Boolean)b.__getattr__("visible") != Boolean.TRUE) {
                b.__setattr__("visible", Boolean.TRUE);
            }
        }
        this.updateColumn(name, value);
    }

    @Override
    public void show() {
        this.__setattr__("visible", Boolean.TRUE);
    }

    @Override
    public void hide() {
        this.__setattr__("visible", Boolean.FALSE);
    }

    @Override
    public GraphElementListener getRep() {
        return this.rep;
    }

    public void readjust() {
        this.rep.readjust();
    }

    public Collection getNodes() {
        HashSet<Node> hs = new HashSet<Node>();
        hs.add(this.getNode1());
        hs.add(this.getNode2());
        return hs;
    }

    public abstract Node getNode1();

    public abstract Node getNode2();

    private EdgeSchema getSchema() {
        if (this.getGraph() != null) {
            return ((Graph)this.getGraph()).getEdgeSchema();
        }
        return Guess.getGraph().getEdgeSchema();
    }

    @Override
    public Map values() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        Iterator fields = this.getSchema().fields();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            String name = field.getName();
            values.put(name, this.__getattr__(name));
        }
        return values;
    }

    public Node __lastTouched() {
        return this.__lastT;
    }

    protected void __lastTouched(Node n) {
        this.__lastT = n;
    }

    public Node __firstTouched() {
        return this.__firstT;
    }

    protected void __firstTouched(Node n) {
        this.__firstT = n;
    }

    public int compareTo(Object object) {
        Integer thisI = new Integer(this.id);
        Integer otherI = new Integer(((Edge)object).getID());
        return thisI.compareTo(otherI);
    }
}

