/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.ComparisonQuery;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.storage.StorageFactory;
import com.hp.hpl.guess.storage.StorageListener;
import com.hp.hpl.guess.ui.EditorPopup;
import com.hp.hpl.guess.ui.Interesting;
import org.python.core.Py;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;

public final class Field
implements Comparable,
Interesting {
    private Graph graph;
    private String name;
    private int type;
    private int sqlType;
    private String state = null;
    public static final int NODE = 1;
    public static final int EDGE = 2;
    public static boolean nn = false;
    private Object defval = null;
    private long lastMod = System.currentTimeMillis();
    private boolean graphSensitive = false;

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setDynamic(boolean dyn) {
        this.graphSensitive = dyn;
    }

    public void update() {
        this.lastMod = System.currentTimeMillis();
    }

    public boolean needsUpdate(Graph g) {
        if (!this.graphSensitive) {
            return false;
        }
        return g.getLastModTime() > this.lastMod;
    }

    public Object getDefault() {
        return this.defval;
    }

    public void setDefault(Object o) {
        if (o == null && nn) {
            throw Py.AttributeError("Unable to set default to null for this field");
        }
        this.defval = o;
    }

    public boolean isNotNull() {
        return nn;
    }

    public void setNotNull(boolean nn) {
        Field.nn = nn;
    }

    public PyObject __getitem__(int key) {
        Field f = new Field(this.graph, this.name, this.type, this.sqlType, this.defval);
        f.setState(key + "");
        return new PyJavaInstance(f);
    }

    public PyObject __getitem__(PyObject key) {
        Field f = new Field(this.graph, this.name, this.type, this.sqlType, this.defval);
        f.setState(key.toString());
        return new PyJavaInstance(f);
    }

    public Field(Graph graph, String name, int type, int sqlType, Object defval) {
        this.graph = graph;
        this.name = name.toLowerCase();
        this.type = type;
        this.sqlType = sqlType;
        this.defval = defval;
    }

    public Field(Graph graph, String name, int type, int sqlType) {
        this(graph, name, type, sqlType, null);
        System.err.println("Call to deprecated Field constructor.");
    }

    public ComparisonQuery __eq__(Object value) {
        return new ComparisonQuery(this.graph, "==", this, value, this.type);
    }

    public ComparisonQuery __ne__(Object value) {
        return new ComparisonQuery(this.graph, "!=", this, value, this.type);
    }

    public ComparisonQuery __lt__(Object value) {
        return new ComparisonQuery(this.graph, "<", this, value, this.type);
    }

    public ComparisonQuery __gt__(Object value) {
        return new ComparisonQuery(this.graph, ">", this, value, this.type);
    }

    public ComparisonQuery __le__(Object value) {
        return new ComparisonQuery(this.graph, "<=", this, value, this.type);
    }

    public ComparisonQuery __ge__(Object value) {
        return new ComparisonQuery(this.graph, ">=", this, value, this.type);
    }

    public ComparisonQuery __like__(Object value) {
        return new ComparisonQuery(this.graph, "like", this, value, this.type);
    }

    public String toString() {
        return this.name;
    }

    public String toSQLString() {
        StringBuffer sb = null;
        sb = this.type == 1 ? new StringBuffer("nodes") : new StringBuffer("edges");
        if (this.state != null) {
            sb.append("_" + this.state);
        }
        sb.append("." + this.name);
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public Object toJava(Object value) {
        return Field.toJava(value, this.sqlType);
    }

    public static Object toJava(Object value, int sqlType) {
        if (value instanceof PyObject) {
            Class javaClass;
            if (sqlType == 12) {
                javaClass = String.class;
            } else if (sqlType == 8) {
                javaClass = Double.class;
            } else if (sqlType == 2003) {
                double[] x = new double[]{0.0};
                javaClass = x.getClass();
            } else if (sqlType == -6) {
                javaClass = Integer.class;
            } else if (sqlType == 4) {
                javaClass = Integer.class;
            } else if (sqlType == 16) {
                javaClass = Boolean.class;
            } else {
                throw new Error("Unable to convert to SQL type:  " + sqlType);
            }
            value = ((PyObject)value).__tojava__(javaClass);
        } else if (value instanceof Integer && sqlType == 8) {
            value = new Double(((Integer)value).intValue());
        } else if (value instanceof Integer && sqlType == 16) {
            value = new Boolean((Integer)value != 0);
        }
        return value;
    }

    public Object __getattr__(String fieldName) {
        if ((fieldName = fieldName.toLowerCase()).equals("max") || fieldName.equals("min") || fieldName.equals("avg") || fieldName.equals("sum")) {
            if (Field.isNumeric(this.sqlType)) {
                StorageListener db = StorageFactory.getSL();
                Object o = db.getStatistic(this, fieldName);
                return o;
            }
            throw new Error(this.name + " is not a numeric field");
        }
        throw new Error("Invalid property: " + fieldName);
    }

    public boolean isNumeric() {
        return Field.isNumeric(this.sqlType);
    }

    public static boolean isNumeric(int type) {
        return type == 3 || type == 8 || type == 6 || type == 2 || type == 7 || type == -5 || type == -6 || type == 5 || type == 4;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((Field)o).getName());
    }

    @Override
    public String getStatusBarString() {
        StringBuffer sb = new StringBuffer();
        if (this.getType() == 1) {
            sb.append("Node Field, ");
        } else {
            sb.append("Edge Field, ");
        }
        sb.append(this.getName() + " ");
        if (this.isNumeric()) {
            sb.append(this.__getattr__("min") + " - " + this.__getattr__("max"));
        }
        return sb.toString();
    }

    @Override
    public EditorPopup getPopup() {
        return null;
    }
}

