/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class FontTest {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: FontTest file format");
            System.exit(0);
        }
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), args[1]));
        while (br.ready()) {
            sb.append(br.readLine());
        }
        Vector valid = FontTest.getValid(sb.toString());
        System.out.println("\n\nValid fonts to use: \n");
        for (int i = 0; i < valid.size(); ++i) {
            System.out.println(((Font)valid.elementAt(i)).getFontName());
        }
        if (valid.size() == 0) {
            System.out.println("no matching fonts found\n");
        }
    }

    public static Vector getValid(String teststring) {
        Vector<Font> validFonts = new Vector<Font>();
        Font[] allfonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        boolean fontcount = false;
        for (int j = 0; j < allfonts.length; ++j) {
            if (allfonts[j].canDisplayUpTo(teststring) != -1) continue;
            validFonts.add(allfonts[j]);
        }
        return validFonts;
    }
}

