/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.DirectedEdge;
import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.EdgeSchema;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.InterpreterAbstraction;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.NodeSchema;
import com.hp.hpl.guess.UndirectedEdge;
import com.hp.hpl.guess.io.GDFReader;
import com.hp.hpl.guess.io.GraphMLReader;
import com.hp.hpl.guess.layout.BinPack;
import com.hp.hpl.guess.layout.CircularConstrained;
import com.hp.hpl.guess.layout.EdgeAdjustment;
import com.hp.hpl.guess.layout.FruchGraphLayout;
import com.hp.hpl.guess.layout.GEM;
import com.hp.hpl.guess.layout.KamadaGraphLayout;
import com.hp.hpl.guess.layout.Move;
import com.hp.hpl.guess.layout.NetUtilities;
import com.hp.hpl.guess.layout.Physics;
import com.hp.hpl.guess.layout.Radial;
import com.hp.hpl.guess.layout.RandomGraphLayout;
import com.hp.hpl.guess.layout.Rescale;
import com.hp.hpl.guess.layout.SMDS;
import com.hp.hpl.guess.layout.Spring;
import com.hp.hpl.guess.layout.Sugiyama2;
import com.hp.hpl.guess.layout.SugiyamaLayout;
import com.hp.hpl.guess.layout.Translate;
import com.hp.hpl.guess.layout.WeightedSpring;
import com.hp.hpl.guess.pajek.GuessPajekReader;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.Morpher;
import com.hp.hpl.guess.storage.StorageFactory;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.GoneIn30;
import com.hp.hpl.guess.ui.StatusBar;
import com.hp.hpl.guess.ui.VisFactory;
import com.hp.hpl.guess.util.AnnoHashSet;
import com.hp.hpl.guess.util.SortableHashSet;
import com.hp.hpl.guess.util.VisualUtils;
import edu.uci.ics.jung.algorithms.cluster.BicomponentClusterer;
import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.algorithms.cluster.EdgeBetweennessClusterer;
import edu.uci.ics.jung.algorithms.cluster.GraphClusterer;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.algorithms.importance.BetweennessCentrality;
import edu.uci.ics.jung.algorithms.importance.DegreeDistributionRanker;
import edu.uci.ics.jung.algorithms.importance.HITS;
import edu.uci.ics.jung.algorithms.importance.PageRank;
import edu.uci.ics.jung.algorithms.importance.RandomWalkBetweenness;
import edu.uci.ics.jung.algorithms.transformation.DirectionTransformer;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.random.generators.BarabasiAlbertGenerator;
import edu.uci.ics.jung.random.generators.EppsteinPowerLawGenerator;
import edu.uci.ics.jung.random.generators.ErdosRenyiGenerator;
import edu.uci.ics.jung.random.generators.GraphGenerator;
import edu.uci.ics.jung.random.generators.KleinbergSmallWorldGenerator;
import edu.uci.ics.jung.random.generators.Lattice1DGenerator;
import edu.uci.ics.jung.random.generators.Lattice2DGenerator;
import edu.uci.ics.jung.random.generators.SimpleRandomDirectedGenerator;
import edu.uci.ics.jung.random.generators.SimpleRandomGenerator;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.ISOMLayout;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.SpringLayout;
import edu.uci.ics.jung.visualization.contrib.CircleLayout;
import edu.uci.ics.jung.visualization.contrib.DAGLayoutWrapper;
import edu.uci.ics.jung.visualization.contrib.KKLayout;
import edu.uci.ics.jung.visualization.contrib.KKLayoutInt;
import edu.uci.ics.jung.visualization.contrib.WeightedKK;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.python.core.PyFloat;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PySequence;

public class Graph
extends SparseGraph
implements NumberEdgeValue {
    protected Hashtable nameToNode = new Hashtable();
    protected Hashtable idToEdge = new Hashtable();
    protected NodeSchema nodeSchemaInt;
    protected EdgeSchema edgeSchemaInt;
    private FrameListener display;
    private InterpreterAbstraction interp;
    protected long lastMod = System.currentTimeMillis();
    protected double pageRankBias = 0.15;
    protected String edgeWeightKey = null;
    private boolean containsDirected = false;
    private boolean centerAfter = true;
    private static final String __nullKey = new String("___GUESS_NULL");

    public long getLastModTime() {
        return this.lastMod;
    }

    public void resetLastMod() {
        this.lastMod = 0L;
    }

    public Node getNodeByName(String name) {
        return (Node)this.nameToNode.get(name);
    }

    public Edge getEdgeByID(Integer id) {
        return (Edge)this.idToEdge.get(id);
    }

    public void setIdToEdge(Edge e) {
        if (e.getID() == -1) {
            return;
        }
        this.idToEdge.put(new Integer(e.getID()), e);
    }

    public Graph(FrameListener display, InterpreterAbstraction interp) {
        this(display, interp, false);
    }

    public Graph(FrameListener display, InterpreterAbstraction interp, boolean multiedge) {
        if (!multiedge) {
            Collection predicates = this.getEdgeConstraints();
            predicates.add(NOT_PARALLEL_EDGE);
        }
        this.display = display;
        this.interp = interp;
        this.nodeSchemaInt = new NodeSchema(this);
        this.edgeSchemaInt = new EdgeSchema(this);
    }

    public Node addNode(Node n) {
        if (n.getGraph() == this) {
            return n;
        }
        StorageFactory.getSL().undelete(n);
        this.nameToNode.put(n.getName(), n);
        VisFactory.getFactory().add(n);
        this.lastMod = System.currentTimeMillis() - 1L;
        return (Node)this.addVertex((Vertex)n);
    }

    public Node addNode(String name) {
        Node node = new Node(name);
        StorageFactory.getSL().addNode(node);
        this.addNode(node);
        Iterator fields = this.nodeSchemaInt.fields();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            String fieldName = field.getName();
            if (fieldName.equals("name")) continue;
            node.__setattr__(fieldName, field.getDefault());
        }
        this.interp.setImmutable(name, node, false);
        return node;
    }

    public Edge addEdge(Edge e) {
        StorageFactory.getSL().undelete(e);
        if (StorageFactory.getSL().containsEdge(e)) {
            this.addEdgeNoCheck(e);
            return e;
        }
        StorageFactory.getSL().addEdge(e);
        this.addEdgeNoCheck(e);
        Iterator fields = this.edgeSchemaInt.fields();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            String name = field.getName();
            if (name.equals("__edgeid") || name.equals("node1") || name.equals("node2") || name.equals("directed")) continue;
            e.__setattr__(name, field.getDefault());
        }
        return e;
    }

    public Edge addEdgeNoCheck(Edge e) {
        if (e instanceof DirectedEdge) {
            this.containsDirected = true;
        }
        if (e.getGraph() == this) {
            return e;
        }
        super.addEdge((edu.uci.ics.jung.graph.Edge)e);
        this.setIdToEdge(e);
        VisFactory.getFactory().add(e);
        this.lastMod = System.currentTimeMillis() - 1L;
        this.updateDegrees(e);
        return e;
    }

    private void updateDegrees(Edge e) {
        Node n1 = e.getNode1();
        n1.updateDegrees();
        Node n2 = e.getNode2();
        if (n2 != n1) {
            n2.updateDegrees();
        }
    }

    public DirectedEdge addDirectedEdge(Node source, Node dest) {
        int id = StorageFactory.getSL().createDirectedEdge(source, dest);
        return this.addDirectedEdge(source, dest, id);
    }

    public DirectedEdge addDirectedEdgeWID(Node source, Node dest, int id) {
        StorageFactory.getSL().createDirectedEdge(source, dest, id);
        return this.addDirectedEdge(source, dest, id);
    }

    private DirectedEdge addDirectedEdge(Node source, Node dest, int id) {
        this.containsDirected = true;
        DirectedEdge edge = new DirectedEdge(id, source, dest);
        this.addEdgeNoCheck(edge);
        Iterator fields = this.edgeSchemaInt.fields();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            String name = field.getName();
            if (name.equals("__edgeid") || name.equals("node1") || name.equals("node2") || name.equals("directed")) continue;
            edge.__setattr__(name, field.getDefault());
        }
        return edge;
    }

    protected boolean containsDirected() {
        return this.containsDirected;
    }

    public UndirectedEdge addUndirectedEdge(Node node1, Node node2) {
        int id = StorageFactory.getSL().createUndirectedEdge(node1, node2);
        return this.addUndirectedEdge(node1, node2, id);
    }

    public UndirectedEdge addUndirectedEdgeWID(Node node1, Node node2, int id) {
        StorageFactory.getSL().createUndirectedEdge(node1, node2, id);
        return this.addUndirectedEdge(node1, node2, id);
    }

    private UndirectedEdge addUndirectedEdge(Node node1, Node node2, int id) {
        UndirectedEdge edge = new UndirectedEdge(id, node1, node2);
        this.addEdgeNoCheck(edge);
        Iterator fields = this.edgeSchemaInt.fields();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            String name = field.getName();
            if (name.equals("__edgeid") || name.equals("node1") || name.equals("node2") || name.equals("directed")) continue;
            edge.__setattr__(name, field.getDefault());
        }
        return edge;
    }

    public UndirectedEdge addEdge(Node node1, Node node2) {
        return this.addUndirectedEdge(node1, node2);
    }

    public Set removeNode(Node n) {
        AnnoHashSet toReturn = new AnnoHashSet("removeNode(" + n + ")");
        if (n.getGraph() == null) {
            return toReturn;
        }
        toReturn.add(n);
        Iterator edges = n.getIncidentEdges().iterator();
        while (edges.hasNext()) {
            toReturn.addAll(this.removeEdge((Edge)edges.next()));
        }
        super.removeVertex((Vertex)n);
        this.nameToNode.remove(n.getName());
        StorageFactory.getSL().remove(n);
        VisFactory.getFactory().remove(n);
        this.lastMod = System.currentTimeMillis() - 1L;
        return toReturn;
    }

    public void removeNodeComplete(Node n) {
        this.interp.remove(n.getName().intern());
        Iterator edges = n.getIncidentEdges().iterator();
        while (edges.hasNext()) {
            this.removeEdgeComplete((Edge)edges.next());
        }
        if (n.getGraph() != null) {
            super.removeVertex((Vertex)n);
        }
        this.nameToNode.remove(n.getName());
        StorageFactory.getSL().removeComplete(n);
        VisFactory.getFactory().remove(n);
        this.lastMod = System.currentTimeMillis() - 1L;
    }

    public void removeEdgeComplete(Edge e) {
        if (e.getGraph() != null) {
            super.removeEdge((edu.uci.ics.jung.graph.Edge)e);
        }
        this.idToEdge.remove(new Integer(e.getID()));
        StorageFactory.getSL().removeComplete(e);
        VisFactory.getFactory().remove(e);
        this.lastMod = System.currentTimeMillis() - 1L;
        this.updateDegrees(e);
    }

    public void removeComplete(PySequence seq) {
        for (GraphElement element : seq.findGraphElements()) {
            if (element instanceof Node) {
                this.removeNodeComplete((Node)element);
                continue;
            }
            if (!(element instanceof Edge)) continue;
            this.removeEdgeComplete((Edge)element);
        }
        this.lastMod = System.currentTimeMillis() - 1L;
    }

    public Set removeEdge(Edge e) {
        AnnoHashSet hs = new AnnoHashSet("removeEdge(" + e + ")");
        if (e.getGraph() == null) {
            return hs;
        }
        hs.add(e);
        super.removeEdge((edu.uci.ics.jung.graph.Edge)e);
        this.idToEdge.remove(new Integer(e.getID()));
        StorageFactory.getSL().remove(e);
        VisFactory.getFactory().remove(e);
        this.lastMod = System.currentTimeMillis() - 1L;
        this.updateDegrees(e);
        return hs;
    }

    public Set remove(PySequence seq) {
        Iterator it = seq.findGraphElements().iterator();
        AnnoHashSet hs = new AnnoHashSet("remove(...)");
        while (it.hasNext()) {
            GraphElement element = (GraphElement)it.next();
            if (element instanceof Node) {
                hs.addAll(this.removeNode((Node)element));
                continue;
            }
            if (!(element instanceof Edge)) continue;
            hs.addAll(this.removeEdge((Edge)element));
        }
        this.lastMod = System.currentTimeMillis() - 1L;
        return hs;
    }

    public Set complement(PySequence seq) {
        HashSet ntp = new HashSet();
        HashSet etp = new HashSet();
        seq.findNodesAndEdges(ntp, etp);
        HashSet toReturn = new HashSet();
        if (ntp.size() > 0) {
            for (Object o : this.getNodes()) {
                if (ntp.contains(o)) continue;
                toReturn.add(o);
            }
        }
        if (etp.size() > 0) {
            for (Object o : this.getEdges()) {
                if (etp.contains(o)) continue;
                toReturn.add(o);
            }
        }
        return toReturn;
    }

    public Set complement(GraphElement t) {
        HashSet toReturn = new HashSet();
        Iterator it = null;
        it = t instanceof Node ? this.getNodes().iterator() : this.getEdges().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == t) continue;
            toReturn.add(o);
        }
        return toReturn;
    }

    public void add(PySequence seq) {
        HashSet ntp = new HashSet();
        HashSet etp = new HashSet();
        seq.findNodesAndEdges(ntp, etp);
        Iterator it = ntp.iterator();
        while (it.hasNext()) {
            this.addNode((Node)it.next());
        }
        it = etp.iterator();
        while (it.hasNext()) {
            this.addEdge((Edge)it.next());
        }
        this.lastMod = System.currentTimeMillis() - 1L;
    }

    public Set getNodes() {
        return this.getVertices();
    }

    public static Color toColor(Object object) {
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof String) {
            return Colors.getColor((String)object, Color.red);
        }
        if (object instanceof PyJavaInstance) {
            return (Color)((PyInstance)object).__tojava__(Color.class);
        }
        throw new Error("Invalid color class:  " + object.getClass());
    }

    public static double toDouble(Object object) {
        if (object instanceof PyFloat) {
            return ((PyFloat)object).getValue();
        }
        if (object instanceof PyInteger) {
            return ((PyInteger)object).getValue();
        }
        throw new Error("Invalid double class:  " + object.getClass());
    }

    public void readjustEdges() {
        this.expandOverlapping();
    }

    public void compressOverlapping() {
        EdgeAdjustment.compressOverlapping(this);
    }

    public void expandOverlapping() {
        EdgeAdjustment.expandOverlapping(this);
    }

    public void kkLayout() {
        this.kkLayout(1000, 1000);
    }

    public void sugiyamaLayout() {
        this.sugiyamaLayout(false);
    }

    public void sugiyamaLayout(boolean bends) {
        new SugiyamaLayout(this, bends);
        if (this.display instanceof GFrame) {
            ((GFrame)this.display).centerFast();
        } else {
            this.display.center();
        }
    }

    public void sugiyamaLayout2() {
        new Sugiyama2(this);
        if (this.display instanceof GFrame) {
            ((GFrame)this.display).centerFast();
        } else {
            this.display.center();
        }
    }

    public void dagLayout() {
        this.layout((Layout)new DAGLayoutWrapper((edu.uci.ics.jung.graph.Graph)this));
    }

    public void frLayout() {
        this.frLayout(1000, 1000);
    }

    public void mdsLayout() {
        this.layout((Layout)new SMDS(this));
    }

    public void moveLayout(int newX, int newY) {
        this.layout((Layout)new Move(this, newX, newY));
    }

    public void moveLayout(double newX, double newY) {
        this.layout((Layout)new Move(this, newX, newY));
    }

    public void translateLayout(int newX, int newY) {
        this.layout((Layout)new Translate(this, newX, newY));
    }

    public void translateLayout(double newX, double newY) {
        this.layout((Layout)new Translate(this, newX, newY));
    }

    public void rescaleLayout(int width, int height) {
        this.layout((Layout)new Rescale(this, width, height));
    }

    public void rescaleLayout(double percent) {
        this.layout((Layout)new Rescale(this, percent));
    }

    public void rescaleLayout(double xpercent, double ypercent) {
        this.layout((Layout)new Rescale(this, xpercent, ypercent));
    }

    public void radialLayout(Node center) {
        this.layout((Layout)new Radial(this, center));
    }

    public void radialLayout(Node center, PySequence seq) {
        Collection hs = seq.findEdges();
        this.layout((Layout)new Radial(this, center, (HashSet)hs));
    }

    public void randomLayout() {
        this.randomLayout(1000, 1000);
    }

    public void randomLayout(int width, int height) {
        this.layout((Layout)new RandomGraphLayout(this, width, height));
    }

    public void jfrLayout() {
        this.layout((Layout)new FRLayout((edu.uci.ics.jung.graph.Graph)this));
    }

    public void jkkLayout1() {
        this.layout((Layout)new KKLayout((edu.uci.ics.jung.graph.Graph)this));
    }

    public void jkkLayout2() {
        this.layout((Layout)new KKLayoutInt((edu.uci.ics.jung.graph.Graph)this));
    }

    public void weightedKKLayout() {
        this.layout((Layout)new WeightedKK((edu.uci.ics.jung.graph.Graph)this));
    }

    public void frLayout(int width, int height) {
        this.layout((Layout)new FruchGraphLayout(this, true, width, height));
    }

    public void kkLayout(int width, int height) {
        this.layout((Layout)new KamadaGraphLayout(this, true, width, height));
    }

    public void physicsLayout(boolean gather, int max) {
        this.layout((Layout)new Physics(this, gather), max);
    }

    public void physicsLayout() {
        this.layout((Layout)new Physics(this, false));
    }

    public void physicsLayout(int max) {
        this.physicsLayout(false, max);
    }

    public void jSpringLayout() {
        this.layout((Layout)new SpringLayout((edu.uci.ics.jung.graph.Graph)this));
    }

    public void jSpringLayout(int max) {
        this.layout((Layout)new SpringLayout((edu.uci.ics.jung.graph.Graph)this), max);
    }

    public void circleLayout() {
        this.layout((Layout)new CircleLayout((edu.uci.ics.jung.graph.Graph)this));
    }

    public void binPackLayout() {
        this.binPackLayout(true);
    }

    public void binPackLayout(boolean rescale) {
        this.layout((Layout)new BinPack(this, rescale));
    }

    public void circleLayout(Field f, Node c) {
        this.layout((Layout)new CircularConstrained(this, c, f));
    }

    public void circleLayout(Field f, Node c, double xorigin, double yorigin) {
        this.layout((Layout)new CircularConstrained(this, c, f, xorigin, yorigin));
    }

    public void springLayout() {
        this.layout((Layout)new Spring(this));
    }

    public void springLayout(int max) {
        this.layout((Layout)new Spring(this), max);
    }

    public void weightedSpringLayout(int min, int max) {
        this.layout((Layout)new WeightedSpring(this, min, max));
    }

    public void weightedSpringLayout(int minL, int maxL, int max) {
        this.layout((Layout)new WeightedSpring(this, minL, maxL), max);
    }

    public void gemLayout() {
        this.layout((Layout)new GEM(this));
    }

    public void gemLayout(long seed) {
        this.layout((Layout)new GEM(this, seed));
    }

    public void isomLayout() {
        this.layout((Layout)new ISOMLayout((edu.uci.ics.jung.graph.Graph)this));
    }

    public void isomLayout(int max) {
        this.layout((Layout)new ISOMLayout((edu.uci.ics.jung.graph.Graph)this), max);
    }

    public void layout(Layout lay) {
        this.layout(lay, Integer.MAX_VALUE);
    }

    public void centerAfterLayout(boolean state) {
        this.centerAfter = state;
    }

    public void layout(Layout lay, int mi) {
        Graph gt = this;
        final Layout layout = lay;
        StatusBar.runProgressBar(true);
        final int maxIters = mi;
        final boolean ca = this.centerAfter;
        Thread thrd = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Graph.this.interp.freeze(true);
                GoneIn30 g30 = null;
                try {
                    layout.initialize(new Dimension(1000, 1000));
                    if (!layout.isIncremental()) {
                        layout.advancePositions();
                    } else {
                        int incCounter = 0;
                        long curTime = System.currentTimeMillis();
                        while (!layout.incrementsAreDone()) {
                            ++incCounter;
                            layout.advancePositions();
                            long test = System.currentTimeMillis() - curTime;
                            if (maxIters == Integer.MAX_VALUE) {
                                if (incCounter == 1) {
                                    g30 = GoneIn30.getWindow();
                                    g30.start();
                                }
                                if (System.currentTimeMillis() - curTime <= 30000L) continue;
                                this.update();
                                int yn = JOptionPane.showConfirmDialog(null, "Ran " + incCounter + " loops, Continue?", "Continue?", 0);
                                if (yn == 1) {
                                    if (g30 == null) break;
                                    g30.stopTimer();
                                    break;
                                }
                                g30 = GoneIn30.getWindow();
                                g30.start();
                                curTime = System.currentTimeMillis();
                                continue;
                            }
                            if (incCounter >= maxIters) break;
                            if (System.currentTimeMillis() - curTime <= 30000L) continue;
                            StatusBar.setStatus("Ran " + incCounter + " loops");
                            curTime = System.currentTimeMillis();
                        }
                    }
                    this.update();
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
                if (g30 != null) {
                    g30.stopTimer();
                }
                StatusBar.runProgressBar(false);
                Graph.this.interp.freeze(false);
            }

            public void update() {
                double minX = Double.MAX_VALUE;
                double minY = Double.MAX_VALUE;
                double maxX = Double.MIN_VALUE;
                double maxY = Double.MIN_VALUE;
                try {
                    for (Node node : Graph.this.getNodes()) {
                        if (((Boolean)node.__getattr__("fixed")).booleanValue()) continue;
                        double x = layout.getX((Vertex)node);
                        double y = layout.getY((Vertex)node);
                        node.__setattr__("x", new Double(x));
                        node.__setattr__("y", new Double(y));
                        if (x < minX) {
                            minX = x;
                        }
                        if (y < minY) {
                            minY = y;
                        }
                        if (y + node.getHeight() > maxY) {
                            maxY = y + node.getHeight();
                        }
                        if (!(x + node.getWidth() > maxX)) continue;
                        maxX = x + node.getWidth();
                    }
                }
                catch (Exception ex) {
                    ExceptionWindow.getExceptionWindow(ex);
                }
                if (ca) {
                    if (Graph.this.display instanceof GFrame) {
                        ((GFrame)Graph.this.display).center(minX, minY, maxX, maxY, 500L);
                    } else {
                        Graph.this.display.center();
                    }
                }
            }
        });
        if (!Guess.getSynchronous()) {
            thrd.start();
        } else {
            thrd.run();
        }
    }

    public Set biComponentClusters() {
        UndirectedGraph tempGraph = DirectionTransformer.toUndirected((edu.uci.ics.jung.graph.Graph)this);
        Set tempClusters = Graph.clusters((edu.uci.ics.jung.graph.Graph)tempGraph, (GraphClusterer)new BicomponentClusterer());
        HashSet<AnnoHashSet> clusters = new HashSet<AnnoHashSet>();
        for (Set tempCluster : tempClusters) {
            AnnoHashSet cluster = new AnnoHashSet("");
            int counter = 0;
            for (Node tempNode : tempCluster) {
                cluster.add(tempNode.getEqualVertex((ArchetypeGraph)this));
                ++counter;
            }
            cluster.annotation = "BiComp Cluster, " + counter + " nodes";
            clusters.add(cluster);
        }
        return clusters;
    }

    public Set edgeBetweennessClusters(int numEdgesToRemove) {
        return Graph.clusters((edu.uci.ics.jung.graph.Graph)this, (GraphClusterer)new EdgeBetweennessClusterer(numEdgesToRemove));
    }

    public Set weakComponentClusters() {
        return Graph.clusters((edu.uci.ics.jung.graph.Graph)this, (GraphClusterer)new WeakComponentClusterer());
    }

    public Set exactFlowCommunity(int cohesion) {
        return null;
    }

    public static Set clusters(edu.uci.ics.jung.graph.Graph graph, GraphClusterer clusterer) {
        ClusterSet clusterSet = clusterer.extract((ArchetypeGraph)graph);
        HashSet clusters = new HashSet();
        Iterator it = clusterSet.iterator();
        while (it.hasNext()) {
            clusters.add(it.next());
        }
        return clusters;
    }

    public void setNumber(ArchetypeEdge edge, Number number) {
        throw new Error("setNumber not yet supported");
    }

    public Number getNumber(ArchetypeEdge e) {
        return (Number)((Edge)e).__getattr__("weight");
    }

    public void computeAbstractRanker(AbstractRanker centrality, String guessKey, ArchetypeGraph ag) {
        if (this.edgeSchemaInt.getField(guessKey) == null) {
            this.addEdgeField(guessKey, 8, new Double(0.0));
        }
        if (this.nodeSchemaInt.getField(guessKey) == null) {
            this.addNodeField(guessKey, 8, new Double(0.0));
        }
        centrality.setRemoveRankScoresOnFinalize(false);
        centrality.evaluate();
        String key = centrality.getRankScoreKey();
        Iterator nodes = ag.getVertices().iterator();
        while (nodes.hasNext()) {
            try {
                ArchetypeVertex node = (ArchetypeVertex)nodes.next();
                double value = ((MutableDouble)node.getUserDatum((Object)key)).doubleValue();
                Node node2 = (Node)node.getEqualVertex((ArchetypeGraph)this);
                node2.__setattr__(guessKey, new Double(value));
            }
            catch (NullPointerException t) {}
        }
        Iterator edges = ag.getEdges().iterator();
        while (edges.hasNext()) {
            try {
                ArchetypeEdge edge = (ArchetypeEdge)edges.next();
                double value = ((MutableDouble)edge.getUserDatum((Object)key)).doubleValue();
                Edge edge2 = (Edge)edge.getEqualEdge((ArchetypeGraph)this);
                edge2.__setattr__(guessKey, new Double(value));
            }
            catch (NullPointerException t) {}
        }
    }

    public void computeBetweennessCentrality() {
        Field f1 = this.nodeSchemaInt.getField("betweenness");
        Field f2 = this.edgeSchemaInt.getField("betweenness");
        if (f1 == null || f2 == null || f1.needsUpdate(this) || f2.needsUpdate(this)) {
            BetweennessCentrality centrality = new BetweennessCentrality((edu.uci.ics.jung.graph.Graph)this);
            this.computeAbstractRanker((AbstractRanker)centrality, "betweenness", (ArchetypeGraph)this);
            this.nodeSchemaInt.getField("betweenness").update();
            this.edgeSchemaInt.getField("betweenness").update();
        }
    }

    public void setPageRankBias(double bias) {
        this.pageRankBias = bias;
        this.lastMod = System.currentTimeMillis() - 1L;
    }

    public double getPageRankBias() {
        return this.pageRankBias;
    }

    public void setRankerWeightField(Field f) {
        if (f.getType() == 2) {
            if (!f.isNumeric()) {
                throw new Error(f + " is not a numeric field");
            }
            this.edgeWeightKey = "com.hp.hpl.guess.Graph.EdgeWeight";
            for (Edge e : this.getEdges()) {
                MutableDouble value = (MutableDouble)e.getUserDatum(this.edgeWeightKey);
                Object val = e.__getattr__(f.getName());
                double weight = 1.0;
                weight = val instanceof Double ? (Double)val : Double.parseDouble(val.toString());
                if (value == null) {
                    e.setUserDatum(this.edgeWeightKey, new MutableDouble(weight), UserData.SHARED);
                    continue;
                }
                value.setDoubleValue(weight);
            }
        } else {
            throw new Error(f + " is not an edge field");
        }
        this.lastMod = System.currentTimeMillis() - 1L;
    }

    public void computePageRank() {
        Field f1 = this.nodeSchemaInt.getField("pagerank");
        Field f2 = this.edgeSchemaInt.getField("pagerank");
        if (f1 == null || f2 == null || f1.needsUpdate(this) || f2.needsUpdate(this)) {
            DirectedGraph tempGraph = DirectionTransformer.toDirected((edu.uci.ics.jung.graph.Graph)this);
            PageRank centrality = null;
            centrality = this.edgeWeightKey != null ? new PageRank(tempGraph, this.pageRankBias, this.edgeWeightKey) : new PageRank(tempGraph, this.pageRankBias);
            this.computeAbstractRanker((AbstractRanker)centrality, "pagerank", (ArchetypeGraph)tempGraph);
            this.nodeSchemaInt.getField("pagerank").update();
            this.edgeSchemaInt.getField("pagerank").update();
        }
    }

    public void computeDegreeDistributionRank() {
        Field f1 = this.nodeSchemaInt.getField("degrank");
        Field f2 = this.edgeSchemaInt.getField("degrank");
        if (f1 == null || f2 == null || f1.needsUpdate(this) || f2.needsUpdate(this)) {
            DegreeDistributionRanker centrality = new DegreeDistributionRanker((edu.uci.ics.jung.graph.Graph)this);
            this.computeAbstractRanker((AbstractRanker)centrality, "degrank", (ArchetypeGraph)this);
            this.nodeSchemaInt.getField("degrank").update();
            this.edgeSchemaInt.getField("degrank").update();
        }
    }

    public void computeHITS() {
        Field f1 = this.nodeSchemaInt.getField("hits");
        Field f2 = this.edgeSchemaInt.getField("hits");
        if (f1 == null || f2 == null || f1.needsUpdate(this) || f2.needsUpdate(this)) {
            HITS centrality = new HITS((edu.uci.ics.jung.graph.Graph)this);
            this.computeAbstractRanker((AbstractRanker)centrality, "hits", (ArchetypeGraph)this);
            this.nodeSchemaInt.getField("hits").update();
            this.edgeSchemaInt.getField("hits").update();
        }
    }

    public void computeRandomWalkBetweenness() {
        Field f1 = this.nodeSchemaInt.getField("rwbetweenness");
        Field f2 = this.edgeSchemaInt.getField("rwbetweenness");
        if (f1 == null || f2 == null || f1.needsUpdate(this) || f2.needsUpdate(this)) {
            UndirectedGraph tempGraph = DirectionTransformer.toUndirected((edu.uci.ics.jung.graph.Graph)this);
            RandomWalkBetweenness centrality = new RandomWalkBetweenness(tempGraph);
            this.computeAbstractRanker((AbstractRanker)centrality, "rwbetweenness", (ArchetypeGraph)tempGraph);
            this.nodeSchemaInt.getField("rwbetweenness").update();
            this.edgeSchemaInt.getField("rwbetweenness").update();
        }
    }

    public void computeDegrees() {
        Field in = this.nodeSchemaInt.getField("indegree");
        Field out = this.nodeSchemaInt.getField("outdegree");
        Field deg = this.nodeSchemaInt.getField("totaldegree");
        if (in == null || out == null || deg == null || in.needsUpdate(this) || out.needsUpdate(this) || deg.needsUpdate(this)) {
            if (this.nodeSchemaInt.getField("indegree") == null) {
                this.addNodeField("indegree", 4, new Integer(0));
            }
            if (this.nodeSchemaInt.getField("outdegree") == null) {
                this.addNodeField("outdegree", 4, new Integer(0));
            }
            if (this.nodeSchemaInt.getField("totaldegree") == null) {
                this.addNodeField("totaldegree", 4, new Integer(0));
            }
            for (Node n : this.getNodes()) {
                n.updateDegrees();
            }
        }
    }

    public Field addNodeField(String fieldName, int sqlType, Object defaultValue) {
        Field field = new Field(this, fieldName, 1, sqlType, defaultValue);
        this.nodeSchemaInt.addFieldToSL(field);
        this.interp.setImmutable(fieldName, field);
        return field;
    }

    public Field addEdgeField(String fieldName, int sqlType, Object defaultValue) {
        Object o;
        Field field = new Field(this, fieldName, 2, sqlType, defaultValue);
        this.edgeSchemaInt.addFieldToSL(field);
        PyObject f = this.interp.get(fieldName);
        if (f == null) {
            this.interp.setImmutable(fieldName, field);
        } else if (f instanceof PyInstance && !((o = ((PyInstance)f).__tojava__(Object.class)) instanceof Field)) {
            this.interp.setImmutable(fieldName, field);
        }
        return field;
    }

    public NodeSchema getNodeSchema() {
        return this.nodeSchemaInt;
    }

    public EdgeSchema getEdgeSchema() {
        return this.edgeSchemaInt;
    }

    public Collection sortBy(PySequence seq, Field field) {
        ArrayList<SortableGraphElement> list = new ArrayList<SortableGraphElement>();
        for (GraphElement ge : seq.findGraphElements()) {
            list.add(new SortableGraphElement(ge, (Comparable)ge.__getattr__(field.getName())));
        }
        Collections.sort(list);
        Vector<GraphElement> hs = new Vector<GraphElement>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            hs.add(((SortableGraphElement)it.next()).el);
        }
        return hs;
    }

    public Collection sortBy(Field field) {
        Iterator it = null;
        if (field.getType() == 1) {
            it = this.getNodes().iterator();
        } else if (field.getType() == 2) {
            it = this.getEdges().iterator();
        } else {
            throw new Error("invalid Field type");
        }
        ArrayList<SortableGraphElement> list = new ArrayList<SortableGraphElement>();
        while (it.hasNext()) {
            GraphElement ge = (GraphElement)it.next();
            list.add(new SortableGraphElement(ge, (Comparable)ge.__getattr__(field.getName())));
        }
        Collections.sort(list);
        Vector<GraphElement> hs = new Vector<GraphElement>();
        it = list.iterator();
        while (it.hasNext()) {
            hs.add(((SortableGraphElement)it.next()).el);
        }
        return hs;
    }

    public Collection groupBy(PySequence seq, Field field) {
        Hashtable<Object, SortableHashSet> map = new Hashtable<Object, SortableHashSet>();
        for (GraphElement ge : seq.findGraphElements()) {
            Object attrib = ge.__getattr__(field.getName());
            if (!map.containsKey(attrib)) {
                map.put(attrib, new SortableHashSet(field, (Comparable)attrib));
            }
            ((HashSet)map.get(attrib)).add(ge);
        }
        return map.values();
    }

    public Collection groupBy(Field field) {
        if (field.getType() == 1) {
            return this.groupNodesBy(field.getName());
        }
        if (field.getType() == 2) {
            return this.groupEdgesBy(field.getName());
        }
        throw new Error("invalid Field type");
    }

    public Collection groupAndSortBy(Field field) {
        if (field.getType() == 1) {
            return this.groupAndSortNodesBy(field.getName());
        }
        if (field.getType() == 2) {
            return this.groupAndSortEdgesBy(field.getName());
        }
        throw new Error("invalid Field type");
    }

    public Collection groupAndSortBy(PySequence seq, Field field) {
        ArrayList al = new ArrayList();
        al.addAll(this.groupBy(seq, field));
        Collections.sort(al);
        return al;
    }

    public Collection groupAndSortNodesBy(String field) {
        ArrayList al = new ArrayList();
        al.addAll(this.groupNodesBy(field));
        Collections.sort(al);
        return al;
    }

    public Collection groupNodesBy(String field) {
        Hashtable<Object, SortableHashSet> map = new Hashtable<Object, SortableHashSet>();
        for (Node n : this.getNodes()) {
            Object attrib = n.__getattr__(field);
            if (attrib == null) {
                attrib = __nullKey;
            }
            if (!map.containsKey(attrib)) {
                map.put(attrib, new SortableHashSet(field, (Comparable)attrib));
            }
            ((HashSet)map.get(attrib)).add(n);
        }
        return map.values();
    }

    public Collection groupAndSortEdgesBy(String field) {
        ArrayList al = new ArrayList();
        al.addAll(this.groupEdgesBy(field));
        Collections.sort(al);
        return al;
    }

    public Collection groupEdgesBy(String field) {
        Hashtable<Object, SortableHashSet> map = new Hashtable<Object, SortableHashSet>();
        for (Edge n : this.getEdges()) {
            Object attrib = n.__getattr__(field);
            if (attrib == null) {
                attrib = __nullKey;
            }
            if (!map.containsKey(attrib)) {
                map.put(attrib, new SortableHashSet(field, (Comparable)attrib));
            }
            ((HashSet)map.get(attrib)).add(n);
        }
        return map.values();
    }

    public void makeBarabasiAlbertRandom(int vert, int edges, int evolve) {
        BarabasiAlbertGenerator barg = new BarabasiAlbertGenerator(vert, edges);
        barg.evolveGraph(evolve);
        this.makeFromGenerator((GraphGenerator)barg);
    }

    public void makeSimpleRandom(int nodes, int edges) {
        SimpleRandomGenerator srg = new SimpleRandomGenerator(nodes, edges);
        this.makeFromGenerator((GraphGenerator)srg);
    }

    public void makeSimpleDirectedRandom(int nodes, int edges) {
        SimpleRandomDirectedGenerator srg = new SimpleRandomDirectedGenerator(nodes, edges);
        this.makeFromGenerator(srg);
    }

    public void makeEppsteinRandom(int nodes, int edges, int r) {
        EppsteinPowerLawGenerator srg = new EppsteinPowerLawGenerator(nodes, edges, r);
        this.makeFromGenerator((GraphGenerator)srg);
    }

    public void makeErdosRenyiRandom(int nodes, double p) {
        ErdosRenyiGenerator srg = new ErdosRenyiGenerator(nodes, p);
        this.makeFromGenerator((GraphGenerator)srg);
    }

    public void makeLattice1DRandom(int nodes, boolean tor) {
        Lattice1DGenerator srg = new Lattice1DGenerator(nodes, tor);
        this.makeFromGenerator((GraphGenerator)srg);
    }

    public void makeLattice2DRandom(int nodes, boolean tor) {
        Lattice2DGenerator srg = new Lattice2DGenerator(nodes, tor);
        this.makeFromGenerator((GraphGenerator)srg);
    }

    public void makeKleinbergRandom(int nodes, double clust) {
        KleinbergSmallWorldGenerator srg = new KleinbergSmallWorldGenerator(nodes, clust);
        this.makeFromGenerator((GraphGenerator)srg);
    }

    public void makeFromGenerator(GraphGenerator gg) {
        ArchetypeGraph ag = gg.generateGraph();
        Iterator it = ag.getVertices().iterator();
        int i = 0;
        Hashtable map = new Hashtable();
        while (it.hasNext()) {
            Node n = this.addNode("nd" + i);
            map.put(it.next(), n);
            ++i;
        }
        for (edu.uci.ics.jung.graph.Edge e : ag.getEdges()) {
            Pair p = e.getEndpoints();
            Node n1 = (Node)map.get(p.getFirst());
            Node n2 = (Node)map.get(p.getSecond());
            if (e instanceof DirectedSparseEdge) {
                this.addDirectedEdge(n1, n2);
                continue;
            }
            this.addUndirectedEdge(n1, n2);
        }
        this.randomLayout();
    }

    public void makeFromGML(String filename) {
        GraphMLReader gmr = new GraphMLReader(this, filename);
        boolean tmp = this.centerAfter;
        boolean tmp2 = Guess.getSynchronous();
        Guess.setSynchronous(true);
        this.centerAfter = false;
        this.randomLayout();
        Guess.setSynchronous(tmp2);
        this.centerAfter = tmp;
        if (this.containsDirected()) {
            VisFactory.getFactory().setDirected(true);
        }
    }

    public void makeFromPajek(String filename) {
        GuessPajekReader.readFile(this, filename);
        if (this.containsDirected()) {
            VisFactory.getFactory().setDirected(true);
        }
    }

    public void makeFromDL(String filename) {
    }

    public void makeFromGDF(String filename) throws IOException {
        GDFReader gmr = new GDFReader(this, filename);
        if (this.containsDirected()) {
            VisFactory.getFactory().setDirected(true);
        }
    }

    public void exportGDF(String filename) {
        StorageFactory.getSL().exportGDF(filename);
    }

    public void morph(String state, long duration) {
        if (VisFactory.getUIMode() == 1) {
            Morpher.morph(this, state, duration);
        }
    }

    public void morph(int state, long duration) {
        this.morph("" + state, duration);
    }

    public void colorize(Field f) {
        VisualUtils.colorize(this, f);
    }

    public void colorize(Field f, Color start, Color end) {
        VisualUtils.colorize(this, f, start, end);
    }

    public void colorize(Field f, String start, String end) {
        VisualUtils.colorize(this, f, Colors.getColor(start, Color.red), Colors.getColor(end, Color.blue));
    }

    public void colorize(Field f, Color start, Color middle, Color end) {
        VisualUtils.colorize(this, f, start, middle, end);
    }

    public void colorize(Field f, String start, String middle, String end) {
        VisualUtils.colorize(this, f, Colors.getColor(start, Color.red), Colors.getColor(middle, Color.green), Colors.getColor(end, Color.blue));
    }

    public void resizeRandom(Field f, double start, double end) {
        VisualUtils.resizeRandom(this, f, start, end);
    }

    public void resizeLinear(Field f, double start, double end) {
        VisualUtils.resizeLinear(this, f, start, end);
    }

    public double density() {
        return NetUtilities.calcDensity(this.getNodes());
    }

    public Set removeSelfLoops() {
        Iterator it = this.getEdges().iterator();
        AnnoHashSet toRemove = new AnnoHashSet("Self loops");
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            if (e.getNode1() != e.getNode2()) continue;
            toRemove.add(e);
        }
        it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeEdge((Edge)it.next());
        }
        return toRemove;
    }

    public Set removeDisconnected() {
        Iterator it = this.getNodes().iterator();
        AnnoHashSet toRemove = new AnnoHashSet("Disconnected");
        while (it.hasNext()) {
            Node n = (Node)it.next();
            boolean todo = true;
            for (Edge e : n.getIncidentEdges()) {
                Node t1 = e.getNode1();
                Node t2 = e.getNode2();
                if (n == t1 && n == t2) continue;
                todo = false;
                break;
            }
            if (!todo) continue;
            toRemove.add(n);
        }
        for (Node n : toRemove) {
            this.removeNode(n);
        }
        return toRemove;
    }

    public void hideDisconnected() {
        for (Node n : this.getNodes()) {
            boolean todo = true;
            for (Edge e : n.getIncidentEdges()) {
                Node t1 = e.getNode1();
                Node t2 = e.getNode2();
                if (n == t1 && n == t2) continue;
                todo = false;
                break;
            }
            if (!todo) continue;
            n.__setattr__("visible", new Boolean(false));
        }
    }

    class SortableGraphElement
    implements Comparable {
        public Comparable key = null;
        public GraphElement el = null;

        public SortableGraphElement(GraphElement el, Comparable key) {
            this.key = key;
            this.el = el;
        }

        public int compareTo(Object o) {
            try {
                return this.key.compareTo(((SortableGraphElement)o).key);
            }
            catch (Exception ex) {
                ExceptionWindow.getExceptionWindow(ex);
                return -1;
            }
        }
    }
}

