/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.FakeInterpreter;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.InterpreterAbstraction;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.RealInterpreter;
import com.hp.hpl.guess.Version;
import com.hp.hpl.guess.r.R;
import com.hp.hpl.guess.storage.StorageFactory;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.GraphEvents;
import com.hp.hpl.guess.ui.MainUIWindow;
import com.hp.hpl.guess.ui.PickFile;
import com.hp.hpl.guess.ui.ShapeDB;
import com.hp.hpl.guess.ui.StatusBar;
import com.hp.hpl.guess.ui.SunFileFilter;
import com.hp.hpl.guess.ui.TextPaneJythonConsole;
import com.hp.hpl.guess.ui.VisFactory;
import com.hp.hpl.guess.util.intervals.Tracker;
import com.jgoodies.looks.FontSizeHints;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jidesoft.utils.Lm;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyObject;
import org.python.core.PySyntaxError;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class Guess {
    private static FrameListener myF = null;
    private static Graph g = null;
    private static InterpreterAbstraction interpSingleton = null;
    private static boolean fakeInterp = false;
    private static final char sep = File.separatorChar;
    private static String doLater = null;
    private static Vector pythonToExec = null;
    private static boolean appletMode = false;
    private static boolean signedAppletMode = false;
    private static AppletContext myAC = null;
    private static boolean gplFree = false;
    private static boolean enableMainUI = true;
    private static boolean multiEdge = false;
    private static TextPaneJythonConsole tpjc = null;
    private static MainUIWindow myWin = null;
    public static boolean nowarn = false;
    public static String defaultFont = null;
    public static String defaultFileFormat = null;
    static BufferedReader reader = null;
    public static BufferedReader outHandle = null;
    public static BufferedReader errHandle = null;
    public static boolean handleOver = true;
    private static boolean sync = false;
    private static boolean mtf = false;

    public static boolean allowMultiEdge() {
        return multiEdge;
    }

    public static void enableMainUI(boolean state) {
        enableMainUI = state;
    }

    public static void setGPLFreeMode(boolean state) {
        gplFree = state;
    }

    public static boolean getGPLFreeMode() {
        return gplFree;
    }

    public static void setSignedAppletMode(boolean state) {
        signedAppletMode = state;
    }

    public static boolean getSignedAppletMode() {
        return signedAppletMode;
    }

    public static void setAppletMode(boolean state, AppletContext ac) {
        appletMode = state;
        myAC = ac;
    }

    public static boolean getAppletMode() {
        return appletMode;
    }

    public static AppletContext getAppletContext() {
        return myAC;
    }

    public static void useFakeInterpreter(boolean state) {
        fakeInterp = state;
    }

    public static InterpreterAbstraction getInterpreter() {
        if (interpSingleton == null) {
            if (fakeInterp) {
                interpSingleton = new FakeInterpreter();
            } else {
                PySystemState.initialize();
                interpSingleton = new RealInterpreter();
            }
        }
        return interpSingleton;
    }

    private static void setFrame(FrameListener gf) {
        myF = gf;
    }

    public static FrameListener getFrame() {
        return myF;
    }

    public static TextPaneJythonConsole getJythonConsole() {
        return tpjc;
    }

    public static Graph getGraph() {
        return g;
    }

    public static MainUIWindow getMainUIWindow() {
        return myWin;
    }

    public static String getDefaultFont() {
        if (defaultFont != null && defaultFont.equals("GUESSFONT")) {
            defaultFont = null;
        }
        return defaultFont;
    }

    public static void setDefaultFont(String font) {
        defaultFont = font;
    }

    public static String getDefaultFileFormat() {
        return defaultFileFormat;
    }

    public static void setCacheDir() {
        Properties prop = System.getProperties();
        String tempdir = System.getProperty("java.io.tmpdir");
        if (tempdir == null) {
            tempdir = "";
        }
        tempdir = tempdir + File.separatorChar + "cachedir";
        prop.setProperty("python.cachedir", tempdir);
    }

    public static void main(String[] argv) throws Exception {
        int c;
        Lm.verifyLicense((String)"GUESS", (String)"GUESS", (String)"kaiS04IaJ.QjUq.ZLB0OWobuNMddGb41");
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            Guess.configureUI();
        }
        catch (Exception lnfe) {
            // empty catch block
        }
        LongOpt[] longopts = new LongOpt[]{new LongOpt("prefuse", 0, null, 112), new LongOpt("touchgraph", 0, null, 116), new LongOpt("console", 0, null, 99), new LongOpt("persistent", 1, null, 111), new LongOpt("gplfree", 0, null, 102), new LongOpt("nowarn", 0, null, 110), new LongOpt("novis", 0, null, 118), new LongOpt("multiedge", 0, null, 109), new LongOpt("fontsize", 1, null, 115), new LongOpt("jung", 0, null, 106), new LongOpt("consolelog", 0, null, 108), new LongOpt("font", 1, null, 97), new LongOpt("fileformat", 1, null, 98), new LongOpt("fitfont", 0, null, 103)};
        Getopt go = new Getopt("Guess", argv, ":ptcvmofnmsl", longopts);
        go.setOpterr(false);
        boolean guiMode = true;
        int uiMode = 1;
        String persistent = null;
        block22: while ((c = go.getopt()) != -1) {
            switch (c) {
                case 112: {
                    uiMode = 2;
                    continue block22;
                }
                case 106: {
                    uiMode = 5;
                    continue block22;
                }
                case 116: {
                    uiMode = 3;
                    continue block22;
                }
                case 118: {
                    uiMode = 4;
                    continue block22;
                }
                case 99: {
                    guiMode = false;
                    continue block22;
                }
                case 110: {
                    nowarn = true;
                    continue block22;
                }
                case 102: {
                    System.out.println("****Running in GPL Free Mode****");
                    gplFree = true;
                    continue block22;
                }
                case 111: {
                    if (go.getOptarg() == null) {
                        System.out.println("Please enter a database directory to use -o/--persistent");
                        System.exit(0);
                        continue block22;
                    }
                    persistent = go.getOptarg();
                    continue block22;
                }
                case 115: {
                    if (go.getOptarg() == null) {
                        System.out.println("Please specify a numerical font size with the -s/--fontsize option");
                        System.exit(0);
                        continue block22;
                    }
                    int size = 10;
                    try {
                        size = Integer.parseInt(go.getOptarg());
                        TextPaneJythonConsole.setFontSize(size);
                    }
                    catch (Exception ne) {
                        System.out.println("Please specify a numerical font size with the -s/--fontsize option");
                        System.exit(0);
                    }
                    continue block22;
                }
                case 109: {
                    System.out.println("allowing multiple edges");
                    multiEdge = true;
                    continue block22;
                }
                case 108: {
                    System.out.println("STDOUT/STDERR logged to console");
                    handleOver = false;
                    continue block22;
                }
                case 97: {
                    defaultFont = go.getOptarg();
                    continue block22;
                }
                case 103: {
                    defaultFont = "GUESSFONT";
                    System.out.println("Trying to find best font");
                    continue block22;
                }
                case 98: {
                    defaultFileFormat = go.getOptarg();
                    continue block22;
                }
                case 58: {
                    System.out.print("unknown option: " + (char)c + "\n");
                    continue block22;
                }
                case 63: {
                    System.out.print("unknown option: " + (char)c + "\n");
                    continue block22;
                }
            }
            System.out.print("unknown option: " + (char)c + "\n");
            System.exit(0);
        }
        System.out.println("GUESS Version: " + Version.MAJOR_VERSION + " (" + Version.MINOR_VERSION + ")");
        Guess.setCacheDir();
        String database = null;
        for (int i = go.getOptind(); i < argv.length; ++i) {
            if (argv[i].endsWith(".py") || argv[i].endsWith(".Py") || argv[i].endsWith(".PY")) {
                if (pythonToExec == null) {
                    pythonToExec = new Vector();
                }
                pythonToExec.addElement(argv[i]);
                continue;
            }
            database = argv[i];
        }
        if (database == null) {
            Guess.getDataBase();
        } else {
            File f = new File(database);
            String fileExtension = "";
            if (f.exists()) {
                SunFileFilter filter = new SunFileFilter();
                fileExtension = filter.getExtension(f);
            }
            if (database.equals("null")) {
                StorageFactory.useDBServer();
                StorageFactory.createEmpty();
            } else if (fileExtension.equalsIgnoreCase("gdf")) {
                if (persistent != null) {
                    StorageFactory.useDBServer(persistent);
                } else {
                    StorageFactory.useDBServer();
                }
                StorageFactory.loadFromFile(database);
            } else if (fileExtension.equalsIgnoreCase("xml") || fileExtension.equalsIgnoreCase("graphml")) {
                if (persistent != null) {
                    StorageFactory.useDBServer(persistent);
                } else {
                    StorageFactory.useDBServer();
                }
                StorageFactory.createEmpty();
                doLater = "g.makeFromGML(\"" + database.replace('\\', '/') + "\")";
            } else if (fileExtension.equalsIgnoreCase("net") || fileExtension.equalsIgnoreCase("paj") || fileExtension.equalsIgnoreCase("pajek")) {
                if (persistent != null) {
                    StorageFactory.useDBServer(persistent);
                } else {
                    StorageFactory.useDBServer();
                }
                StorageFactory.createEmpty();
                doLater = "g.makeFromPajek(\"" + database.replace('\\', '/') + "\")";
            } else if (fileExtension.equalsIgnoreCase("dl")) {
                if (persistent != null) {
                    StorageFactory.useDBServer(persistent);
                } else {
                    StorageFactory.useDBServer();
                }
                StorageFactory.createEmpty();
                doLater = "g.makeFromDL(\"" + database.replace('\\', '/') + "\")";
            } else {
                System.out.println(database + " not found as file, trying to load database");
                StorageFactory.useDBServer(database);
            }
        }
        InterpreterAbstraction interp = Guess.getInterpreter();
        interp.exec("from java.sql import Types");
        interp.exec("from com.hp.hpl.guess.ui import VisFactory");
        interp.exec("from com.hp.hpl.guess.ui import Colors");
        interp.exec("from com.hp.hpl.guess import Subgraph");
        interp.exec("from com.hp.hpl.guess.piccolo import Legend");
        interp.exec("from com.hp.hpl.guess.piccolo import GradientLegend");
        interp.exec("from com.hp.hpl.guess.ui import InfoWindow");
        interp.exec("from com.hp.hpl.guess.ui import DragWindow");
        interp.exec("from com.hp.hpl.guess.ui import DWButton");
        interp.exec("from com.hp.hpl.guess.ui import ExceptionWindow");
        interp.exec("from com.hp.hpl.guess.ui import DrawWindow");
        interp.exec("from com.hp.hpl.guess.util.intervals import Tracker");
        interp.exec("from com.hp.hpl.guess.ui import GraphElementEditorPopup");
        interp.exec("from com.hp.hpl.guess.ui import NodeEditorPopup");
        interp.exec("from com.hp.hpl.guess.ui import EdgeEditorPopup");
        Guess.init(uiMode, guiMode, !guiMode);
    }

    public static void getDataBase() {
        Object[] options = new Object[]{"Existing Database", "Load GDF/GraphML", "Empty"};
        int n = JOptionPane.showOptionDialog(null, "Would you like to open an existing database, load a graph definition file, or start with a blank space?", "Welcome to GUESS", 0, 3, null, options, options[0]);
        if (n == 0 ? Guess.existingChooser() : (n == 1 ? Guess.newChooser() : Guess.emptyChooser())) {
            return;
        }
        Guess.getDataBase();
    }

    private static boolean existingChooser() {
        try {
            String toLoad = ".";
            try {
                toLoad = System.getProperty("gHome");
                if (toLoad == null) {
                    toLoad = ".";
                } else {
                    File testF = new File(toLoad);
                    if (!testF.exists() || !testF.isDirectory()) {
                        toLoad = ".";
                    }
                }
            }
            catch (Exception hde) {
                toLoad = ".";
            }
            JFileChooser chooser = new JFileChooser(new File(toLoad).getCanonicalPath());
            SunFileFilter filter = new SunFileFilter();
            filter.addExtension("properties");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                String fileName = chooser.getSelectedFile().getAbsolutePath();
                fileName = fileName.substring(0, fileName.length() - 11);
                StorageFactory.useDBServer(fileName);
                return true;
            }
        }
        catch (Exception e) {
            Guess.exceptionHandle(e);
        }
        return false;
    }

    private static boolean newChooser() {
        try {
            PickFile chooser = new PickFile();
            File returnVal = chooser.showDialog();
            if (returnVal != null) {
                String fileName = returnVal.getAbsolutePath();
                SunFileFilter filter = new SunFileFilter();
                String fileExtension = filter.getExtension(returnVal);
                if (chooser.isPersistent()) {
                    String directory = chooser.getDirectory().getCanonicalPath();
                    String dbName = chooser.getName();
                    if (fileExtension.equalsIgnoreCase("dl")) {
                        StorageFactory.useDBServer(directory + sep + dbName);
                        StorageFactory.createEmpty();
                        doLater = "g.makeFromDL(\"" + fileName.replace('\\', '/') + "\")";
                    } else if (fileExtension.equalsIgnoreCase("xml") || fileExtension.equalsIgnoreCase("graphml")) {
                        StorageFactory.useDBServer(directory + sep + dbName);
                        StorageFactory.createEmpty();
                        doLater = "g.makeFromGML(\"" + fileName.replace('\\', '/') + "\")";
                    } else if (fileExtension.equalsIgnoreCase("net") || fileExtension.equalsIgnoreCase("paj") || fileExtension.equalsIgnoreCase("pajek")) {
                        StorageFactory.useDBServer(directory + sep + dbName);
                        StorageFactory.createEmpty();
                        doLater = "g.makeFromPajek(\"" + fileName.replace('\\', '/') + "\")";
                    } else {
                        StorageFactory.useDBServer(directory + sep + dbName);
                        StorageFactory.loadFromFile(fileName);
                    }
                    return true;
                }
                if (fileExtension.equalsIgnoreCase("dl")) {
                    StorageFactory.useDBServer();
                    StorageFactory.createEmpty();
                    doLater = "g.makeFromDL(\"" + fileName.replace('\\', '/') + "\")";
                } else if (fileExtension.equalsIgnoreCase("xml") || fileExtension.equalsIgnoreCase("graphml")) {
                    StorageFactory.useDBServer();
                    StorageFactory.createEmpty();
                    doLater = "g.makeFromGML(\"" + fileName.replace('\\', '/') + "\")";
                } else if (fileExtension.equalsIgnoreCase("net") || fileExtension.equalsIgnoreCase("paj") || fileExtension.equalsIgnoreCase("pajek")) {
                    StorageFactory.useDBServer();
                    StorageFactory.createEmpty();
                    doLater = "g.makeFromPajek(\"" + fileName.replace('\\', '/') + "\")";
                } else {
                    StorageFactory.useDBServer();
                    StorageFactory.loadFromFile(fileName);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Guess.exceptionHandle(e);
            return false;
        }
    }

    private static boolean emptyChooser() {
        try {
            StorageFactory.useDBServer();
            StorageFactory.createEmpty();
            return true;
        }
        catch (Exception e) {
            Guess.exceptionHandle(e);
            return false;
        }
    }

    public static void configureUI() {
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setGlobalFontSizeHints((FontSizeHints)FontSizeHints.MIXED);
        Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
        String lafName = LookUtils.IS_OS_WINDOWS_XP ? Options.getCrossPlatformLookAndFeelClassName() : Options.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            System.err.println("Can't set look & feel");
            Guess.exceptionHandle(e);
        }
    }

    public static void exceptionHandle(Throwable e2) {
        if (e2 instanceof PyException) {
            e2.printStackTrace();
        } else {
            System.out.println(e2.toString() + "\n\t(Use Help->Error Log for more details)");
        }
        ExceptionWindow.getExceptionWindow(e2);
    }

    public static void init(int uiMode, boolean guiMode, boolean textMode) throws Exception {
        Guess.initUI(uiMode, guiMode, textMode);
        Guess.initRest(uiMode, guiMode, textMode);
    }

    public static void initHandles() throws Exception {
        PipedOutputStream pos;
        PipedInputStream pis;
        if (handleOver) {
            return;
        }
        if (outHandle == null) {
            pis = new PipedInputStream();
            pos = new PipedOutputStream(pis);
            System.setOut(new PrintStream(pos));
            outHandle = new BufferedReader(new InputStreamReader(pis));
        }
        if (errHandle == null) {
            pis = new PipedInputStream();
            pos = new PipedOutputStream(pis);
            System.setErr(new PrintStream(pos));
            errHandle = new BufferedReader(new InputStreamReader(pis));
        }
    }

    public static void setSynchronous(boolean state) {
        sync = state;
    }

    public static boolean getSynchronous() {
        return sync;
    }

    public static void setMTF(boolean state) {
        mtf = state;
    }

    public static boolean getMTF() {
        return mtf;
    }

    public static void initUI(int uiMode, boolean guiMode, boolean textMode) throws Exception {
        FrameListener myFrame;
        if (textMode && guiMode) {
            guiMode = true;
            textMode = false;
        }
        InterpreterAbstraction interp = Guess.getInterpreter();
        final int uiMode2 = uiMode;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    VisFactory.setFactory(uiMode2);
                }
            });
        }
        catch (Exception e) {
            Guess.exceptionHandle(e);
        }
        myF = myFrame = VisFactory.getFactory().getDisplay();
        myF.setDisplayBackground(Color.black);
        try {
            g = new Graph(myFrame, interp, multiEdge);
            StorageFactory.getSL().refresh(g);
        }
        catch (Exception e) {
            Guess.exceptionHandle(e);
        }
        if (enableMainUI) {
            myWin = new MainUIWindow((Component)((Object)myFrame));
        }
        VisFactory.getFactory().runNow();
        for (Node node : g.getVertices()) {
            interp.setImmutable(node.getName(), node);
        }
        Enumeration en = Colors.colors.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Color val = (Color)Colors.colors.get(key);
            interp.setImmutable(key, val.toString());
        }
        if (g.containsDirected()) {
            VisFactory.getFactory().setDirected(true);
        }
    }

    public static void initRest(int uiMode, boolean guiMode, boolean textMode) throws Exception {
        Field field;
        URL mbpy;
        if (guiMode) {
            Guess.initHandles();
        }
        final FrameListener myFrame = VisFactory.getFactory().getDisplay();
        final InterpreterAbstraction interp = Guess.getInterpreter();
        interp.setImmutable("v", myFrame);
        interp.setImmutable("true", new Integer(1));
        interp.setImmutable("false", new Integer(0));
        interp.setImmutable("Node", g.getNodeSchema());
        interp.setImmutable("Edge", g.getEdgeSchema());
        interp.setImmutable("g", (Object)g);
        interp.setImmutable("db", StorageFactory.getSL());
        R myR = new R();
        interp.setImmutable("r", myR);
        interp.setImmutable("interp", interp);
        interp.setImmutable("vf", VisFactory.getFactory());
        interp.setImmutable("graphevents", GraphEvents.getGraphEvents());
        interp.setImmutable("shapeDB", ShapeDB.getShapeDB());
        if (enableMainUI) {
            interp.setImmutable("ui", myWin);
            try {
                mbpy = interp.getClass().getResource("/scripts/MenuBar.py");
                if (mbpy != null) {
                    interp.execfile(mbpy.openStream());
                }
            }
            catch (Throwable fe) {
                Guess.exceptionHandle(fe);
            }
            myWin.validate();
        }
        try {
            mbpy = null;
            mbpy = interp.getClass().getResource("/scripts/Main.py");
            if (mbpy != null) {
                interp.execfile(mbpy.openStream());
            }
        }
        catch (Throwable fe) {
            Guess.exceptionHandle(fe);
            try {
                if (appletMode) {
                    URL mbpy2 = null;
                    mbpy2 = interp.getClass().getResource("/scripts/Main-applet.py");
                    if (mbpy2 != null) {
                        interp.execfile(mbpy2.openStream());
                    }
                }
            }
            catch (Throwable fe2) {
                Guess.exceptionHandle(fe2);
            }
        }
        Iterator fields = g.getEdgeSchema().fields();
        while (fields.hasNext()) {
            field = (Field)fields.next();
            interp.setImmutable(field.getName(), field);
        }
        fields = g.getNodeSchema().fields();
        while (fields.hasNext()) {
            field = (Field)fields.next();
            interp.setImmutable(field.getName(), field);
        }
        if (guiMode) {
            if (gplFree) {
                System.out.println("running in GPL free mode, unable to use UI console, reverting to text...");
                guiMode = false;
                textMode = true;
            } else if (enableMainUI) {
                tpjc = new TextPaneJythonConsole((PythonInterpreter)((Object)interp));
                myWin.dock(tpjc);
            }
        }
        myFrame.repaint();
        if (doLater != null) {
            final InterpreterAbstraction ia = interp;
            final String doLater2 = doLater;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ia.exec(doLater2);
                    }
                });
            }
            catch (Exception e) {
                Guess.exceptionHandle(e);
            }
        }
        if (pythonToExec != null) {
            for (final String fl : pythonToExec) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            interp.execfile(fl);
                            StatusBar.setStatus("executed: " + fl);
                        }
                    });
                }
                catch (Exception e) {
                    Guess.exceptionHandle(e);
                }
            }
        }
        myFrame.center();
        if (textMode) {
            reader = new BufferedReader(new InputStreamReader(System.in));
            String s = Guess.readLine();
            Tracker.disableTracker();
            while (!s.equals("quit")) {
                if (s.equals("rmode")) {
                    myR.rmode(reader);
                    s = Guess.readLine();
                    continue;
                }
                final String s2 = s;
                try {
                    StatusBar.setStatus("");
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PyObject value = interp.eval(s2);
                                Guess.checkFrozen(interp);
                                interp.set("_", (Object)value);
                                if (value instanceof PyFunction) {
                                    Guess.checkFrozen(interp);
                                    interp.set("_", interp.eval("apply(_, ())"));
                                }
                                Guess.checkFrozen(interp);
                                interp.exec("if _ != None: print _");
                            }
                            catch (PySyntaxError e) {
                                try {
                                    Guess.checkFrozen(interp);
                                    interp.exec(s2);
                                }
                                catch (Throwable e2) {
                                    Guess.exceptionHandle(e2);
                                }
                                StatusBar.runProgressBar(false);
                            }
                            catch (Throwable e3) {
                                Guess.exceptionHandle(e3);
                                StatusBar.runProgressBar(false);
                            }
                            myFrame.repaint();
                        }
                    });
                }
                catch (InterruptedException e) {
                    StatusBar.runProgressBar(false);
                    Guess.exceptionHandle(e);
                }
                Guess.checkFrozen(interp);
                s = Guess.readLine();
            }
            Guess.shutdown();
        }
    }

    public static void checkFrozen(InterpreterAbstraction interp) {
        while (interp.isFrozen()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                interp.freeze(false);
            }
        }
    }

    public static void shutdown() {
        if (interpSingleton != null) {
            interpSingleton.stoplog();
        }
        StorageFactory.shutdown();
        myF = null;
        g = null;
        interpSingleton = null;
        VisFactory.shutdown();
        if (tpjc != null) {
            tpjc.shutdown();
        }
        if (myWin != null) {
            myWin.dispose();
        }
        myWin = null;
        if (!appletMode) {
            System.exit(0);
        }
    }

    private static String readLine() {
        System.out.print("> ");
        try {
            String s = reader.readLine();
            if (s.endsWith(":")) {
                System.out.print(". ");
                String t = reader.readLine();
                while (!t.equals("")) {
                    s = s + "\n" + t;
                    System.out.print(". ");
                    t = reader.readLine();
                }
            }
            return s;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

