/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.storage.StorageFactory;
import com.hp.hpl.guess.ui.ExceptionWindow;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.python.core.PySystemState;

public class GuessApplet
extends Applet {
    @Override
    public void init() {
        try {
            PySystemState.initializeApplet();
            Guess.setAppletMode(true, this.getAppletContext());
            Guess.configureUI();
            Guess.useFakeInterpreter(true);
            System.out.println("init...");
            String db_url = this.getParameter("URL");
            if (db_url != null && !db_url.equals("")) {
                try {
                    String line;
                    URLConnection conn = null;
                    DataInputStream data = null;
                    StringBuffer buf = new StringBuffer();
                    URL theURL = new URL(db_url);
                    conn = theURL.openConnection();
                    conn.connect();
                    data = new DataInputStream(new BufferedInputStream(conn.getInputStream()));
                    while ((line = data.readLine()) != null) {
                        buf.append(line + "\n");
                    }
                    data.close();
                    StorageFactory.useDBServer();
                    StorageFactory.loadFromText(buf.toString());
                }
                catch (MalformedURLException e) {
                    System.out.println("Bad URL: " + db_url);
                }
                catch (IOException e) {
                    System.out.println("IO Error:" + e.getMessage());
                }
            } else {
                String applet_db = this.getParameter("DB");
                applet_db = applet_db.replace(';', '\n');
                StorageFactory.useDBServer();
                StorageFactory.loadFromText(applet_db);
            }
            String mode = this.getParameter("VISMODE");
            if (mode == null) {
                mode = "PICCOLO";
            }
            if (mode.equalsIgnoreCase("PICCOLO")) {
                Guess.init(1, false, false);
            } else if (mode.equalsIgnoreCase("PREFUSE")) {
                Guess.init(2, false, false);
            } else if (mode.equalsIgnoreCase("TOUCHGRAPH")) {
                Guess.init(3, false, false);
            }
            String toolbar = this.getParameter("TOOLBAR");
            if (toolbar != null && !toolbar.equals("")) {
                Class<?> tb = Class.forName(toolbar);
                Constructor<?> tcon = tb.getConstructor(null);
                Object o = tcon.newInstance(null);
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        this.destory();
        super.stop();
    }

    public void destory() {
        Guess.shutdown();
        super.destroy();
    }
}

