/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.DirectedEdge;
import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.NodeSchema;
import com.hp.hpl.guess.StateQuery;
import com.hp.hpl.guess.UndirectedEdge;
import com.hp.hpl.guess.storage.StorageFactory;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.GraphElementListener;
import com.hp.hpl.guess.ui.NodeListener;
import com.hp.hpl.guess.ui.VisFactory;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.algorithms.shortestpath.ShortestPath;
import edu.uci.ics.jung.algorithms.shortestpath.ShortestPathUtils;
import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;

public class Node
extends SparseVertex
implements Comparable,
GraphElement {
    private static int nextID = 1;
    private String name;
    private Object _scratch = null;
    private String label = null;
    private NodeListener rep = null;
    private static final Random r = new Random();

    public String getName() {
        return this.name;
    }

    public Node(String name) {
        this(1, r.nextDouble() * 5.0, r.nextDouble() * 5.0, 10.0, 10.0, name);
    }

    public Node(int type, double x, double y, double width, double height, String name) {
        this.name = name;
        this.rep = VisFactory.getFactory().generateNode(type, x, y, width, height, Color.red, this);
    }

    public String toString() {
        if (this.label == null) {
            return this.name;
        }
        if (this.label.equals(this.name)) {
            return this.name;
        }
        return this.label;
    }

    public PyObject __getitem__(int key) {
        if (StorageFactory.getSL().containsNode(this, "" + key)) {
            return new PyJavaInstance(new StateQuery(this, "" + key));
        }
        return null;
    }

    public PyObject __getitem__(PyObject key) {
        if (StorageFactory.getSL().containsNode(this, key.toString())) {
            return new PyJavaInstance(new StateQuery(this, key.toString()));
        }
        return null;
    }

    public int compareTo(Object object) {
        return this.name.compareTo(((Node)object).__getattr__("name").toString());
    }

    public PySequence __anye__(PySequence sequence) {
        PyList nodes = new PyList();
        nodes.append(new PyJavaInstance(this));
        return (PySequence)nodes.__anye__(sequence);
    }

    public PySequence __anye__(Node node) {
        PyList toRet = new PyList();
        HashSet seen = new HashSet();
        for (Object o : this.findEdgeSet((Vertex)node)) {
            if (seen.contains(o)) continue;
            toRet.append(new PyJavaInstance(o));
            seen.add(o);
        }
        for (Object o : node.findEdgeSet((Vertex)this)) {
            if (seen.contains(o)) continue;
            toRet.append(new PyJavaInstance(o));
            seen.add(o);
        }
        return toRet;
    }

    public PySequence __sub__(PySequence sequence) {
        PyList nodes = new PyList();
        nodes.append(new PyJavaInstance(this));
        return (PySequence)nodes.__sub__(sequence);
    }

    public PySequence __sub__(Node node) {
        PyList toRet = new PyList();
        boolean found = false;
        Set set = this.findEdgeSet((Vertex)node);
        for (Edge edge : set) {
            if (!(edge instanceof UndirectedEdge)) continue;
            edge.__lastTouched(node);
            edge.__firstTouched(this);
            found = true;
            toRet.append(new PyJavaInstance(edge));
        }
        return toRet;
    }

    public PySequence __rde__(PySequence sequence) {
        PyList nodes = new PyList();
        nodes.append(new PyJavaInstance(this));
        return (PySequence)nodes.__rde__(sequence);
    }

    public PySequence __rde__(Node node) {
        PyList toRet = new PyList();
        boolean found = false;
        Set set = this.findEdgeSet((Vertex)node);
        for (Edge edge : set) {
            if (!(edge instanceof DirectedEdge)) continue;
            edge.__lastTouched(node);
            edge.__firstTouched(this);
            found = true;
            toRet.append(new PyJavaInstance(edge));
        }
        return toRet;
    }

    public PySequence __lde__(PySequence sequence) {
        PyList nodes = new PyList();
        nodes.append(new PyJavaInstance(this));
        return (PySequence)nodes.__lde__(sequence);
    }

    public PySequence __lde__(Node node) {
        return node.__rde__(this);
    }

    public PySequence __bde__(PySequence sequence) {
        PyList nodes = new PyList();
        nodes.append(new PyJavaInstance(this));
        return (PySequence)nodes.__bde__(sequence);
    }

    public PySequence __bde__(Node node) {
        return this.__sub__(node);
    }

    public void updateDegrees() {
        NodeSchema schema = this.getSchema();
        Field deg = schema.getField("indegree");
        if (deg != null) {
            this.__setattr__("indegree", new Integer(this.inDegree()));
        }
        if ((deg = schema.getField("outdegree")) != null) {
            this.__setattr__("outdegree", new Integer(this.outDegree()));
        }
        if ((deg = schema.getField("totaldegree")) != null) {
            this.__setattr__("totaldegree", new Integer(this.degree()));
        }
    }

    @Override
    public Object __getattr__(String fieldName) {
        if ((fieldName = fieldName.toLowerCase()).equals("_scratch")) {
            return this._scratch;
        }
        NodeSchema schema = this.getSchema();
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("size")) {
            double height = (Double)this.__getattr__("height");
            double width = (Double)this.__getattr__("width");
            return new Double(Math.sqrt(height * width));
        }
        if (fieldName.equals("betweenness")) {
            ((Graph)this.getGraph()).computeBetweennessCentrality();
        } else if (fieldName.equals("pagerank")) {
            ((Graph)this.getGraph()).computePageRank();
        } else if (fieldName.equals("hits")) {
            ((Graph)this.getGraph()).computeHITS();
        } else if (fieldName.equals("degrank")) {
            ((Graph)this.getGraph()).computeDegreeDistributionRank();
        } else if (fieldName.equals("rwbetweenness")) {
            ((Graph)this.getGraph()).computeRandomWalkBetweenness();
        } else if (fieldName.equals("indegree")) {
            ((Graph)this.getGraph()).computeDegrees();
        } else if (fieldName.equals("outdegree")) {
            ((Graph)this.getGraph()).computeDegrees();
        } else if (fieldName.equals("totaldegree")) {
            ((Graph)this.getGraph()).computeDegrees();
        } else {
            if (fieldName.equals("location")) {
                ArrayList<Object> location = new ArrayList<Object>();
                location.add(this.rep.get("x"));
                location.add(this.rep.get("y"));
                return location;
            }
            if (fieldName.equals("bounds")) {
                ArrayList<Object> bounds = new ArrayList<Object>();
                bounds.add(this.rep.get("x"));
                bounds.add(this.rep.get("y"));
                bounds.add(this.rep.get("width"));
                bounds.add(this.rep.get("height"));
                return bounds;
            }
        }
        Object value = this.rep.get(fieldName);
        if (value != null) {
            return value;
        }
        Field field = schema.getField(fieldName);
        if (field == null) {
            throw new Error("Invalid property:  " + fieldName);
        }
        Object dbValue = StorageFactory.getSL().getColumn(this, field);
        return dbValue;
    }

    public Object getAttrDB(String fieldName) {
        NodeSchema schema = this.getSchema();
        Field field = schema.getField(fieldName = fieldName.toLowerCase());
        if (field == null) {
            throw new Error("Invalid property:  " + fieldName);
        }
        Object dbValue = StorageFactory.getSL().getColumn(this, field);
        return dbValue;
    }

    @Override
    public void __setattr__(String name, Object value) {
        name = name.toLowerCase();
        Field field = null;
        if (name.equals("size")) {
            value = Field.toJava(value, 8);
        } else if (name.equals("location") || name.equals("bounds")) {
            value = Field.toJava(value, 2003);
        } else {
            if (name.equals("shape")) {
                this.rep.set(name, value);
                return;
            }
            if (name.equals("_scratch")) {
                this._scratch = value;
                return;
            }
            field = this.getSchema().getField(name);
            if (field == null) {
                throw new Error("Invalid property:  " + name);
            }
            value = field.toJava(value);
        }
        if (name.equals("name")) {
            throw new Error("Cannot modify name");
        }
        if (name.equals("size")) {
            this.__setattr__("height", value);
            this.__setattr__("width", value);
            return;
        }
        if (name.equals("location")) {
            double[] values = (double[])value;
            this.setLocation(values[0], values[1]);
            return;
        }
        if (name.equals("bounds")) {
            double[] values = (double[])value;
            this.setLocation(values[0], values[1], values[2], values[3]);
            return;
        }
        if (name.equals("label")) {
            this.label = (String)value;
            this.rep.set(name, value);
        } else if (this.rep.get(name) != null) {
            this.rep.set(name, value);
        }
        this.updateColumn(name, value);
        if (name.equals("visible")) {
            for (Edge edge : this.getIncidentEdges()) {
                Node a = edge.getNode1();
                Node b = edge.getNode2();
                if (a.__getattr__("visible").equals(Boolean.TRUE) && b.__getattr__("visible").equals(Boolean.TRUE)) {
                    if (!edge.__getattr__("visible").equals(Boolean.FALSE)) continue;
                    edge.__setattr__("visible", Boolean.TRUE);
                    continue;
                }
                if (!edge.__getattr__("visible").equals(Boolean.TRUE)) continue;
                edge.__setattr__("visible", Boolean.FALSE);
            }
        }
    }

    @Override
    public void hide() {
        this.__setattr__("visible", Boolean.FALSE);
    }

    @Override
    public void show() {
        this.__setattr__("visible", Boolean.TRUE);
    }

    @Override
    public GraphElementListener getRep() {
        return this.rep;
    }

    public void setRep(NodeListener rep) {
        this.rep = rep;
    }

    public void readjustEdges() {
        Iterator i = this.getIncidentEdges().iterator();
        while (i.hasNext()) {
            ((Edge)i.next()).readjust();
        }
    }

    public double getX() {
        return this.getDouble("x");
    }

    public void setX(double x) {
        this.__setattr__("x", new Double(x));
    }

    public double getY() {
        return this.getDouble("y");
    }

    public void setY(double y) {
        this.__setattr__("y", new Double(y));
    }

    public double getWidth() {
        return this.getDouble("width");
    }

    public void setWidth(double width) {
        this.__setattr__("width", new Double(width));
    }

    public void updateColumn(String fName, Object o) {
        try {
            StorageFactory.getSL().updateColumn(this, this.getSchema().getField(fName), o);
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    public double getHeight() {
        return this.getDouble("height");
    }

    public void setHeight(double height) {
        this.__setattr__("height", new Double(height));
    }

    public void setLocation(double x1, double y1, double width, double height) {
        this.rep.setLocation(x1, y1, width, height);
        this.updateColumn("x", new Double(x1));
        this.updateColumn("y", new Double(y1));
        this.updateColumn("width", new Double(width));
        this.updateColumn("height", new Double(height));
    }

    public void setLocation(double x1, double y1) {
        this.rep.setLocation(x1, y1);
        this.updateColumn("x", new Double(x1));
        this.updateColumn("y", new Double(y1));
    }

    public void startMove(double x1, double y1) {
        this.rep.setLocation(x1, y1);
    }

    public void move(double x1, double y1) {
        this.rep.setLocation(x1, y1);
    }

    public void endMove(double x1, double y1) {
        this.setLocation(x1, y1);
    }

    public List unweightedShortestPath(Node dest) {
        UnweightedShortestPath alg = new UnweightedShortestPath((edu.uci.ics.jung.graph.Graph)((Graph)this.getGraph()));
        return ShortestPathUtils.getPath((ShortestPath)alg, (Vertex)this, (Vertex)dest);
    }

    public List dijkstraShortestPath(Node dest) {
        DijkstraShortestPath alg = new DijkstraShortestPath((ArchetypeGraph)((Graph)this.getGraph()), (NumberEdgeValue)((Graph)this.getGraph()));
        return ShortestPathUtils.getPath((ShortestPath)alg, (Vertex)this, (Vertex)dest);
    }

    private NodeSchema getSchema() {
        if (this.getGraph() != null) {
            return ((Graph)this.getGraph()).getNodeSchema();
        }
        return Guess.getGraph().getNodeSchema();
    }

    private double getDouble(String name) {
        return (Double)this.__getattr__(name);
    }

    @Override
    public Map values() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        Iterator fields = this.getSchema().fields();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            String name = field.getName();
            values.put(name, this.__getattr__(name));
        }
        return values;
    }
}

