/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.CompoundQuery;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.storage.StorageFactory;
import com.hp.hpl.guess.storage.StorageListener;
import java.util.Set;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public abstract class Query
extends PyList {
    public static final String EQ = "==";
    public static final String NE = "!=";
    public static final String LT = "<";
    public static final String GT = ">";
    public static final String LE = "<=";
    public static final String GE = ">=";
    public static final String LIKE = "like";
    public static final String AND = "&";
    public static final String OR = "|";
    private Graph graph;
    private int type;
    boolean forced = false;

    public abstract Set getStates(Set var1);

    public Query(Graph graph, int type) {
        this.graph = graph;
        this.type = type;
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public PyObject __and__(PyObject other) {
        if (other instanceof PyList) {
            return super.__and__(other);
        }
        return new CompoundQuery(this.graph, AND, this, (Query)other, this.type);
    }

    @Override
    public PyObject __or__(PyObject other) {
        if (other instanceof PyList) {
            return super.__or__(other);
        }
        return new CompoundQuery(this.graph, OR, this, (Query)other, this.type);
    }

    protected void forceQuery() {
        if (this.forced) {
            return;
        }
        this.forced = true;
        StorageListener db = StorageFactory.getSL();
        if (this.type == 1) {
            db.findMatchingNodes(this);
        } else if (this.type == 2) {
            db.findMatchingEdges(this);
        } else {
            throw new Error("Invalid field type:  " + this.type);
        }
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        this.forceQuery();
        super.__setattr__(name, value);
    }

    @Override
    public PyObject get(int i) {
        this.forceQuery();
        return super.get(i);
    }

    @Override
    public int __len__() {
        this.forceQuery();
        return super.__len__();
    }

    public abstract boolean describes(GraphElement var1);

    @Override
    public PyString __str__() {
        this.forceQuery();
        return super.__str__();
    }

    @Override
    public String toString() {
        this.forceQuery();
        return super.toString();
    }

    public abstract String toSQLString();
}

