/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.InterpreterAbstraction;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.util.GuessPyStringMap;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class RealInterpreter
extends PythonInterpreter
implements InterpreterAbstraction {
    PrintStream log = null;
    private static GuessPyStringMap gpsm = new GuessPyStringMap();
    public boolean state = false;

    public static GuessPyStringMap getPyStringMap() {
        return gpsm;
    }

    public RealInterpreter() {
        super(gpsm);
    }

    public RealInterpreter(PyObject dict) {
        super(dict);
    }

    public RealInterpreter(PyObject dict, PySystemState systemState) {
        super(dict, systemState);
    }

    @Override
    public void setImmutable(String name, Object value) {
        this.setImmutable(name, value, true);
    }

    @Override
    public void setImmutable(String name, Object value, boolean overwrite) {
        if (!overwrite && gpsm.contains(name)) {
            throw Py.NameError("Immutable variable " + name + " already defined in namespace");
        }
        try {
            gpsm.removeImmutable(name);
            super.set(name, value);
            gpsm.setImmutable(name);
        }
        catch (Exception ex) {
            ExceptionWindow.getExceptionWindow(ex);
        }
        catch (NoClassDefFoundError ncdfe) {
            // empty catch block
        }
    }

    @Override
    public void setImmutable(String name, PyObject value) {
        this.setImmutable(name, value, true);
    }

    @Override
    public void setImmutable(String name, PyObject value, boolean overwrite) {
        if (!overwrite && gpsm.contains(name)) {
            throw Py.NameError("Immutable variable " + name + " already defined in namespace");
        }
        gpsm.removeImmutable(name);
        super.set(name, value);
        gpsm.setImmutable(name);
    }

    @Override
    public void freeze(boolean state) {
        this.state = state;
    }

    @Override
    public void exec(String s) {
        super.exec(s);
        this.logCommand(s);
    }

    @Override
    public PyObject eval(String s) {
        PyObject toRet = null;
        toRet = super.eval(s);
        this.logCommand(s);
        return toRet;
    }

    @Override
    public void logCommand(String s) {
        if (!(this.log == null || s.startsWith("ENV[") || s.startsWith("if _ != None:") || s.equals("print _") || s.indexOf("interp.stoplog") >= 0 || s.startsWith("interp.log"))) {
            try {
                if (s.startsWith("apply(_, ())")) {
                    this.log.println("()");
                    return;
                }
                this.log.println("");
                this.log.print(s);
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
        }
    }

    @Override
    public boolean isFrozen() {
        return this.state;
    }

    @Override
    public void log(String filename) {
        try {
            if (this.log != null) {
                this.stoplog();
            }
            this.log = new PrintStream(new FileOutputStream(filename));
            Date gc = new Date(System.currentTimeMillis());
            this.log.println("# Logged on " + gc.toString());
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            this.log = null;
        }
    }

    @Override
    public void stoplog() {
        if (this.log != null) {
            try {
                this.log.println("");
                this.log.close();
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
        }
        this.log = null;
    }

    @Override
    public void remove(String name) {
        gpsm.removeImmutable(name);
        gpsm.__delitem__(name);
    }
}

