/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.storage.StorageFactory;
import com.hp.hpl.guess.util.intervals.IntervalNode;
import com.hp.hpl.guess.util.intervals.IntervalTree;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;

public abstract class Schema {
    private static HashSet dynamicFields = new HashSet();
    private static String[] dynamicF = new String[]{"betweenness", "pagerank", "hits", "degrank", "rwbetweenness"};
    private Hashtable fields = new Hashtable();
    private IntervalTree rangeIndex = null;
    private Field myRangeField = null;

    public Collection fieldNames() {
        return this.fields.keySet();
    }

    public Collection allFields() {
        return this.fields.values();
    }

    public Iterator fields() {
        return this.fields.values().iterator();
    }

    public void addField(Field f) {
        this.fields.put(f.getName(), f);
        if (dynamicFields.contains(f.getName())) {
            f.setDynamic(true);
        }
    }

    public Field getField(String fieldName) {
        return (Field)this.fields.get(fieldName);
    }

    public Object __getattr__(String fieldName) {
        return (Field)this.fields.get(fieldName);
    }

    public void addFieldToSL(Field f) {
        StorageFactory.getSL().addField(f);
        this.addField(f);
    }

    public Enumeration getFields() {
        return this.fields.elements();
    }

    public int fieldCount() {
        return this.fields.size();
    }

    public abstract void createIntegerField(String var1, int var2);

    public abstract void createDoubleField(String var1, double var2);

    public abstract void createBooleanField(String var1, boolean var2);

    public abstract void createStringField(String var1, String var2);

    public void createField(String fieldName, Object def) {
        if (def instanceof Double) {
            this.createDoubleField(fieldName, (Double)def);
        } else if (def instanceof Integer) {
            this.createDoubleField(fieldName, ((Integer)def).intValue());
        } else if (def instanceof String) {
            this.createStringField(fieldName, (String)def);
        } else if (def instanceof BigInteger) {
            this.createIntegerField(fieldName, ((BigInteger)def).intValue());
        } else {
            throw new Error("Unknown default object type: " + def.getClass());
        }
    }

    public void setRangeField(Field rf) {
        this.myRangeField = rf;
        this.rangeIndex = null;
    }

    public void rebuildRangeIndex() {
        Field rf = this.getRangeField();
        if (rf == null) {
            throw new Error("No field found for range values");
        }
        this.rebuildRange(rf);
    }

    public List parseRange(String range) {
        ArrayList<SimplePair> toRet = new ArrayList<SimplePair>();
        String[] ranges = range.split(",");
        for (int i = 0; i < ranges.length; ++i) {
            try {
                String temp = ranges[i].trim();
                String[] hilo = temp.split("\\s*-\\s*");
                int hi = 0;
                int lo = 0;
                if (hilo.length == 1) {
                    lo = Integer.parseInt(hilo[0]);
                    hi = Integer.parseInt(hilo[0]);
                    toRet.add(new SimplePair(lo, hi));
                    continue;
                }
                if (hilo.length == 2) {
                    lo = Integer.parseInt(hilo[0]);
                    hi = Integer.parseInt(hilo[1]);
                    toRet.add(new SimplePair(lo, hi));
                    continue;
                }
                throw new Error("Invalid range: " + temp + "in '" + range + "'");
            }
            catch (Exception ex) {
                throw new Error("Invalid range '" + range + "' " + ex.toString());
            }
        }
        return toRet;
    }

    protected void rebuildRange(Field rangeField) {
        if (rangeField != null) {
            this.rangeIndex = new IntervalTree();
            Iterator elements = null;
            String fname = rangeField.getName();
            elements = rangeField.getType() == 1 ? Guess.getGraph().getNodes().iterator() : Guess.getGraph().getEdges().iterator();
            while (elements.hasNext()) {
                GraphElement ge = (GraphElement)elements.next();
                PyJavaInstance pge = new PyJavaInstance(ge);
                String range = (String)ge.__getattr__(fname);
                if (range == null) continue;
                for (SimplePair t : this.parseRange(range)) {
                    IntervalNode toAdd = new IntervalNode(t.lo, t.hi, pge);
                    this.rangeIndex.insert(toAdd);
                }
            }
        }
    }

    public Field getRangeField() {
        Field def;
        if (this.myRangeField == null && (def = this.getField("range")) != null) {
            this.myRangeField = def;
        }
        return this.myRangeField;
    }

    public void rangeIndexCheck() {
        if (this.rangeIndex != null) {
            return;
        }
        Field rangeField = this.getRangeField();
        if (rangeField == null) {
            throw new Error("No field found for range values");
        }
        this.rebuildRange(rangeField);
    }

    public SimplePair parseLH(PyObject other) {
        int lo = 0;
        int hi = 0;
        if (other instanceof PyString) {
            StringTokenizer st = new StringTokenizer(other.toString(), "-");
            hi = lo = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                hi = Integer.parseInt(st.nextToken());
            }
        } else if (other instanceof PySequence) {
            PyObject s;
            int length = ((PySequence)other).__len__();
            if (length < 1 || length > 2) {
                throw new Error("Ranges must be 1 or 2 numbers in length");
            }
            PyObject e = s = ((PySequence)other).__finditem__(0);
            if (length == 2) {
                e = ((PySequence)other).__finditem__(0);
            }
            if (s instanceof PyInteger) {
                lo = ((PyInteger)s).getValue();
            } else if (s instanceof PyString) {
                lo = Integer.parseInt(s.toString());
            }
            if (e instanceof PyInteger) {
                hi = ((PyInteger)e).getValue();
            } else if (s instanceof PyString) {
                hi = Integer.parseInt(e.toString());
            }
        } else if (other instanceof PyInteger) {
            hi = lo = ((PyInteger)other).getValue();
        } else {
            throw new Error("Invalid argument to range operation");
        }
        return new SimplePair(lo, hi);
    }

    private PyObject bundle(IntervalNode[] output) {
        PyList toRet = new PyList();
        for (int i = 0; i < output.length; ++i) {
            Object proxy = output[i].getProxy();
            if (proxy == null) continue;
            if (proxy instanceof PyObject) {
                toRet.append((PyObject)proxy);
                continue;
            }
            toRet.append(new PyJavaInstance(proxy));
        }
        return toRet;
    }

    public PyObject __rcontains__(PyObject other) {
        this.rangeIndexCheck();
        SimplePair sp = this.parseLH(other);
        IntervalNode[] output = this.rangeIndex.searchContains(sp.lo, sp.hi);
        return this.bundle(output);
    }

    public PyObject __rexact__(PyObject other) {
        this.rangeIndexCheck();
        SimplePair sp = this.parseLH(other);
        IntervalNode[] output = this.rangeIndex.searchExact(sp.lo, sp.hi);
        return this.bundle(output);
    }

    public PyObject __rcontained__(PyObject other) {
        this.rangeIndexCheck();
        SimplePair sp = this.parseLH(other);
        IntervalNode[] output = this.rangeIndex.searchContained(sp.lo, sp.hi);
        return this.bundle(output);
    }

    public PyObject __roverlaps__(PyObject other) {
        this.rangeIndexCheck();
        SimplePair sp = this.parseLH(other);
        IntervalNode[] output = this.rangeIndex.searchOverlap(sp.lo, sp.hi);
        return this.bundle(output);
    }

    static {
        for (int i = 0; i < dynamicF.length; ++i) {
            dynamicFields.add(dynamicF[i]);
        }
    }

    class SimplePair {
        public int lo = 0;
        public int hi = 0;

        SimplePair(int lo, int hi) {
            this.lo = lo;
            this.hi = hi;
        }
    }
}

