/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.DirectedEdge;
import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.EdgeSchema;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.InterpreterAbstraction;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.NodeSchema;
import com.hp.hpl.guess.UndirectedEdge;
import com.hp.hpl.guess.io.GraphMLReader;
import com.hp.hpl.guess.layout.BinPack;
import com.hp.hpl.guess.layout.CircularConstrained;
import com.hp.hpl.guess.layout.EdgeAdjustment;
import com.hp.hpl.guess.layout.FruchGraphLayout;
import com.hp.hpl.guess.layout.GEM;
import com.hp.hpl.guess.layout.KamadaGraphLayout;
import com.hp.hpl.guess.layout.Move;
import com.hp.hpl.guess.layout.NetUtilities;
import com.hp.hpl.guess.layout.Physics;
import com.hp.hpl.guess.layout.Radial;
import com.hp.hpl.guess.layout.RandomGraphLayout;
import com.hp.hpl.guess.layout.Rescale;
import com.hp.hpl.guess.layout.SMDS;
import com.hp.hpl.guess.layout.Spring;
import com.hp.hpl.guess.layout.Sugiyama2;
import com.hp.hpl.guess.layout.SugiyamaLayout;
import com.hp.hpl.guess.layout.Translate;
import com.hp.hpl.guess.layout.WeightedSpring;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.Morpher;
import com.hp.hpl.guess.storage.StorageFactory;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.GoneIn30;
import com.hp.hpl.guess.ui.StatusBar;
import com.hp.hpl.guess.ui.VisFactory;
import com.hp.hpl.guess.util.SortableHashSet;
import com.hp.hpl.guess.util.VisualUtils;
import edu.uci.ics.jung.algorithms.cluster.BicomponentClusterer;
import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.algorithms.cluster.EdgeBetweennessClusterer;
import edu.uci.ics.jung.algorithms.cluster.GraphClusterer;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.algorithms.importance.BetweennessCentrality;
import edu.uci.ics.jung.algorithms.importance.DegreeDistributionRanker;
import edu.uci.ics.jung.algorithms.importance.HITS;
import edu.uci.ics.jung.algorithms.importance.PageRank;
import edu.uci.ics.jung.algorithms.importance.RandomWalkBetweenness;
import edu.uci.ics.jung.algorithms.transformation.DirectionTransformer;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.random.generators.BarabasiAlbertGenerator;
import edu.uci.ics.jung.random.generators.EppsteinPowerLawGenerator;
import edu.uci.ics.jung.random.generators.ErdosRenyiGenerator;
import edu.uci.ics.jung.random.generators.GraphGenerator;
import edu.uci.ics.jung.random.generators.KleinbergSmallWorldGenerator;
import edu.uci.ics.jung.random.generators.Lattice1DGenerator;
import edu.uci.ics.jung.random.generators.Lattice2DGenerator;
import edu.uci.ics.jung.random.generators.SimpleRandomDirectedGenerator;
import edu.uci.ics.jung.random.generators.SimpleRandomGenerator;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.ISOMLayout;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.SpringLayout;
import edu.uci.ics.jung.visualization.contrib.CircleLayout;
import edu.uci.ics.jung.visualization.contrib.DAGLayoutWrapper;
import edu.uci.ics.jung.visualization.contrib.KKLayout;
import edu.uci.ics.jung.visualization.contrib.KKLayoutInt;
import edu.uci.ics.jung.visualization.contrib.WeightedKK;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.python.core.PyFloat;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PySequence;

public class StateGraph
extends Graph {
    NodeSchema nodeSchema = null;
    EdgeSchema edgeSchema = null;
    private InterpreterAbstraction interp;
    private FrameListener display;
    private boolean containsDirected = false;
    private boolean sync = false;
    private boolean centerAfter = true;

    public StateGraph(InterpreterAbstraction interp) {
        super(null, interp);
    }

    @Override
    public Node addNode(Node n) {
        this.nameToNode.put(n.getName(), n);
        this.lastMod = System.currentTimeMillis() - 1L;
        return (Node)this.addVertex((Vertex)n);
    }

    @Override
    public Node addNode(String name) {
        Node node = new Node(name);
        this.addNode(node);
        Iterator fields = this.nodeSchema.fields();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            String fieldName = field.getName();
            if (fieldName.equals("name")) continue;
            node.__setattr__(fieldName, field.getDefault());
        }
        return node;
    }

    @Override
    public Edge addEdge(Edge e) {
        if (StorageFactory.getSL().containsEdge(e)) {
            this.addEdgeNoCheck(e);
            return e;
        }
        StorageFactory.getSL().addEdge(e);
        this.addEdgeNoCheck(e);
        Iterator fields = this.edgeSchema.fields();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            String name = field.getName();
            if (name.equals("__edgeid") || name.equals("node1") || name.equals("node2") || name.equals("directed")) continue;
            e.__setattr__(name, field.getDefault());
        }
        return e;
    }

    @Override
    public Edge addEdgeNoCheck(Edge e) {
        if (e instanceof DirectedEdge) {
            this.containsDirected = true;
        }
        super.addEdge(e);
        this.setIdToEdge(e);
        VisFactory.getFactory().add(e);
        this.lastMod = System.currentTimeMillis() - 1L;
        this.updateDegrees(e);
        return e;
    }

    private void updateDegrees(Edge e) {
        Node n1 = e.getNode1();
        n1.updateDegrees();
        Node n2 = e.getNode2();
        if (n2 != n1) {
            n2.updateDegrees();
        }
    }

    @Override
    public DirectedEdge addDirectedEdge(Node source, Node dest) {
        this.containsDirected = true;
        int id = StorageFactory.getSL().createDirectedEdge(source, dest);
        DirectedEdge edge = new DirectedEdge(id, source, dest);
        this.addEdgeNoCheck(edge);
        Iterator fields = this.edgeSchema.fields();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            String name = field.getName();
            if (name.equals("__edgeid") || name.equals("node1") || name.equals("node2") || name.equals("directed")) continue;
            edge.__setattr__(name, field.getDefault());
        }
        return edge;
    }

    @Override
    protected boolean containsDirected() {
        return this.containsDirected;
    }

    @Override
    public UndirectedEdge addUndirectedEdge(Node node1, Node node2) {
        int id = StorageFactory.getSL().createUndirectedEdge(node1, node2);
        UndirectedEdge edge = new UndirectedEdge(id, node1, node2);
        this.addEdgeNoCheck(edge);
        Iterator fields = this.edgeSchema.fields();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            String name = field.getName();
            if (name.equals("__edgeid") || name.equals("node1") || name.equals("node2") || name.equals("directed")) continue;
            edge.__setattr__(name, field.getDefault());
        }
        return edge;
    }

    @Override
    public UndirectedEdge addEdge(Node node1, Node node2) {
        return this.addUndirectedEdge(node1, node2);
    }

    @Override
    public Set removeNode(Node n) {
        Iterator edges = n.getIncidentEdges().iterator();
        while (edges.hasNext()) {
            this.removeEdge((Edge)edges.next());
        }
        super.removeVertex((Vertex)n);
        this.nameToNode.remove(n.getName());
        StorageFactory.getSL().remove(n);
        VisFactory.getFactory().remove(n);
        this.lastMod = System.currentTimeMillis() - 1L;
        return null;
    }

    @Override
    public Set removeEdge(Edge e) {
        super.removeEdge(e);
        this.idToEdge.remove(new Integer(e.getID()));
        StorageFactory.getSL().remove(e);
        VisFactory.getFactory().remove(e);
        this.lastMod = System.currentTimeMillis() - 1L;
        this.updateDegrees(e);
        return null;
    }

    @Override
    public Set remove(PySequence seq) {
        for (int i = 0; i < seq.__len__(); ++i) {
            GraphElement element = (GraphElement)((PyInstance)seq.__finditem__(i)).__tojava__(GraphElement.class);
            if (element instanceof Node) {
                this.removeNode((Node)element);
                continue;
            }
            if (element instanceof Edge) {
                this.removeEdge((Edge)element);
                continue;
            }
            throw new Error("Invalid graph element type:  " + element.getClass());
        }
        this.lastMod = System.currentTimeMillis() - 1L;
        return null;
    }

    @Override
    public void add(PySequence seq) {
        for (int i = 0; i < seq.__len__(); ++i) {
            GraphElement element = (GraphElement)((PyInstance)seq.__finditem__(i)).__tojava__(GraphElement.class);
            if (element instanceof Node) {
                this.addNode((Node)element);
                continue;
            }
            if (element instanceof Edge) {
                this.addEdge((Edge)element);
                continue;
            }
            throw new Error("Invalid graph element type:  " + element.getClass());
        }
        this.lastMod = System.currentTimeMillis() - 1L;
    }

    @Override
    public Set getNodes() {
        return this.getVertices();
    }

    public static Color toColor(Object object) {
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof String) {
            return Colors.getColor((String)object, Color.red);
        }
        if (object instanceof PyJavaInstance) {
            return (Color)((PyInstance)object).__tojava__(Color.class);
        }
        throw new Error("Invalid color class:  " + object.getClass());
    }

    public static double toDouble(Object object) {
        if (object instanceof PyFloat) {
            return ((PyFloat)object).getValue();
        }
        if (object instanceof PyInteger) {
            return ((PyInteger)object).getValue();
        }
        throw new Error("Invalid double class:  " + object.getClass());
    }

    @Override
    public void readjustEdges() {
        this.expandOverlapping();
    }

    @Override
    public void compressOverlapping() {
        EdgeAdjustment.compressOverlapping(this);
    }

    @Override
    public void expandOverlapping() {
        EdgeAdjustment.expandOverlapping(this);
    }

    @Override
    public void kkLayout() {
        this.kkLayout(1000, 1000);
    }

    @Override
    public void sugiyamaLayout() {
        this.sugiyamaLayout(false);
    }

    @Override
    public void sugiyamaLayout(boolean bends) {
        new SugiyamaLayout(this, bends);
        if (this.display instanceof GFrame) {
            ((GFrame)this.display).centerFast();
        } else {
            this.display.center();
        }
    }

    @Override
    public void sugiyamaLayout2() {
        new Sugiyama2(this);
        if (this.display instanceof GFrame) {
            ((GFrame)this.display).centerFast();
        } else {
            this.display.center();
        }
    }

    @Override
    public void dagLayout() {
        this.layout((Layout)new DAGLayoutWrapper((edu.uci.ics.jung.graph.Graph)this));
    }

    @Override
    public void frLayout() {
        this.frLayout(1000, 1000);
    }

    @Override
    public void mdsLayout() {
        this.layout((Layout)new SMDS(this));
    }

    @Override
    public void moveLayout(int newX, int newY) {
        this.layout((Layout)new Move(this, newX, newY));
    }

    @Override
    public void moveLayout(double newX, double newY) {
        this.layout((Layout)new Move(this, newX, newY));
    }

    @Override
    public void translateLayout(int newX, int newY) {
        this.layout((Layout)new Translate(this, newX, newY));
    }

    @Override
    public void translateLayout(double newX, double newY) {
        this.layout((Layout)new Translate(this, newX, newY));
    }

    @Override
    public void rescaleLayout(int width, int height) {
        this.layout((Layout)new Rescale((Graph)this, width, height));
    }

    @Override
    public void rescaleLayout(double percent) {
        this.layout((Layout)new Rescale(this, percent));
    }

    @Override
    public void rescaleLayout(double xpercent, double ypercent) {
        this.layout((Layout)new Rescale((Graph)this, xpercent, ypercent));
    }

    @Override
    public void radialLayout(Node center) {
        this.layout((Layout)new Radial(this, center));
    }

    @Override
    public void radialLayout(Node center, PySequence seq) {
        HashSet<GraphElement> hs = new HashSet<GraphElement>();
        for (int i = 0; i < seq.__len__(); ++i) {
            GraphElement element = (GraphElement)((PyInstance)seq.__finditem__(i)).__tojava__(GraphElement.class);
            if (!(element instanceof Edge)) {
                throw new Error("Invalid graph element type:  " + element.getClass());
            }
            hs.add(element);
        }
        this.layout((Layout)new Radial(this, center, hs));
    }

    @Override
    public void randomLayout() {
        this.randomLayout(1000, 1000);
    }

    @Override
    public void randomLayout(int width, int height) {
        this.layout((Layout)new RandomGraphLayout(this, width, height));
    }

    @Override
    public void jfrLayout() {
        this.layout((Layout)new FRLayout((edu.uci.ics.jung.graph.Graph)this));
    }

    @Override
    public void jkkLayout1() {
        this.layout((Layout)new KKLayout((edu.uci.ics.jung.graph.Graph)this));
    }

    @Override
    public void jkkLayout2() {
        this.layout((Layout)new KKLayoutInt((edu.uci.ics.jung.graph.Graph)this));
    }

    @Override
    public void weightedKKLayout() {
        this.layout((Layout)new WeightedKK((edu.uci.ics.jung.graph.Graph)this));
    }

    @Override
    public void frLayout(int width, int height) {
        this.layout((Layout)new FruchGraphLayout(this, true, width, height));
    }

    @Override
    public void kkLayout(int width, int height) {
        this.layout((Layout)new KamadaGraphLayout(this, true, width, height));
    }

    @Override
    public void physicsLayout(boolean gather, int max) {
        this.layout((Layout)new Physics(this, gather), max);
    }

    @Override
    public void physicsLayout() {
        this.layout((Layout)new Physics(this, false));
    }

    @Override
    public void physicsLayout(int max) {
        this.physicsLayout(false, max);
    }

    @Override
    public void jSpringLayout() {
        this.layout((Layout)new SpringLayout((edu.uci.ics.jung.graph.Graph)this));
    }

    @Override
    public void jSpringLayout(int max) {
        this.layout((Layout)new SpringLayout((edu.uci.ics.jung.graph.Graph)this), max);
    }

    @Override
    public void circleLayout() {
        this.layout((Layout)new CircleLayout((edu.uci.ics.jung.graph.Graph)this));
    }

    @Override
    public void binPackLayout() {
        this.binPackLayout(true);
    }

    @Override
    public void binPackLayout(boolean rescale) {
        this.layout((Layout)new BinPack(this, rescale));
    }

    @Override
    public void circleLayout(Field f, Node c) {
        this.layout((Layout)new CircularConstrained(this, c, f));
    }

    @Override
    public void circleLayout(Field f, Node c, double xorigin, double yorigin) {
        this.layout((Layout)new CircularConstrained(this, c, f, xorigin, yorigin));
    }

    @Override
    public void springLayout() {
        this.layout((Layout)new Spring(this));
    }

    @Override
    public void springLayout(int max) {
        this.layout((Layout)new Spring(this), max);
    }

    @Override
    public void weightedSpringLayout(int min, int max) {
        this.layout((Layout)new WeightedSpring(this, min, max));
    }

    @Override
    public void weightedSpringLayout(int minL, int maxL, int max) {
        this.layout((Layout)new WeightedSpring(this, minL, maxL), max);
    }

    @Override
    public void gemLayout() {
        this.layout((Layout)new GEM(this));
    }

    @Override
    public void isomLayout() {
        this.layout((Layout)new ISOMLayout((edu.uci.ics.jung.graph.Graph)this));
    }

    @Override
    public void isomLayout(int max) {
        this.layout((Layout)new ISOMLayout((edu.uci.ics.jung.graph.Graph)this), max);
    }

    @Override
    public void layout(Layout lay) {
        this.layout(lay, Integer.MAX_VALUE);
    }

    public void setSynchronous(boolean state) {
        this.sync = state;
    }

    @Override
    public void centerAfterLayout(boolean state) {
        this.centerAfter = state;
    }

    @Override
    public void layout(Layout lay, int mi) {
        StateGraph gt = this;
        final Layout layout = lay;
        StatusBar.runProgressBar(true);
        final int maxIters = mi;
        final boolean ca = this.centerAfter;
        Thread thrd = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                StateGraph.this.interp.freeze(true);
                GoneIn30 g30 = null;
                try {
                    layout.initialize(new Dimension(1000, 1000));
                    if (!layout.isIncremental()) {
                        layout.advancePositions();
                    } else {
                        int incCounter = 0;
                        long curTime = System.currentTimeMillis();
                        while (!layout.incrementsAreDone()) {
                            ++incCounter;
                            layout.advancePositions();
                            long test = System.currentTimeMillis() - curTime;
                            if (maxIters == Integer.MAX_VALUE) {
                                if (incCounter == 1) {
                                    g30 = GoneIn30.getWindow();
                                    g30.start();
                                }
                                if (System.currentTimeMillis() - curTime <= 30000L) continue;
                                this.update();
                                int yn = JOptionPane.showConfirmDialog(null, "Ran " + incCounter + " loops, Continue?", "Continue?", 0);
                                if (yn == 1) {
                                    if (g30 == null) break;
                                    g30.stopTimer();
                                    break;
                                }
                                g30 = GoneIn30.getWindow();
                                g30.start();
                                curTime = System.currentTimeMillis();
                                continue;
                            }
                            if (incCounter >= maxIters) break;
                            if (System.currentTimeMillis() - curTime <= 30000L) continue;
                            StatusBar.setStatus("Ran " + incCounter + " loops");
                            System.out.println("Ran " + incCounter + " loops");
                            curTime = System.currentTimeMillis();
                        }
                    }
                    this.update();
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
                if (g30 != null) {
                    g30.stopTimer();
                }
                StatusBar.runProgressBar(false);
                StateGraph.this.interp.freeze(false);
            }

            public void update() {
                try {
                    for (Node node : StateGraph.this.getNodes()) {
                        if (((Boolean)node.__getattr__("fixed")).booleanValue()) continue;
                        node.__setattr__("x", new Double(layout.getX((Vertex)node)));
                        node.__setattr__("y", new Double(layout.getY((Vertex)node)));
                    }
                }
                catch (Exception ex) {
                    ExceptionWindow.getExceptionWindow(ex);
                }
                if (ca) {
                    if (StateGraph.this.display instanceof GFrame) {
                        ((GFrame)StateGraph.this.display).centerFast();
                    } else {
                        StateGraph.this.display.center();
                    }
                }
            }
        });
        if (!this.sync) {
            thrd.start();
        } else {
            thrd.run();
        }
    }

    @Override
    public Set biComponentClusters() {
        UndirectedGraph tempGraph = DirectionTransformer.toUndirected((edu.uci.ics.jung.graph.Graph)this);
        Set tempClusters = StateGraph.clusters((edu.uci.ics.jung.graph.Graph)tempGraph, (GraphClusterer)new BicomponentClusterer());
        HashSet clusters = new HashSet();
        for (Set tempCluster : tempClusters) {
            HashSet<ArchetypeVertex> cluster = new HashSet<ArchetypeVertex>();
            for (Node tempNode : tempCluster) {
                cluster.add(tempNode.getEqualVertex((ArchetypeGraph)this));
            }
            clusters.add(cluster);
        }
        return clusters;
    }

    @Override
    public Set edgeBetweennessClusters(int numEdgesToRemove) {
        return StateGraph.clusters((edu.uci.ics.jung.graph.Graph)this, (GraphClusterer)new EdgeBetweennessClusterer(numEdgesToRemove));
    }

    @Override
    public Set weakComponentClusters() {
        return StateGraph.clusters((edu.uci.ics.jung.graph.Graph)this, (GraphClusterer)new WeakComponentClusterer());
    }

    @Override
    public Set exactFlowCommunity(int cohesion) {
        return null;
    }

    public static Set clusters(edu.uci.ics.jung.graph.Graph graph, GraphClusterer clusterer) {
        ClusterSet clusterSet = clusterer.extract((ArchetypeGraph)graph);
        HashSet clusters = new HashSet();
        Iterator it = clusterSet.iterator();
        while (it.hasNext()) {
            clusters.add(it.next());
        }
        return clusters;
    }

    @Override
    public void setNumber(ArchetypeEdge edge, Number number) {
        throw new Error("setNumber not yet supported");
    }

    @Override
    public Number getNumber(ArchetypeEdge e) {
        return (Number)((Edge)e).__getattr__("weight");
    }

    public void computeAbstractRanker(AbstractRanker centrality, String guessKey) {
        if (this.edgeSchema.getField(guessKey) == null) {
            this.addEdgeField(guessKey, 8, new Double(0.0));
        }
        if (this.nodeSchema.getField(guessKey) == null) {
            this.addNodeField(guessKey, 8, new Double(0.0));
        }
        centrality.setRemoveRankScoresOnFinalize(false);
        centrality.evaluate();
        String key = centrality.getRankScoreKey();
        for (Node node : this.getNodes()) {
            double value = ((MutableDouble)node.getUserDatum(key)).doubleValue();
            node.__setattr__(guessKey, new Double(value));
        }
        for (Edge edge : this.getEdges()) {
            double value = ((MutableDouble)edge.getUserDatum(key)).doubleValue();
            edge.__setattr__(guessKey, new Double(value));
        }
    }

    @Override
    public void computeBetweennessCentrality() {
        Field f1 = this.nodeSchema.getField("betweenness");
        Field f2 = this.edgeSchema.getField("betweenness");
        if (f1 == null || f2 == null || f1.needsUpdate(this) || f2.needsUpdate(this)) {
            BetweennessCentrality centrality = new BetweennessCentrality((edu.uci.ics.jung.graph.Graph)this);
            this.computeAbstractRanker((AbstractRanker)centrality, "betweenness");
            this.nodeSchema.getField("betweenness").update();
            this.edgeSchema.getField("betweenness").update();
        }
    }

    public void computePageRank(double bias) {
        Field f1 = this.nodeSchema.getField("pagerank");
        Field f2 = this.edgeSchema.getField("pagerank");
        if (f1 == null || f2 == null || f1.needsUpdate(this) || f2.needsUpdate(this)) {
            DirectedGraph tempGraph = DirectionTransformer.toDirected((edu.uci.ics.jung.graph.Graph)this);
            PageRank centrality = new PageRank(tempGraph, bias);
            this.computeAbstractRanker((AbstractRanker)centrality, "pagerank");
            this.nodeSchema.getField("pagerank").update();
            this.edgeSchema.getField("pagerank").update();
        }
    }

    @Override
    public void computeDegreeDistributionRank() {
        Field f1 = this.nodeSchema.getField("degrank");
        Field f2 = this.edgeSchema.getField("degrank");
        if (f1 == null || f2 == null || f1.needsUpdate(this) || f2.needsUpdate(this)) {
            DegreeDistributionRanker centrality = new DegreeDistributionRanker((edu.uci.ics.jung.graph.Graph)this);
            this.computeAbstractRanker((AbstractRanker)centrality, "degrank");
            this.nodeSchema.getField("degrank").update();
            this.edgeSchema.getField("degrank").update();
        }
    }

    @Override
    public void computeHITS() {
        Field f1 = this.nodeSchema.getField("hits");
        Field f2 = this.edgeSchema.getField("hits");
        if (f1 == null || f2 == null || f1.needsUpdate(this) || f2.needsUpdate(this)) {
            HITS centrality = new HITS((edu.uci.ics.jung.graph.Graph)this);
            this.computeAbstractRanker((AbstractRanker)centrality, "hits");
            this.nodeSchema.getField("hits").update();
            this.edgeSchema.getField("hits").update();
        }
    }

    @Override
    public void computeRandomWalkBetweenness() {
        Field f1 = this.nodeSchema.getField("rwbetweenness");
        Field f2 = this.edgeSchema.getField("rwbetweenness");
        if (f1 == null || f2 == null || f1.needsUpdate(this) || f2.needsUpdate(this)) {
            UndirectedGraph tempGraph = DirectionTransformer.toUndirected((edu.uci.ics.jung.graph.Graph)this);
            RandomWalkBetweenness centrality = new RandomWalkBetweenness(tempGraph);
            this.computeAbstractRanker((AbstractRanker)centrality, "rwbetweenness");
            this.nodeSchema.getField("rwbetweenness").update();
            this.edgeSchema.getField("rwbetweenness").update();
        }
    }

    @Override
    public void computeDegrees() {
        Field in = this.nodeSchema.getField("indegree");
        Field out = this.nodeSchema.getField("outdegree");
        Field deg = this.nodeSchema.getField("totaldegree");
        if (in == null || out == null || deg == null || in.needsUpdate(this) || out.needsUpdate(this) || deg.needsUpdate(this)) {
            if (this.nodeSchema.getField("indegree") == null) {
                this.addNodeField("indegree", 4, new Integer(0));
            }
            if (this.nodeSchema.getField("outdegree") == null) {
                this.addNodeField("outdegree", 4, new Integer(0));
            }
            if (this.nodeSchema.getField("totaldegree") == null) {
                this.addNodeField("totaldegree", 4, new Integer(0));
            }
            for (Node n : this.getNodes()) {
                n.updateDegrees();
            }
        }
    }

    @Override
    public Field addNodeField(String fieldName, int sqlType, Object defaultValue) {
        Field field = new Field(this, fieldName, 1, sqlType, defaultValue);
        this.nodeSchema.addFieldToSL(field);
        this.interp.setImmutable(fieldName, field);
        return field;
    }

    @Override
    public Field addEdgeField(String fieldName, int sqlType, Object defaultValue) {
        Field field = new Field(this, fieldName, 2, sqlType, defaultValue);
        this.edgeSchema.addFieldToSL(field);
        this.interp.setImmutable(fieldName, field);
        return field;
    }

    @Override
    public NodeSchema getNodeSchema() {
        return this.nodeSchema;
    }

    @Override
    public EdgeSchema getEdgeSchema() {
        return this.edgeSchema;
    }

    @Override
    public Collection sortBy(PySequence seq, Field field) {
        ArrayList<SortableGraphElement> list = new ArrayList<SortableGraphElement>();
        for (int i = 0; i < seq.__len__(); ++i) {
            GraphElement ge = (GraphElement)((PyInstance)seq.__finditem__(i)).__tojava__(GraphElement.class);
            list.add(new SortableGraphElement(ge, (Comparable)ge.__getattr__(field.getName())));
        }
        Collections.sort(list);
        Vector<GraphElement> hs = new Vector<GraphElement>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            hs.add(((SortableGraphElement)it.next()).el);
        }
        return hs;
    }

    @Override
    public Collection sortBy(Field field) {
        Iterator it = null;
        if (field.getType() == 1) {
            it = this.getNodes().iterator();
        } else if (field.getType() == 2) {
            it = this.getEdges().iterator();
        } else {
            throw new Error("invalid Field type");
        }
        ArrayList<SortableGraphElement> list = new ArrayList<SortableGraphElement>();
        while (it.hasNext()) {
            GraphElement ge = (GraphElement)it.next();
            list.add(new SortableGraphElement(ge, (Comparable)ge.__getattr__(field.getName())));
        }
        Collections.sort(list);
        Vector<GraphElement> hs = new Vector<GraphElement>();
        it = list.iterator();
        while (it.hasNext()) {
            hs.add(((SortableGraphElement)it.next()).el);
        }
        return hs;
    }

    @Override
    public Collection groupBy(PySequence seq, Field field) {
        Hashtable<Object, SortableHashSet> map = new Hashtable<Object, SortableHashSet>();
        for (int i = 0; i < seq.__len__(); ++i) {
            GraphElement ge = (GraphElement)((PyInstance)seq.__finditem__(i)).__tojava__(GraphElement.class);
            Object attrib = ge.__getattr__(field.getName());
            if (!map.containsKey(attrib)) {
                map.put(attrib, new SortableHashSet((Comparable)attrib));
            }
            ((HashSet)map.get(attrib)).add(ge);
        }
        return map.values();
    }

    @Override
    public Collection groupBy(Field field) {
        if (field.getType() == 1) {
            return this.groupNodesBy(field.getName());
        }
        if (field.getType() == 2) {
            return this.groupEdgesBy(field.getName());
        }
        throw new Error("invalid Field type");
    }

    @Override
    public Collection groupAndSortBy(Field field) {
        if (field.getType() == 1) {
            return this.groupAndSortNodesBy(field.getName());
        }
        if (field.getType() == 2) {
            return this.groupAndSortEdgesBy(field.getName());
        }
        throw new Error("invalid Field type");
    }

    @Override
    public Collection groupAndSortBy(PySequence seq, Field field) {
        ArrayList al = new ArrayList();
        al.addAll(this.groupBy(seq, field));
        Collections.sort(al);
        return al;
    }

    @Override
    public Collection groupAndSortNodesBy(String field) {
        ArrayList al = new ArrayList();
        al.addAll(this.groupNodesBy(field));
        Collections.sort(al);
        return al;
    }

    @Override
    public Collection groupNodesBy(String field) {
        Hashtable<Object, SortableHashSet> map = new Hashtable<Object, SortableHashSet>();
        for (Node n : this.getNodes()) {
            Object attrib = n.__getattr__(field);
            if (!map.containsKey(attrib)) {
                map.put(attrib, new SortableHashSet((Comparable)attrib));
            }
            ((HashSet)map.get(attrib)).add(n);
        }
        return map.values();
    }

    @Override
    public Collection groupAndSortEdgesBy(String field) {
        ArrayList al = new ArrayList();
        al.addAll(this.groupEdgesBy(field));
        Collections.sort(al);
        return al;
    }

    @Override
    public Collection groupEdgesBy(String field) {
        Hashtable<Object, SortableHashSet> map = new Hashtable<Object, SortableHashSet>();
        for (Edge n : this.getEdges()) {
            Object attrib = n.__getattr__(field);
            if (!map.containsKey(attrib)) {
                map.put(attrib, new SortableHashSet((Comparable)attrib));
            }
            ((HashSet)map.get(attrib)).add(n);
        }
        return map.values();
    }

    @Override
    public void makeBarabasiAlbertRandom(int vert, int edges, int evolve) {
        BarabasiAlbertGenerator barg = new BarabasiAlbertGenerator(vert, edges);
        barg.evolveGraph(evolve);
        this.makeFromGenerator((GraphGenerator)barg);
    }

    @Override
    public void makeSimpleRandom(int nodes, int edges) {
        SimpleRandomGenerator srg = new SimpleRandomGenerator(nodes, edges);
        this.makeFromGenerator((GraphGenerator)srg);
    }

    @Override
    public void makeSimpleDirectedRandom(int nodes, int edges) {
        SimpleRandomDirectedGenerator srg = new SimpleRandomDirectedGenerator(nodes, edges);
        this.makeFromGenerator(srg);
    }

    @Override
    public void makeEppsteinRandom(int nodes, int edges, int r) {
        EppsteinPowerLawGenerator srg = new EppsteinPowerLawGenerator(nodes, edges, r);
        this.makeFromGenerator((GraphGenerator)srg);
    }

    @Override
    public void makeErdosRenyiRandom(int nodes, double p) {
        ErdosRenyiGenerator srg = new ErdosRenyiGenerator(nodes, p);
        this.makeFromGenerator((GraphGenerator)srg);
    }

    @Override
    public void makeLattice1DRandom(int nodes, boolean tor) {
        Lattice1DGenerator srg = new Lattice1DGenerator(nodes, tor);
        this.makeFromGenerator((GraphGenerator)srg);
    }

    @Override
    public void makeLattice2DRandom(int nodes, boolean tor) {
        Lattice2DGenerator srg = new Lattice2DGenerator(nodes, tor);
        this.makeFromGenerator((GraphGenerator)srg);
    }

    @Override
    public void makeKleinbergRandom(int nodes, double clust) {
        KleinbergSmallWorldGenerator srg = new KleinbergSmallWorldGenerator(nodes, clust);
        this.makeFromGenerator((GraphGenerator)srg);
    }

    @Override
    public void makeFromGenerator(GraphGenerator gg) {
        ArchetypeGraph ag = gg.generateGraph();
        Iterator it = ag.getVertices().iterator();
        int i = 0;
        Hashtable map = new Hashtable();
        while (it.hasNext()) {
            Node n = this.addNode("nd" + i);
            map.put(it.next(), n);
            ++i;
        }
        for (edu.uci.ics.jung.graph.Edge e : ag.getEdges()) {
            Pair p = e.getEndpoints();
            Node n1 = (Node)map.get(p.getFirst());
            Node n2 = (Node)map.get(p.getSecond());
            if (e instanceof DirectedSparseEdge) {
                this.addDirectedEdge(n1, n2);
                continue;
            }
            this.addUndirectedEdge(n1, n2);
        }
        this.randomLayout();
    }

    @Override
    public void makeFromGML(String filename) {
        GraphMLReader gmr = new GraphMLReader((Graph)this, filename);
        boolean tmp = this.centerAfter;
        boolean tmp2 = this.sync;
        this.sync = true;
        this.centerAfter = false;
        this.randomLayout();
        this.sync = tmp2;
        this.centerAfter = tmp;
    }

    @Override
    public void makeFromDL(String filename) {
    }

    @Override
    public void morph(String state, long duration) {
        if (VisFactory.getUIMode() == 1) {
            Morpher.morph((Graph)this, state, duration);
        }
    }

    @Override
    public void morph(int state, long duration) {
        this.morph("" + state, duration);
    }

    @Override
    public void colorize(Field f) {
        VisualUtils.colorize(this, f);
    }

    @Override
    public void colorize(Field f, Color start, Color end) {
        VisualUtils.colorize(this, f, start, end);
    }

    @Override
    public void colorize(Field f, String start, String end) {
        VisualUtils.colorize(this, f, Colors.getColor(start, Color.red), Colors.getColor(end, Color.blue));
    }

    @Override
    public void resizeRandom(Field f, double start, double end) {
        VisualUtils.resizeRandom(this, f, start, end);
    }

    @Override
    public void resizeLinear(Field f, double start, double end) {
        VisualUtils.resizeLinear(this, f, start, end);
    }

    @Override
    public double density() {
        return NetUtilities.calcDensity(this.getNodes());
    }

    @Override
    public Set removeSelfLoops() {
        Iterator it = this.getEdges().iterator();
        HashSet<Edge> toRemove = new HashSet<Edge>();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            if (e.getNode1() != e.getNode2()) continue;
            toRemove.add(e);
        }
        it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeEdge((Edge)it.next());
        }
        return null;
    }

    @Override
    public Set removeDisconnected() {
        Iterator it = this.getNodes().iterator();
        HashSet<Node> toRemove = new HashSet<Node>();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            boolean todo = true;
            for (Edge e : n.getIncidentEdges()) {
                Node t1 = e.getNode1();
                Node t2 = e.getNode2();
                if (n == t1 && n == t2) continue;
                todo = false;
                break;
            }
            if (!todo) continue;
            toRemove.add(n);
        }
        for (Node n : toRemove) {
            this.removeNode(n);
        }
        return null;
    }

    @Override
    public void hideDisconnected() {
        for (Node n : this.getNodes()) {
            boolean todo = true;
            for (Edge e : n.getIncidentEdges()) {
                Node t1 = e.getNode1();
                Node t2 = e.getNode2();
                if (n == t1 && n == t2) continue;
                todo = false;
                break;
            }
            if (!todo) continue;
            n.__setattr__("visible", new Boolean(false));
        }
    }

    class SortableGraphElement
    implements Comparable {
        public Comparable key = null;
        public GraphElement el = null;

        public SortableGraphElement(GraphElement el, Comparable key) {
            this.key = key;
            this.el = el;
        }

        public int compareTo(Object o) {
            return this.key.compareTo(((SortableGraphElement)o).key);
        }
    }
}

