/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Node;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.python.core.PyInstance;
import org.python.core.PySequence;

public class Subgraph {
    private static HashMap rootNodes = new HashMap();
    private String name = "";
    private HashMap cmap = new HashMap();
    private HashSet nodes = new HashSet();

    public static Subgraph getRootSubgraph(String name) {
        if (rootNodes.containsKey(name)) {
            return (Subgraph)rootNodes.get(name);
        }
        Subgraph toRet = new Subgraph(name);
        rootNodes.put(name, toRet);
        return toRet;
    }

    public Subgraph(String name) {
        this.name = name;
    }

    public Subgraph() {
        this("__root");
    }

    public Set getNodesShallow(Set input) {
        if (input == null) {
            input = new HashSet(this.nodes);
        } else {
            input.addAll(this.nodes);
        }
        return input;
    }

    public Set getNodesDeep(Set input) {
        if (input == null) {
            input = new HashSet(this.nodes);
        } else {
            input.addAll(this.nodes);
        }
        for (Subgraph sg : this.cmap.values()) {
            input = sg.getNodesDeep(input);
        }
        return input;
    }

    public Set getSubgraphsShallow(Set input) {
        if (input == null) {
            input = new HashSet(this.cmap.values());
        } else {
            input.addAll(this.cmap.values());
        }
        return input;
    }

    public Set getSubgraphsDeep(Set input) {
        if (input == null) {
            input = new HashSet(this.cmap.values());
        } else {
            input.addAll(this.cmap.values());
        }
        for (Subgraph sg : this.cmap.values()) {
            input = sg.getSubgraphsDeep(input);
        }
        return input;
    }

    public Object __call__(Object o) {
        return null;
    }

    public Object __getattr__(String fieldName) {
        if ((fieldName = fieldName.toLowerCase()).equals("nodes")) {
            return this.getNodesDeep(new HashSet());
        }
        if (fieldName.equals("subgraphs")) {
            return this.getSubgraphsDeep(new HashSet());
        }
        if (fieldName.equals("snodes")) {
            return this.getNodesShallow(new HashSet());
        }
        if (fieldName.equals("ssubgraphs")) {
            return this.getSubgraphsShallow(new HashSet());
        }
        if (!fieldName.startsWith("__")) {
            if (this.cmap.containsKey(fieldName)) {
                return this.cmap.get(fieldName);
            }
            Subgraph temp = new Subgraph(fieldName);
            this.cmap.put(fieldName, temp);
            return temp;
        }
        return this;
    }

    public void clear() {
        this.nodes.clear();
        this.cmap.clear();
    }

    public void add(Object o) {
        if (o instanceof Node) {
            this.nodes.add(o);
        } else if (o instanceof Subgraph) {
            this.cmap.put(((Subgraph)o).getName(), o);
        } else if (o instanceof PySequence) {
            PySequence seq = (PySequence)o;
            for (int i = 0; i < seq.__len__(); ++i) {
                this.add(((PyInstance)seq.__finditem__(i)).__tojava__(Object.class));
            }
        } else {
            throw new Error("You can not add objects of type " + o.getClass() + " to a subgraph");
        }
    }

    public void remove(Object o) {
        if (o instanceof Node) {
            this.nodes.remove(o);
        } else if (o instanceof Subgraph) {
            this.cmap.remove(((Subgraph)o).getName());
        } else if (o instanceof PySequence) {
            PySequence seq = (PySequence)o;
            for (int i = 0; i < seq.__len__(); ++i) {
                this.remove(((PyInstance)seq.__finditem__(i)).__tojava__(Object.class));
            }
        } else {
            throw new Error("You can not add objects of type " + o.getClass() + " to a subgraph");
        }
    }

    public void addNodes(Object o) {
        if (o instanceof Node) {
            this.nodes.add(o);
        } else if (o instanceof PySequence) {
            PySequence seq = (PySequence)o;
            for (int i = 0; i < seq.__len__(); ++i) {
                this.addNodes(((PyInstance)seq.__finditem__(i)).__tojava__(Object.class));
            }
        } else {
            throw new Error("You can not add objects of type " + o.getClass() + " to a subgraph.nodes");
        }
    }

    public void addSubgraphs(Object o) {
        if (o instanceof Subgraph) {
            this.cmap.put(((Subgraph)o).getName(), o);
        } else if (o instanceof PySequence) {
            PySequence seq = (PySequence)o;
            for (int i = 0; i < seq.__len__(); ++i) {
                this.addSubgraphs(((PyInstance)seq.__finditem__(i)).__tojava__(Object.class));
            }
        } else {
            throw new Error("You can not add objects of type " + o.getClass() + " to a subgraph.subgraphs");
        }
    }

    public Subgraph __add__(Object test) {
        this.add(test);
        return this;
    }

    public Subgraph __sub__(Object test) {
        this.remove(test);
        return this;
    }

    public void __setattr__(String fieldName, Object value) {
        if ((fieldName = fieldName.toLowerCase()).equals("nodes")) {
            this.nodes.clear();
            this.addNodes(value);
        } else if (fieldName.equals("subgraphs")) {
            this.cmap.clear();
            this.addSubgraphs(value);
        } else if (value instanceof Node || value instanceof Edge || value instanceof PySequence) {
            if (!fieldName.startsWith("__")) {
                Subgraph sg = null;
                if (this.cmap.containsKey(fieldName)) {
                    sg = (Subgraph)this.cmap.get(fieldName);
                } else {
                    Subgraph temp = new Subgraph(fieldName);
                    this.cmap.put(fieldName, temp);
                    sg = temp;
                }
                sg.clear();
                sg.add(value);
            }
        } else {
            for (Node n : this.getNodesDeep(null)) {
                n.__setattr__(fieldName, value);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("(nodes: ");
        boolean f = true;
        for (Node n : this.nodes) {
            if (f) {
                sb.append(n.getName());
                f = false;
                continue;
            }
            sb.append(", " + n.getName());
        }
        sb.append(") (subgraphs: ");
        Iterator<Object> it = this.cmap.keySet().iterator();
        f = true;
        while (it.hasNext()) {
            String s = (String)it.next();
            if (f) {
                sb.append(s);
                f = false;
                continue;
            }
            sb.append(", " + s);
        }
        sb.append(")");
        return sb.toString();
    }
}

