/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.db;

import com.hp.hpl.guess.DirectedEdge;
import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.EdgeSchema;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.FontTest;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.NodeSchema;
import com.hp.hpl.guess.Query;
import com.hp.hpl.guess.Schema;
import com.hp.hpl.guess.UndirectedEdge;
import com.hp.hpl.guess.db.Helper;
import com.hp.hpl.guess.db.SpreadSheetTable;
import com.hp.hpl.guess.storage.StorageListener;
import com.hp.hpl.guess.ui.ExceptionWindow;
import com.hp.hpl.guess.ui.StatusBar;
import edu.uci.ics.jung.exceptions.ConstraintViolationException;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.python.core.PyJavaInstance;

public class DBServer
implements StorageListener {
    private Connection conn;
    private static DBServer singleton = null;
    public static final boolean NODE = true;
    public static final boolean EDGE = false;
    private static HashSet tableList = new HashSet();
    private Hashtable preparedStatements = new Hashtable();
    private boolean commitState = false;
    private boolean inmem = false;
    public static Hashtable nodedefs = new Hashtable();
    public static Hashtable edgedefs;
    Hashtable unusedEdges = new Hashtable();
    Hashtable unusedNodes = new Hashtable();

    public Statement getStatement() throws SQLException {
        if (this.conn != null) {
            return this.conn.createStatement();
        }
        return null;
    }

    @Override
    public Set getStates() {
        HashSet<String> hs = new HashSet<String>();
        try {
            DatabaseMetaData dmb = this.conn.getMetaData();
            ResultSet rs = dmb.getTables(null, null, null, null);
            while (rs.next()) {
                String foo;
                String name = rs.getString(3);
                if (!name.startsWith("EDGES_") || (foo = name.substring(6)).equalsIgnoreCase("_deleted") || foo.equalsIgnoreCase("DEF")) continue;
                hs.add(foo);
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
        return hs;
    }

    private boolean containsTable(boolean nodeOrEdge, String st) {
        if (st == null) {
            return true;
        }
        if (tableList.size() == 0) {
            try {
                DatabaseMetaData dmb = this.conn.getMetaData();
                ResultSet rs = dmb.getTables(null, null, null, null);
                while (rs.next()) {
                    String name = rs.getString(3);
                    tableList.add(name.toLowerCase());
                }
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
        }
        String toTest = "NODES_" + st;
        if (!nodeOrEdge) {
            toTest = "EDGES_" + st;
        }
        return tableList.contains(toTest.toLowerCase());
    }

    private Set getAllStates() {
        HashSet<String> hs = new HashSet<String>();
        try {
            DatabaseMetaData dmb = this.conn.getMetaData();
            ResultSet rs = dmb.getTables(null, null, null, null);
            while (rs.next()) {
                String foo;
                String name = rs.getString(3);
                if (!name.startsWith("EDGES") || (foo = name.substring(5)).equalsIgnoreCase("_DEF")) continue;
                hs.add(foo);
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
        return hs;
    }

    public void setCommitState(boolean state) {
        this.commitState = state;
    }

    public boolean getCommitState() {
        return this.commitState;
    }

    @Override
    public Object getColumn(Node n, Field f) {
        if (n.getGraph() == null) {
            return this.getColumn(n, f, "_deleted");
        }
        return this.getColumn(n, f, null);
    }

    @Override
    public Object getColumn(Edge e, Field f) {
        if (e.getGraph() == null) {
            return this.getColumn(e, f, "_deleted");
        }
        return this.getColumn(e, f, null);
    }

    @Override
    public Object getColumn(Node n, Field f, String s) {
        try {
            Statement st = null;
            ResultSet rs = null;
            st = this.conn.createStatement();
            rs = s == null ? st.executeQuery("SELECT " + f.getName() + " from nodes where name = '" + n.getName() + "'") : st.executeQuery("SELECT " + f.getName() + " from nodes_" + s + " where name = '" + n.getName() + "'");
            if (rs.next()) {
                Object o = rs.getObject(1);
                st.close();
                return o;
            }
            return null;
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    @Override
    public Object getStatistic(Field f, String s) {
        return this.getStatistic(f, s, null);
    }

    public Object getStatistic(Field f, String s, String state) {
        try {
            Statement st = null;
            ResultSet rs = null;
            state = state != null ? "_" + state : "";
            st = this.conn.createStatement();
            rs = f.getType() == 1 ? st.executeQuery("SELECT " + s + "(" + f.getName() + ") from nodes" + state) : st.executeQuery("SELECT " + s + "(" + f.getName() + ") from edges" + state);
            if (rs.next()) {
                Object o = rs.getObject(1);
                st.close();
                return o;
            }
            return null;
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    @Override
    public Object getColumn(Edge e, Field f, String s) {
        try {
            Statement st = null;
            ResultSet rs = null;
            st = this.conn.createStatement();
            rs = s == null ? st.executeQuery("SELECT " + f.getName() + " from edges where __EDGEID = " + e.getID()) : st.executeQuery("SELECT " + f.getName() + " from edges_" + s + " where __EDGEID = " + e.getID());
            if (rs.next()) {
                Object o = rs.getObject(1);
                st.close();
                return o;
            }
            return null;
        }
        catch (Exception ex) {
            throw new Error(ex.toString());
        }
    }

    @Override
    public Object getColumn(Node n, Field f, int s) {
        return this.getColumn(n, f, "" + s);
    }

    @Override
    public Object getColumn(Edge e, Field f, int s) {
        return this.getColumn(e, f, "" + s);
    }

    @Override
    public Object[] getColumns(Node n, Field[] f) {
        return this.getColumns(n, f, null);
    }

    @Override
    public Object[] getColumns(Edge e, Field[] f) {
        return this.getColumns(e, f, null);
    }

    @Override
    public Object[] getColumns(Edge e, Field[] f, String s) {
        try {
            Statement st = null;
            ResultSet rs = null;
            st = this.conn.createStatement();
            StringBuffer toSelect = new StringBuffer();
            for (int i = 0; i < f.length; ++i) {
                if (i == 0) {
                    toSelect.append(f[i].getName());
                    continue;
                }
                toSelect.append("," + f[i].getName());
            }
            rs = s == null ? st.executeQuery("SELECT " + toSelect.toString() + " from edges where __EDGEID = " + e.getID()) : st.executeQuery("SELECT " + toSelect.toString() + " from edges_" + s + " where __EDGEID = " + e.getID());
            Object[] toRet = new Object[f.length];
            if (rs.next()) {
                for (int i = 0; i < f.length; ++i) {
                    toRet[i] = rs.getObject(i + 1);
                }
                st.close();
                return toRet;
            }
            return null;
        }
        catch (Exception ex) {
            throw new Error(ex.toString());
        }
    }

    @Override
    public Object[] getColumns(Node n, Field[] f, String s) {
        try {
            Statement st = null;
            ResultSet rs = null;
            st = this.conn.createStatement();
            StringBuffer toSelect = new StringBuffer();
            for (int i = 0; i < f.length; ++i) {
                if (i == 0) {
                    toSelect.append(f[i].getName());
                    continue;
                }
                toSelect.append("," + f[i].getName());
            }
            rs = s == null ? st.executeQuery("SELECT " + toSelect.toString() + " from nodes where name = '" + n.getName() + "'") : st.executeQuery("SELECT " + toSelect.toString() + " from nodes_" + s + " where name = '" + n.getName() + "'");
            Object[] toRet = new Object[f.length];
            if (rs.next()) {
                for (int i = 0; i < f.length; ++i) {
                    toRet[i] = rs.getObject(i + 1);
                }
                st.close();
                return toRet;
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionWindow.getExceptionWindow(ex);
            throw new Error(ex.toString());
        }
    }

    @Override
    public Object[] getColumns(Node n, Field[] f, int s) {
        return this.getColumns(n, f, "" + s);
    }

    @Override
    public Object[] getColumns(Edge e, Field[] f, int s) {
        return this.getColumns(e, f, "" + s);
    }

    public PreparedStatement getStatement(String prep) throws SQLException {
        PreparedStatement st = (PreparedStatement)this.preparedStatements.get(prep);
        if (st != null) {
            return st;
        }
        if (this.conn != null) {
            st = this.conn.prepareStatement(prep);
            this.preparedStatements.put(prep, st);
            return st;
        }
        throw new Error("no connection to the database");
    }

    public void closeStatements() {
        Iterator it = this.preparedStatements.values().iterator();
        while (it.hasNext()) {
            try {
                PreparedStatement ps = (PreparedStatement)it.next();
                ps.close();
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
        }
    }

    @Override
    public void fillSchema(NodeSchema schema, Graph g) {
        this.fillSchemaInternal(schema, g);
    }

    @Override
    public void fillSchema(EdgeSchema schema, Graph g) {
        this.fillSchemaInternal(schema, g);
    }

    private void fillSchemaInternal(Schema schema, Graph g) {
        try {
            int i;
            Statement stmt = this.conn.createStatement();
            ResultSet rs = null;
            int type = 1;
            if (schema instanceof NodeSchema) {
                rs = stmt.executeQuery("SELECT * from nodes");
            } else {
                rs = stmt.executeQuery("SELECT * from edges");
                type = 2;
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            int colmax = rsmd.getColumnCount();
            Object o = null;
            String[] names = new String[colmax];
            int[] types2 = new int[colmax];
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < colmax; ++i) {
                names[i] = rsmd.getColumnName(i + 1).toLowerCase();
                if (i >= 1) {
                    sb.append(",");
                }
                sb.append(names[i]);
                types2[i] = rsmd.getColumnType(i + 1);
            }
            stmt.close();
            stmt = this.conn.createStatement();
            rs = type == 1 ? stmt.executeQuery("SELECT " + sb.toString() + " FROM nodes_def") : stmt.executeQuery("SELECT " + sb.toString() + " FROM edges_def");
            while (rs.next()) {
                for (i = 0; i < colmax; ++i) {
                    schema.addField(new Field(g, names[i], type, types2[i], rs.getObject(i + 1)));
                }
            }
            stmt.close();
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    @Override
    public void updateColumn(Node n, Field f, Object value) {
        if (!this.commitState) {
            return;
        }
        String extra = "";
        if (n.getGraph() == null) {
            extra = "__deleted";
        }
        try {
            PreparedStatement st = this.getStatement("UPDATE nodes" + extra + " SET " + f.getName() + " = ? WHERE name = ?");
            this.updateColumn(st, f, value, 1);
            st.setString(2, n.getName());
            st.executeUpdate();
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    @Override
    public void updateColumn(Edge n, Field f, Object value) {
        if (!this.commitState) {
            return;
        }
        String extra = "";
        if (n.getGraph() == null) {
            extra = "__deleted";
        }
        try {
            PreparedStatement st = this.getStatement("UPDATE edges" + extra + " SET " + f.getName() + " = ? WHERE __EDGEID = ?");
            this.updateColumn(st, f, value, 1);
            st.setInt(2, n.getID());
            st.executeUpdate();
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    @Override
    public void addField(Field f) {
        try {
            StringBuffer sb2;
            if (Helper.isBadName(f.getName())) {
                System.out.println("\n\nWARNING! field name \"" + f.getName() + "\" may conflict with a restricted word\n\n");
            }
            if (this.conn != null) {
                StringBuffer sb = new StringBuffer("");
                sb2 = new StringBuffer("ALTER TABLE ");
                if (f.getType() == 1) {
                    sb2.append("nodes_def ");
                } else if (f.getType() == 2) {
                    sb2.append("edges_def ");
                } else {
                    throw new Error("Unsuported field type");
                }
                sb.append("ADD COLUMN " + f.getName() + " " + DBServer.getTypeString(f.getSQLType()) + " ");
                sb2.append("ADD COLUMN " + f.getName() + " " + DBServer.getTypeString(f.getSQLType()) + " ");
                if (f.getDefault() != null) {
                    if (f.getSQLType() == 12 || f.getSQLType() == 1 || f.getSQLType() == 91 || f.getSQLType() == 92 || f.getSQLType() == 93 || f.getSQLType() == -1) {
                        sb.append("DEFAULT '" + f.getDefault() + "'");
                        sb2.append("DEFAULT '" + f.getDefault() + "'");
                    } else {
                        sb.append("DEFAULT " + f.getDefault());
                        sb2.append("DEFAULT " + f.getDefault());
                    }
                }
                for (String st : this.getAllStates()) {
                    if (f.getType() == 1) {
                        this.update("ALTER TABLE nodes" + st + " " + sb.toString());
                        continue;
                    }
                    if (f.getType() == 2) {
                        this.update("ALTER TABLE edges" + st + " " + sb.toString());
                        continue;
                    }
                    throw new Error("Unsuported field type");
                }
            } else {
                throw new Error("no connection to the database");
            }
            this.update(sb2.toString());
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    private void updateColumn(PreparedStatement st, Field f, Object value, int column) {
        if (!this.commitState) {
            return;
        }
        try {
            if (value == null) {
                st.setNull(column, 0);
                return;
            }
            switch (f.getSQLType()) {
                case 2003: {
                    st.setArray(column, (Array)value);
                    break;
                }
                case -5: {
                    st.setInt(column, (Integer)value);
                    break;
                }
                case -2: {
                    st.setBoolean(column, (Boolean)value);
                    break;
                }
                case -7: {
                    st.setBoolean(column, (Boolean)value);
                    break;
                }
                case 16: {
                    st.setBoolean(column, (Boolean)value);
                    break;
                }
                case 2004: {
                    st.setBlob(column, (Blob)value);
                    break;
                }
                case 1: {
                    st.setString(column, value.toString());
                    break;
                }
                case 2005: {
                    st.setClob(column, (Clob)value);
                    break;
                }
                case 91: {
                    st.setDate(column, (Date)value);
                    break;
                }
                case 3: {
                    st.setBigDecimal(column, (BigDecimal)value);
                    break;
                }
                case 2001: {
                    throw new SQLException("Unsuported Type");
                }
                case 8: {
                    st.setDouble(column, (Double)value);
                    break;
                }
                case 6: {
                    st.setDouble(column, (Double)value);
                    break;
                }
                case 4: {
                    st.setInt(column, (Integer)value);
                    break;
                }
                case 2000: {
                    st.setObject(column, value);
                    break;
                }
                case -4: {
                    throw new SQLException("Unsuported Type");
                }
                case -1: {
                    st.setString(column, value.toString());
                    break;
                }
                case 0: {
                    st.setNull(column, 0);
                    break;
                }
                case 2: {
                    st.setBigDecimal(column, (BigDecimal)value);
                    break;
                }
                case 1111: {
                    throw new SQLException("Unsuported Type");
                }
                case 7: {
                    st.setDouble(column, (Double)value);
                    break;
                }
                case 2006: {
                    throw new SQLException("Unsuported Type");
                }
                case 5: {
                    st.setInt(column, (Integer)value);
                    break;
                }
                case 2002: {
                    st.setArray(column, (Array)value);
                    break;
                }
                case 92: {
                    st.setTime(column, (Time)value);
                    break;
                }
                case 93: {
                    st.setTimestamp(column, (Timestamp)value);
                    break;
                }
                case -6: {
                    st.setInt(column, (Integer)value);
                    break;
                }
                case -3: {
                    throw new SQLException("Unsuported Type");
                }
                case 12: {
                    st.setString(column, value.toString());
                    break;
                }
                default: {
                    throw new SQLException("Unsuported Type");
                }
            }
        }
        catch (Exception e) {
            System.out.println("error: " + st.toString());
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    public static String getTypeString(int type) {
        switch (type) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 2004: {
                return "BLOB";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                throw new Error("Unsuported Type");
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                throw new Error("Unsuported Type");
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                throw new Error("Unsuported Type");
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                throw new Error("Unsuported Type");
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                throw new Error("Unsuported Type");
            }
            case 12: {
                return "VARCHAR";
            }
        }
        throw new Error("Unsuported Type");
    }

    public DBServer(String db_file_name_prefix) throws Exception {
        Class.forName("org.hsqldb.jdbcDriver");
        this.conn = db_file_name_prefix.equals(".") ? DriverManager.getConnection("jdbc:hsqldb:mem:aname", "sa", "") : DriverManager.getConnection("jdbc:hsqldb:file:" + db_file_name_prefix, "sa", "");
    }

    public void shutdownConn() throws SQLException {
        this.conn.close();
    }

    public synchronized void q(String expression) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        st = this.conn.createStatement();
        if (expression.startsWith("SELECT") || expression.startsWith("select")) {
            rs = st.executeQuery(expression);
            try {
                DBServer.dump(rs);
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
        } else {
            try {
                st.executeUpdate(expression);
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
        }
        st.close();
    }

    public synchronized void saveCSV(String filename, String expression) throws Exception {
        int i;
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        Statement st = null;
        ResultSet rs = null;
        st = this.conn.createStatement();
        rs = st.executeQuery(expression);
        ResultSetMetaData meta = rs.getMetaData();
        int colmax = meta.getColumnCount();
        Object o = null;
        for (i = 0; i < colmax; ++i) {
            String colName = meta.getColumnName(i + 1);
            if (i == colmax - 1) {
                bw.write(colName);
                continue;
            }
            bw.write(colName + ",");
        }
        bw.write("\n");
        while (rs.next()) {
            for (i = 0; i < colmax; ++i) {
                o = rs.getObject(i + 1);
                String toStr = "NULL";
                if (o != null) {
                    toStr = o.toString();
                }
                if (toStr.indexOf(",") != -1) {
                    toStr = "\"" + toStr + "\"";
                }
                if (i == colmax - 1) {
                    bw.write(toStr);
                    continue;
                }
                bw.write(toStr + ",");
            }
            bw.write("\n");
        }
        st.close();
        bw.close();
    }

    public synchronized void query(String expression) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        st = this.conn.createStatement();
        rs = st.executeQuery(expression);
        st.close();
    }

    public synchronized int identity() throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        st = this.conn.createStatement();
        rs = st.executeQuery("CALL IDENTITY()");
        int toRet = -1;
        while (rs.next()) {
            try {
                toRet = rs.getInt(1);
            }
            catch (SQLException e1) {}
        }
        st.close();
        return toRet;
    }

    public synchronized void update(String expression, Statement st) throws SQLException {
        int i = st.executeUpdate(expression);
        if (i == -1) {
            System.out.println("db error : " + expression);
        }
    }

    public synchronized void update(String expression) throws SQLException {
        Statement st = this.conn.createStatement();
        this.update(expression, st);
        st.close();
    }

    public synchronized String prettyPrintResult(String query) {
        try {
            Statement st = null;
            ResultSet rs = null;
            st = this.conn.createStatement();
            rs = st.executeQuery(query);
            StringBuffer toRet = new StringBuffer();
            ResultSetMetaData meta = rs.getMetaData();
            int colmax = meta.getColumnCount();
            Object o = null;
            while (rs.next()) {
                for (int i = 0; i < colmax; ++i) {
                    o = rs.getObject(i + 1);
                    String colName = meta.getColumnName(i + 1);
                    if (o == null) continue;
                    toRet.append(colName + "\t" + o.toString() + "\n");
                }
                toRet.append("\n");
            }
            st.close();
            return toRet.toString();
        }
        catch (SQLException e) {
            return "unable to find match";
        }
    }

    public static void dump(ResultSet rs) throws SQLException {
        if (rs == null) {
            return;
        }
        ResultSetMetaData meta = rs.getMetaData();
        int colmax = meta.getColumnCount();
        Object o = null;
        while (rs.next()) {
            for (int i = 0; i < colmax; ++i) {
                o = rs.getObject(i + 1);
                if (o == null) continue;
                System.out.print(o.toString() + " ");
            }
            System.out.println(" ");
        }
    }

    public void getNodeColumn(Hashtable ht, String column, String limit) throws Exception {
        Statement st = null;
        ResultSet rs = null;
        st = this.conn.createStatement();
        String where = "";
        if (limit != null) {
            where = " WHERE " + limit;
        }
        rs = st.executeQuery("SELECT name," + column + " from nodes" + where);
        while (rs.next()) {
            String name = rs.getString("name");
            Object o = rs.getObject(2);
            ht.put(name, o);
        }
        st.close();
    }

    private String getStateString(Set s) {
        StringBuffer sb = new StringBuffer();
        Iterator it = s.iterator();
        while (it.hasNext()) {
            String st = (String)it.next();
            sb.append(st);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String getDisambigString(Set s, String col) {
        StringBuffer sb = new StringBuffer();
        Iterator it = s.iterator();
        String prev = null;
        while (it.hasNext()) {
            String st = (String)it.next();
            if (prev != null) {
                sb.append(" AND (" + prev + "." + col + "=" + st + "." + col + ")");
            }
            prev = st;
        }
        return sb.toString();
    }

    @Override
    public void findMatchingNodes(Query q) {
        try {
            Statement st = null;
            ResultSet rs = null;
            HashSet hs = new HashSet();
            st = this.conn.createStatement();
            Set s = q.getStates(null);
            String tables = this.getStateString(s);
            Iterator it = s.iterator();
            String first = (String)it.next();
            String disamb = "";
            if (s.size() > 1) {
                disamb = this.getDisambigString(s, "name");
            }
            rs = st.executeQuery("SELECT DISTINCT " + first + "." + "name FROM " + tables + " WHERE " + q.toSQLString() + disamb);
            while (rs.next()) {
                String name = rs.getString("name");
                Node gn = q.getGraph().getNodeByName(name);
                if (gn == null) {
                    gn = (Node)this.unusedNodes.get(name);
                }
                q.append(new PyJavaInstance(gn));
            }
            st.close();
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    @Override
    public void findMatchingEdges(Query q) {
        try {
            Statement st = null;
            ResultSet rs = null;
            HashSet hs = new HashSet();
            st = this.conn.createStatement();
            Set s = q.getStates(null);
            String tables = this.getStateString(s);
            String disamb = "";
            if (s.size() > 1) {
                disamb = this.getDisambigString(s, "__EDGEID");
            }
            Iterator it = s.iterator();
            String first = (String)it.next();
            rs = st.executeQuery("SELECT " + first + "." + "__EDGEID FROM " + tables + " WHERE " + q.toSQLString() + disamb);
            while (rs.next()) {
                int name = rs.getInt("__EDGEID");
                Edge gn = q.getGraph().getEdgeByID(new Integer(name));
                if (gn == null) {
                    gn = (Edge)this.unusedEdges.get(new Integer(name));
                }
                q.append(new PyJavaInstance(gn));
            }
            st.close();
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    @Override
    public void refresh(Graph g) {
        this.setCommitState(false);
        try {
            Statement st = null;
            ResultSet rs = null;
            st = this.conn.createStatement();
            rs = st.executeQuery("SELECT name,label,x,y,visible,color,fixed,style,width,height,labelvisible,labelcolor,strokecolor,image,labelsize from nodes");
            Hashtable map = new Hashtable();
            while (rs.next()) {
                String name = rs.getString("name");
                double x = rs.getDouble("x");
                double y = rs.getDouble("y");
                String color = rs.getString("color");
                String labelcolor = rs.getString("labelcolor");
                String strokecolor = rs.getString("strokecolor");
                boolean vis = rs.getBoolean("visible");
                String label = rs.getString("label");
                boolean labelvis = rs.getBoolean("labelvisible");
                boolean fixed = rs.getBoolean("fixed");
                int style = rs.getInt("style");
                double width = rs.getDouble("width");
                double height = rs.getDouble("height");
                String image = rs.getString("image");
                int labelsize = rs.getInt("labelsize");
                Node n = g.getNodeByName(name);
                if (n == null && (n = (Node)this.unusedNodes.get(name)) != null) {
                    this.unusedNodes.remove(name);
                }
                if (n == null) {
                    n = new Node(style, x, y, width, height, name);
                    g.addNode(n);
                } else {
                    if (n.getGraph() == null) {
                        g.addNode(n);
                    }
                    n.__setattr__("style", new Integer(style));
                    n.__setattr__("x", new Double(x));
                    n.__setattr__("y", new Double(y));
                    n.__setattr__("width", new Double(width));
                    n.__setattr__("height", new Double(height));
                }
                if (label != null) {
                    n.__setattr__("label", label);
                } else {
                    n.__setattr__("label", name);
                }
                n.__setattr__("color", color);
                n.__setattr__("strokecolor", strokecolor);
                n.__setattr__("fixed", new Boolean(fixed));
                n.__setattr__("visible", new Boolean(vis));
                n.__setattr__("labelvisible", new Boolean(labelvis));
                n.__setattr__("labelsize", new Integer(labelsize));
                n.__setattr__("image", image);
            }
            st.close();
            st = this.conn.createStatement();
            rs = st.executeQuery("SELECT __EDGEID,node1,node2,visible,color,width,weight,directed,label,labelvisible,labelcolor,labelsize from edges");
            while (rs.next()) {
                Node d;
                Node s;
                String src = rs.getString("node1");
                String dest = rs.getString("node2");
                boolean vis = rs.getBoolean("visible");
                String color = rs.getString("color");
                String labelcolor = rs.getString("labelcolor");
                double width = rs.getDouble("width");
                boolean directed = rs.getBoolean("directed");
                double weight = rs.getDouble("weight");
                String label = rs.getString("label");
                boolean labelvis = rs.getBoolean("labelvisible");
                int id = rs.getInt("__EDGEID");
                int labelsize = rs.getInt("labelsize");
                Edge e = g.getEdgeByID(new Integer(id));
                if (e == null && (e = (Edge)this.unusedEdges.get(new Integer(id))) != null) {
                    this.unusedEdges.remove(new Integer(id));
                }
                if (e == null) {
                    s = g.getNodeByName(src);
                    d = g.getNodeByName(dest);
                    if (s == null || s.getGraph() == null) {
                        System.err.println("\tedge contains undefined node \"" + src + "\"");
                        continue;
                    }
                    if (d == null || d.getGraph() == null) {
                        System.err.println("\tedge contains undefined node \"" + dest + "\"");
                        continue;
                    }
                    if (!directed) {
                        e = new UndirectedEdge(id, s, d);
                        g.addEdgeNoCheck(e);
                    } else {
                        e = new DirectedEdge(id, s, d);
                        g.addEdgeNoCheck(e);
                    }
                } else {
                    s = g.getNodeByName(src);
                    d = g.getNodeByName(dest);
                    if (s == null || s.getGraph() == null) {
                        System.err.println("\tedge contains undefined node " + src);
                        if (e.getGraph() != null) {
                            ((Graph)e.getGraph()).removeEdge(e);
                        }
                        this.unusedEdges.put(new Integer(id), e);
                        continue;
                    }
                    if (d == null || d.getGraph() == null) {
                        System.err.println("\tedge contains undefined node " + dest);
                        if (e.getGraph() != null) {
                            ((Graph)e.getGraph()).removeEdge(e);
                        }
                        this.unusedEdges.put(new Integer(id), e);
                        continue;
                    }
                }
                if (e.getGraph() == null) {
                    g.addEdgeNoCheck(e);
                }
                if (label != null) {
                    e.__setattr__("label", label);
                } else {
                    e.__setattr__("label", "" + weight);
                }
                e.__setattr__("width", new Double(width));
                e.__setattr__("weight", new Double(weight));
                e.__setattr__("visible", new Boolean(vis));
                e.__setattr__("color", color);
                if (labelcolor != null) {
                    e.__setattr__("labelcolor", labelcolor);
                }
                e.__setattr__("labelvisible", new Boolean(labelvis));
                e.__setattr__("labelsize", new Integer(labelsize));
            }
            st.close();
        }
        catch (ConstraintViolationException e) {
            System.out.println("\n*** You likely have a duplicate edge, try using the -m option\n");
            ExceptionWindow.getExceptionWindow(e);
            this.setCommitState(true);
            g.resetLastMod();
            throw new Error(e);
        }
        catch (Throwable e2) {
            ExceptionWindow.getExceptionWindow(e2);
            this.setCommitState(true);
            g.resetLastMod();
            throw new Error(e2);
        }
        this.setCommitState(true);
        g.resetLastMod();
    }

    public static DBServer init(String dbname) throws Exception {
        if (singleton != null) {
            return singleton;
        }
        singleton = new DBServer(dbname);
        try {
            singleton.query("SET WRITE_DELAY TRUE");
        }
        catch (SQLException ex2) {
            ExceptionWindow.getExceptionWindow(ex2);
        }
        return singleton;
    }

    public static DBServer getDBServer() {
        try {
            if (singleton == null) {
                DBServer.initInMemory();
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
        return singleton;
    }

    public static DBServer initInMemory() throws Exception {
        if (singleton != null) {
            return singleton;
        }
        singleton = new DBServer(".");
        DBServer.singleton.inmem = true;
        return singleton;
    }

    public static void resetSingleton() {
        singleton = null;
    }

    @Override
    public void shutdown() {
        DBServer.resetSingleton();
        StatusBar.setStatus("Shutting down database");
        StatusBar.runProgressBar(true);
        this.closeStatements();
        try {
            this.update("SHUTDOWN");
        }
        catch (Exception ex4) {
            ExceptionWindow.getExceptionWindow(ex4);
        }
        try {
            this.shutdownConn();
        }
        catch (Exception ex3) {
            ExceptionWindow.getExceptionWindow(ex3);
        }
        StatusBar.runProgressBar(false);
    }

    public void alter(String columnname, String query) {
        block2: {
            try {
                this.update(query);
            }
            catch (SQLException e) {
                String t = e.toString();
                if (t.indexOf("Column already exists") != -1) break block2;
                ExceptionWindow.getExceptionWindow(e);
            }
        }
    }

    public static String fixString(String init, Hashtable defs) {
        String s = init.trim();
        StringBuffer toRet = new StringBuffer();
        String[] foo = s.split(",");
        for (int i = 0; i < foo.length; ++i) {
            String t = foo[i].trim().toLowerCase();
            String[] subelem = t.split(" ");
            if (defs.containsKey(subelem[0])) {
                toRet.append(defs.get(subelem[0]));
            } else {
                toRet.append(foo[i]);
            }
            if (Helper.isBadName(subelem[0])) {
                System.out.println("\n\nWARNING! field name \"" + subelem[0] + "\" may conflict with a restricted word\n\n");
            }
            if (i >= foo.length - 1) continue;
            toRet.append(",");
        }
        return toRet.toString();
    }

    private static void processNodeDef(DBServer db, String def) throws Exception {
        String fixed = DBServer.fixString(def, nodedefs);
        db.update("CREATE CACHED TABLE nodes(" + fixed + ")");
        tableList.clear();
        db.alter("constraining names", "ALTER TABLE nodes ADD UNIQUE (NAME)");
        db.alter("x", "ALTER TABLE NODES ADD COLUMN X DOUBLE DEFAULT 500");
        db.alter("y", "ALTER TABLE nodes ADD COLUMN Y DOUBLE DEFAULT 500");
        db.alter("visible", "ALTER TABLE nodes ADD COLUMN visible BOOLEAN default true");
        db.alter("color", "ALTER TABLE nodes ADD COLUMN color VARCHAR(32) default 'cornflowerblue'");
        db.alter("strokecolor", "ALTER TABLE nodes ADD COLUMN strokecolor VARCHAR(32) default 'cadetblue'");
        db.alter("labelcolor", "ALTER TABLE nodes ADD COLUMN labelcolor VARCHAR(32) default NULL");
        db.alter("fixed", "ALTER TABLE nodes ADD COLUMN fixed BOOLEAN default false");
        db.alter("style", "ALTER TABLE nodes ADD COLUMN style TINYINT default 2");
        db.alter("width", "ALTER TABLE nodes ADD COLUMN width DOUBLE default 10");
        db.alter("height", "ALTER TABLE nodes ADD COLUMN height DOUBLE default 10");
        db.alter("name", "ALTER TABLE nodes ADD COLUMN name VARCHAR(32) default ''");
        db.alter("label", "ALTER TABLE nodes ADD COLUMN label VARCHAR(32) default NULL");
        db.alter("image", "ALTER TABLE nodes ADD COLUMN image VARCHAR(32) default NULL");
        db.alter("labelvisible", "ALTER TABLE nodes ADD COLUMN labelvisible BOOLEAN DEFAULT false");
        db.alter("labelsize", "ALTER TABLE nodes ADD COLUMN labelsize INT DEFAULT 12");
        db.update("CREATE CACHED TABLE nodes_def(" + fixed + ")");
        tableList.clear();
        db.alter("constraining names", "ALTER TABLE nodes_def ADD UNIQUE (NAME)");
        db.alter("x", "ALTER TABLE nodes_def ADD COLUMN X DOUBLE DEFAULT 500");
        db.alter("y", "ALTER TABLE nodes_def ADD COLUMN Y DOUBLE DEFAULT 500");
        db.alter("visible", "ALTER TABLE nodes_def ADD COLUMN visible BOOLEAN default true");
        db.alter("color", "ALTER TABLE nodes_def ADD COLUMN color VARCHAR(32) default 'cornflowerblue'");
        db.alter("strokecolor", "ALTER TABLE nodes_def ADD COLUMN strokecolor VARCHAR(32) default 'cadetblue'");
        db.alter("labelcolor", "ALTER TABLE nodes_def ADD COLUMN labelcolor VARCHAR(32) default NULL");
        db.alter("fixed", "ALTER TABLE nodes_def ADD COLUMN fixed BOOLEAN default false");
        db.alter("style", "ALTER TABLE nodes_def ADD COLUMN style TINYINT default 2");
        db.alter("width", "ALTER TABLE nodes_def ADD COLUMN width DOUBLE default 10");
        db.alter("height", "ALTER TABLE nodes_def ADD COLUMN height DOUBLE default 10");
        db.alter("name", "ALTER TABLE nodes_def ADD COLUMN name VARCHAR(32) default ''");
        db.alter("label", "ALTER TABLE nodes_def ADD COLUMN label VARCHAR(32) default NULL");
        db.alter("image", "ALTER TABLE nodes_def ADD COLUMN image VARCHAR(32) default NULL");
        db.alter("labelvisible", "ALTER TABLE nodes_def ADD COLUMN labelvisible BOOLEAN DEFAULT false");
        db.alter("labelsize", "ALTER TABLE nodes_def ADD COLUMN labelsize INT DEFAULT 12");
        db.query("INSERT INTO nodes_def(name) values('default')");
    }

    private static void processEdgeDef(DBServer db, String def) throws Exception {
        String fixed = DBServer.fixString(def, edgedefs);
        if (fixed.indexOf("__EDGEID") == -1) {
            fixed = fixed + ",__EDGEID INT IDENTITY PRIMARY KEY";
        }
        db.update("CREATE CACHED TABLE edges(" + fixed + ")");
        tableList.clear();
        db.alter("visible", "ALTER TABLE edges ADD COLUMN visible BOOLEAN default true");
        db.alter("color", "ALTER TABLE edges ADD COLUMN color VARCHAR(32) default 'dandelion'");
        db.alter("labelcolor", "ALTER TABLE edges ADD COLUMN labelcolor VARCHAR(32) default NULL");
        db.alter("width", "ALTER TABLE edges ADD COLUMN width DOUBLE default 2");
        db.alter("weight", "ALTER TABLE edges ADD COLUMN weight DOUBLE default 1");
        db.alter("directed", "ALTER TABLE edges ADD COLUMN directed BOOLEAN default 0");
        db.alter("node1", "ALTER TABLE edges ADD COLUMN node1 VARCHAR default ''");
        db.alter("node2", "ALTER TABLE edges ADD COLUMN node2 VARCHAR default ''");
        db.alter("label", "ALTER TABLE edges ADD COLUMN label VARCHAR(32) default NULL");
        db.alter("labelvisible", "ALTER TABLE edges ADD COLUMN labelvisible BOOLEAN DEFAULT false");
        db.alter("labelsize", "ALTER TABLE edges ADD COLUMN labelsize INT DEFAULT 12");
        db.update("CREATE CACHED TABLE edges_def(" + fixed + ")");
        tableList.clear();
        db.alter("visible", "ALTER TABLE edges_def ADD COLUMN visible BOOLEAN default true");
        db.alter("color", "ALTER TABLE edges_def ADD COLUMN color VARCHAR(32) default 'dandelion'");
        db.alter("labelcolor", "ALTER TABLE edges_def ADD COLUMN labelcolor VARCHAR(32) default NULL");
        db.alter("width", "ALTER TABLE edges_def ADD COLUMN width DOUBLE default 2");
        db.alter("weight", "ALTER TABLE edges_def ADD COLUMN weight DOUBLE default 1");
        db.alter("directed", "ALTER TABLE edges_def ADD COLUMN directed BOOLEAN default 0");
        db.alter("node1", "ALTER TABLE edges_def ADD COLUMN node1 VARCHAR default ''");
        db.alter("node2", "ALTER TABLE edges_def ADD COLUMN node2 VARCHAR default ''");
        db.alter("label", "ALTER TABLE edges_def ADD COLUMN label VARCHAR(32) default NULL");
        db.alter("labelvisible", "ALTER TABLE edges_def ADD COLUMN labelvisible BOOLEAN DEFAULT false");
        db.alter("labelsize", "ALTER TABLE edges_def ADD COLUMN labelsize INT DEFAULT 12");
        db.query("INSERT INTO edges_def(node1,node2) values('default','default')");
    }

    @Override
    public void loadFromFile(String text) {
        try {
            File f = new File(text);
            if (f.exists()) {
                BufferedReader br = null;
                br = Guess.getDefaultFileFormat() != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(text), Guess.getDefaultFileFormat())) : new BufferedReader(new FileReader(text));
                this.loadFromFile(br);
                br.close();
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    @Override
    public void loadFromText(String text) {
        try {
            BufferedReader br = new BufferedReader(new StringReader(text));
            this.loadFromFile(br);
            br.close();
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    @Override
    public void createEmpty() {
        try {
            String s = "nodedef> name\nedgedef> node1,node2\n";
            this.loadFromFile(new BufferedReader(new StringReader(s)));
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
    }

    public static String[] stringSplit(String line) {
        if (line.indexOf("'") >= 0 || line.indexOf("\"") >= 0 || line.indexOf("\\") >= 0) {
            char[] chars = new char[line.length()];
            line.getChars(0, chars.length, chars, 0);
            boolean inQuote = false;
            char quoteChar = '\'';
            char slashChar = '\\';
            Vector<String> toReturn = new Vector<String>();
            StringBuffer curString = null;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == slashChar) {
                    if (chars[i + 1] == 'n') {
                        curString.append("\n");
                        ++i;
                        continue;
                    }
                    if (chars[i + 1] == 't') {
                        curString.append("\t");
                        ++i;
                        continue;
                    }
                }
                if (inQuote) {
                    if (chars[i] == quoteChar) {
                        inQuote = false;
                        if (curString != null) {
                            toReturn.addElement(curString.toString());
                        }
                        curString = null;
                        continue;
                    }
                } else {
                    if (chars[i] == ',') {
                        if (curString != null) {
                            toReturn.addElement(curString.toString());
                        } else if (i > 0 && chars[i - 1] == ',') {
                            toReturn.addElement("");
                        }
                        curString = null;
                        continue;
                    }
                    if (chars[i] == '\'' || chars[i] == '\"') {
                        inQuote = true;
                        quoteChar = chars[i];
                        continue;
                    }
                }
                if (curString == null) {
                    curString = new StringBuffer();
                }
                curString.append(chars[i]);
            }
            if (curString != null || line.charAt(line.length() - 1) == ',') {
                toReturn.addElement(curString.toString());
            }
            Object[] toR = new String[toReturn.size()];
            toReturn.copyInto(toR);
            return toR;
        }
        return line.split(",");
    }

    private void loadFromFile(BufferedReader br) throws Exception {
        DBServer db = this;
        HashSet<String> seenEdge = new HashSet<String>();
        try {
            db.query("SET AUTOCOMMIT TRUE");
        }
        catch (SQLException ex2) {
            ExceptionWindow.getExceptionWindow(ex2);
        }
        try {
            db.query("DROP TABLE nodes");
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        try {
            db.query("DROP TABLE edges");
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        try {
            db.query("DROP TABLE nodes_def");
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        try {
            db.query("DROP TABLE edges_def");
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        try {
            db.query("SET WRITE_DELAY TRUE");
        }
        catch (SQLException ex2) {
            ExceptionWindow.getExceptionWindow(ex2);
        }
        String line = null;
        boolean inNodeDef = false;
        boolean inEdgeDef = false;
        String[] nnames = null;
        int[] ntypes = null;
        String[] enames = null;
        int[] etypes = null;
        int nodecount = 0;
        int edgecount = 0;
        Random rand = new Random();
        boolean lookupID = false;
        int node1Column = 0;
        int node2Column = 0;
        int directedColumn = -1;
        int nameColumn = 0;
        int lineNum = 0;
        StringBuffer fontTest = null;
        if (Guess.defaultFont != null && Guess.defaultFont.equals("GUESSFONT")) {
            fontTest = new StringBuffer();
        }
        while ((line = br.readLine()) != null) {
            String val;
            String[] vals;
            StringBuffer values;
            StringBuffer into;
            Object o;
            ResultSet rs;
            Statement stmt;
            String def;
            line = line.trim();
            if (fontTest != null) {
                fontTest.append(line);
            }
            ++lineNum;
            if (line.startsWith("#") || line.equals("")) continue;
            if (line.startsWith("nodedef>")) {
                inEdgeDef = false;
                inNodeDef = true;
                def = line.substring(8);
                try {
                    DBServer.processNodeDef(db, def);
                    stmt = db.conn.createStatement();
                    rs = stmt.executeQuery("SELECT * from nodes");
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int colmax = rsmd.getColumnCount();
                    o = null;
                    nnames = new String[colmax];
                    ntypes = new int[colmax];
                    for (int i = 0; i < colmax; ++i) {
                        nnames[i] = rsmd.getColumnName(i + 1);
                        ntypes[i] = rsmd.getColumnType(i + 1);
                        if (!nnames[i].equalsIgnoreCase("name")) continue;
                        nameColumn = i;
                    }
                    stmt.close();
                    continue;
                }
                catch (SQLException ex2) {
                    ExceptionWindow.getExceptionWindow(ex2);
                    System.out.println("*** failed to create db correctly, make sure you have defined the required columns (line: " + lineNum + ")");
                    return;
                }
            }
            if (line.startsWith("edgedef>")) {
                try {
                    inEdgeDef = true;
                    inNodeDef = false;
                    def = line.substring(8);
                    DBServer.processEdgeDef(db, def);
                    stmt = db.conn.createStatement();
                    rs = stmt.executeQuery("SELECT * from edges");
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int colmax = rsmd.getColumnCount();
                    o = null;
                    enames = new String[colmax];
                    etypes = new int[colmax];
                    for (int i = 0; i < colmax; ++i) {
                        enames[i] = rsmd.getColumnName(i + 1);
                        if (enames[i].equalsIgnoreCase("node1")) {
                            node1Column = i;
                        } else if (enames[i].equalsIgnoreCase("node2")) {
                            node2Column = i;
                        } else if (enames[i].equalsIgnoreCase("directed")) {
                            directedColumn = i;
                        }
                        etypes[i] = rsmd.getColumnType(i + 1);
                    }
                    stmt.close();
                    continue;
                }
                catch (SQLException ex2) {
                    ExceptionWindow.getExceptionWindow(ex2);
                    System.out.println("*** failed to create db correctly, make sure you have defined the required columns (line: " + lineNum + ")");
                    return;
                }
            }
            if (inNodeDef) {
                try {
                    into = new StringBuffer();
                    values = new StringBuffer();
                    vals = DBServer.stringSplit(line);
                    int i = -1;
                    boolean xl = false;
                    boolean yl = false;
                    String node1 = null;
                    for (int z = 0; z < vals.length; ++z) {
                        ++i;
                        val = vals[z];
                        if (val.equals("")) continue;
                        if (i == nameColumn) {
                            node1 = val;
                        }
                        into.append("," + nnames[i]);
                        if (ntypes[i] == 12 || ntypes[i] == 1 || ntypes[i] == 93 || ntypes[i] == 91 || ntypes[i] == 92 || ntypes[i] == -1) {
                            values.append(",");
                            if (!val.startsWith("'")) {
                                values.append("'");
                            }
                            values.append(val);
                            if (!val.endsWith("'")) {
                                values.append("'");
                            }
                        } else {
                            values.append("," + val);
                        }
                        if (nnames[i].equalsIgnoreCase("X")) {
                            xl = true;
                            continue;
                        }
                        if (!nnames[i].equalsIgnoreCase("Y")) continue;
                        yl = true;
                    }
                    if (!xl) {
                        into.append(",X");
                        values.append("," + rand.nextDouble() * 500.0);
                    }
                    if (!yl) {
                        into.append(",Y");
                        values.append("," + rand.nextDouble() * 500.0);
                    }
                    if (Helper.isBadName(node1)) {
                        System.out.println("\n\nWARNING! node name \"" + node1 + "\" may conflict with a restricted\n word or character  (line: " + lineNum + ")\n\n");
                    }
                    String a = into.toString();
                    String b = values.toString();
                    a = a.substring(1);
                    b = b.substring(1);
                    db.query("INSERT INTO nodes(" + a + ") VALUES(" + b + ")");
                    ++nodecount;
                }
                catch (Exception e3) {
                    System.out.println("problem with: " + line + " (line: " + lineNum + ")");
                    ExceptionWindow.getExceptionWindow(e3);
                }
                continue;
            }
            if (inEdgeDef) {
                try {
                    into = new StringBuffer();
                    values = new StringBuffer();
                    vals = DBServer.stringSplit(line);
                    int i = -1;
                    String node1 = null;
                    String node2 = null;
                    String directed = null;
                    for (int z = 0; z < vals.length; ++z) {
                        ++i;
                        val = vals[z];
                        if (val.equals("")) continue;
                        into.append("," + enames[i]);
                        if (i == node1Column) {
                            node1 = val;
                        } else if (i == node2Column) {
                            node2 = val;
                        } else if (i == directedColumn) {
                            directed = val;
                        }
                        if (etypes[i] == 12 || etypes[i] == 1 || etypes[i] == 93 || etypes[i] == 91 || etypes[i] == 92 || etypes[i] == -1) {
                            values.append(",");
                            if (!val.startsWith("'")) {
                                values.append("'");
                            }
                            values.append(val);
                            if (val.endsWith("'")) continue;
                            values.append("'");
                            continue;
                        }
                        values.append("," + val);
                    }
                    String sedge1 = null;
                    String sedge2 = null;
                    if (directed == null) {
                        sedge1 = node1 + "-" + node2;
                        if (!node1.equals(node2)) {
                            sedge2 = node2 + "-" + node1;
                        }
                    } else if (directed.equalsIgnoreCase("false") || directed.equals("0")) {
                        sedge1 = node1 + "-" + node2;
                        if (!node1.equals(node2)) {
                            sedge2 = node2 + "-" + node1;
                        }
                    } else {
                        sedge1 = node1 + "->" + node2;
                    }
                    if (sedge1 != null) {
                        if (seenEdge.contains(sedge1 = sedge1.toLowerCase()) && !Guess.allowMultiEdge()) {
                            System.out.println("\nWARNING! Duplicate edge " + sedge1 + " ignored (line: " + lineNum + ")\nConsider using the -m option to enable multiple edges.");
                            continue;
                        }
                        seenEdge.add(sedge1);
                    }
                    if (sedge2 != null) {
                        if (seenEdge.contains(sedge2 = sedge2.toLowerCase()) && !Guess.allowMultiEdge()) {
                            System.out.println("\nWARNING! Duplicate edge " + sedge2 + " ignored (line: " + lineNum + ")\nConsider using the -m option to enable multiple edges.");
                            continue;
                        }
                        seenEdge.add(sedge2);
                    }
                    String a = into.toString();
                    String b = values.toString();
                    a = a.substring(1);
                    b = b.substring(1);
                    db.query("INSERT INTO edges(" + a + ") VALUES(" + b + ")");
                    ++edgecount;
                }
                catch (Exception e3) {
                    System.out.println("problem with: " + line + "  (line: " + lineNum + ")");
                    ExceptionWindow.getExceptionWindow(e3);
                }
                continue;
            }
            System.out.println("Your database definition file may have a problem in it, not sure what to do with:\n" + line + " (line: " + lineNum + ")");
        }
        System.out.println("\nLoaded " + nodecount + " nodes and " + edgecount + " edges");
        if (fontTest != null) {
            System.out.println("Checking for best font...");
            Vector validFonts = FontTest.getValid(fontTest.toString());
            if (validFonts.size() == 0) {
                System.out.println("None found... using default");
                Guess.setDefaultFont(null);
            } else {
                System.out.println("using: " + ((Font)validFonts.elementAt(0)).getFontName());
                Guess.setDefaultFont(((Font)validFonts.elementAt(0)).getFontName());
                System.out.println("\nall choices:");
                for (int i = 0; i < validFonts.size(); ++i) {
                    System.out.println(((Font)validFonts.elementAt(i)).getFontName());
                }
            }
        }
    }

    @Override
    public void saveState(int statenum) {
        this.saveState("" + statenum);
    }

    @Override
    public void saveState(String statenum) {
        tableList.clear();
        try {
            this.query("DROP TABLE nodes_" + statenum);
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        try {
            this.query("DROP TABLE edges_" + statenum);
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        try {
            String create = "SELECT nodes.* INTO nodes_" + statenum + " FROM nodes";
            this.query(create);
            create = "SELECT edges.* INTO edges_" + statenum + " FROM edges";
            this.query(create);
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
        }
        StatusBar.setState(statenum);
    }

    public Collection getRemovedNodes() {
        return this.unusedNodes.values();
    }

    public Collection getRemovedEdges() {
        return this.unusedEdges.values();
    }

    @Override
    public Vector getNodesNotInCurrent(Graph g, int statenum) {
        return this.getNodesNotInCurrent(g, "" + statenum);
    }

    @Override
    public Vector getNodesNotInCurrent(Graph g, String statenum) {
        Vector<Node> toReturn = new Vector<Node>();
        try {
            Statement st = null;
            ResultSet rs = null;
            HashSet hs = new HashSet();
            st = this.conn.createStatement();
            rs = st.executeQuery("SELECT name from nodes_" + statenum + " minus select name from nodes");
            while (rs.next()) {
                String name = rs.getString("name");
                Node gn = (Node)this.unusedNodes.get(name);
                if (gn == null) {
                    System.out.println("I can't find an edge in the cache, did you load all the states before running a morph?");
                }
                toReturn.addElement(gn);
            }
            st.close();
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
        return toReturn;
    }

    @Override
    public Vector getEdgesNotInCurrent(Graph g, int statenum) {
        return this.getEdgesNotInCurrent(g, "" + statenum);
    }

    @Override
    public Vector getEdgesNotInCurrent(Graph g, String statenum) {
        Vector<Edge> toReturn = new Vector<Edge>();
        try {
            Statement st = null;
            ResultSet rs = null;
            HashSet hs = new HashSet();
            st = this.conn.createStatement();
            rs = st.executeQuery("SELECT __EDGEID from edges_" + statenum + " minus select __EDGEID from edges");
            while (rs.next()) {
                int eid = rs.getInt("__EDGEID");
                Edge ge = (Edge)this.unusedEdges.get(new Integer(eid));
                if (ge == null) {
                    System.out.println("I can't find an edge in the cache, did you load all the states before running a morph?");
                }
                toReturn.addElement(ge);
            }
            st.close();
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
        return toReturn;
    }

    @Override
    public void loadState(int state) {
        this.loadState(Guess.getGraph(), state);
    }

    @Override
    public void loadState(String state) {
        this.loadState(Guess.getGraph(), state);
    }

    @Override
    public void loadState(Graph g, int statenum) {
        this.loadState(g, "" + statenum);
    }

    @Override
    public void loadState(Graph g, String statenum) {
        HashSet hs;
        ResultSet rs;
        Statement st;
        this.setCommitState(false);
        try {
            st = null;
            rs = null;
            hs = new HashSet();
            st = this.conn.createStatement();
            rs = st.executeQuery("SELECT __EDGEID from edges minus select __EDGEID from edges_" + statenum);
            while (rs.next()) {
                int name = rs.getInt("__EDGEID");
                Edge ge = g.getEdgeByID(new Integer(name));
                this.unusedEdges.put(new Integer(name), ge);
                ge.__setattr__("visible", Boolean.FALSE);
                g.removeEdge(ge);
            }
            st.close();
        }
        catch (Exception e) {
            this.setCommitState(true);
            throw new Error(e.toString());
        }
        try {
            st = null;
            rs = null;
            hs = new HashSet();
            st = this.conn.createStatement();
            rs = st.executeQuery("SELECT name from nodes minus select name from nodes_" + statenum);
            while (rs.next()) {
                String name = rs.getString("name");
                Node gn = g.getNodeByName(name);
                gn.__setattr__("visible", Boolean.FALSE);
                this.unusedNodes.put(name, gn);
                g.removeNode(gn);
            }
            st.close();
        }
        catch (Exception e) {
            this.setCommitState(true);
            throw new Error(e.toString());
        }
        this.setCommitState(true);
        try {
            this.query("DROP TABLE nodes");
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        try {
            this.query("DROP TABLE edges");
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        String create = "SELECT nodes_" + statenum + ".* INTO nodes" + " FROM nodes_" + statenum;
        try {
            this.query(create);
        }
        catch (SQLException ex2) {
            ExceptionWindow.getExceptionWindow(ex2);
        }
        create = "SELECT edges_" + statenum + ".* INTO edges" + " FROM edges_" + statenum;
        try {
            this.query(create);
        }
        catch (SQLException ex2) {
            ExceptionWindow.getExceptionWindow(ex2);
        }
        NodeSchema ns = g.getNodeSchema();
        Enumeration en = ns.getFields();
        while (en.hasMoreElements()) {
            try {
                Field f = (Field)en.nextElement();
                if (f.getDefault() == null) continue;
                if (f.getSQLType() == 12 || f.getSQLType() == 1 || f.getSQLType() == 91 || f.getSQLType() == 92 || f.getSQLType() == 93 || f.getSQLType() == -1) {
                    this.update("ALTER TABLE NODES ALTER COLUMN " + f.getName() + " SET DEFAULT '" + f.getDefault() + "'");
                    continue;
                }
                this.update("ALTER TABLE NODES ALTER COLUMN " + f.getName() + " SET DEFAULT '" + f.getDefault() + "'");
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
        }
        EdgeSchema es = g.getEdgeSchema();
        en = es.getFields();
        while (en.hasMoreElements()) {
            try {
                Field f = (Field)en.nextElement();
                if (f.getDefault() == null) continue;
                if (f.getSQLType() == 12 || f.getSQLType() == 1 || f.getSQLType() == 91 || f.getSQLType() == 92 || f.getSQLType() == 93 || f.getSQLType() == -1) {
                    this.update("ALTER TABLE EDGES ALTER COLUMN " + f.getName() + " SET DEFAULT '" + f.getDefault() + "'");
                    continue;
                }
                this.update("ALTER TABLE EDGES ALTER COLUMN " + f.getName() + " SET DEFAULT '" + f.getDefault() + "'");
            }
            catch (Exception e) {
                ExceptionWindow.getExceptionWindow(e);
            }
        }
        this.refresh(g);
        StatusBar.setState(statenum);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            DBServer db = DBServer.init(args[0]);
            db.loadFromFile(args[1]);
            if (db != null) {
                db.shutdown();
            }
            System.exit(0);
        }
    }

    @Override
    public boolean containsEdge(Edge e) {
        return this.containsEdge(e, null);
    }

    @Override
    public boolean containsEdge(Edge e, String state) {
        try {
            if (!this.containsTable(false, state)) {
                return false;
            }
            Statement st = null;
            ResultSet rs = null;
            state = state == null ? "" : "_" + state;
            st = this.conn.createStatement();
            rs = st.executeQuery("SELECT * from edges" + state + " where __EDGEID = " + e.getID());
            return rs.next();
        }
        catch (Exception ex) {
            throw new Error(ex.toString());
        }
    }

    @Override
    public boolean containsNode(Node n) {
        return this.containsNode(n, null);
    }

    @Override
    public boolean containsNode(Node n, String state) {
        try {
            if (!this.containsTable(true, state)) {
                return false;
            }
            Statement st = null;
            ResultSet rs = null;
            state = state == null ? "" : "_" + state;
            st = this.conn.createStatement();
            rs = st.executeQuery("SELECT * from nodes" + state + " where name = '" + n.getName() + "'");
            return rs.next();
        }
        catch (Exception ex) {
            throw new Error(ex.toString());
        }
    }

    @Override
    public void addEdge(Edge e) {
        try {
            if (e instanceof UndirectedEdge) {
                this.query("INSERT INTO edges(__edgeid,node1,node2,directed) VALUES(" + e.getID() + "," + "'" + e.getNode1().getName() + "'," + "'" + e.getNode2().getName() + "',false)");
            } else {
                this.query("INSERT INTO edges(__edgeid,node1,node2,directed) VALUES(" + e.getID() + "," + "'" + e.getNode1().getName() + "'," + "'" + e.getNode2().getName() + "',true)");
            }
        }
        catch (Exception ex) {
            throw new Error(ex.toString() + " " + e);
        }
    }

    @Override
    public int createDirectedEdge(Node source, Node dest) {
        try {
            this.query("INSERT INTO edges(node1,node2,directed) VALUES('" + source.getName() + "'," + "'" + dest.getName() + "',true)");
            return this.identity();
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    @Override
    public int createDirectedEdge(Node source, Node dest, int id) {
        try {
            this.query("INSERT INTO edges(__edgeid,node1,node2,directed) VALUES(" + id + "," + "'" + source.getName() + "'," + "'" + dest.getName() + "',true)");
            return id;
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    @Override
    public int createUndirectedEdge(Node source, Node dest, int id) {
        try {
            this.query("INSERT INTO edges(__edgeid,node1,node2,directed) VALUES(" + id + "," + "'" + source.getName() + "'," + "'" + dest.getName() + "',false)");
            return id;
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    @Override
    public int createUndirectedEdge(Node source, Node dest) {
        try {
            this.query("INSERT INTO edges(node1,node2,directed) VALUES('" + source.getName() + "'," + "'" + dest.getName() + "',false)");
            return this.identity();
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    @Override
    public void undelete(Edge e) {
        try {
            this.unusedEdges.remove(new Integer(e.getID()));
            if (this.containsTable(false, "_deleted") && this.containsEdge(e, "_deleted")) {
                this.query("DELETE FROM edges WHERE __edgeid = " + e.getID() + "");
                String create = "INSERT INTO edges select * from edges__deleted where __edgeid = " + e.getID() + "";
                this.query(create);
                this.query("DELETE FROM edges__deleted WHERE __edgeid = " + e.getID() + "");
                return;
            }
        }
        catch (Exception ex) {
            ExceptionWindow.getExceptionWindow(ex);
            throw new Error(ex.toString());
        }
    }

    @Override
    public void undelete(Node node) {
        try {
            this.unusedNodes.remove(node.getName());
            if (this.containsTable(true, "_deleted") && this.containsNode(node, "_deleted")) {
                this.query("DELETE FROM nodes WHERE name = '" + node.getName() + "'");
                String create = "INSERT INTO nodes select * from nodes__deleted where name = '" + node.getName() + "'";
                this.query(create);
                this.query("DELETE FROM nodes__deleted WHERE name = '" + node.getName() + "'");
                return;
            }
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    @Override
    public void addNode(Node node) {
        if (Helper.isBadName(node.getName())) {
            System.out.println("\n\nWARNING! node name \"" + node.getName() + "\" may conflict with a restricted\n" + " word or character.\n\n");
        }
        try {
            this.query("INSERT INTO nodes(name) VALUES('" + node.getName() + "')");
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    @Override
    public void remove(Edge edge) {
        try {
            String create = null;
            if (this.containsTable(false, "_deleted")) {
                create = "DELETE FROM edges__deleted where __edgeid = " + edge.getID();
                this.query(create);
                create = "INSERT INTO edges__deleted select * from edges where __edgeid = " + edge.getID() + "";
                this.query(create);
            } else {
                create = "SELECT edges.* INTO edges__deleted  FROM edges where __edgeid = " + edge.getID() + "";
                this.query(create);
                this.alter("constraining edges", "ALTER TABLE edges__deleted ADD UNIQUE (__EDGEID)");
                tableList.clear();
            }
            this.query("DELETE FROM edges WHERE __edgeid = " + edge.getID());
            this.unusedEdges.put(new Integer(edge.getID()), edge);
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    @Override
    public void removeComplete(Edge edge) {
        Set s = this.getStates();
        if (this.containsTable(false, "_deleted")) {
            s.add("_deleted");
        }
        try {
            this.query("DELETE FROM edges WHERE __EDGEID = " + edge.getID());
        }
        catch (Exception ex) {
            ExceptionWindow.getExceptionWindow(ex);
        }
        Iterator it = s.iterator();
        while (it.hasNext()) {
            try {
                this.query("DELETE FROM edges_" + it.next() + " WHERE __EDGEID = " + edge.getID());
            }
            catch (Exception ex) {
                ExceptionWindow.getExceptionWindow(ex);
            }
        }
    }

    @Override
    public void removeComplete(Node node) {
        Set s = this.getStates();
        if (this.containsTable(true, "_deleted")) {
            s.add("_deleted");
        }
        try {
            this.query("DELETE FROM nodes WHERE name = '" + node.getName() + "'");
        }
        catch (Exception ex) {
            ExceptionWindow.getExceptionWindow(ex);
        }
        Iterator it = s.iterator();
        while (it.hasNext()) {
            try {
                this.query("DELETE FROM nodes_" + it.next() + " WHERE name = '" + node.getName() + "'");
            }
            catch (Exception ex) {
                ExceptionWindow.getExceptionWindow(ex);
            }
        }
    }

    @Override
    public void remove(Node node) {
        try {
            String create = null;
            if (this.containsTable(true, "_deleted")) {
                create = "DELETE FROM nodes__deleted where name = '" + node.getName() + "'";
                this.query(create);
                create = "INSERT INTO nodes__deleted select * from nodes where name = '" + node.getName() + "'";
                this.query(create);
            } else {
                create = "SELECT nodes.* INTO nodes__deleted  FROM nodes where name = '" + node.getName() + "'";
                this.query(create);
                this.alter("constraining names", "ALTER TABLE nodes__deleted ADD UNIQUE (NAME)");
                tableList.clear();
            }
            this.query("DELETE FROM nodes WHERE name = '" + node.getName() + "'");
            this.unusedNodes.put(node.getName(), node);
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error(e.toString());
        }
    }

    @Override
    public AbstractTableModel getNodeTable() {
        return new SpreadSheetTable(this, true);
    }

    @Override
    public AbstractTableModel getEdgeTable() {
        return new SpreadSheetTable(this, false);
    }

    @Override
    public void exportGDF(String filename) {
        try {
            String test;
            int i;
            PrintStream gdf = null;
            gdf = Guess.getDefaultFileFormat() != null ? new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(filename)), false, Guess.getDefaultFileFormat()) : new PrintStream(new BufferedOutputStream(new FileOutputStream(filename)));
            Statement stmt = this.conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * from nodes");
            ResultSetMetaData rsmd = rs.getMetaData();
            int colmax = rsmd.getColumnCount();
            Object o = null;
            String name = null;
            String type = null;
            gdf.print("nodedef>");
            for (i = 0; i < colmax; ++i) {
                name = rsmd.getColumnName(i + 1).toLowerCase();
                type = DBServer.getTypeString(rsmd.getColumnType(i + 1));
                if (i >= 1) {
                    gdf.print(",");
                }
                gdf.print(name + " " + type);
            }
            gdf.print("\n");
            while (rs.next()) {
                for (i = 0; i < colmax; ++i) {
                    o = rs.getObject(i + 1);
                    if (i >= 1) {
                        gdf.print(",");
                    }
                    if (o == null || o.toString().equals("")) continue;
                    test = o.toString();
                    if (test.indexOf(",") >= 0) {
                        gdf.print("'");
                        gdf.print(o.toString());
                        gdf.print("'");
                        continue;
                    }
                    gdf.print(o.toString());
                }
                gdf.print("\n");
            }
            stmt.close();
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("SELECT * from edges");
            rsmd = rs.getMetaData();
            colmax = rsmd.getColumnCount();
            o = null;
            name = null;
            type = null;
            gdf.print("edgedef>");
            for (i = 0; i < colmax; ++i) {
                name = rsmd.getColumnName(i + 1).toLowerCase();
                type = DBServer.getTypeString(rsmd.getColumnType(i + 1));
                if (i >= 1) {
                    gdf.print(",");
                }
                gdf.print(name + " " + type);
            }
            gdf.print("\n");
            while (rs.next()) {
                for (i = 0; i < colmax; ++i) {
                    o = rs.getObject(i + 1);
                    if (i >= 1) {
                        gdf.print(",");
                    }
                    if (o == null || o.toString().equals("")) continue;
                    test = o.toString();
                    if (test.indexOf(",") >= 0) {
                        gdf.print("'");
                        gdf.print(o.toString());
                        gdf.print("'");
                        continue;
                    }
                    gdf.print(o.toString());
                }
                gdf.print("\n");
            }
            stmt.close();
            gdf.close();
        }
        catch (Exception ex) {
            ExceptionWindow.getExceptionWindow(ex);
        }
    }

    static {
        nodedefs.put("name", "NAME VARCHAR(32) PRIMARY KEY");
        nodedefs.put("x", "X DOUBLE DEFAULT 500");
        nodedefs.put("y", "Y DOUBLE DEFAULT 500");
        nodedefs.put("visible", "VISIBLE BOOLEAN DEFAULT true");
        nodedefs.put("color", "COLOR VARCHAR(32) DEFAULT 'cornflowerblue'");
        nodedefs.put("strokecolor", "STROKECOLOR VARCHAR(32) DEFAULT 'cadetblue'");
        nodedefs.put("labelcolor", "LABELCOLOR VARCHAR(32) DEFAULT NULL");
        nodedefs.put("fixed", "FIXED BOOLEAN DEFAULT false");
        nodedefs.put("style", "STYLE TINYINT DEFAULT 2");
        nodedefs.put("width", "WIDTH DOUBLE DEFAULT 10");
        nodedefs.put("height", "HEIGHT DOUBLE DEFAULT 10");
        nodedefs.put("label", "LABEL VARCHAR(256) DEFAULT NULL");
        nodedefs.put("image", "IMAGE VARCHAR(256) DEFAULT NULL");
        nodedefs.put("labelvisible", "LABELVISIBLE BOOLEAN DEFAULT FALSE");
        nodedefs.put("labelsize", "LABELSIZE INT DEFAULT 12");
        edgedefs = new Hashtable();
        edgedefs.put("color", "COLOR VARCHAR(32) DEFAULT 'dandelion'");
        edgedefs.put("labelcolor", "LABELCOLOR VARCHAR(32) DEFAULT NULL");
        edgedefs.put("visible", "VISIBLE BOOLEAN DEFAULT true");
        edgedefs.put("__edgeid", "__EDGEID INT IDENTITY PRIMARY KEY");
        edgedefs.put("width", "width DOUBLE DEFAULT 2");
        edgedefs.put("weight", "weight DOUBLE DEFAULT 1");
        edgedefs.put("directed", "directed BOOLEAN DEFAULT 0");
        edgedefs.put("node1", "node1 VARCHAR(32) DEFAULT '' NOT NULL");
        edgedefs.put("node2", "node2 VARCHAR(32) DEFAULT '' NOT NULL");
        edgedefs.put("label", "LABEL VARCHAR(256) DEFAULT NULL");
        edgedefs.put("labelvisible", "LABELVISIBLE BOOLEAN DEFAULT FALSE");
        edgedefs.put("labelsize", "LABELSIZE INT DEFAULT 12");
    }
}

