/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.freehep;

import com.hp.hpl.guess.freehep.HEPWriter;
import com.hp.hpl.guess.piccolo.GFrame;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.freehep.graphicsio.cgm.CGMExportFileType;
import org.freehep.graphicsio.emf.EMFExportFileType;
import org.freehep.graphicsio.gif.GIFExportFileType;
import org.freehep.graphicsio.java.JAVAExportFileType;
import org.freehep.graphicsio.jpg.JPGExportFileType;
import org.freehep.graphicsio.pdf.PDFExportFileType;
import org.freehep.graphicsio.png.PNGExportFileType;
import org.freehep.graphicsio.ppm.PPMExportFileType;
import org.freehep.graphicsio.ps.EPSExportFileType;
import org.freehep.graphicsio.ps.PSExportFileType;
import org.freehep.graphicsio.raw.RawExportFileType;
import org.freehep.graphicsio.svg.SVGExportFileType;
import org.freehep.graphicsio.swf.SWFExportFileType;
import org.freehep.util.export.ExportFileType;

public class HEPDialog
extends JOptionPane {
    private static final String rootKey = HEPDialog.class.getName();
    private static final String SAVE_AS_TYPE = rootKey + ".SaveAsType";
    private static final String SAVE_AS_FILE = rootKey + ".SaveAsFile";
    private static Vector list = new Vector();
    private static HashMap efts = new HashMap();
    Rectangle2D originalSize = null;
    boolean fullImage = true;
    private String creator;
    private JButton browse = null;
    private JButton advanced = null;
    private JTextField file = null;
    private JComboBox type = null;
    private GFrame gframe = null;
    private Component component = null;
    private static double scaling;
    private boolean trusted = true;
    private Properties props = new Properties();
    private static String baseDir;
    private JTextField scale = null;
    private JLabel imageSize = null;

    public void setUserProperties(Properties properties) {
        this.props = properties;
    }

    private static void addExportFileType(ExportFileType fileType, int tp) {
        list.addElement(fileType);
        efts.put(fileType, new Integer(tp));
    }

    private static void addAllExportFileTypes() {
        HEPDialog.addExportFileType((ExportFileType)new JPGExportFileType(), 1);
        HEPDialog.addExportFileType((ExportFileType)new PNGExportFileType(), 9);
        HEPDialog.addExportFileType((ExportFileType)new PPMExportFileType(), 10);
        HEPDialog.addExportFileType((ExportFileType)new RawExportFileType(), 11);
        HEPDialog.addExportFileType((ExportFileType)new CGMExportFileType(), 7);
        HEPDialog.addExportFileType((ExportFileType)new EMFExportFileType(), 8);
        HEPDialog.addExportFileType((ExportFileType)new PDFExportFileType(), 2);
        HEPDialog.addExportFileType((ExportFileType)new EPSExportFileType(), 3);
        HEPDialog.addExportFileType((ExportFileType)new PSExportFileType(), 3);
        HEPDialog.addExportFileType((ExportFileType)new SVGExportFileType(), 4);
        HEPDialog.addExportFileType((ExportFileType)new SWFExportFileType(), 5);
        HEPDialog.addExportFileType((ExportFileType)new GIFExportFileType(), 0);
        HEPDialog.addExportFileType((ExportFileType)new JAVAExportFileType(), 6);
    }

    public HEPDialog() {
        this(null);
    }

    public void updateSize() {
        double rescale = 1.0;
        try {
            rescale = Double.parseDouble(this.scale.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.originalSize != null) {
            this.imageSize.setText("Output image size = " + (int)(this.originalSize.getWidth() * rescale) + " x " + (int)(this.originalSize.getHeight() * rescale) + " px");
        }
    }

    public JPanel createPanel() {
        JPanel jpanel1 = new JPanel();
        FormLayout formlayout1 = new FormLayout("FILL:4DLU:NONE,FILL:80PX:NONE,FILL:4DLU:NONE,FILL:55PX:NONE,FILL:4DLU:NONE,FILL:130PX:NONE,FILL:4DLU:NONE,FILL:93PX:NONE,FILL:4DLU:NONE", "CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE");
        CellConstraints cc = new CellConstraints();
        jpanel1.setLayout((LayoutManager)formlayout1);
        JLabel jlabel1 = new JLabel();
        jlabel1.setText("Rescale image:");
        jpanel1.add((Component)jlabel1, cc.xy(2, 7));
        this.scale = new JTextField();
        this.scale.setName("scale");
        this.scale.setText("" + scaling);
        jpanel1.add((Component)this.scale, cc.xy(4, 7));
        this.scale.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                HEPDialog.this.updateSize();
            }
        });
        this.imageSize = new JLabel();
        this.imageSize.setText("Output image size = ");
        jpanel1.add((Component)this.imageSize, cc.xywh(6, 7, 3, 1));
        this.file = new JTextField();
        this.file.setName("file");
        jpanel1.add((Component)this.file, cc.xywh(2, 2, 5, 1));
        this.type = new JComboBox(list);
        this.type.setName("type");
        jpanel1.add((Component)this.type, cc.xywh(2, 4, 5, 1));
        this.browse = new JButton();
        this.browse.setActionCommand("Browse...");
        this.browse.setName("browse");
        this.browse.setText("Browse...");
        jpanel1.add((Component)this.browse, cc.xy(8, 2));
        this.advanced = new JButton();
        this.advanced.setActionCommand("Options...");
        this.advanced.setName("advanced");
        this.advanced.setText("Options...");
        jpanel1.add((Component)this.advanced, cc.xy(8, 4));
        this.addFillComponents(jpanel1, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, new int[]{1, 2, 3, 4, 5, 6, 7, 8});
        return jpanel1;
    }

    void addFillComponents(Container panel, int[] cols, int[] rows) {
        int index;
        Dimension filler = new Dimension(10, 10);
        boolean filled_cell_11 = false;
        CellConstraints cc = new CellConstraints();
        if (cols.length > 0 && rows.length > 0 && cols[0] == 1 && rows[0] == 1) {
            panel.add(Box.createRigidArea(filler), cc.xy(1, 1));
            filled_cell_11 = true;
        }
        for (index = 0; index < cols.length; ++index) {
            if (cols[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(cols[index], 1));
        }
        for (index = 0; index < rows.length; ++index) {
            if (rows[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(1, rows[index]));
        }
    }

    public HEPDialog(String creator) {
        super(null, -1, 2);
        this.creator = creator;
        try {
            if (baseDir == null) {
                baseDir = System.getProperty("user.home");
            }
        }
        catch (SecurityException x) {
            this.trusted = false;
        }
        ButtonListener bl = new ButtonListener();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.createPanel(), "Center");
        this.type.setMaximumRowCount(16);
        this.browse.addActionListener(bl);
        this.advanced.addActionListener(bl);
        this.type.setRenderer(new SaveAsRenderer());
        this.type.addActionListener(bl);
        this.setMessage(panel);
    }

    public void showHEPDialog(Component parent, String title, Component target, String defFile) {
        this.showHEPDialog(parent, title, target, defFile, false);
    }

    public void showHEPDialog(Component parent, String title, Component target, String defFile, boolean fullImage) {
        String dType;
        if (target instanceof GFrame) {
            this.gframe = (GFrame)((Object)target);
            this.originalSize = this.gframe.getFullImageSize();
        } else {
            this.component = target;
        }
        this.fullImage = fullImage;
        if (fullImage) {
            this.scale.setEnabled(true);
        } else {
            this.scale.setEnabled(false);
        }
        this.updateSize();
        if (list.size() > 0) {
            this.type.setSelectedIndex(0);
        }
        if ((dType = this.props.getProperty(SAVE_AS_TYPE)) != null) {
            for (int i = 0; i < list.size(); ++i) {
                ExportFileType saveAs = (ExportFileType)list.elementAt(i);
                if (!saveAs.getFileFilter().getDescription().equals(dType)) continue;
                this.type.setSelectedItem(saveAs);
                break;
            }
        }
        this.advanced.setEnabled(this.currentType() != null && this.currentType().hasOptionPanel());
        if (this.trusted) {
            defFile = baseDir + File.separator + defFile;
            File f = new File(defFile);
            if (this.currentType() != null) {
                f = this.currentType().adjustFilename(f, this.props);
            }
            this.file.setText(f.toString());
        } else {
            this.file.setEnabled(false);
            this.browse.setEnabled(false);
        }
        JDialog dlg = this.createDialog(parent, title);
        dlg.pack();
        dlg.show();
    }

    private ExportFileType currentType() {
        return (ExportFileType)this.type.getSelectedItem();
    }

    protected String selectFile() {
        JFileChooser dlg = new JFileChooser();
        String f = this.file.getText();
        if (f != null) {
            dlg.setSelectedFile(new File(f));
        }
        dlg.setFileFilter(this.currentType().getFileFilter());
        if (dlg.showDialog(this, "Select") == 0) {
            return dlg.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    protected boolean writeFile(ExportFileType t) throws IOException {
        int ok;
        File f = new File(this.file.getText());
        if (f.exists() && (ok = JOptionPane.showConfirmDialog(this, "Replace existing file?")) != 0) {
            return false;
        }
        if (this.gframe != null) {
            if (this.fullImage) {
                this.gframe.writeFullImage(this.file.getText(), this.getEFType(t), scaling, this.props);
            } else {
                HEPWriter.export(this.file.getText(), (Component)((Object)this.gframe), this.getEFType(t), this.props);
            }
        } else {
            HEPWriter.export(this.file.getText(), this.component, this.getEFType(t), this.props);
        }
        this.props.put(SAVE_AS_FILE, this.file.getText());
        this.props.put(SAVE_AS_TYPE, this.currentType().getFileFilter().getDescription());
        baseDir = f.getParent();
        return true;
    }

    private int getEFType(ExportFileType t) {
        Integer i = (Integer)efts.get(t);
        if (i == null) {
            return 9;
        }
        return i;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Integer && (Integer)value == 0) {
            try {
                if (!this.writeFile(this.currentType())) {
                    return;
                }
            }
            catch (IOException x) {
                JOptionPane.showMessageDialog(this, x, "Error...", 0);
                return;
            }
        }
        super.setValue(value);
    }

    static {
        HEPDialog.addAllExportFileTypes();
        scaling = 1.0;
        baseDir = null;
    }

    private static class SaveAsRenderer
    extends DefaultListCellRenderer {
        private SaveAsRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ExportFileType) {
                this.setText(((ExportFileType)value).getFileFilter().getDescription());
            }
            return this;
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == HEPDialog.this.browse) {
                String fileName = HEPDialog.this.selectFile();
                if (fileName != null) {
                    if (HEPDialog.this.currentType() != null) {
                        File f = HEPDialog.this.currentType().adjustFilename(new File(fileName), HEPDialog.this.props);
                        HEPDialog.this.file.setText(f.getPath());
                    } else {
                        HEPDialog.this.file.setText(fileName);
                    }
                }
            } else if (source == HEPDialog.this.advanced) {
                JPanel panel = HEPDialog.this.currentType().createOptionPanel(HEPDialog.this.props);
                int rc = JOptionPane.showConfirmDialog(HEPDialog.this, panel, "Options for " + HEPDialog.this.currentType().getDescription(), 2, -1);
                if (rc == 0) {
                    HEPDialog.this.currentType().applyChangedOptions(panel, HEPDialog.this.props);
                    File f1 = new File(HEPDialog.this.file.getText());
                    File f2 = HEPDialog.this.currentType().adjustFilename(f1, HEPDialog.this.props);
                    if (!f1.equals(f2) && HEPDialog.this.file.isEnabled()) {
                        HEPDialog.this.file.setText(f2.toString());
                    }
                }
            } else if (source == HEPDialog.this.type) {
                HEPDialog.this.advanced.setEnabled(HEPDialog.this.currentType().hasOptionPanel());
                File f1 = new File(HEPDialog.this.file.getText());
                File f2 = HEPDialog.this.currentType().adjustFilename(f1, HEPDialog.this.props);
                if (!f1.equals(f2) && HEPDialog.this.file.isEnabled()) {
                    HEPDialog.this.file.setText(f2.toString());
                }
            }
        }
    }
}

