/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.freehep;

import com.hp.hpl.guess.ui.StatusBar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.File;
import java.util.Properties;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.cgm.CGMGraphics2D;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.gif.GIFGraphics2D;
import org.freehep.graphicsio.java.JAVAGraphics2D;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.freehep.graphicsio.swf.SWFGraphics2D;

public abstract class HEPWriter {
    public static final int GIF = 0;
    public static final int JPG = 1;
    public static final int PDF = 2;
    public static final int PS = 3;
    public static final int EPS = 3;
    public static final int SVG = 4;
    public static final int SWF = 5;
    public static final int JAVA = 6;
    public static final int CGM = 7;
    public static final int EMF = 8;
    public static final int PNG = 9;
    public static final int PPM = 10;
    public static final int RAW = 11;

    public static Graphics2D getGraphics2D(String outputfile, int type, int width, int height) {
        return HEPWriter.getGraphics2D(outputfile, type, width, height, null);
    }

    public static Graphics2D getGraphics2D(String outputfile, int type, int width, int height, Properties props) {
        PSGraphics2D toReturn = null;
        System.out.println("type: " + type + " " + 9);
        try {
            if (type == 3) {
                PSGraphics2D g;
                toReturn = g = new PSGraphics2D(new File(outputfile), new Dimension(width, height));
            } else if (type == 0) {
                GIFGraphics2D g = new GIFGraphics2D(new File(outputfile), new Dimension(width, height));
                toReturn = g;
            } else if (type == 1) {
                ImageGraphics2D g = new ImageGraphics2D(new File(outputfile), new Dimension(width, height), "jpg");
                toReturn = g;
            } else if (type == 9) {
                System.err.println("PNG");
                ImageGraphics2D g = new ImageGraphics2D(new File(outputfile), new Dimension(width, height), "png");
                toReturn = g;
            } else if (type == 10) {
                ImageGraphics2D g = new ImageGraphics2D(new File(outputfile), new Dimension(width, height), "ppm");
                toReturn = g;
            } else if (type == 11) {
                ImageGraphics2D g = new ImageGraphics2D(new File(outputfile), new Dimension(width, height), "raw");
                toReturn = g;
            } else if (type == 6) {
                JAVAGraphics2D g = new JAVAGraphics2D(new File(outputfile), new Dimension(width, height));
                toReturn = g;
            } else if (type == 2) {
                System.err.println("PDF");
                PDFGraphics2D g = new PDFGraphics2D(new File(outputfile), new Dimension(width, height));
                toReturn = g;
            } else if (type == 5) {
                SWFGraphics2D g = new SWFGraphics2D(new File(outputfile), new Dimension(width, height));
                toReturn = g;
            } else if (type == 4) {
                SVGGraphics2D g = new SVGGraphics2D(new File(outputfile), new Dimension(width, height));
                toReturn = g;
            } else if (type == 7) {
                CGMGraphics2D g = new CGMGraphics2D(new File(outputfile), new Dimension(width, height));
                toReturn = g;
            } else if (type == 8) {
                EMFGraphics2D g = new EMFGraphics2D(new File(outputfile), new Dimension(width, height));
                toReturn = g;
            }
            if (toReturn != null) {
                toReturn.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (props != null) {
                    ((VectorGraphics)toReturn).setProperties(props);
                }
            }
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
        return toReturn;
    }

    public static void export(String outputfile, Component mds, int type) {
        System.out.println("type: " + type + " " + 9);
        HEPWriter.export(outputfile, mds, type, null);
    }

    public static void export(String outputfile, Component mds, int type, Properties props) {
        try {
            Rectangle b = mds.getBounds();
            VectorGraphics g = (VectorGraphics)HEPWriter.getGraphics2D(outputfile, type, (int)b.getWidth(), (int)b.getHeight(), props);
            StatusBar.setStatus("Saving image...", true);
            g.startExport();
            mds.paint((Graphics)g);
            g.endExport();
            StatusBar.setStatus("Imaged saved...", false);
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }
}

