/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.io;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.EdgeSchema;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.NodeSchema;
import com.hp.hpl.guess.Schema;
import com.hp.hpl.guess.db.Helper;
import com.hp.hpl.guess.ui.ExceptionWindow;
import edu.uci.ics.jung.graph.Vertex;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class GDFReader {
    public static String[] stringSplit(String line) {
        if (line.indexOf("'") >= 0 || line.indexOf("\"") >= 0 || line.indexOf("\\") >= 0) {
            char[] chars = new char[line.length()];
            line.getChars(0, chars.length, chars, 0);
            boolean inQuote = false;
            char quoteChar = '\'';
            char slashChar = '\\';
            Vector<String> toReturn = new Vector<String>();
            StringBuffer curString = null;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == slashChar) {
                    if (chars[i + 1] == 'n') {
                        curString.append("\n");
                        ++i;
                        continue;
                    }
                    if (chars[i + 1] == 't') {
                        curString.append("\t");
                        ++i;
                        continue;
                    }
                }
                if (inQuote) {
                    if (chars[i] == quoteChar) {
                        inQuote = false;
                        if (curString != null) {
                            toReturn.addElement(curString.toString());
                        }
                        curString = null;
                        continue;
                    }
                } else {
                    if (chars[i] == ',') {
                        if (curString != null) {
                            toReturn.addElement(curString.toString());
                        } else if (i > 0 && chars[i - 1] == ',') {
                            toReturn.addElement("");
                        }
                        curString = null;
                        continue;
                    }
                    if (chars[i] == '\'' || chars[i] == '\"') {
                        inQuote = true;
                        quoteChar = chars[i];
                        continue;
                    }
                }
                if (curString == null) {
                    curString = new StringBuffer();
                }
                curString.append(chars[i]);
            }
            if (curString != null || line.charAt(line.length() - 1) == ',') {
                toReturn.addElement(curString.toString());
            }
            Object[] toR = new String[toReturn.size()];
            toReturn.copyInto(toR);
            return toR;
        }
        return line.split(",");
    }

    private static String fixString(String init, Hashtable defs) {
        String s = init.trim();
        StringBuffer toRet = new StringBuffer();
        String[] foo = s.split(",");
        for (int i = 0; i < foo.length; ++i) {
            String t = foo[i].trim().toLowerCase();
            String[] subelem = t.split(" ");
            if (defs.containsKey(subelem[0])) {
                toRet.append(defs.get(subelem[0]));
            } else {
                toRet.append(foo[i]);
            }
            if (Helper.isBadName(subelem[0])) {
                System.err.println("\n\nWARNING! field name \"" + subelem[0] + "\" may conflict with a restricted word\n\n");
            }
            if (i >= foo.length - 1) continue;
            toRet.append(",");
        }
        return toRet.toString();
    }

    private Field[] processNodeDef(Graph g, String s) {
        return this.processDef(g, s, g.getNodeSchema());
    }

    private Field[] processEdgeDef(Graph g, String s) {
        return this.processDef(g, s, g.getEdgeSchema());
    }

    private Field[] processDef(Graph g, String s, Schema ns) {
        String[] foo = s.split(",");
        Field[] toRet = new Field[foo.length];
        for (int i = 0; i < foo.length; ++i) {
            String t = foo[i].trim().toLowerCase();
            String[] subelem = t.split(" ");
            String attrName = subelem[0];
            Field existingF = ns.getField(attrName);
            Integer attrType = null;
            if (existingF != null) {
                attrType = new Integer(existingF.getSQLType());
            }
            String def = null;
            for (int j = 1; j < subelem.length; ++j) {
                if (subelem[j].equals("default")) {
                    def = subelem[j + 1];
                    ++j;
                    continue;
                }
                if (attrType != null) continue;
                attrType = new Integer(this.getSQLType(subelem[j]));
            }
            if (attrType == null) {
                throw new RuntimeException("");
            }
            Field f = ns.getField(attrName);
            if (f != null) {
                Object o = this.convertToType(f.getSQLType(), def);
                if (o != null) {
                    f.setDefault(o);
                }
                if (f.getSQLType() != attrType.intValue()) {
                    String error = attrName + ", current SQL type: " + f.getSQLType() + "requested type: " + attrType;
                    if (ns instanceof NodeSchema) {
                        ExceptionWindow.getExceptionWindow(new Exception("Possible type conflict on: Node." + error));
                    } else {
                        ExceptionWindow.getExceptionWindow(new Exception("Possible type conflict on: Edge." + error));
                    }
                }
            } else if (ns instanceof NodeSchema) {
                f = g.addNodeField(attrName, attrType, this.convertToType(attrType, def));
            } else if (ns instanceof EdgeSchema) {
                f = g.addEdgeField(attrName, attrType, this.convertToType(attrType, def));
            }
            toRet[i] = f;
        }
        return toRet;
    }

    private Object convertToType(int attrType, String def) {
        if (def == null) {
            return null;
        }
        try {
            if (attrType == -7 || attrType == 16) {
                if (def.equalsIgnoreCase("true") || def.equalsIgnoreCase("1")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (attrType == 4 || attrType == -6 || attrType == 5) {
                return new Integer(Integer.parseInt(def));
            }
            if (attrType == 8) {
                return new Double(Double.parseDouble(def));
            }
            if (attrType == 6) {
                return new Float(Float.parseFloat(def));
            }
            if (attrType == 12) {
                return def;
            }
            System.out.println("Treating unknown type " + attrType + " as String");
            return def;
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            return null;
        }
    }

    public GDFReader(Graph g, String file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = null;
        boolean inNodeDef = false;
        boolean inEdgeDef = false;
        boolean nodecount = false;
        boolean edgecount = false;
        Random rand = new Random();
        Field[] nodeCols = null;
        Field[] edgeCols = null;
        int nNameCol = -1;
        int eNode1Col = -1;
        int eNode2Col = -1;
        int eIDCol = -1;
        int eDirCol = -1;
        boolean randomLayout = true;
        int lineNum = 0;
        while ((line = br.readLine()) != null) {
            String def;
            line = line.trim();
            ++lineNum;
            if (line.startsWith("#") || line.equals("")) continue;
            if (line.startsWith("nodedef>")) {
                inEdgeDef = false;
                inNodeDef = true;
                def = line.substring(8);
                nodeCols = this.processNodeDef(g, def);
                for (int i = 0; i < nodeCols.length; ++i) {
                    if (nodeCols[i].getName().equalsIgnoreCase("name")) {
                        nNameCol = i;
                        continue;
                    }
                    if (nodeCols[i].getName().equalsIgnoreCase("x")) {
                        randomLayout = false;
                        continue;
                    }
                    if (!nodeCols[i].getName().equalsIgnoreCase("y")) continue;
                    randomLayout = false;
                }
                if (nNameCol != -1) continue;
                throw new RuntimeException("No name column, invalid GDF file");
            }
            if (line.startsWith("edgedef>")) {
                inEdgeDef = true;
                inNodeDef = false;
                def = line.substring(8);
                edgeCols = this.processEdgeDef(g, def);
                for (int i = 0; i < edgeCols.length; ++i) {
                    if (edgeCols[i].getName().equalsIgnoreCase("node1")) {
                        eNode1Col = i;
                        continue;
                    }
                    if (edgeCols[i].getName().equalsIgnoreCase("node2")) {
                        eNode2Col = i;
                        continue;
                    }
                    if (edgeCols[i].getName().equalsIgnoreCase("directed")) {
                        eDirCol = i;
                        continue;
                    }
                    if (!edgeCols[i].getName().equalsIgnoreCase("__edgeid")) continue;
                    eIDCol = i;
                }
                if (eNode1Col == -1) {
                    throw new RuntimeException("No node1 column, invalid GDF file");
                }
                if (eNode2Col != -1) continue;
                throw new RuntimeException("No node2 column, invalid GDF file");
            }
            String[] vals = GDFReader.stringSplit(line);
            if (inNodeDef) {
                Node n = g.getNodeByName(vals[nNameCol]);
                if (n == null) {
                    n = g.addNode(vals[nNameCol]);
                }
                n.__setattr__("label", vals[nNameCol]);
                for (int i = 0; i < vals.length; ++i) {
                    if (i == nNameCol) continue;
                    n.__setattr__(nodeCols[i].getName(), this.convertToType(nodeCols[i].getSQLType(), vals[i]));
                }
                if (!randomLayout) continue;
                n.__setattr__("x", new Double(rand.nextDouble() * 500.0));
                n.__setattr__("y", new Double(rand.nextDouble() * 500.0));
                continue;
            }
            if (inEdgeDef) {
                Node s = g.getNodeByName(vals[eNode1Col]);
                Node t = g.getNodeByName(vals[eNode2Col]);
                boolean directed = false;
                if (eDirCol != -1) {
                    directed = (Boolean)this.convertToType(edgeCols[eDirCol].getSQLType(), vals[eDirCol]);
                }
                Edge e = null;
                if (eIDCol == -1) {
                    e = (Edge)s.findEdge((Vertex)t);
                    if (e == null) {
                        e = directed ? g.addDirectedEdge(s, t) : g.addUndirectedEdge(s, t);
                    }
                } else {
                    int eid = Integer.parseInt(vals[eIDCol]);
                    e = g.getEdgeByID(eid);
                    if (e == null) {
                        e = directed ? g.addDirectedEdgeWID(s, t, eid) : g.addUndirectedEdgeWID(s, t, eid);
                    }
                }
                for (int i = 0; i < vals.length; ++i) {
                    if (i == eNode1Col || i == eNode2Col || i == eIDCol || i == eDirCol) continue;
                    e.__setattr__(edgeCols[i].getName(), this.convertToType(edgeCols[i].getSQLType(), vals[i]));
                }
                continue;
            }
            throw new RuntimeException("Your database definition file may have a problem in it, not sure what to do with:\n" + line + " (line: " + lineNum + ")");
        }
    }

    private int getSQLType(String s) {
        if (s.equals("array")) {
            return 2003;
        }
        if (s.equals("bigint")) {
            return -5;
        }
        if (s.equals("binary")) {
            return -2;
        }
        if (s.equals("bit")) {
            return -7;
        }
        if (s.equals("boolean")) {
            return 16;
        }
        if (s.equals("blob")) {
            return 2004;
        }
        if (s.equals("decimal")) {
            return 3;
        }
        if (s.equals("double")) {
            return 8;
        }
        if (s.equals("float")) {
            return 6;
        }
        if (s.equals("integer") || s.equals("int")) {
            return 4;
        }
        if (s.equals("java_object")) {
            return 2000;
        }
        if (s.equals("longvarchar")) {
            return -1;
        }
        if (s.equals("null")) {
            return 0;
        }
        if (s.equals("numeric")) {
            return 2;
        }
        if (s.equals("real")) {
            return 7;
        }
        if (s.equals("smallint")) {
            return 5;
        }
        if (s.equals("struct")) {
            return 2002;
        }
        if (s.equals("time")) {
            return 92;
        }
        if (s.equals("timestamp")) {
            return 93;
        }
        if (s.equals("tinyint")) {
            return -6;
        }
        if (s.startsWith("varchar")) {
            return 12;
        }
        throw new RuntimeException("Unsuported Type");
    }
}

