/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.io;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.EdgeSchema;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.NodeSchema;
import com.hp.hpl.guess.ui.ExceptionWindow;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GraphMLReader
extends DefaultHandler {
    private static final int GRAPH = 1;
    private static final int NODE = 2;
    private static final int EDGE = 3;
    private static final int DEFAULT = 4;
    private static final int DATA = 5;
    private static final int KEY = 6;
    private static final int OTHER = 10;
    Graph g = null;
    NodeSchema ns = null;
    EdgeSchema es = null;
    private boolean directed = false;
    private Map curAttrs = null;
    private Stack seen = new Stack();
    private String curString = "";
    private String dataName = "";
    private HashMap nameMap = new HashMap();

    public GraphMLReader(Graph g, String fileName) {
        this.g = g;
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileName));
            this.load(g, bis);
            bis.close();
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    public GraphMLReader(Graph g, InputStream r) {
        this.g = g;
        this.load(g, r);
    }

    public void load(Graph g, InputStream r) {
        this.ns = g.getNodeSchema();
        this.es = g.getEdgeSchema();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(r, (DefaultHandler)this);
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            throw new Error("Error loading graphml file: " + e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        if ((qName = qName.toLowerCase()).equals("graph")) {
            this.createGraph(this.getAttributeMap(attrs));
        } else if (!qName.equals("default")) {
            if (qName.equals("data")) {
                this.dataName = this.getKeyName(attrs);
            } else {
                this.curAttrs = this.getAttributeMap(attrs);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String lName, String qName) throws SAXException {
        if ((qName = qName.toLowerCase()).equals("node")) {
            this.createNode(this.curAttrs);
        } else if (qName.equals("edge")) {
            this.createEdge(this.curAttrs);
        } else if (qName.equals("key")) {
            this.createKey(this.curAttrs);
        } else if (qName.equals("default")) {
            this.curString = this.curString.trim();
            this.curAttrs.put("default", this.curString);
            this.curString = "";
        } else if (qName.equals("data")) {
            this.curString = this.curString.trim();
            this.curAttrs.put(this.dataName, this.curString);
            this.curString = "";
            this.dataName = "";
        }
    }

    public void createKey(Map attributeMap) {
        Object o;
        Field f;
        String attrName = (String)attributeMap.get("attr.name");
        String attrType = (String)attributeMap.get("attr.type");
        String id = (String)attributeMap.get("id");
        String forT = (String)attributeMap.get("for");
        String def = (String)attributeMap.get("default");
        if (attrName == null || attrType == null || id == null || forT == null) {
            System.out.println("illegal key definition " + id);
            return;
        }
        attrName = attrName.toLowerCase();
        attrType = attrType.toLowerCase();
        id = id.toLowerCase();
        forT = forT.toLowerCase();
        boolean addNF = false;
        boolean addEF = false;
        if (forT.equals("node")) {
            addNF = true;
        } else if (forT.equals("edge")) {
            addEF = true;
        } else if (forT.equals("all")) {
            addNF = true;
            addEF = true;
        } else if (forT.equals("graph")) {
            System.out.println("graph keys not supported");
        }
        if (addNF) {
            f = this.ns.getField(attrName);
            if (f != null) {
                System.out.println("node." + attrName + " already exists " + f.getSQLType() + " " + def);
                o = this.convertToType(f.getSQLType(), def);
                if (o != null) {
                    f.setDefault(o);
                }
            } else {
                int t = this.getSQLType(attrType);
                this.g.addNodeField(attrName, this.getSQLType(attrType), this.convertToType(t, def));
            }
            f = this.ns.getField(attrName);
        }
        if (addEF) {
            f = this.es.getField(attrName);
            if (f != null) {
                System.out.println("edge." + attrName + " already exists " + f.getSQLType() + " " + def);
                o = this.convertToType(f.getSQLType(), def);
                if (o != null) {
                    f.setDefault(o);
                }
            } else {
                int t = this.getSQLType(attrType);
                this.g.addEdgeField(attrName, this.getSQLType(attrType), this.convertToType(t, def));
            }
            f = this.es.getField(attrName);
        }
        this.nameMap.put(id, attrName);
    }

    private int getSQLType(String attrType) {
        if (attrType.equals("boolean")) {
            return -7;
        }
        if (attrType.equals("int")) {
            return 4;
        }
        if (attrType.equals("long")) {
            return 8;
        }
        if (attrType.equals("float")) {
            return 6;
        }
        if (attrType.equals("double")) {
            return 8;
        }
        if (attrType.equals("string")) {
            return 12;
        }
        System.out.println("Unsupported type: " + attrType + ", treating as String");
        return 12;
    }

    private Object convertToType(int attrType, String def) {
        if (def == null) {
            return null;
        }
        try {
            if (attrType == -7 || attrType == 16) {
                if (def.equalsIgnoreCase("true") || def.equalsIgnoreCase("1")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (attrType == 4 || attrType == -6 || attrType == 5) {
                return new Integer(Integer.parseInt(def));
            }
            if (attrType == 8) {
                return new Double(Double.parseDouble(def));
            }
            if (attrType == 6) {
                return new Float(Float.parseFloat(def));
            }
            if (attrType == 12) {
                return def;
            }
            System.out.println("Treating unknown type " + attrType + " as String");
            return def;
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            return null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.curString = this.curString + new String(ch, start, length);
    }

    public void createNode(Map attributeMap) {
        try {
            String idString = (String)attributeMap.remove("id");
            Node n = this.g.addNode(idString);
            n.__setattr__("label", idString);
            for (String key : attributeMap.keySet()) {
                String val = (String)attributeMap.get(key);
                Field f = this.ns.getField(key);
                if (f == null) continue;
                n.__setattr__(f.getName(), this.convertToType(f.getSQLType(), val));
            }
        }
        catch (Exception ex) {
            ExceptionWindow.getExceptionWindow(ex);
        }
    }

    protected void createGraph(Map attributeMap) {
        String edgeDefaultType = (String)attributeMap.remove("edgedefault");
        if (edgeDefaultType != null && edgeDefaultType.equalsIgnoreCase("directed")) {
            this.directed = true;
        }
    }

    public void createEdge(Map attributeMap) {
        try {
            Node t;
            String source = (String)attributeMap.remove("source");
            String target = (String)attributeMap.remove("target");
            Node s = this.g.getNodeByName(source);
            if (s == null) {
                s = this.g.addNode(source);
            }
            if ((t = this.g.getNodeByName(target)) == null) {
                t = this.g.addNode(target);
            }
            Edge e = null;
            String dirOver = (String)attributeMap.remove("directed");
            boolean d = this.directed;
            if (dirOver != null) {
                d = dirOver.equalsIgnoreCase("true");
            }
            e = d ? this.g.addDirectedEdge(s, t) : this.g.addUndirectedEdge(s, t);
            for (String key : attributeMap.keySet()) {
                String val = (String)attributeMap.get(key);
                Field f = this.es.getField(key);
                if (f == null) continue;
                e.__setattr__(f.getName(), this.convertToType(f.getSQLType(), val));
            }
        }
        catch (Exception ex) {
            ExceptionWindow.getExceptionWindow(ex);
        }
    }

    private Map getAttributeMap(Attributes attrs) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                map.put(attrs.getQName(i).toLowerCase(), attrs.getValue(i));
            }
        }
        return map;
    }

    private String getKeyName(Attributes attrs) {
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (!attrs.getQName(i).equalsIgnoreCase("key")) continue;
                return this.remapKey(attrs.getValue(i));
            }
        }
        return null;
    }

    private String remapKey(String keyName) {
        return (String)this.nameMap.get(keyName);
    }
}

