/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.jfreechart;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.ui.Dockable;
import com.hp.hpl.guess.ui.EdgeEditorPopup;
import com.hp.hpl.guess.ui.EditorPopup;
import com.hp.hpl.guess.ui.GraphElementEditorPopup;
import com.hp.hpl.guess.ui.GraphEvents;
import com.hp.hpl.guess.ui.GraphMouseListener;
import com.hp.hpl.guess.ui.GuessJFrame;
import com.hp.hpl.guess.ui.NodeEditorPopup;
import com.hp.hpl.guess.ui.VisFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYDrawableAnnotation;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.Drawable;
import org.python.core.PyFloat;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PySequence;

public class GChartFrame
extends JPanel
implements Dockable {
    protected String title = null;
    protected HashMap seriesMap = new HashMap();
    protected XYPlot plot = null;
    private int seriesCounter = 0;
    private boolean docking = true;
    private boolean legend = true;
    private XYSeriesCollection dataset = new XYSeriesCollection();
    private JFreeChart chart = null;
    private ChartPanel cp = null;
    private static CircleDrawer cd = new CircleDrawer(Color.blue, new BasicStroke(1.0f), null);
    private GuessJFrame myParent = null;

    public void setTitle(String title) {
        this.title = this.title == null ? title : this.title + " / " + title;
    }

    public void addToChart(String title, GraphElement[] names, double[] vals, String xlabel) {
        SeriesPackage series1 = new SeriesPackage(title, this.plot, this.docking);
        for (int i = 0; i < names.length; ++i) {
            series1.add(i, vals[i], names[i]);
        }
        this.augmentChart(title, series1);
    }

    public GChartFrame(String title, PySequence names, PySequence vals, String xlabel) {
        this(title, names, vals, xlabel, true, true);
    }

    public GChartFrame(String title, PySequence names, PySequence vals, String xlabel, boolean docking, boolean legend) {
        this.docking = docking;
        this.legend = legend;
        this.buildChart(title, xlabel);
        this.addToChart(title, names, vals, xlabel);
    }

    public void addToChart(String title, PySequence names, PySequence vals, String xlabel) {
        SeriesPackage series1 = new SeriesPackage(title, this.plot, this.docking);
        for (int i = 0; i < names.size(); ++i) {
            PyObject pyval = vals.__finditem__(i);
            double val = 0.0;
            if (pyval instanceof PyInteger) {
                val = ((PyInteger)pyval).getValue();
            } else if (pyval instanceof PyFloat) {
                val = ((PyFloat)pyval).getValue();
            } else if (pyval instanceof PyInstance) {
                Double tval = (Double)((PyInstance)vals.__finditem__(i)).__tojava__(Double.class);
                val = tval;
            }
            GraphElement name = (GraphElement)((PyInstance)names.__finditem__(i)).__tojava__(GraphElement.class);
            series1.add(i, val, name);
        }
        this.augmentChart(title, series1);
    }

    public void augmentChart(String title, SeriesPackage pac) {
        this.setTitle(title);
        this.dataset.addSeries((XYSeries)pac);
        if (this.docking) {
            GraphEvents.getGraphEvents().addGraphMouseListener(pac);
        }
        this.seriesMap.put(new Integer(this.seriesCounter), pac);
        ++this.seriesCounter;
    }

    public void saveJPEG(String filename) throws IOException {
        File f = new File(filename);
        this.saveChartAsJPEG(new File(filename), 0.9f, (int)this.cp.getPreferredSize().getWidth(), (int)this.cp.getPreferredSize().getHeight());
    }

    public void saveJPEG(String filename, float quality) throws IOException {
        this.saveChartAsJPEG(new File(filename), quality, (int)this.cp.getPreferredSize().getWidth(), (int)this.cp.getPreferredSize().getHeight());
    }

    public void saveJPEG(String filename, float quality, int width, int height) throws IOException {
        this.saveChartAsJPEG(new File(filename), quality, width, height);
    }

    private void saveChartAsJPEG(File fname, float quality, int width, int height) throws IOException {
        ChartUtilities.saveChartAsJPEG((File)fname, (float)quality, (JFreeChart)this.chart, (int)width, (int)height);
    }

    public void buildChart(String title, String xlabel) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridy = 1;
        c.gridx = 1;
        this.dataset = new XYSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)title, (String)xlabel, (String)title, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.legend, (boolean)true, (boolean)false);
        this.plot = (XYPlot)this.chart.getPlot();
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)this.plot.getRenderer();
        renderer.setShapesVisible(true);
        renderer.setShapesFilled(true);
        this.cp = new ChartPanel(this.chart);
        if (this.docking) {
            this.cp.addChartMouseListener((ChartMouseListener)new InternalMouseListener(this));
        }
        this.cp.setPreferredSize(new Dimension(600, 250));
        this.add((Component)this.cp, c);
        if (this.docking) {
            Guess.getMainUIWindow().dock(this);
        }
    }

    @Override
    public int getDirectionPreference() {
        return 1;
    }

    @Override
    public void opening(boolean state) {
    }

    @Override
    public void attaching(boolean state) {
    }

    @Override
    public GuessJFrame getWindow() {
        return this.myParent;
    }

    @Override
    public void setWindow(GuessJFrame gjf) {
        this.myParent = gjf;
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            return "Charts";
        }
        return this.title;
    }

    static class CircleDrawer
    implements Drawable {
        private Paint outlinePaint;
        private Stroke outlineStroke;
        private Paint fillPaint;

        public CircleDrawer(Paint outlinePaint, Stroke outlineStroke, Paint fillPaint) {
            this.outlinePaint = outlinePaint;
            this.outlineStroke = outlineStroke;
            this.fillPaint = fillPaint;
        }

        public void draw(Graphics2D g2, Rectangle2D area) {
            Ellipse2D.Double ellipse = new Ellipse2D.Double(area.getX(), area.getY(), area.getWidth(), area.getHeight());
            if (this.fillPaint != null) {
                g2.setPaint(this.fillPaint);
                g2.fill(ellipse);
            }
            if (this.outlinePaint != null && this.outlineStroke != null) {
                g2.setPaint(this.outlinePaint);
                g2.setStroke(this.outlineStroke);
                g2.draw(ellipse);
            }
            g2.setPaint(Color.black);
            g2.setStroke(new BasicStroke(1.0f));
            Line2D.Double line1 = new Line2D.Double(area.getCenterX(), area.getMinY(), area.getCenterX(), area.getMaxY());
            Line2D.Double line2 = new Line2D.Double(area.getMinX(), area.getCenterY(), area.getMaxX(), area.getCenterY());
            g2.draw(line1);
            g2.draw(line2);
        }
    }

    class InternalMouseListener
    implements ChartMouseListener {
        private GChartFrame owner = null;
        private GraphElement prev = null;
        private JPopupMenu jpm = null;

        public InternalMouseListener(GChartFrame own) {
            this.owner = own;
        }

        public void chartMouseClicked(ChartMouseEvent event) {
            int item;
            Object cat;
            int ser;
            SeriesPackage sp;
            MouseEvent ev = event.getTrigger();
            if (ev.getButton() != 1) {
                return;
            }
            ChartEntity ce = event.getEntity();
            if (ce == null) {
                return;
            }
            if (ce instanceof XYItemEntity && (sp = (SeriesPackage)this.owner.seriesMap.get(new Integer(ser = ((XYItemEntity)ce).getSeriesIndex()))) != null && (cat = sp.idToElem.get(new Integer(item = ((XYItemEntity)ce).getItem()))) != null) {
                VisFactory.getFactory().getDisplay().center(cat);
            }
        }

        public void chartMouseMoved(ChartMouseEvent event) {
            int ser;
            SeriesPackage sp;
            if (this.jpm == null) {
                this.jpm = this.owner.cp.getPopupMenu();
            }
            ChartEntity ce = event.getEntity();
            if (this.prev != null) {
                GraphEvents.mouseLeave(this.prev);
                this.prev = null;
            }
            if (ce == null) {
                return;
            }
            if (ce instanceof XYItemEntity && (sp = (SeriesPackage)this.owner.seriesMap.get(new Integer(ser = ((XYItemEntity)ce).getSeriesIndex()))) != null) {
                int item = ((XYItemEntity)ce).getItem();
                Object cat = sp.idToElem.get(new Integer(item));
                boolean nodes = false;
                boolean edges = false;
                if (cat instanceof Node) {
                    nodes = true;
                } else if (cat instanceof Edge) {
                    edges = true;
                }
                if (cat instanceof GraphElement) {
                    this.prev = (GraphElement)cat;
                    GraphEvents.mouseEnter(this.prev);
                }
                EditorPopup ep = null;
                if (nodes && edges) {
                    ep = GraphElementEditorPopup.getPopup();
                } else if (nodes) {
                    ep = NodeEditorPopup.getPopup();
                } else if (edges) {
                    ep = EdgeEditorPopup.getPopup();
                }
                HashSet<GraphElement> hs = new HashSet<GraphElement>();
                hs.add(this.prev);
                if (ep != null) {
                    ep.cacheContent(hs, hs);
                    this.owner.cp.setPopupMenu((JPopupMenu)ep);
                }
            }
        }
    }

    class SeriesPackage
    extends XYSeries
    implements GraphMouseListener {
        protected HashMap idToElem;
        protected HashMap elemToId;
        protected XYPlot plot;
        private HashMap annotations;
        private boolean docking;

        public SeriesPackage(String title, XYPlot plot, boolean docking) {
            super((Comparable)((Object)title));
            this.idToElem = new HashMap();
            this.elemToId = new HashMap();
            this.plot = null;
            this.annotations = new HashMap();
            this.docking = true;
            this.plot = plot;
            this.docking = docking;
        }

        public void add(int x, double y, GraphElement name) {
            super.add((double)x, y);
            if (this.docking) {
                this.idToElem.put(new Integer(x), name);
                this.elemToId.put(name, new Integer(x));
            }
        }

        @Override
        public void mouseEnterNode(Node n) {
            this.annotate(n);
        }

        @Override
        public void mouseEnterEdge(Edge e) {
            this.annotate(e);
        }

        @Override
        public void mouseLeaveNode(Node n) {
            if (this.annotations.containsKey(n)) {
                this.plot.removeAnnotation((XYAnnotation)this.annotations.get(n));
                this.annotations.remove(n);
            }
        }

        @Override
        public void mouseLeaveEdge(Edge e) {
            if (this.annotations.containsKey(e)) {
                this.plot.removeAnnotation((XYAnnotation)this.annotations.get(e));
                this.annotations.remove(e);
            }
        }

        public void annotate(GraphElement name) {
            if (this.annotations.containsKey(name)) {
                return;
            }
            int x = 0;
            double y = 0.0;
            if (this.elemToId.containsKey(name)) {
                x = (Integer)this.elemToId.get(name);
            }
            y = this.getY(x).doubleValue();
            XYDrawableAnnotation anno = new XYDrawableAnnotation((double)x, y, 11.0, 11.0, (Drawable)cd);
            this.annotations.put(name, anno);
            this.plot.addAnnotation((XYAnnotation)anno);
        }
    }
}

