/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.jfreechart;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.Dockable;
import com.hp.hpl.guess.ui.EdgeEditorPopup;
import com.hp.hpl.guess.ui.EditorPopup;
import com.hp.hpl.guess.ui.GraphElementEditorPopup;
import com.hp.hpl.guess.ui.GraphEvents;
import com.hp.hpl.guess.ui.GraphMouseListener;
import com.hp.hpl.guess.ui.GuessJFrame;
import com.hp.hpl.guess.ui.NodeEditorPopup;
import com.hp.hpl.guess.ui.VisFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.python.core.PyFloat;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PySequence;

public class GHistoChartFrame
extends JPanel
implements Dockable,
GraphMouseListener {
    protected HashMap idToGroup = new HashMap();
    protected HashMap elemToSection = new HashMap();
    private boolean docking = true;
    private boolean legend = false;
    String title = null;
    private JFreeChart chart = null;
    private ChartPanel cp = null;
    private GuessJFrame myParent = null;
    private int section = -1;
    private Paint prev = null;
    private CategoryPlot plot = null;
    private CategoryItemRenderer rend = null;

    public GHistoChartFrame(String title, PySequence groups, PySequence vals, PySequence groupNames, PySequence colors) {
        this(title, groups, vals, groupNames, colors, true, false);
    }

    public GHistoChartFrame(String title, PySequence groups, PySequence vals, PySequence groupNames, PySequence colors, boolean docking, boolean legend) {
        this.docking = docking;
        this.legend = legend;
        DefaultCategoryDataset dset = new DefaultCategoryDataset();
        Color[] clrs = null;
        if (colors != null) {
            clrs = new Color[groups.size()];
        }
        for (int i = 0; i < groups.size(); ++i) {
            PyObject group = groups.__finditem__(i);
            Collection grp = ((PySequence)group).findGraphElements();
            if (docking) {
                this.idToGroup.put(new Integer(i), grp);
            }
            PyObject pyval = vals.__finditem__(i);
            double val = 0.0;
            if (pyval instanceof PyInteger) {
                val = ((PyInteger)pyval).getValue();
            } else if (pyval instanceof PyFloat) {
                val = ((PyFloat)pyval).getValue();
            } else if (pyval instanceof PyInstance) {
                Double tval = (Double)((PyInstance)vals.__finditem__(i)).__tojava__(Double.class);
                val = tval;
            }
            String name = groupNames.__finditem__(i).toString();
            dset.addValue(val, (Comparable)((Object)name), (Comparable)new Integer(1));
            if (colors != null) {
                String clr = colors.__finditem__(i).toString();
                clrs[i] = Colors.getColor(clr, Color.blue);
            }
            if (!docking) continue;
            for (GraphElement ge : grp) {
                this.elemToSection.put(ge, new Integer(i));
            }
        }
        this.buildChart(title, "Histo", dset, clrs);
    }

    public void buildChart(String title, String xlabel, DefaultCategoryDataset dataset, Color[] clr) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridy = 1;
        c.gridx = 1;
        this.title = title;
        this.chart = ChartFactory.createBarChart((String)title, (String)xlabel, (String)"#", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.legend, (boolean)true, (boolean)false);
        this.plot = (CategoryPlot)this.chart.getPlot();
        this.rend = this.plot.getRenderer();
        if (clr != null) {
            for (int i = 0; i < clr.length; ++i) {
                this.rend.setSeriesPaint(i, (Paint)clr[i]);
            }
        }
        this.cp = new ChartPanel(this.chart);
        if (this.docking) {
            this.cp.addChartMouseListener((ChartMouseListener)new InternalMouseListener(this));
        }
        this.cp.setPreferredSize(new Dimension(600, 250));
        this.add((Component)this.cp, c);
        if (this.docking) {
            Guess.getMainUIWindow().dock(this);
            GraphEvents.getGraphEvents().addGraphMouseListener(this);
        }
    }

    public void saveJPEG(String filename) throws IOException {
        File f = new File(filename);
        this.saveChartAsJPEG(new File(filename), 0.9f, (int)this.cp.getPreferredSize().getWidth(), (int)this.cp.getPreferredSize().getHeight());
    }

    public void saveJPEG(String filename, float quality) throws IOException {
        this.saveChartAsJPEG(new File(filename), quality, (int)this.cp.getPreferredSize().getWidth(), (int)this.cp.getPreferredSize().getHeight());
    }

    public void saveJPEG(String filename, float quality, int width, int height) throws IOException {
        this.saveChartAsJPEG(new File(filename), quality, width, height);
    }

    private void saveChartAsJPEG(File fname, float quality, int width, int height) throws IOException {
        ChartUtilities.saveChartAsJPEG((File)fname, (float)quality, (JFreeChart)this.chart, (int)width, (int)height);
    }

    @Override
    public int getDirectionPreference() {
        return 1;
    }

    @Override
    public void opening(boolean state) {
    }

    @Override
    public void attaching(boolean state) {
    }

    @Override
    public GuessJFrame getWindow() {
        return this.myParent;
    }

    @Override
    public void setWindow(GuessJFrame gjf) {
        this.myParent = gjf;
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            return "Charts";
        }
        return this.title;
    }

    @Override
    public synchronized void mouseEnterNode(Node n) {
        this.annotate(n);
    }

    @Override
    public synchronized void mouseEnterEdge(Edge e) {
        this.annotate(e);
    }

    @Override
    public synchronized void mouseLeaveNode(Node n) {
        if (this.elemToSection.containsKey(n)) {
            if (this.section != -1) {
                this.rend.setSeriesPaint(this.section, this.prev);
            }
            this.section = -1;
            this.prev = null;
        }
    }

    @Override
    public synchronized void mouseLeaveEdge(Edge e) {
        if (this.elemToSection.containsKey(e)) {
            if (this.section != -1) {
                this.rend.setSeriesPaint(this.section, this.prev);
            }
            this.section = -1;
            this.prev = null;
        }
    }

    public synchronized void annotate(GraphElement ge) {
        Integer st = (Integer)this.elemToSection.get(ge);
        if (st != null) {
            if (this.section != -1) {
                this.rend.setSeriesPaint(this.section, this.prev);
            }
            this.prev = this.rend.getSeriesPaint(st.intValue());
            this.section = st;
            this.rend.setSeriesPaint(this.section, (Paint)Color.yellow);
        }
    }

    class InternalMouseListener
    implements ChartMouseListener {
        private GHistoChartFrame owner = null;
        private Collection prev = null;
        private JPopupMenu jpm = null;

        public InternalMouseListener(GHistoChartFrame own) {
            this.owner = own;
        }

        public void chartMouseClicked(ChartMouseEvent event) {
            MouseEvent ev = event.getTrigger();
            if (ev.getButton() != 1) {
                return;
            }
            ChartEntity ce = event.getEntity();
            if (ce == null) {
                return;
            }
            if (ce instanceof CategoryItemEntity) {
                int ser = ((CategoryItemEntity)ce).getSeries();
                this.prev = (Collection)this.owner.idToGroup.get(new Integer(ser));
                if (this.prev != null) {
                    VisFactory.getFactory().getDisplay().center(this.prev);
                }
            }
        }

        public void chartMouseMoved(ChartMouseEvent event) {
            if (this.jpm == null) {
                this.jpm = this.owner.cp.getPopupMenu();
            }
            ChartEntity ce = event.getEntity();
            if (this.prev != null) {
                for (GraphElement ge : this.prev) {
                    GraphEvents.mouseLeave(ge);
                }
                this.prev = null;
                this.owner.cp.setPopupMenu(this.jpm);
            }
            if (ce == null) {
                return;
            }
            if (ce instanceof CategoryItemEntity) {
                int ser = ((CategoryItemEntity)ce).getSeries();
                this.prev = (Collection)this.owner.idToGroup.get(new Integer(ser));
                if (this.prev != null) {
                    boolean nodes = false;
                    boolean edges = false;
                    for (GraphElement ge : this.prev) {
                        if (ge instanceof Node) {
                            nodes = true;
                        } else if (ge instanceof Edge) {
                            edges = true;
                        }
                        GraphEvents.mouseEnter(ge);
                    }
                    EditorPopup ep = null;
                    if (nodes && edges) {
                        ep = GraphElementEditorPopup.getPopup();
                    } else if (nodes) {
                        ep = NodeEditorPopup.getPopup();
                    } else if (edges) {
                        ep = EdgeEditorPopup.getPopup();
                    }
                    if (ep != null) {
                        ep.cacheContent(this.prev, this.prev);
                        this.owner.cp.setPopupMenu((JPopupMenu)ep);
                    }
                }
            }
        }
    }
}

