/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.jfreechart;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.Dockable;
import com.hp.hpl.guess.ui.EdgeEditorPopup;
import com.hp.hpl.guess.ui.EditorPopup;
import com.hp.hpl.guess.ui.GraphElementEditorPopup;
import com.hp.hpl.guess.ui.GraphEvents;
import com.hp.hpl.guess.ui.GraphMouseListener;
import com.hp.hpl.guess.ui.GuessJFrame;
import com.hp.hpl.guess.ui.NodeEditorPopup;
import com.hp.hpl.guess.ui.VisFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.python.core.PyFloat;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PySequence;

public class GPieChartFrame
extends JPanel
implements Dockable,
GraphMouseListener {
    protected HashMap idToGroup = new HashMap();
    protected HashMap elemToSection = new HashMap();
    private boolean docking = true;
    private boolean legend = false;
    String title = null;
    ChartPanel cp = null;
    PiePlot plot = null;
    private JFreeChart chart = null;
    private GuessJFrame myParent = null;
    private int exploded = -1;

    public GPieChartFrame(String title, PySequence groups, PySequence vals, PySequence groupNames, PySequence colors) {
        this(title, groups, vals, groupNames, colors, true, false);
    }

    public GPieChartFrame(String title, PySequence groups, PySequence vals, PySequence groupNames, PySequence colors, boolean docking, boolean legend) {
        this.docking = docking;
        this.legend = legend;
        DefaultPieDataset dset = new DefaultPieDataset();
        Color[] clrs = null;
        if (colors != null) {
            clrs = new Color[groups.size()];
        }
        for (int i = 0; i < groups.size(); ++i) {
            PyObject group = groups.__finditem__(i);
            Collection grp = ((PySequence)group).findGraphElements();
            if (docking) {
                for (GraphElement ge : grp) {
                    this.elemToSection.put(ge, new Integer(i));
                }
                this.idToGroup.put(new Integer(i), grp);
            }
            PyObject pyval = vals.__finditem__(i);
            double val = 0.0;
            if (pyval instanceof PyInteger) {
                val = ((PyInteger)pyval).getValue();
            } else if (pyval instanceof PyFloat) {
                val = ((PyFloat)pyval).getValue();
            } else if (pyval instanceof PyInstance) {
                Double tval = (Double)((PyInstance)vals.__finditem__(i)).__tojava__(Double.class);
                val = tval;
            }
            String name = groupNames.__finditem__(i).toString();
            dset.setValue((Comparable)((Object)name), val);
            if (colors == null) continue;
            String clr = colors.__finditem__(i).toString();
            clrs[i] = Colors.getColor(clr, Color.blue);
        }
        this.buildChart(title, dset, clrs);
    }

    public void saveJPEG(String filename) throws IOException {
        File f = new File(filename);
        this.saveChartAsJPEG(new File(filename), 0.9f, (int)this.cp.getPreferredSize().getWidth(), (int)this.cp.getPreferredSize().getHeight());
    }

    public void saveJPEG(String filename, float quality) throws IOException {
        this.saveChartAsJPEG(new File(filename), quality, (int)this.cp.getPreferredSize().getWidth(), (int)this.cp.getPreferredSize().getHeight());
    }

    public void saveJPEG(String filename, float quality, int width, int height) throws IOException {
        this.saveChartAsJPEG(new File(filename), quality, width, height);
    }

    private void saveChartAsJPEG(File fname, float quality, int width, int height) throws IOException {
        ChartUtilities.saveChartAsJPEG((File)fname, (float)quality, (JFreeChart)this.chart, (int)width, (int)height);
    }

    public void buildChart(String title, DefaultPieDataset dataset, Color[] clr) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridy = 1;
        c.gridx = 1;
        this.title = title;
        this.chart = ChartFactory.createPieChart((String)title, (PieDataset)dataset, (boolean)this.legend, (boolean)true, (boolean)false);
        this.plot = (PiePlot)this.chart.getPlot();
        if (clr != null) {
            for (int i = 0; i < clr.length; ++i) {
                this.plot.setSectionPaint(i, (Paint)clr[i]);
            }
        }
        this.cp = new ChartPanel(this.chart);
        if (this.docking) {
            this.cp.setPreferredSize(new Dimension(600, 250));
        }
        this.cp.addChartMouseListener((ChartMouseListener)new InternalMouseListener(this));
        this.add((Component)this.cp, c);
        if (this.docking) {
            Guess.getMainUIWindow().dock(this);
            GraphEvents.getGraphEvents().addGraphMouseListener(this);
        }
    }

    @Override
    public int getDirectionPreference() {
        return 1;
    }

    @Override
    public void opening(boolean state) {
    }

    @Override
    public void attaching(boolean state) {
    }

    @Override
    public GuessJFrame getWindow() {
        return this.myParent;
    }

    @Override
    public void setWindow(GuessJFrame gjf) {
        this.myParent = gjf;
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            return "Charts";
        }
        return this.title;
    }

    @Override
    public synchronized void mouseEnterNode(Node n) {
        this.annotate(n);
    }

    @Override
    public synchronized void mouseEnterEdge(Edge e) {
        this.annotate(e);
    }

    @Override
    public synchronized void mouseLeaveNode(Node n) {
        if (this.elemToSection.containsKey(n)) {
            if (this.exploded != -1) {
                this.plot.setExplodePercent(this.exploded, 0.0);
            }
            this.exploded = -1;
        }
    }

    @Override
    public synchronized void mouseLeaveEdge(Edge e) {
        if (this.elemToSection.containsKey(e)) {
            if (this.exploded != -1) {
                this.plot.setExplodePercent(this.exploded, 0.0);
            }
            this.exploded = -1;
        }
    }

    public synchronized void annotate(GraphElement ge) {
        Integer i = (Integer)this.elemToSection.get(ge);
        if (i != null) {
            if (this.exploded != -1) {
                this.plot.setExplodePercent(this.exploded, 0.0);
            }
            this.exploded = i;
            this.plot.setExplodePercent(this.exploded, 0.3);
        }
    }

    class InternalMouseListener
    implements ChartMouseListener {
        private GPieChartFrame owner = null;
        private Collection prev = null;
        private JPopupMenu jpm = null;

        public InternalMouseListener(GPieChartFrame own) {
            this.owner = own;
        }

        public void chartMouseClicked(ChartMouseEvent event) {
            MouseEvent ev = event.getTrigger();
            if (ev.getButton() != 1) {
                return;
            }
            ChartEntity ce = event.getEntity();
            if (ce == null) {
                return;
            }
            if (ce instanceof PieSectionEntity) {
                int ser = ((PieSectionEntity)ce).getSectionIndex();
                this.prev = (Collection)this.owner.idToGroup.get(new Integer(ser));
                if (this.prev != null) {
                    VisFactory.getFactory().getDisplay().center(this.prev);
                }
            }
        }

        public void chartMouseMoved(ChartMouseEvent event) {
            if (this.jpm == null) {
                this.jpm = this.owner.cp.getPopupMenu();
            }
            ChartEntity ce = event.getEntity();
            if (this.prev != null) {
                for (GraphElement ge : this.prev) {
                    GraphEvents.mouseLeave(ge);
                }
                this.prev = null;
                this.owner.cp.setPopupMenu(this.jpm);
            }
            if (ce == null) {
                return;
            }
            if (ce instanceof PieSectionEntity) {
                int ser = ((PieSectionEntity)ce).getSectionIndex();
                this.prev = (Collection)this.owner.idToGroup.get(new Integer(ser));
                if (this.prev != null) {
                    Iterator it = this.prev.iterator();
                    boolean nodes = false;
                    boolean edges = false;
                    while (it.hasNext()) {
                        GraphElement ge = (GraphElement)it.next();
                        if (ge instanceof Node) {
                            nodes = true;
                        } else if (ge instanceof Edge) {
                            edges = true;
                        }
                        GraphEvents.mouseEnter(ge);
                    }
                    EditorPopup ep = null;
                    if (nodes && edges) {
                        ep = GraphElementEditorPopup.getPopup();
                    } else if (nodes) {
                        ep = NodeEditorPopup.getPopup();
                    } else if (edges) {
                        ep = EdgeEditorPopup.getPopup();
                    }
                    if (ep != null) {
                        ep.cacheContent(this.prev, this.prev);
                        this.owner.cp.setPopupMenu((JPopupMenu)ep);
                    }
                }
            }
        }
    }
}

