/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.jung;

import com.hp.hpl.guess.DirectedEdge;
import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.jung.JungVisDirectedEdge;
import com.hp.hpl.guess.jung.JungVisEdge;
import com.hp.hpl.guess.jung.JungVisFrame;
import com.hp.hpl.guess.jung.JungVisNode;
import com.hp.hpl.guess.jung.JungVisUndirectedEdge;
import com.hp.hpl.guess.ui.EdgeListener;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.NodeListener;
import com.hp.hpl.guess.ui.VisFactory;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeShapeFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.EllipseVertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class JungVisFactory
extends VisFactory {
    private JungVisFrame curFrame = null;
    private SparseGraph g = new SparseGraph();
    protected VisualizationViewer vv = null;
    private JungVisNode lastCreated = null;

    public JungVisFactory() {
        this.init();
    }

    @Override
    public void runNow() {
        if (this.curFrame != null) {
            this.vv.restart();
        }
    }

    public JungVisFrame init() {
        PassThroughLayout l = new PassThroughLayout((Graph)this.g);
        PluggableRenderer pr = new PluggableRenderer();
        pr.setVertexPaintFunction((VertexPaintFunction)new VPaintFunction());
        pr.setVertexShapeFunction((VertexShapeFunction)new EllipseVertexShapeFunction());
        pr.setEdgePaintFunction((EdgePaintFunction)new EPaintFunction());
        pr.setEdgeShapeFunction((EdgeShapeFunction)new EdgeShape.Line());
        pr.setEdgeStrokeFunction((EdgeStrokeFunction)new ConstantEdgeStrokeFunction(1.0f));
        this.vv = new VisualizationViewer((Layout)l, (Renderer)pr);
        this.curFrame = new JungVisFrame(this.vv);
        return this.curFrame;
    }

    @Override
    public FrameListener getDisplay() {
        return this.curFrame;
    }

    @Override
    public NodeListener generateNode(int type, double x, double y, double width, double height, Color clr, Node n) {
        JungVisNode nl = new JungVisNode();
        this.g.addVertex((Vertex)nl);
        nl.set("x", new Double(x));
        nl.set("y", new Double(y));
        nl.set("width", new Double(width));
        nl.set("height", new Double(height));
        nl.set("color", clr);
        nl.set("label", n.getName());
        nl.set("labelvisible", new Boolean(false));
        nl.set("style", new Integer(type));
        nl.set("fixed", new Boolean(false));
        return nl;
    }

    @Override
    public NodeListener generateNode(Node n) {
        return this.generateNode(0, 0.0, 0.0, 1.0, 1.0, Color.blue, n);
    }

    @Override
    public void remove(Node n) {
    }

    @Override
    public void remove(Edge e) {
    }

    @Override
    public void add(Node n) {
    }

    @Override
    public void add(Edge e) {
    }

    @Override
    public EdgeListener generateEdge(Edge n) {
        JungVisEdge pe = null;
        pe = n instanceof DirectedEdge ? new JungVisDirectedEdge((JungVisNode)n.getNode1().getRep(), (JungVisNode)n.getNode2().getRep()) : new JungVisUndirectedEdge((JungVisNode)n.getNode1().getRep(), (JungVisNode)n.getNode2().getRep());
        pe.set("width", new Double(1.0));
        pe.set("color", Color.black);
        pe.set("label", "");
        pe.set("labelvisible", new Boolean(false));
        this.g.addEdge((edu.uci.ics.jung.graph.Edge)pe);
        return pe;
    }

    class VShapeFunction
    implements VertexShapeFunction {
        public Shape getShape(Vertex vs) {
            JungVisNode v = (JungVisNode)vs;
            double x = (Double)v.get("x");
            double y = (Double)v.get("y");
            double width = (Double)v.get("width");
            double height = (Double)v.get("height");
            Ellipse2D.Double toRet = new Ellipse2D.Double(x, y, width, height);
            return toRet;
        }
    }

    class EPaintFunction
    implements EdgePaintFunction {
        public Paint getDrawPaint(edu.uci.ics.jung.graph.Edge v) {
            return (Paint)((JungVisEdge)v).get("color");
        }

        public Paint getFillPaint(edu.uci.ics.jung.graph.Edge v) {
            return (Paint)((JungVisEdge)v).get("color");
        }
    }

    class VPaintFunction
    implements VertexPaintFunction {
        public Paint getDrawPaint(Vertex v) {
            return Color.black;
        }

        public Paint getFillPaint(Vertex v) {
            return (Paint)((JungVisNode)v).get("color");
        }
    }

    class PassThroughLayout
    extends AbstractLayout {
        public PassThroughLayout(Graph g) {
            super(g);
        }

        public void advancePositions() {
        }

        public Point2D getLocation(JungVisNode v) {
            return new Point2D.Double((Double)v.get("x"), (Double)v.get("y"));
        }

        public double getX(JungVisNode v) {
            return (Double)v.get("x");
        }

        public double getY(JungVisNode v) {
            return (Double)v.get("x");
        }

        public Coordinates getCoordinates(JungVisNode v) {
            return new Coordinates(((Double)v.get("x")).doubleValue(), ((Double)v.get("y")).doubleValue());
        }

        public boolean incrementsAreDone() {
            return true;
        }

        public void initialize_local_vertex(Vertex v) {
        }

        public void initialize_local() {
        }

        public boolean isIncremental() {
            return false;
        }
    }
}

