/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class BinPack
extends AbstractLayout {
    HashMap locations = new HashMap();
    boolean done = false;
    Graph g = null;
    private boolean rescale = true;

    public BinPack(Graph g, boolean rescale) {
        super((edu.uci.ics.jung.graph.Graph)g);
        this.g = g;
        for (Node n : g.getNodes()) {
            this.locations.put(n, new Coordinates(n.getX(), n.getY()));
        }
        this.rescale = rescale;
    }

    public void advancePositions() {
        int i;
        if (this.done) {
            return;
        }
        double sumHeight = 0.0;
        double sumWidth = 0.0;
        ArrayList<SizeCompRect> toFit = new ArrayList<SizeCompRect>();
        Set clusters = this.g.weakComponentClusters();
        if (clusters.size() <= 1) {
            return;
        }
        Iterator it = clusters.iterator();
        double maxD = Double.MIN_VALUE;
        while (it.hasNext()) {
            Set n2 = (Set)it.next();
            SizeCompRect ntf = this.getBoundingBox(n2);
            toFit.add(ntf);
            double test = (ntf.getWidth() - 30.0) * (ntf.getHeight() - 30.0) / (double)n2.size();
            if (test > maxD) {
                maxD = test;
            }
            sumHeight += ntf.getHeight();
            sumWidth += ntf.getWidth();
        }
        Collections.sort(toFit);
        if (this.rescale) {
            sumHeight = 0.0;
            sumWidth = 0.0;
            HashMap<Integer, Double> seenResizes = new HashMap<Integer, Double>();
            for (int i2 = toFit.size() - 1; i2 >= 0; --i2) {
                SizeCompRect tf = (SizeCompRect)toFit.get(i2);
                double test2 = (tf.getWidth() - 30.0) * (tf.getHeight() - 30.0) / (double)tf.nodes.size();
                double curSize = tf.getWidth() * tf.getHeight();
                double test = maxD * (double)tf.nodes.size() / curSize;
                if (tf.nodes.size() > 1 && test != 1.0 && test != Double.POSITIVE_INFINITY && test != Double.NEGATIVE_INFINITY) {
                    Double alreadyDone = (Double)seenResizes.get(new Integer(tf.nodes.size()));
                    if (alreadyDone != null) {
                        this.rescaleRect(tf, alreadyDone);
                    } else {
                        seenResizes.put(new Integer(tf.nodes.size()), new Double(1.0 + Math.log(test)));
                        this.rescaleRect(tf, 1.0 + Math.log(test));
                    }
                }
                sumHeight += tf.getHeight();
                sumWidth += tf.getWidth();
            }
            Collections.sort(toFit);
        }
        ArrayList<SizeCompRect> available = new ArrayList<SizeCompRect>();
        available.add(new SizeCompRect(0.0, 0.0, sumWidth, sumHeight, null));
        double xcent = 0.0;
        double ycent = 0.0;
        for (i = toFit.size() - 1; i >= 0; --i) {
            SizeCompRect tf = (SizeCompRect)toFit.get(i);
            int locBF = this.findBestFit2(available, tf, xcent, ycent);
            SizeCompRect bf = (SizeCompRect)available.get(locBF);
            Collection newRects = this.moveAndSplit(bf, tf);
            if (i == toFit.size() - 1) {
                xcent = tf.getWidth() / 2.0;
                ycent = tf.getHeight() / 2.0;
            }
            available.remove(locBF);
            available.addAll(newRects);
            Collections.sort(available);
        }
        for (i = 0; i < toFit.size(); ++i) {
            SizeCompRect scr = (SizeCompRect)toFit.get(i);
            double deltaX = scr.getX() - scr.originalX;
            double deltaY = scr.getY() - scr.originalY;
            for (Node n : scr.nodes) {
                Coordinates c = (Coordinates)this.locations.get(n);
                c.setX(c.getX() + deltaX);
                c.setY(c.getY() + deltaY);
            }
        }
        this.done = true;
    }

    public void rescaleRect(SizeCompRect scr, double percent) {
        double w = scr.getWidth();
        double h = scr.getHeight();
        scr.setRect(scr.getX(), scr.getY(), w * percent, h * percent);
        for (Node n : scr.nodes) {
            Coordinates c = (Coordinates)this.locations.get(n);
            c.setX(scr.getX() + (c.getX() - scr.getX()) * percent);
            c.setY(scr.getY() + (c.getY() - scr.getY()) * percent);
        }
    }

    public SizeCompRect getBoundingBox(Set nodes) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Node n : nodes) {
            if (n.getX() < minX) {
                minX = n.getX();
            }
            if (n.getY() < minY) {
                minY = n.getY();
            }
            if (n.getX() + n.getWidth() > maxX) {
                maxX = n.getX() + n.getWidth();
            }
            if (!(n.getY() + n.getHeight() > maxY)) continue;
            maxY = n.getY() + n.getHeight();
        }
        return new SizeCompRect(minX -= 15.0, minY -= 15.0, (maxX += 15.0) - minX, (maxY += 15.0) - minY, nodes);
    }

    private int findBestFit(ArrayList avail, SizeCompRect tf) {
        double tfS = tf.size;
        for (int i = 0; i < avail.size(); ++i) {
            SizeCompRect test = (SizeCompRect)avail.get(i);
            if (!(test.size >= tf.size) || !(tf.getWidth() <= test.getWidth()) || !(tf.getHeight() <= test.getHeight())) continue;
            return i;
        }
        return -1;
    }

    private int findBestFit2(ArrayList avail, SizeCompRect tf, double xcent, double ycent) {
        double minDist = Double.MAX_VALUE;
        int minIndex = -1;
        int counter = 0;
        for (int i = avail.size() - 1; i >= 0; --i) {
            double dist;
            SizeCompRect test = (SizeCompRect)avail.get(i);
            if (!(tf.getWidth() <= test.getWidth()) || !(tf.getHeight() <= test.getHeight()) || !((dist = Point2D.distance(xcent, ycent, test.getX() + tf.getWidth() / 2.0, test.getY() + tf.getHeight() / 2.0)) < minDist)) continue;
            minDist = dist;
            minIndex = i;
            ++counter;
        }
        return minIndex;
    }

    private Collection moveAndSplit(SizeCompRect bf, SizeCompRect tf) {
        tf.setRect(bf.getX(), bf.getY(), tf.getWidth(), tf.getHeight());
        ArrayList<SizeCompRect> al = new ArrayList<SizeCompRect>(2);
        double xn1 = bf.getX() + tf.getWidth();
        double yn1 = bf.getY();
        double wn1 = bf.getWidth() - tf.getWidth();
        double hn1 = tf.getHeight();
        double xn2 = bf.getX();
        double yn2 = bf.getY() + tf.getHeight();
        double wn2 = bf.getWidth();
        double hn2 = bf.getHeight() - tf.getHeight();
        al.add(new SizeCompRect(xn1, yn1, wn1, hn1, null));
        al.add(new SizeCompRect(xn2, yn2, wn2, hn2, null));
        return al;
    }

    public double getX(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getX();
    }

    public double getY(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getY();
    }

    public Coordinates getCoordinates(Node v) {
        return (Coordinates)this.locations.get(v);
    }

    public boolean incrementsAreDone() {
        return this.done;
    }

    public void initialize_local_vertex(Vertex v) {
    }

    public void initialize_local() {
    }

    public boolean isIncremental() {
        return false;
    }

    class SizeCompRect
    extends Rectangle2D.Double
    implements Comparable {
        public double size;
        public Set nodes;
        public double originalX;
        public double originalY;

        public SizeCompRect(double x, double y, double width, double height, Set nodes) {
            super(x, y, width, height);
            this.size = 0.0;
            this.nodes = null;
            this.originalX = 0.0;
            this.originalY = 0.0;
            this.size = width * height;
            this.nodes = nodes;
            this.originalX = x;
            this.originalY = y;
        }

        public int compareTo(Object o) {
            if (((SizeCompRect)o).size < this.size) {
                return 1;
            }
            return -1;
        }
    }
}

