/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class CircularConstrained
extends AbstractLayout {
    private int pad = 4;
    protected int maxradius = 500;
    protected Node center = null;
    protected int minradius = 30;
    protected boolean sorted = true;
    protected String column = null;
    protected ArrayList nodeList = null;
    protected double originx = 500.0;
    protected double originy = 500.0;
    protected double maxangle = Math.PI * 2;
    protected boolean disSim = false;
    private Graph g = null;
    private Field field = null;
    private HashMap locations = new HashMap();
    public boolean done = false;

    public CircularConstrained(Graph g, Node center, Field f, double xo, double yo) {
        this(g, center, f);
        this.originx = xo;
        this.originy = yo;
    }

    public CircularConstrained(Graph g, Node center, Field f) {
        super((edu.uci.ics.jung.graph.Graph)g);
        this.g = g;
        this.center = center;
        this.field = f;
    }

    public CircularConstrained(Graph g, Node center, Field f, int maxrad, int minrad, boolean sorted, boolean disSim, int maxangle) {
        this(g, center, f);
        this.maxradius = maxrad;
        this.minradius = minrad;
        this.sorted = sorted;
        this.disSim = disSim;
        this.maxangle = maxangle;
    }

    public double getAsDouble(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Float)o).floatValue();
        }
        return 0.0;
    }

    public void advancePositions() {
        if (this.done) {
            return;
        }
        for (Node n : this.g.getNodes()) {
            this.locations.put(n, new Coordinates(n.getX(), n.getY()));
        }
        this.locations.put(this.center, new Coordinates(this.originx, this.originy));
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int count = 0;
        ArrayList<SortableNode> al = new ArrayList<SortableNode>();
        Hashtable<Node, Double> quickLookup = new Hashtable<Node, Double>();
        if (this.field.getType() == 1) {
            Set s = this.center.getNeighbors();
            count = s.size();
            if (s.contains(this.center)) {
                --count;
            }
            for (Node n : s) {
                Object o = n.__getattr__(this.field.getName());
                double dval = 1.0;
                if (this.field.isNumeric()) {
                    dval = this.getAsDouble(o);
                    min = Math.min(min, dval);
                    max = Math.max(max, dval);
                }
                al.add(new SortableNode(n, new Double(dval)));
                quickLookup.put(n, new Double(dval));
            }
        } else {
            for (Edge e : this.center.getIncidentEdges()) {
                Node n1 = e.getNode1();
                Node n2 = e.getNode2();
                Object o = e.__getattr__(this.field.getName());
                double dval = 1.0;
                if (n1 == n2) continue;
                if (this.field.isNumeric()) {
                    dval = this.getAsDouble(o);
                    min = Math.min(min, dval);
                    max = Math.max(max, dval);
                }
                ++count;
                if (this.center == n1) {
                    al.add(new SortableNode(n2, new Double(dval)));
                    quickLookup.put(n2, new Double(dval));
                    continue;
                }
                al.add(new SortableNode(n1, new Double(dval)));
                quickLookup.put(n1, new Double(dval));
            }
        }
        if (count == 0) {
            System.out.println("No neighbors");
            this.done = true;
            return;
        }
        if (!this.field.isNumeric()) {
            max = min = (double)((this.maxradius - this.minradius) / 2);
        }
        Collections.sort(al);
        double angledelta = this.maxangle / (double)count;
        Iterator it = al.iterator();
        int i = 0;
        while (it.hasNext()) {
            SortableNode sn = (SortableNode)it.next();
            Node gn = sn.node;
            double val = (Double)quickLookup.get(gn);
            if (this.disSim) {
                val = max - val;
            }
            double radius = 300.0;
            if (max != min) {
                radius = (double)this.minradius + (double)(this.maxradius - this.minradius) * val / max;
            } else if (radius != 0.0) {
                radius = max;
            }
            double angle = (double)i * angledelta;
            double newx = this.originx + radius * Math.cos(angle);
            double newy = this.originy + radius * Math.sin(angle);
            this.locations.put(gn, new Coordinates(newx, newy));
            ++i;
        }
        this.done = true;
    }

    public double getX(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getX();
    }

    public double getY(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getY();
    }

    public Coordinates getCoordinates(Node v) {
        return (Coordinates)this.locations.get(v);
    }

    public boolean incrementsAreDone() {
        return this.done;
    }

    public void initialize_local_vertex(Vertex v) {
    }

    public void initialize_local() {
    }

    public boolean isIncremental() {
        return false;
    }

    class SortableNode
    implements Comparable {
        public Comparable key = null;
        public Node node = null;

        public SortableNode(Node n, Comparable key) {
            this.key = key;
            this.node = n;
        }

        public int compareTo(Object o) {
            return this.key.compareTo(((SortableNode)o).key);
        }
    }
}

