/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.layout.NetUtilities;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public class FruchGraphLayout
extends AbstractLayout {
    private int pad = 20;
    private int initialIter = 30;
    private int maxPasses = 500;
    private double optDist = 100.0;
    private int updates = 0;
    private boolean rescaleLayout = true;
    private boolean firstLayout = true;
    private boolean noBreak = true;
    private int seed;
    private boolean isSeedSet = false;
    private Set nodeList;
    private int width;
    private int height;
    private boolean update = true;
    private HashMap locations = new HashMap();
    double maxWidth = 10.0;
    double maxHeight = 10.0;
    public boolean done = false;

    public FruchGraphLayout(Graph g, boolean firstLayout, int width, int height) {
        super((edu.uci.ics.jung.graph.Graph)g);
        this.width = width;
        this.height = height;
        this.nodeList = g.getNodes();
        this.firstLayout = firstLayout;
    }

    public void setPad(int p) {
        this.pad = p;
    }

    public void setUpdateEveryN(int updateEveryN) {
        this.updates = updateEveryN;
    }

    public void setRescaleLayout(boolean rescale) {
        this.rescaleLayout = rescale;
    }

    private double calcAttraction(double dist) {
        return dist * dist / this.optDist;
    }

    private double calcRepulsion(double dist) {
        return Math.pow(this.optDist, 4.0) / dist;
    }

    private double coolTemp(double val) {
        return val / 1.1;
    }

    public void setRandomSeed(int seed) {
        this.seed = seed;
        this.isSeedSet = true;
    }

    public void randomizeLayout() {
        System.out.println("randomizing layout");
        MersenneTwister mt = null;
        mt = this.isSeedSet ? new MersenneTwister(this.seed) : new MersenneTwister(new Date());
        Uniform uni = new Uniform((RandomElement)mt);
        int xLimit = this.width - this.pad;
        int yLimit = this.height - this.pad;
        for (Node node : this.nodeList) {
            Coordinates c = (Coordinates)this.locations.get(node);
            c.setX(uni.nextDoubleFromTo(0.0, (double)xLimit));
            c.setY(uni.nextDoubleFromTo(0.0, (double)yLimit));
        }
    }

    public void advancePositions() {
        if (this.done) {
            return;
        }
        if (this.update) {
            for (Node workNode : this.nodeList) {
                this.locations.put(workNode, new Coordinates(workNode.getX(), workNode.getY()));
            }
            this.noBreak = true;
            Object[] nl = this.nodeList.toArray();
            this.optDist = 0.46 * Math.sqrt(this.width * this.height / (nl.length + 1));
            double temp = this.width / 10;
            int passes = 0;
            int nNodes = nl.length;
            double xDelta = 0.0;
            double yDelta = 0.0;
            double deltaLength = 0.0;
            double force = 0.0;
            HashSet edges = new HashSet();
            HashMap<Node, Integer> nodeIndexer = new HashMap<Node, Integer>();
            if (this.firstLayout) {
                this.randomizeLayout();
                this.firstLayout = false;
            }
            double[] xPos = new double[nNodes];
            double[] yPos = new double[nNodes];
            boolean[] fixed = new boolean[nNodes];
            for (int i = 0; i < nNodes; ++i) {
                Node workNode = (Node)nl[i];
                xPos[i] = workNode.getX();
                yPos[i] = workNode.getY();
                this.maxWidth = Math.max(this.maxWidth, workNode.getWidth() * 1.5);
                this.maxHeight = Math.max(this.maxHeight, workNode.getHeight() * 1.5);
                fixed[i] = false;
                edges.addAll(workNode.getOutEdges());
                nodeIndexer.put(workNode, new Integer(i));
            }
            if (NetUtilities.hasSelfLoops(this.nodeList)) {
                edges = (HashSet)this.removeLoops(edges);
            }
            double[] xDisp = new double[nNodes];
            double[] yDisp = new double[nNodes];
            while (temp > 1.0 && passes < this.maxPasses && this.noBreak) {
                int limit = nNodes - 1;
                for (int v = 0; v < limit; ++v) {
                    xDisp[v] = 0.0;
                    yDisp[v] = 0.0;
                    for (int u = v + 1; u < nNodes; ++u) {
                        xDelta = xPos[v] - xPos[u];
                        yDelta = yPos[v] - yPos[u];
                        if (xDelta == 0.0 && yDelta == 0.0) continue;
                        deltaLength = Math.sqrt(xDelta * xDelta + yDelta * yDelta);
                        force = this.calcRepulsion(deltaLength);
                        int n = v;
                        xDisp[n] = xDisp[n] + xDelta / deltaLength * force;
                        int n2 = v;
                        yDisp[n2] = yDisp[n2] + yDelta / deltaLength * force;
                        int n3 = u;
                        xDisp[n3] = xDisp[n3] - xDelta / deltaLength * force;
                        int n4 = u;
                        yDisp[n4] = yDisp[n4] - yDelta / deltaLength * force;
                    }
                }
                Iterator iter = edges.iterator();
                while (iter.hasNext() && this.noBreak) {
                    int uIndex;
                    Edge edge = (Edge)iter.next();
                    int vIndex = (Integer)nodeIndexer.get(edge.getNode1());
                    xDelta = xPos[vIndex] - xPos[uIndex = ((Integer)nodeIndexer.get(edge.getNode2())).intValue()];
                    deltaLength = Math.sqrt(xDelta * xDelta + (yDelta = yPos[vIndex] - yPos[uIndex]) * yDelta);
                    if (deltaLength == 0.0) {
                        deltaLength = 0.001;
                    }
                    force = this.calcAttraction(deltaLength);
                    int n = vIndex;
                    xDisp[n] = xDisp[n] - xDelta / deltaLength * force;
                    int n5 = vIndex;
                    yDisp[n5] = yDisp[n5] - yDelta / deltaLength * force;
                    int n6 = uIndex;
                    xDisp[n6] = xDisp[n6] + xDelta / deltaLength * force;
                    int n7 = uIndex;
                    yDisp[n7] = yDisp[n7] + yDelta / deltaLength * force;
                }
                for (int v = 0; v < nNodes; ++v) {
                    double xDispVal = xDisp[v];
                    double yDispVal = yDisp[v];
                    deltaLength = Math.sqrt(xDispVal * xDispVal + yDispVal * yDispVal);
                    if (fixed[v]) continue;
                    if (deltaLength > temp) {
                        int n = v;
                        xPos[n] = xPos[n] + this.round(xDisp[v] / (deltaLength / temp), Math.rint(this.maxWidth));
                        int n8 = v;
                        yPos[n8] = yPos[n8] + this.round(yDisp[v] / (deltaLength / temp), Math.rint(this.maxHeight));
                        continue;
                    }
                    int n = v;
                    xPos[n] = xPos[n] + this.round(xDisp[v], Math.rint(this.maxWidth));
                    int n9 = v;
                    yPos[n9] = yPos[n9] + this.round(yDisp[v], Math.rint(this.maxHeight));
                }
                if (passes > this.initialIter) {
                    temp = this.coolTemp(temp);
                }
                ++passes;
            }
            if (this.rescaleLayout) {
                this.rescalePositions(nl, xPos, yPos);
            }
            Random r = new Random();
            int overlapping = 0;
            boolean[][] cells = new boolean[this.width / (int)Math.rint(this.maxWidth) + 10][this.height / (int)Math.rint(this.maxHeight) + 10];
            for (int i = 0; i < nNodes; ++i) {
                Node node = (Node)nl[i];
                int ci = (int)xPos[i] / (int)Math.rint(this.maxWidth);
                int cj = (int)yPos[i] / (int)Math.rint(this.maxHeight);
                boolean found = false;
                if (cells[ci][cj]) {
                    for (int t = 1; t <= 4; ++t) {
                        for (int s = 0; s <= t; ++s) {
                            if (!cells[ci = Math.min(Math.max(0, ci + t), cells.length - 1)][cj = Math.min(Math.max(0, cj + s), cells[ci].length - 1)]) {
                                found = true;
                                break;
                            }
                            if (cells[ci = Math.min(Math.max(0, ci - t), cells.length - 1)][cj = Math.min(Math.max(0, cj - s), cells[ci].length - 1)]) continue;
                            found = true;
                            break;
                        }
                        if (found) break;
                    }
                }
                Coordinates c = (Coordinates)this.locations.get(node);
                c.setX((double)ci * Math.rint(this.maxWidth));
                c.setY((double)cj * Math.rint(this.maxHeight));
                if (cells[ci][cj]) {
                    ++overlapping;
                    c.setX(c.getX() + (double)r.nextInt((int)this.maxWidth));
                    c.setY(c.getY() + (double)r.nextInt((int)this.maxHeight));
                }
                cells[ci][cj] = true;
            }
            if (overlapping > 0) {
                System.out.println("\tThere are " + overlapping + " overlapping nodes, (you may want " + "to increase the height/width)");
            }
        }
        this.done = true;
    }

    public double round(double a, double modx) {
        double temp = Math.rint(a);
        double temp2 = temp - temp % modx;
        return temp2;
    }

    private void rescalePositions(Object[] nList, double[] xPos, double[] yPos) {
        int nNodes = nList.length;
        double xMax = xPos[0];
        double yMax = yPos[0];
        double xMin = xPos[0];
        double yMin = yPos[0];
        for (int i = 1; i < nNodes; ++i) {
            xMax = Math.max(xMax, xPos[i]);
            yMax = Math.max(yMax, yPos[i]);
            xMin = Math.min(xMin, xPos[i]);
            yMin = Math.min(yMin, yPos[i]);
        }
        double xDiff = xMax - xMin;
        double yDiff = yMax - yMin;
        int xPadVal = this.width - this.pad;
        int yPadVal = this.height - this.pad;
        for (int i = 0; i < nNodes; ++i) {
            xPos[i] = this.round((xPos[i] - xMin) / xDiff * (double)xPadVal, Math.rint(this.maxWidth));
            yPos[i] = this.round((yPos[i] - yMin) / yDiff * (double)yPadVal, Math.rint(this.maxHeight));
            Node node = (Node)nList[i];
            Coordinates c = (Coordinates)this.locations.get(node);
            c.setX(xPos[i]);
            c.setY(yPos[i]);
        }
    }

    private Set removeLoops(Set edges) {
        HashSet<Edge> returnList = new HashSet<Edge>();
        for (Edge edge : edges) {
            if (edge == null || edge.getNode1() == edge.getNode2()) continue;
            returnList.add(edge);
        }
        return returnList;
    }

    public void actionPerformed(ActionEvent evt) {
        this.noBreak = false;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setUpdate(boolean doUpdate) {
        this.update = doUpdate;
    }

    public double getX(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getX();
    }

    public double getY(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getY();
    }

    public Coordinates getCoordinates(Node v) {
        return (Coordinates)this.locations.get(v);
    }

    public boolean incrementsAreDone() {
        return this.done;
    }

    public void initialize_local_vertex(Vertex v) {
    }

    public void initialize_local() {
    }

    public boolean isIncremental() {
        return false;
    }
}

