/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.layout.Rescale;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class GEM
extends AbstractLayout {
    public static final String Name = "GEM Force-directed";
    private static Graph graph;
    private static Set nodes;
    private static Set edges;
    private static int nodeCount;
    private static int edgeCount;
    private static final int ELEN = 128;
    private static final int ELENSQR = 16384;
    private static final int MAXATTRACT = 0x100000;
    private static final float IMAXTEMPDEF = 1.0f;
    private static final float ISTARTTEMPDEF = 0.3f;
    private static final float IFINALTEMPDEF = 0.05f;
    private static final int IMAXITERDEF = 10;
    private static final float IGRAVITYDEF = 0.05f;
    private static final float IOSCILLATIONDEF = 0.4f;
    private static final float IROTATIONDEF = 0.5f;
    private static final float ISHAKEDEF = 0.2f;
    private static final float AMAXTEMPDEF = 1.5f;
    private static final float ASTARTTEMPDEF = 1.0f;
    private static final float AFINALTEMPDEF = 0.02f;
    private static final int AMAXITERDEF = 3;
    private static final float AGRAVITYDEF = 0.1f;
    private static final float AOSCILLATIONDEF = 0.4f;
    private static final float AROTATIONDEF = 0.9f;
    private static final float ASHAKEDEF = 0.3f;
    private static final float OMAXTEMPDEF = 0.25f;
    private static final float OSTARTTEMPDEF = 1.0f;
    private static final float OFINALTEMPDEF = 1.0f;
    private static final int OMAXITERDEF = 3;
    private static final float OGRAVITYDEF = 0.1f;
    private static final float OOSCILLATIONDEF = 0.4f;
    private static final float OROTATIONDEF = 0.9f;
    private static final float OSHAKEDEF = 0.3f;
    private static long iteration;
    private static long temperature;
    private static int centerX;
    private static int centerY;
    private static long maxtemp;
    private static float oscillation;
    private static float rotation;
    private float i_maxtemp = 1.0f;
    private float a_maxtemp = 1.5f;
    private float o_maxtemp = 0.25f;
    private float i_starttemp = 0.3f;
    private float a_starttemp = 1.0f;
    private float o_starttemp = 1.0f;
    private float i_finaltemp = 0.05f;
    private float a_finaltemp = 0.02f;
    private float o_finaltemp = 1.0f;
    private int i_maxiter = 10;
    private int a_maxiter = 3;
    private int o_maxiter = 3;
    private float i_gravity = 0.05f;
    private float i_oscillation = 0.4f;
    private float i_rotation = 0.5f;
    private float i_shake = 0.2f;
    private float a_gravity = 0.1f;
    private float a_oscillation = 0.4f;
    private float a_rotation = 0.9f;
    private float a_shake = 0.3f;
    private float o_gravity = 0.1f;
    private float o_oscillation = 0.4f;
    private float o_rotation = 0.9f;
    private float o_shake = 0.3f;
    private Graph g = null;
    protected double defaultNodeSize = 1.0;
    private static final String GEM2D = "GEM 2D Parameters";
    private GemP[] gemProp;
    private Node[] invmap;
    private ArrayList[] adjacent;
    private HashMap nodeNumbers;
    private Random rand = new Random();
    private int[] map;
    private LinkedList q;
    private int i_impulseX;
    private int i_impulseY;
    private int EVdistX;
    private int EVdistY;
    private int o_impulseX;
    private int o_impulseY;
    private HashMap myDone = new HashMap();
    public boolean done = false;

    public GEM(Graph g, long seed) {
        this(g);
        this.rand.setSeed(seed);
    }

    public GEM(Graph g) {
        super((edu.uci.ics.jung.graph.Graph)g);
        if (Guess.getGPLFreeMode()) {
            throw new Error("Running in GPL Free Mode, you will not be able to use this class");
        }
        this.g = g;
    }

    protected double setDefaultNodeSize() {
        return 1.0;
    }

    public String getName() {
        return Name;
    }

    public int rand() {
        return (int)(this.rand.nextDouble() * 2.147483647E9);
    }

    private int select() {
        if (iteration == 0L) {
            this.map = new int[nodeCount];
            for (int i = 0; i < nodeCount; ++i) {
                this.map[i] = i;
            }
        }
        int n = (int)((long)nodeCount - iteration % (long)nodeCount);
        int v = this.rand() % n;
        if (v == nodeCount) {
            --v;
        }
        if (n == nodeCount) {
            --n;
        }
        int u = this.map[v];
        this.map[v] = this.map[n];
        this.map[n] = u;
        return u;
    }

    private int bfs(int root) {
        if (root >= 0) {
            this.q = new LinkedList();
            if (!this.gemProp[root].mark) {
                for (int vi = 0; vi < nodeCount; ++vi) {
                    this.gemProp[vi].in = 0;
                }
            } else {
                this.gemProp[root].mark = true;
            }
            this.q.addFirst(new Integer(root));
            this.gemProp[root].in = 1;
        }
        if (this.q.size() == 0) {
            return -1;
        }
        int v = (Integer)this.q.removeLast();
        for (Integer uint : this.adjacent[v]) {
            int ui = uint;
            if (this.gemProp[ui].in == 0) continue;
            this.q.addFirst(uint);
            this.gemProp[ui].in = this.gemProp[v].in + 1;
        }
        return v;
    }

    private int graph_center() {
        int c = -1;
        int u = -1;
        int h = nodeCount + 1;
        for (int w = 0; w < nodeCount; ++w) {
            int v = this.bfs(w);
            while (v >= 0 && this.gemProp[v].in < h) {
                u = v;
                v = this.bfs(-1);
            }
            GemP p = this.gemProp[u];
            if (p.in >= h) continue;
            h = p.in;
            c = w;
        }
        return c;
    }

    private void vertexdata_init(float starttemp) {
        temperature = 0L;
        centerY = 0;
        centerX = 0;
        for (int v = 0; v < nodeCount; ++v) {
            GemP p = this.gemProp[v];
            p.heat = starttemp * 128.0f;
            temperature = (long)((float)temperature + p.heat * p.heat);
            p.iY = 0;
            p.iX = 0;
            p.dir = 0.0f;
            p.mass = 1.0f + this.gemProp[v].mass / 3.0f;
            centerX += p.x;
            centerY += p.y;
        }
    }

    private void i_impulse(int v) {
        int dY;
        int dX;
        GemP q;
        int u;
        GemP p = this.gemProp[v];
        int pX = p.x;
        int pY = p.y;
        int n = (int)(this.i_shake * 128.0f);
        int iX = this.rand() % (2 * n + 1) - n;
        int iY = this.rand() % (2 * n + 1) - n;
        iX = (int)((float)iX + (float)(centerX / nodeCount - pX) * p.mass * this.i_gravity);
        iY = (int)((float)iY + (float)(centerY / nodeCount - pY) * p.mass * this.i_gravity);
        for (u = 0; u < nodeCount; ++u) {
            q = this.gemProp[u];
            if (q.in <= 0 || (n = (dX = pX - q.x) * dX + (dY = pY - q.y) * dY) <= 0) continue;
            iX += dX * 16384 / n;
            iY += dY * 16384 / n;
        }
        Iterator nodeSet = this.adjacent[v].iterator();
        while (nodeSet.hasNext()) {
            u = (Integer)nodeSet.next();
            q = this.gemProp[u];
            if (q.in <= 0) continue;
            dX = pX - q.x;
            dY = pY - q.y;
            n = (int)((float)(dX * dX + dY * dY) / p.mass);
            n = Math.min(n, 0x100000);
            iX -= dX * n / 16384;
            iY -= dY * n / 16384;
        }
        this.i_impulseX = iX;
        this.i_impulseY = iY;
    }

    public void insert() {
        this.vertexdata_init(this.i_starttemp);
        oscillation = this.i_oscillation;
        rotation = this.i_rotation;
        maxtemp = (int)(this.i_maxtemp * 128.0f);
        int v = this.graph_center();
        for (int ui = 0; ui < nodeCount; ++ui) {
            this.gemProp[ui].in = 0;
        }
        this.gemProp[v].in = -1;
        int startNode = -1;
        for (int i = 0; i < nodeCount; ++i) {
            int u;
            int d = 0;
            for (u = 0; u < nodeCount; ++u) {
                if (this.gemProp[u].in >= d) continue;
                d = this.gemProp[u].in;
                v = u;
            }
            this.gemProp[v].in = 1;
            Iterator nodeSet2 = this.adjacent[v].iterator();
            while (nodeSet2.hasNext()) {
                u = (Integer)nodeSet2.next();
                if (this.gemProp[u].in > 0) continue;
                --this.gemProp[u].in;
            }
            GemP p = this.gemProp[v];
            p.y = 0;
            p.x = 0;
            if (startNode >= 0) {
                d = 0;
                p = this.gemProp[v];
                nodeSet2 = this.adjacent[v].iterator();
                while (nodeSet2.hasNext()) {
                    int w = (Integer)nodeSet2.next();
                    GemP q = this.gemProp[w];
                    if (q.in <= 0) continue;
                    p.x += q.x;
                    p.y += q.y;
                    ++d;
                }
                if (d > 1) {
                    p.x /= d;
                    p.y /= d;
                }
                d = 0;
                while (d++ < this.i_maxiter && p.heat > this.i_finaltemp * 128.0f) {
                    this.i_impulse(v);
                    this.displace(v, this.i_impulseX, this.i_impulseY);
                }
                continue;
            }
            startNode = i;
        }
    }

    private void displace(int v, int iX, int iY) {
        if (iX != 0 || iY != 0) {
            int n = Math.max(Math.abs(iX), Math.abs(iY)) / 16384;
            if (n > 1) {
                iX /= n;
                iY /= n;
            }
            GemP p = this.gemProp[v];
            int t = (int)p.heat;
            n = (int)Math.sqrt(iX * iX + iY * iY);
            iX = iX * t / n;
            iY = iY * t / n;
            p.x += iX;
            p.y += iY;
            centerX += iX;
            centerY += iY;
            n = t * (int)Math.sqrt(p.iX * p.iX + p.iY * p.iY);
            if (n > 0) {
                temperature -= (long)(t * t);
                t = (int)((float)t + (float)t * oscillation * (float)(iX * p.iX + iY * p.iY) / (float)n);
                t = (int)Math.min((long)t, maxtemp);
                p.dir += rotation * (float)(iX * p.iY - iY * p.iX) / (float)n;
                t = (int)((float)t - (float)t * Math.abs(p.dir) / (float)nodeCount);
                t = Math.max(t, 2);
                temperature += (long)(t * t);
                p.heat = t;
            }
            p.iX = iX;
            p.iY = iY;
        }
    }

    void a_round() {
        for (int i = 0; i < nodeCount; ++i) {
            int dY;
            int dX;
            GemP q;
            int u;
            int v = this.select();
            GemP p = this.gemProp[v];
            int pX = p.x;
            int pY = p.y;
            int n = (int)(this.a_shake * 128.0f);
            int iX = this.rand() % (2 * n + 1) - n;
            int iY = this.rand() % (2 * n + 1) - n;
            iX = (int)((float)iX + (float)(centerX / nodeCount - pX) * p.mass * this.a_gravity);
            iY = (int)((float)iY + (float)(centerY / nodeCount - pY) * p.mass * this.a_gravity);
            for (u = 0; u < nodeCount; ++u) {
                q = this.gemProp[u];
                dX = pX - q.x;
                dY = pY - q.y;
                n = dX * dX + dY * dY;
                if (n <= 0) continue;
                iX += dX * 16384 / n;
                iY += dY * 16384 / n;
            }
            Iterator nodeSet = this.adjacent[v].iterator();
            while (nodeSet.hasNext()) {
                u = (Integer)nodeSet.next();
                q = this.gemProp[u];
                dX = pX - q.x;
                dY = pY - q.y;
                n = (int)((float)(dX * dX + dY * dY) / p.mass);
                n = Math.min(n, 0x100000);
                iX -= dX * n / 16384;
                iY -= dY * n / 16384;
            }
            this.displace(v, iX, iY);
            ++iteration;
        }
    }

    private void arrange() {
        this.vertexdata_init(this.a_starttemp);
        oscillation = this.a_oscillation;
        rotation = this.a_rotation;
        maxtemp = (int)(this.a_maxtemp * 128.0f);
        long stop_temperature = (int)(this.a_finaltemp * this.a_finaltemp * 16384.0f * (float)nodeCount);
        long stop_iteration = this.a_maxiter * nodeCount * nodeCount;
        iteration = 0L;
        while (temperature > stop_temperature && iteration < stop_iteration) {
            this.a_round();
        }
    }

    private void EVdistance(int thisNode, int thatNode, int v) {
        GemP thisGP = this.gemProp[thisNode];
        GemP thatGP = this.gemProp[thatNode];
        GemP nodeGP = this.gemProp[v];
        int aX = thisGP.x;
        int aY = thisGP.y;
        int bX = thatGP.x;
        int bY = thatGP.y;
        int cX = nodeGP.x;
        int cY = nodeGP.y;
        long m = (bX -= aX) * (cX - aX) + (bY -= aY) * (cY - aY);
        long n = bX * bX + bY * bY;
        if (m < 0L) {
            m = 0L;
        }
        if (m > n) {
            n = 1L;
            m = 1L;
        }
        if (m >> 17 > 0L) {
            n /= m >> 16;
            m /= m >> 16;
        }
        if (n != 0L) {
            aX += (int)((long)bX * m / n);
            aY += (int)((long)bY * m / n);
        }
        this.EVdistX = aX;
        this.EVdistY = aY;
    }

    private void o_impulse(int v) {
        GemP p = this.gemProp[v];
        int pX = p.x;
        int pY = p.y;
        int n = (int)(this.o_shake * 128.0f);
        int iX = this.rand() % (2 * n + 1) - n;
        int iY = this.rand() % (2 * n + 1) - n;
        iX = (int)((float)iX + (float)(centerX / nodeCount - pX) * p.mass * this.o_gravity);
        iY = (int)((float)iY + (float)(centerY / nodeCount - pY) * p.mass * this.o_gravity);
        for (Edge e : edges) {
            int dY;
            int dX;
            GemP up;
            int u = (Integer)this.nodeNumbers.get(e.getNode1());
            int w = (Integer)this.nodeNumbers.get(e.getNode2());
            if (u != v && w != v) {
                up = this.gemProp[u];
                GemP wp = this.gemProp[w];
                dX = (up.x + wp.x) / 2 - pX;
                dY = (up.y + wp.y) / 2 - pY;
                n = dX * dX + dY * dY;
                if (n < 131072) {
                    this.EVdistance(u, w, v);
                    dX = this.EVdistX;
                    dY = this.EVdistY;
                    n = (dX -= pX) * dX + (dY -= pY) * dY;
                }
                if (n <= 0) continue;
                iX -= dX * 16384 / n;
                iY -= dY * 16384 / n;
                continue;
            }
            if (u == v) {
                u = w;
            }
            up = this.gemProp[u];
            dX = pX - up.x;
            dY = pY - up.y;
            n = (int)((float)(dX * dX + dY * dY) / p.mass);
            n = Math.min(n, 0x100000);
            iX -= dX * n / 16384;
            iY -= dY * n / 16384;
        }
        this.o_impulseX = iX;
        this.o_impulseY = iY;
    }

    private void o_round() {
        for (int i = 0; i < nodeCount; ++i) {
            int v = this.select();
            this.o_impulse(v);
            this.displace(v, this.o_impulseX, this.o_impulseY);
            ++iteration;
        }
    }

    private void optimize() {
        this.vertexdata_init(this.o_starttemp);
        oscillation = this.o_oscillation;
        rotation = this.o_rotation;
        maxtemp = (int)(this.o_maxtemp * 128.0f);
        long stop_temperature = (int)(this.o_finaltemp * this.o_finaltemp * 16384.0f * (float)nodeCount);
        long stop_iteration = this.o_maxiter * nodeCount * nodeCount;
        while (temperature > stop_temperature && iteration < stop_iteration) {
            this.o_round();
            if (iteration % 20000L != 0L) continue;
        }
    }

    public void computePositions() {
        int i;
        Node n;
        long startTime = System.currentTimeMillis();
        graph = this.g;
        nodes = graph.getNodes();
        edges = graph.getEdges();
        nodeCount = nodes.size();
        edgeCount = edges.size();
        this.gemProp = new GemP[nodeCount];
        this.invmap = new Node[nodeCount];
        this.adjacent = new ArrayList[nodeCount];
        this.nodeNumbers = new HashMap();
        Iterator nodeSet = nodes.iterator();
        int i2 = 0;
        while (nodeSet.hasNext()) {
            n = (Node)nodeSet.next();
            this.gemProp[i2] = new GemP(n.getOutEdges().size());
            this.invmap[i2] = n;
            this.nodeNumbers.put(n, new Integer(i2));
            ++i2;
        }
        for (i = 0; i < nodeCount; ++i) {
            Set nset = this.invmap[i].getNeighbors();
            Iterator neighbors = nset.iterator();
            this.adjacent[i] = new ArrayList(nset.size());
            int j = 0;
            while (neighbors.hasNext()) {
                n = (Node)neighbors.next();
                Integer nodeNr = (Integer)this.nodeNumbers.get(n);
                this.adjacent[i].add(nodeNr);
                ++j;
            }
        }
        if (this.i_finaltemp < this.i_starttemp) {
            this.insert();
        }
        if (this.a_finaltemp < this.a_starttemp) {
            this.arrange();
        }
        if (this.o_finaltemp < this.o_starttemp) {
            this.optimize();
        }
        for (i = 0; i < nodeCount; ++i) {
            GemP p = this.gemProp[i];
            n = this.invmap[i];
            this.myDone.put(n, new Coordinates((double)p.x, (double)p.y));
        }
        Rescale.rescalePositions(graph.getNodes(), 0.25, 0, (Map)this.myDone);
        long endTime = System.currentTimeMillis();
        this.done = true;
    }

    public double getX(Vertex n) {
        Coordinates d2d = (Coordinates)this.myDone.get(n);
        return d2d.getX();
    }

    public double getY(Vertex n) {
        Coordinates d2d = (Coordinates)this.myDone.get(n);
        return d2d.getY();
    }

    public Coordinates getCoordinates(Node v) {
        return (Coordinates)this.myDone.get(v);
    }

    public boolean incrementsAreDone() {
        return this.done;
    }

    public void advancePositions() {
        if (!this.done) {
            this.computePositions();
        }
    }

    public void initialize_local_vertex(Vertex v) {
    }

    public void initialize_local() {
    }

    public boolean isIncremental() {
        return false;
    }

    static class GemP {
        public int x = 0;
        public int y = 0;
        public int in;
        public int iX = 0;
        public int iY = 0;
        public float dir = 0.0f;
        public float heat = 0.0f;
        public float mass;
        public boolean mark;

        public GemP(int m) {
            this.mass = m;
            this.mark = false;
        }
    }
}

