/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.layout.NetUtilities;
import com.hp.hpl.guess.layout.Rescale;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class KamadaGraphLayout
extends AbstractLayout {
    private double springConst = 1.0;
    private double minEpsilon = 1.0;
    private int maxPasses = 5000;
    private boolean circleLayout = false;
    private boolean rescaleLayout = true;
    private int pad = 20;
    private int updates = 0;
    private boolean stop = false;
    private String status = "";
    private boolean firstLayout = true;
    private boolean breakOut = false;
    private Set nodeList;
    private int width;
    private int height;
    private boolean update = true;
    private HashMap locations = new HashMap();
    public boolean done = false;

    public KamadaGraphLayout(Graph g, boolean firstLayout, int width, int height) {
        super((edu.uci.ics.jung.graph.Graph)g);
        this.width = width;
        this.height = height;
        this.nodeList = g.getNodes();
        this.firstLayout = firstLayout;
    }

    public void setPad(int p) {
        this.pad = p;
    }

    public void setUpdateEveryN(int updateEveryN) {
        this.updates = updateEveryN;
    }

    public void setMinEpsilon(double energy) {
        this.minEpsilon = energy;
    }

    public void setSpringConst(double spring) {
        this.springConst = spring;
    }

    public void setMaxPasses(int passes) {
        this.maxPasses = passes;
    }

    public void setCircleLayout(boolean eachTime) {
        this.circleLayout = eachTime;
        this.firstLayout = false;
    }

    public void setRescaleLayout(boolean rescale) {
        this.rescaleLayout = rescale;
    }

    public void circleLayout() {
        int nNodes = this.nodeList.size();
        int originX = this.width / 2;
        int originY = this.height / 2;
        int radius = this.height > this.width ? this.width / 2 - this.pad * 2 : this.height / 2 - this.pad * 2;
        Iterator it = this.nodeList.iterator();
        int i = 0;
        while (it.hasNext()) {
            Node node = (Node)it.next();
            Coordinates c = (Coordinates)this.locations.get(node);
            c.setX((double)radius * Math.cos(Math.PI * 2 * (double)i / (double)nNodes) + (double)originX);
            c.setY((double)radius * Math.sin(Math.PI * 2 * (double)i / (double)nNodes) + (double)originY);
            ++i;
        }
    }

    private DenseDoubleMatrix2D calcKMatrix(DenseDoubleMatrix2D distMatrix, double spring) {
        int nNodes = distMatrix.rows();
        DenseDoubleMatrix2D kMatrix = new DenseDoubleMatrix2D(nNodes, nNodes);
        for (int i = 0; i < nNodes; ++i) {
            for (int j = 0; j < nNodes; ++j) {
                double distMVal = distMatrix.getQuick(i, j);
                kMatrix.setQuick(i, j, spring / (distMVal * distMVal));
            }
        }
        return kMatrix;
    }

    private DenseDoubleMatrix2D calcLMatrix(DenseDoubleMatrix2D distMatrix, double optDist) {
        int nNodes = distMatrix.rows();
        DenseDoubleMatrix2D lMatrix = new DenseDoubleMatrix2D(nNodes, nNodes);
        for (int i = 0; i < nNodes; ++i) {
            for (int j = 0; j < nNodes; ++j) {
                lMatrix.setQuick(i, j, optDist * distMatrix.getQuick(i, j));
            }
        }
        return lMatrix;
    }

    private int getDiam(DenseDoubleMatrix2D distMatrix) {
        int nNodes = distMatrix.rows();
        double graphDiam = 0.0;
        for (int i = 0; i < nNodes; ++i) {
            for (int j = 0; j < nNodes; ++j) {
                graphDiam = Math.max(graphDiam, distMatrix.getQuick(i, j));
            }
        }
        return (int)graphDiam;
    }

    public void advancePositions() {
        if (this.done) {
            return;
        }
        if (this.update) {
            for (Node workNode : this.nodeList) {
                this.locations.put(workNode, new Coordinates(workNode.getX(), workNode.getY()));
            }
            this.stop = false;
            if (this.circleLayout) {
                this.circleLayout();
            }
            if (this.firstLayout) {
                this.firstLayout = false;
                this.circleLayout();
            }
            Set components = NetUtilities.getComponents(this.nodeList);
            Iterator compIter = components.iterator();
            while (compIter.hasNext() && !this.stop) {
                Set comp = (Set)compIter.next();
                if (comp.size() <= 1) continue;
                this.runKamadaOn(comp);
            }
            if (this.rescaleLayout) {
                Rescale.rescalePositions(this.nodeList, this.width, this.height, (Map)this.locations);
            }
        }
        this.done = true;
    }

    private void runKamadaOn(Set componentNodes) {
        double deltaM;
        int nNodes = componentNodes.size();
        DenseDoubleMatrix2D distMatrix = NetUtilities.getAllShortPathMatrix(componentNodes);
        DenseDoubleMatrix2D kMatrix = this.calcKMatrix(distMatrix, this.springConst);
        double optDist = Math.min(this.width, this.height) / Math.max(this.getDiam(distMatrix), 1);
        DenseDoubleMatrix2D lMatrix = this.calcLMatrix(distMatrix, optDist);
        double[] xPos = new double[nNodes];
        double[] yPos = new double[nNodes];
        int numEdges = 0;
        Node[] nList = new Node[nNodes];
        Iterator it = this.nodeList.iterator();
        int w = 0;
        while (it.hasNext()) {
            Node workNode = (Node)it.next();
            Coordinates c = (Coordinates)this.locations.get(workNode);
            xPos[w] = c.getX();
            yPos[w] = c.getY();
            nList[w] = workNode;
            numEdges += workNode.getOutEdges().size();
            ++w;
        }
        double initialEnergy = this.getEnergy(lMatrix, kMatrix, xPos, yPos);
        double epsilon = initialEnergy / (double)nNodes;
        int maxDeltaMIndex = 0;
        double maxDeltaM = this.getDeltaM(0, lMatrix, kMatrix, xPos, yPos);
        for (int i = 1; i < nNodes; ++i) {
            deltaM = this.getDeltaM(i, lMatrix, kMatrix, xPos, yPos);
            if (!(deltaM > maxDeltaM)) continue;
            maxDeltaM = deltaM;
            maxDeltaMIndex = i;
        }
        boolean passes = false;
        int subPasses = 0;
        while (epsilon > this.minEpsilon && !this.stop) {
            double previousMaxDeltaM = maxDeltaM + 1.0;
            while (maxDeltaM > epsilon && previousMaxDeltaM - maxDeltaM > 0.1 && !this.stop) {
                System.out.print(".");
                double moveNodeDeltaM = maxDeltaM;
                double previousDeltaM = moveNodeDeltaM + 1.0;
                while (moveNodeDeltaM > epsilon && !this.stop) {
                    double[] deltas = this.getDeltas(maxDeltaMIndex, lMatrix, kMatrix, xPos, yPos);
                    int n = maxDeltaMIndex;
                    xPos[n] = xPos[n] + deltas[0];
                    int n2 = maxDeltaMIndex;
                    yPos[n2] = yPos[n2] + deltas[1];
                    previousDeltaM = moveNodeDeltaM;
                    moveNodeDeltaM = this.getDeltaM(maxDeltaMIndex, lMatrix, kMatrix, xPos, yPos);
                    if (++subPasses <= this.maxPasses) continue;
                    this.stop = true;
                }
                previousDeltaM = maxDeltaM;
                maxDeltaMIndex = 0;
                maxDeltaM = this.getDeltaM(0, lMatrix, kMatrix, xPos, yPos);
                for (int i = 1; i < nNodes; ++i) {
                    deltaM = this.getDeltaM(i, lMatrix, kMatrix, xPos, yPos);
                    if (!(deltaM > maxDeltaM)) continue;
                    maxDeltaM = deltaM;
                    maxDeltaMIndex = i;
                }
            }
            epsilon -= epsilon / 4.0;
        }
        System.out.print("\n");
        for (int i = 0; i < nNodes; ++i) {
            Node node = nList[i];
            Coordinates c = (Coordinates)this.locations.get(node);
            c.setX(xPos[i]);
            c.setY(yPos[i]);
        }
    }

    private double[] getDeltas(int i, DenseDoubleMatrix2D lMatrix, DenseDoubleMatrix2D kMatrix, double[] xPos, double[] yPos) {
        int nNodes = lMatrix.rows();
        double[] deltas = new double[2];
        double xPartial = 0.0;
        double yPartial = 0.0;
        double xxPartial = 0.0;
        double xyPartial = 0.0;
        double yxPartial = 0.0;
        double yyPartial = 0.0;
        for (int j = 0; j < nNodes; ++j) {
            if (i == j) continue;
            double dx = xPos[i] - xPos[j];
            double dy = yPos[i] - yPos[j];
            double dd = Math.sqrt(dx * dx + dy * dy);
            double kMatrixVal = kMatrix.getQuick(i, j);
            double lMatrixVal = lMatrix.getQuick(i, j);
            double ddCubed = dd * dd * dd;
            xPartial += kMatrixVal * (dx - lMatrixVal * dx / dd);
            yPartial += kMatrixVal * (dy - lMatrixVal * dy / dd);
            xxPartial += kMatrixVal * (1.0 - lMatrixVal * dy * dy / ddCubed);
            xyPartial += kMatrixVal * (lMatrixVal * dx * dy / ddCubed);
            yxPartial += kMatrixVal * (lMatrixVal * dy * dx / ddCubed);
            yyPartial += kMatrixVal * (1.0 - lMatrixVal * dx * dx / ddCubed);
        }
        deltas[0] = (-xPartial * yyPartial - xyPartial * -yPartial) / (xxPartial * yyPartial - xyPartial * yxPartial);
        deltas[1] = (xxPartial * -yPartial - -xPartial * yxPartial) / (xxPartial * yyPartial - xyPartial * yxPartial);
        return deltas;
    }

    private double getDeltaM(int i, DenseDoubleMatrix2D lMatrix, DenseDoubleMatrix2D kMatrix, double[] xPos, double[] yPos) {
        int nNodes = lMatrix.rows();
        double deltaM = 0.0;
        double xPartial = 0.0;
        double yPartial = 0.0;
        for (int j = 0; j < nNodes; ++j) {
            if (i == j) continue;
            double dx = xPos[i] - xPos[j];
            double dy = yPos[i] - yPos[j];
            double dd = Math.sqrt(dx * dx + dy * dy);
            double kMatrixVal = kMatrix.getQuick(i, j);
            double lMatrixVal = lMatrix.getQuick(i, j);
            xPartial += kMatrixVal * (dx - lMatrixVal * dx / dd);
            yPartial += kMatrixVal * (dy - lMatrixVal * dy / dd);
        }
        deltaM = Math.sqrt(xPartial * xPartial + yPartial * yPartial);
        return deltaM;
    }

    private void rescalePositions(Set nodes) {
        int nNodes = nodes.size();
        double[] xPos = new double[nNodes];
        double[] yPos = new double[nNodes];
        Node[] nList = new Node[nNodes];
        Iterator it = nodes.iterator();
        int i = 0;
        while (it.hasNext()) {
            Node workNode = (Node)it.next();
            xPos[i] = workNode.getX();
            yPos[i] = workNode.getY();
            nList[i] = workNode;
            ++i;
        }
        double xMax = xPos[0];
        double yMax = yPos[0];
        double xMin = xPos[0];
        double yMin = yPos[0];
        for (i = 1; i < nNodes; ++i) {
            xMax = Math.max(xMax, xPos[i]);
            yMax = Math.max(yMax, yPos[i]);
            xMin = Math.min(xMin, xPos[i]);
            yMin = Math.min(yMin, yPos[i]);
        }
        for (i = 0; i < nNodes; ++i) {
            xPos[i] = (xPos[i] - xMin) / (xMax - xMin) * (double)(this.width - this.pad);
            yPos[i] = (yPos[i] - yMin) / (yMax - yMin) * (double)(this.height - this.pad);
        }
        int numSteps = 5;
        for (i = 0; i < nNodes; ++i) {
            Node node = nList[i];
            Coordinates c = (Coordinates)this.locations.get(node);
            c.setX(xPos[i]);
            c.setY(yPos[i]);
        }
    }

    private double getEnergy(DenseDoubleMatrix2D lMatrix, DenseDoubleMatrix2D kMatrix, double[] xPos, double[] yPos) {
        int nNodes = lMatrix.rows();
        double energy = 0.0;
        int limit = nNodes - 1;
        for (int i = 0; i < limit; ++i) {
            for (int j = i + 1; j < nNodes; ++j) {
                double dx = xPos[i] - xPos[j];
                double dy = yPos[i] - yPos[j];
                double lij = lMatrix.getQuick(i, j);
                energy += 0.5 * kMatrix.getQuick(i, j) * (dx * dx + dy * dy + lij * lij - 2.0 * lij * Math.sqrt(dx * dx + dy * dy));
            }
        }
        return energy;
    }

    public void actionPerformed(ActionEvent evt) {
        this.stop = true;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setUpdate(boolean doUpdate) {
        this.update = doUpdate;
    }

    public double getX(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getX();
    }

    public double getY(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getY();
    }

    public Coordinates getCoordinates(Node v) {
        return (Coordinates)this.locations.get(v);
    }

    public boolean incrementsAreDone() {
        return this.done;
    }

    public void initialize_local_vertex(Vertex v) {
    }

    public void initialize_local() {
    }

    public boolean isIncremental() {
        return false;
    }
}

