/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.util.HashMap;
import java.util.Set;

public class Move
extends AbstractLayout {
    private double xmove = 0.0;
    private double ymove = 0.0;
    private int pad = 0;
    Graph g = null;
    HashMap locations = new HashMap();
    public boolean done = false;

    public Move(Graph g, double xmove, double ymove) {
        super((edu.uci.ics.jung.graph.Graph)g);
        this.xmove = xmove;
        this.ymove = ymove;
        this.g = g;
    }

    public void advancePositions() {
        if (this.done) {
            return;
        }
        this.movePositionsInternal(this.g.getNodes(), this.xmove, this.ymove, 0);
        this.done = true;
    }

    public double getX(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getX();
    }

    public double getY(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getY();
    }

    public Coordinates getCoordinates(Node v) {
        return (Coordinates)this.locations.get(v);
    }

    public boolean incrementsAreDone() {
        return this.done;
    }

    public void initialize_local_vertex(Vertex v) {
    }

    public void initialize_local() {
    }

    public boolean isIncremental() {
        return false;
    }

    public static void movePositions(Set nodes, int newx, int newy, int pad) {
        int nNodes = nodes.size();
        Object[] nlist = nodes.toArray();
        if (nNodes == 1) {
            Node move1 = (Node)nlist[0];
            move1.setLocation(newx + pad, newy + pad);
            return;
        }
        double[] xPos = new double[nNodes];
        double[] yPos = new double[nNodes];
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        for (int i = 0; i < nNodes; ++i) {
            Node workNode = (Node)nlist[i];
            xPos[i] = workNode.getX();
            yPos[i] = workNode.getY();
            xMin = Math.min(xMin, xPos[i]);
            yMin = Math.min(yMin, yPos[i]);
        }
        double xTrans = (double)newx - xMin + (double)pad;
        double yTrans = (double)newy - yMin + (double)pad;
        for (int i = 0; i < nNodes; ++i) {
            xPos[i] = xPos[i] + xTrans;
            yPos[i] = yPos[i] + yTrans;
            ((Node)nlist[i]).setLocation(xPos[i], yPos[i]);
        }
    }

    public void movePositionsInternal(Set nodes, double newx, double newy, int pad) {
        int nNodes = nodes.size();
        Object[] nlist = nodes.toArray();
        if (nNodes == 1) {
            Node move1 = (Node)nlist[0];
            this.locations.put(move1, new Coordinates(newx + (double)pad, newy + (double)pad));
            return;
        }
        double[] xPos = new double[nNodes];
        double[] yPos = new double[nNodes];
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        for (int i = 0; i < nNodes; ++i) {
            Node workNode = (Node)nlist[i];
            xPos[i] = workNode.getX();
            yPos[i] = workNode.getY();
            xMin = Math.min(xMin, xPos[i]);
            yMin = Math.min(yMin, yPos[i]);
        }
        double xTrans = newx - xMin + (double)pad;
        double yTrans = newy - yMin + (double)pad;
        for (int i = 0; i < nNodes; ++i) {
            xPos[i] = xPos[i] + xTrans;
            yPos[i] = yPos[i] + yTrans;
            this.locations.put(nlist[i], new Coordinates(xPos[i], yPos[i]));
        }
    }
}

