/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Node;
import edu.uci.ics.jung.graph.Vertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NetUtilities {
    public static double calcDensity(Set nodes) {
        double density = 0.0;
        int nNodes = nodes.size();
        int degreeSum = 0;
        if (NetUtilities.isMultiplexNet(nodes)) {
            String error = "calcDensity expects a non-multiplex network. Please run collapseMultiplexNet() before calculating density.";
        } else {
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                degreeSum += ((Node)it.next()).getOutEdges().size();
            }
            density = (double)degreeSum / (double)(nNodes * nNodes);
        }
        return density;
    }

    public static double calcDensity(Set nodes, boolean collapseMulti) {
        double density = 0.0;
        int nNodes = nodes.size();
        int degreeSum = 0;
        if (!collapseMulti) {
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                degreeSum += ((Node)it.next()).getOutEdges().size();
            }
            density = (double)degreeSum / (double)(nNodes * nNodes);
        }
        return density;
    }

    public static boolean isMultiplexNet(Set nodes) {
        boolean multiplex = false;
        int nNodes = nodes.size();
        HashSet<Node> jNodes = new HashSet<Node>(nNodes);
        Iterator nodeIter = nodes.iterator();
        while (nodeIter.hasNext() && !multiplex) {
            jNodes.clear();
            Node context = (Node)nodeIter.next();
            Iterator edgeIter = context.getOutEdges().iterator();
            while (edgeIter.hasNext() && !multiplex) {
                Node jNode = (Node)((Edge)edgeIter.next()).getOpposite((Vertex)context);
                if (jNodes.contains(jNode)) {
                    multiplex = true;
                    continue;
                }
                jNodes.add(jNode);
            }
        }
        return multiplex;
    }

    public static boolean hasSelfLoops(Set nodes) {
        for (Node iNode : nodes) {
            if (iNode.findEdge((Vertex)iNode) == null) continue;
            return true;
        }
        return false;
    }

    public static int getOutDegree(Node iNode) {
        return iNode.getOutEdges().size();
    }

    public static int getInDegree(Node iNode) {
        return iNode.getInEdges().size();
    }

    public static int getNumDirectTriads(Node iNode, Node jNode) {
        int parentCount = 0;
        HashSet<Node> iLinks = new HashSet<Node>();
        Iterator en = iNode.getInEdges().iterator();
        while (en.hasNext()) {
            iLinks.add((Node)((Edge)en.next()).getOpposite((Vertex)iNode));
        }
        en = jNode.getInEdges().iterator();
        while (en.hasNext()) {
            if (!iLinks.contains((Node)((Edge)en.next()).getOpposite((Vertex)jNode))) continue;
            ++parentCount;
        }
        return parentCount;
    }

    public static Set getComponents(Set nodes) {
        ComponentFinder finder = new ComponentFinder();
        return finder.findComponents(nodes);
    }

    public static DenseDoubleMatrix2D getAllShortPathMatrix(Set nodes) {
        int nNodes = nodes.size();
        DenseDoubleMatrix2D distMatrix = new DenseDoubleMatrix2D(nNodes, nNodes);
        distMatrix.assign(Double.POSITIVE_INFINITY);
        HashMap<Node, Integer> nodeIndexer = new HashMap<Node, Integer>();
        DoubleArrayList priorityList = new DoubleArrayList();
        ArrayList<Node> nodeQueue = new ArrayList<Node>();
        HashSet<Node> checkedNodes = new HashSet<Node>();
        Iterator it = nodes.iterator();
        int w = 0;
        Node[] nds = new Node[nNodes];
        while (it.hasNext()) {
            Node work = (Node)it.next();
            nodeIndexer.put(work, new Integer(w));
            nds[w] = work;
            ++w;
        }
        for (int i = 0; i < nNodes; ++i) {
            checkedNodes.clear();
            priorityList.clear();
            nodeQueue.clear();
            Node iNode = nds[i];
            distMatrix.setQuick(i, i, 0.0);
            checkedNodes.add(iNode);
            priorityList.add(0.0);
            nodeQueue.add(iNode);
            while (nodeQueue.size() > 0) {
                double fringeNodePrior = Double.POSITIVE_INFINITY;
                int fringeNodeIndex = Integer.MAX_VALUE;
                for (int n = 0; n < priorityList.size(); ++n) {
                    if (!(priorityList.getQuick(n) < fringeNodePrior)) continue;
                    fringeNodeIndex = n;
                    fringeNodePrior = priorityList.getQuick(fringeNodeIndex);
                }
                Node fringeNode = (Node)nodeQueue.get(fringeNodeIndex);
                double fringeNodeDist = priorityList.getQuick(fringeNodeIndex);
                nodeQueue.remove(fringeNodeIndex);
                priorityList.remove(fringeNodeIndex);
                checkedNodes.add(fringeNode);
                int index = (Integer)nodeIndexer.get(fringeNode);
                distMatrix.setQuick(i, index, fringeNodeDist);
                distMatrix.setQuick(index, i, fringeNodeDist);
                for (Edge edge : fringeNode.getOutEdges()) {
                    Node workNode = (Node)edge.getOpposite((Vertex)fringeNode);
                    if (checkedNodes.contains(workNode)) continue;
                    double eweight = (Double)edge.__getattr__("weight");
                    double workNodeDist = fringeNodeDist + eweight;
                    int prevDistIndex = nodeQueue.indexOf(workNode);
                    if (prevDistIndex >= 0) {
                        if (!(priorityList.getQuick(prevDistIndex) > workNodeDist)) continue;
                        priorityList.set(prevDistIndex, workNodeDist);
                        continue;
                    }
                    priorityList.add(workNodeDist);
                    nodeQueue.add(workNode);
                }
            }
        }
        return distMatrix;
    }

    private static class ComponentFinder {
        Set nodeList;
        int nNodes = 0;
        HashSet checked = new HashSet(this.nNodes);
        HashSet currentComps = new HashSet();
        HashSet currentComp = new HashSet();

        private ComponentFinder() {
        }

        public Set findComponents(Set nodeList) {
            this.nNodes = nodeList.size();
            HashSet returnList = new HashSet();
            this.checked.clear();
            for (Node iNode : nodeList) {
                if (this.checked.contains(iNode)) continue;
                this.currentComp = new HashSet();
                this.currentComps.add(this.currentComp);
                this.findConnectedNodes(iNode);
            }
            int size = this.currentComps.size();
            for (HashSet set : this.currentComps) {
                HashSet component = new HashSet(set.size());
                Iterator nodeIter = set.iterator();
                while (nodeIter.hasNext()) {
                    component.add(nodeIter.next());
                }
                returnList.add(component);
            }
            return returnList;
        }

        private void findConnectedNodes(Node iNode) {
            this.checked.add(iNode);
            this.currentComp.add(iNode);
            for (Edge edge : iNode.getOutEdges()) {
                Node nextNode = (Node)edge.getOpposite((Vertex)iNode);
                if (!this.checked.contains(nextNode)) {
                    this.findConnectedNodes(nextNode);
                    continue;
                }
                if (this.currentComp.contains(nextNode)) continue;
                HashSet set = this.getComponentFor(nextNode);
                set.addAll(this.currentComp);
                this.currentComps.remove(this.currentComp);
                this.currentComp = set;
            }
        }

        private HashSet getComponentFor(Node node) {
            int size = this.currentComps.size();
            for (HashSet set : this.currentComps) {
                if (!set.contains(node)) continue;
                return set;
            }
            return null;
        }
    }
}

