/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class Physics
extends AbstractLayout {
    double node_mass = 30.0;
    double node_charge = 0.001;
    int spring_length = 0;
    double spring_constant = 1.0;
    double max_sa_movement = 5.0;
    int layers_to_hide = 0;
    int min_layer = Integer.MAX_VALUE;
    int max_layer = Integer.MIN_VALUE;
    static final double COULOMBS_CONSTANT = 8.9875E9;
    Hashtable pendingForces = new Hashtable();
    Hashtable layer = new Hashtable();
    Hashtable locations = new Hashtable();
    private List my_nodes = null;
    int steps = 500;
    boolean gather = false;
    Graph g = null;
    int iter = 0;
    public boolean done = false;

    public Physics(Graph g, boolean gather) {
        super((edu.uci.ics.jung.graph.Graph)g);
        this.g = g;
        this.gather = gather;
        Set nodes = g.getNodes();
        ArrayList my_nodes = new ArrayList(nodes.size());
        my_nodes.addAll(nodes);
        for (Node n : my_nodes) {
            this.layer.put(n, new Integer(999999));
            this.locations.put(n, new Coordinates(n.getX(), n.getY()));
        }
        this.assign_layers(my_nodes);
        this.seperateNodes(my_nodes);
        this.my_nodes = my_nodes;
        System.out.println("working on: " + my_nodes.size() + " nodes");
        if (gather) {
            System.out.println("layer range: " + this.min_layer + " " + this.max_layer);
            for (int i = this.min_layer; i <= this.max_layer; ++i) {
                this.gather_nodes_with_layer(my_nodes, i);
            }
        }
    }

    public void advancePositions() {
        if (this.done) {
            return;
        }
        if (this.iter >= this.steps) {
            this.done = true;
            return;
        }
        this.advance();
        ++this.iter;
    }

    public void seperateNodes(List my_nodes) {
        int counter = 0;
        Random r = new Random();
        while (counter < my_nodes.size()) {
            Node this_node = (Node)my_nodes.get(counter);
            Coordinates this_loc = (Coordinates)this.locations.get(this_node);
            int counter2 = counter + 1;
            boolean clear = true;
            while (counter2 < my_nodes.size() && clear) {
                if (counter2 != counter) {
                    Node other_node = (Node)my_nodes.get(counter2);
                    Coordinates other_loc = (Coordinates)this.locations.get(other_node);
                    if (this_loc.getX() == other_loc.getX() && this_loc.getY() == other_loc.getY()) {
                        this_loc.setX(this_loc.getX() + (double)r.nextInt(20));
                        this_loc.setY(this_loc.getY() + (double)r.nextInt(20));
                        clear = false;
                        counter = 0;
                        continue;
                    }
                    ++counter2;
                    continue;
                }
                ++counter2;
            }
            if (!clear) continue;
            ++counter;
        }
    }

    public void advance() {
        Node this_node = null;
        Node other_node2 = null;
        for (Node n : this.my_nodes) {
            Coordinates p2d = (Coordinates)this.pendingForces.get(n);
            if (p2d == null) {
                this.pendingForces.put(n, new Coordinates(0.0, 0.0));
                continue;
            }
            p2d.setX(0.0);
            p2d.setY(0.0);
        }
        boolean apply_electric_charges = true;
        if (this.node_charge == 0.0) {
            apply_electric_charges = false;
        }
        int number_of_nodes = this.my_nodes.size();
        for (int counter = 0; counter < number_of_nodes; ++counter) {
            this_node = (Node)this.my_nodes.get(counter);
            if ((Integer)this.layer.get(this_node) <= this.layers_to_hide) continue;
            if (apply_electric_charges) {
                for (int counter2 = counter + 1; counter2 < number_of_nodes; ++counter2) {
                    double distance;
                    other_node2 = (Node)this.my_nodes.get(counter2);
                    if ((Integer)this.layer.get(other_node2) <= this.layers_to_hide || (distance = this.distance_between(this_node, other_node2)) == 0.0 || !(distance < 500.0)) continue;
                    this.apply_electrical_force(other_node2, this_node, distance);
                }
            }
            for (Node other_node2 : this_node.getNeighbors()) {
                if (other_node2.getName().compareTo(this_node.getName()) > 0 || (Integer)this.layer.get(other_node2) <= this.layers_to_hide) continue;
                this.apply_spring_force(other_node2, this_node);
            }
        }
        this.move_nodes(this.my_nodes);
    }

    public void apply_electrical_force(Node other_node, Node this_node, double distance) {
        double directed_force = 8.9875E9 * (this.node_charge * this.node_charge / (distance * distance));
        Coordinates incForce = this.determine_electric_axal_forces(directed_force, distance, other_node, this_node);
        Coordinates oldForce = (Coordinates)this.pendingForces.get(this_node);
        oldForce.setX(oldForce.getX() + incForce.getX());
        oldForce.setY(oldForce.getY() + incForce.getY());
        oldForce = (Coordinates)this.pendingForces.get(other_node);
        oldForce.setX(oldForce.getX() - incForce.getX());
        oldForce.setY(oldForce.getY() - incForce.getY());
    }

    public void apply_spring_force(Node other_node, Node this_node) {
        double distance = this.distance_between(other_node, this_node);
        if (distance == 0.0) {
            return;
        }
        double displacement = distance - (double)this.spring_length;
        if (displacement < 0.0) {
            displacement = -displacement;
        }
        double directed_force = -1.0 * this.spring_constant * displacement;
        Coordinates incForce = this.determine_spring_axal_forces(directed_force, distance, this.spring_length, other_node, this_node);
        Coordinates oldForce = (Coordinates)this.pendingForces.get(this_node);
        oldForce.setX(oldForce.getX() + incForce.getX());
        oldForce.setY(oldForce.getY() + incForce.getY());
        oldForce = (Coordinates)this.pendingForces.get(other_node);
        oldForce.setX(oldForce.getX() - incForce.getX());
        oldForce.setY(oldForce.getY() - incForce.getY());
    }

    public void move_nodes(List my_nodes) {
        for (int counter = 0; counter < my_nodes.size(); ++counter) {
            Node this_node = (Node)my_nodes.get(counter);
            Coordinates pending = (Coordinates)this.pendingForces.get(this_node);
            double x_movement = pending.getX() / this.node_mass;
            if (x_movement > this.max_sa_movement) {
                x_movement = this.max_sa_movement;
            } else if (x_movement < -this.max_sa_movement) {
                x_movement = -this.max_sa_movement;
            }
            double y_movement = pending.getY() / this.node_mass;
            if (y_movement > this.max_sa_movement) {
                y_movement = this.max_sa_movement;
            } else if (y_movement < -this.max_sa_movement) {
                y_movement = -this.max_sa_movement;
            }
            Coordinates loc = (Coordinates)this.locations.get(this_node);
            loc.setX(loc.getX() + x_movement);
            loc.setY(loc.getY() + y_movement);
        }
    }

    public double distance_between(Node node1, Node node2) {
        double y_difference;
        Coordinates node_one = (Coordinates)this.locations.get(node1);
        Coordinates node_two = (Coordinates)this.locations.get(node2);
        double x_difference = node_one.getX() - node_two.getX();
        double distance = Math.sqrt(x_difference * x_difference + (y_difference = node_one.getY() - node_two.getY()) * y_difference);
        if (distance < 0.0) {
            distance = -distance;
        }
        return distance;
    }

    public Coordinates determine_electric_axal_forces(double directed_force, double distance, Node otherN, Node thisN) {
        Coordinates other_node = (Coordinates)this.locations.get(otherN);
        Coordinates this_node = (Coordinates)this.locations.get(thisN);
        double y_distance = other_node.getY() - this_node.getY();
        if (y_distance < 0.0) {
            y_distance = -y_distance;
        }
        double y = -1.0 * (directed_force * y_distance / distance);
        double x_distance = other_node.getX() - this_node.getX();
        if (x_distance < 0.0) {
            x_distance = -x_distance;
        }
        double x = -1.0 * (directed_force * x_distance / distance);
        if (other_node.getX() < this_node.getX()) {
            x *= -1.0;
        }
        if (other_node.getY() < this_node.getY()) {
            y *= -1.0;
        }
        return new Coordinates(x, y);
    }

    public Coordinates determine_spring_axal_forces(double directed_force, double distance, int spring_length, Node other_node, Node this_node) {
        double x = 0.0;
        double y = 0.0;
        if (distance == (double)spring_length) {
            x = 0.0;
            y = 0.0;
        } else {
            Coordinates newDisp = this.determine_electric_axal_forces(directed_force, distance, other_node, this_node);
            x = newDisp.getX();
            y = newDisp.getY();
            if (distance < (double)spring_length) {
                x = -1.0 * x;
                y = -1.0 * y;
            }
            x = 0.5 * x;
            y = 0.5 * y;
        }
        return new Coordinates(x, y);
    }

    public void assign_layers(List nodes) {
        int i = 1;
        while (this.assign_layer(nodes, i) > 0) {
            ++i;
        }
    }

    int assign_layer(List my_nodes, int layer_number) {
        int nodes_assigned_to_this_layer = 0;
        for (int x = 0; x < my_nodes.size(); ++x) {
            Node my_node = (Node)my_nodes.get(x);
            if ((Integer)this.layer.get(my_node) < layer_number || my_node.getOutEdges().size() != 0 && !this.all_connections_in_lower_layer(my_node.getNeighbors(), layer_number)) continue;
            this.layer.put(my_node, new Integer(layer_number));
            this.min_layer = Math.min(this.min_layer, layer_number);
            this.max_layer = Math.max(this.max_layer, layer_number);
            ++nodes_assigned_to_this_layer;
        }
        int connecting_nodes_threshold = 1;
        while (nodes_assigned_to_this_layer == 0 && !this.every_node_is_in_a_layer(my_nodes)) {
            for (int x = 0; x < my_nodes.size(); ++x) {
                Node my_node = (Node)my_nodes.get(x);
                if ((Integer)this.layer.get(my_node) < layer_number || this.nodes_not_in_lower_layer(my_node.getNeighbors(), layer_number) != connecting_nodes_threshold) continue;
                this.layer.put(my_node, new Integer(layer_number));
                this.min_layer = Math.min(this.min_layer, layer_number);
                this.max_layer = Math.max(this.max_layer, layer_number);
                ++nodes_assigned_to_this_layer;
            }
            ++connecting_nodes_threshold;
        }
        return nodes_assigned_to_this_layer;
    }

    public boolean all_connections_in_lower_layer(Set s, int layer_number) {
        for (Node n : s) {
            if ((Integer)this.layer.get(n) <= layer_number) continue;
            return false;
        }
        return true;
    }

    public boolean every_node_is_in_a_layer(List my_nodes) {
        for (int i = 0; i < my_nodes.size(); ++i) {
            Node my_node = (Node)my_nodes.get(i);
            if ((Integer)this.layer.get(my_node) != 999999) continue;
            return false;
        }
        return true;
    }

    public int nodes_not_in_lower_layer(Set these_nodes, int layer_number) {
        int returnValue = 0;
        for (Node n : these_nodes) {
            if ((Integer)this.layer.get(n) < layer_number) continue;
            ++returnValue;
        }
        return returnValue;
    }

    public void gather_nodes_with_layer(List my_nodes, int which_layer) {
        Random r = new Random();
        for (int x = 0; x < my_nodes.size(); ++x) {
            Node my_node = (Node)my_nodes.get(x);
            if ((Integer)this.layer.get(my_node) <= which_layer + 1) continue;
            for (Node temp : my_node.getNeighbors()) {
                if ((Integer)this.layer.get(temp) != which_layer + 1) continue;
                Coordinates loc = (Coordinates)this.locations.get(temp);
                this.locations.put(temp, new Coordinates(my_node.getX() - 0.5 + r.nextDouble(), my_node.getY() - 0.5 + r.nextDouble()));
            }
        }
    }

    public double getX(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getX();
    }

    public double getY(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getY();
    }

    public Coordinates getCoordinates(Node v) {
        return (Coordinates)this.locations.get(v);
    }

    public boolean incrementsAreDone() {
        return this.done;
    }

    public void initialize_local_vertex(Vertex v) {
    }

    public void initialize_local() {
    }

    public boolean isIncremental() {
        return true;
    }
}

