/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Radial
extends AbstractLayout {
    protected double layerDistance = 10.0;
    Node center = null;
    Graph tree = null;
    HashSet ve = null;
    HashMap locations = new HashMap();
    private Graph graph = null;
    Hashtable coords = new Hashtable();
    Hashtable radialWidth = new Hashtable();
    HashSet seen = new HashSet();
    HashSet validEdges = new HashSet();
    public boolean done = false;

    public Radial(Graph tree, Node center, HashSet ve) {
        super((edu.uci.ics.jung.graph.Graph)tree);
        this.tree = tree;
        this.center = center;
        this.ve = ve;
        for (Node n : tree.getNodes()) {
            this.locations.put(n, new Coordinates(n.getX(), n.getY()));
        }
    }

    public Radial(Graph tree, Node center) {
        this(tree, center, null);
    }

    public Vector getNextLayerEdgesPredef(Node center) {
        Vector<Node> frontier = new Vector<Node>();
        Iterator it = center.getOutEdges().iterator();
        this.seen.add(center);
        while (it.hasNext()) {
            Node n;
            Edge e = (Edge)it.next();
            if (!this.validEdges.contains(e) || (n = (Node)e.getOpposite((Vertex)center)) == center || this.seen.contains(n)) continue;
            frontier.addElement(n);
            this.seen.add(n);
        }
        return frontier;
    }

    public Vector getNextLayer(Node center) {
        Vector<Node> frontier = new Vector<Node>();
        Iterator it = center.getOutEdges().iterator();
        this.seen.add(center);
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            Node n = (Node)e.getOpposite((Vertex)center);
            if (n == center || this.seen.contains(n)) continue;
            this.validEdges.add(e);
            frontier.addElement(n);
            this.seen.add(n);
        }
        return frontier;
    }

    public void advancePositions() {
        if (this.done) {
            return;
        }
        boolean predef = false;
        if (this.ve != null) {
            predef = true;
            this.validEdges = this.ve;
        }
        Vector front = null;
        front = !predef ? this.getNextLayer(this.center) : this.getNextLayerEdgesPredef(this.center);
        while (front.size() > 0) {
            Vector nextLayer = new Vector();
            for (int i = 0; i < front.size(); ++i) {
                if (!predef) {
                    nextLayer.addAll(this.getNextLayer((Node)front.elementAt(i)));
                    continue;
                }
                nextLayer.addAll(this.getNextLayerEdgesPredef((Node)front.elementAt(i)));
            }
            front = nextLayer;
        }
        this.seen.clear();
        for (Node n : this.tree.getNodes()) {
            this.layerDistance = Math.max(Math.max(this.layerDistance, n.getWidth() * 5.0), n.getHeight() * 5.0);
        }
        this.graph = this.tree;
        double baseX = 0.0;
        this.defineWidthProperty(this.center, null);
        double rho = 0.0;
        double alpha1 = 0.0;
        double alpha2 = Math.PI * 2;
        Point2D nodeCoord = this.polarToCartesian(rho, (alpha1 + alpha2) / 2.0, baseX);
        this.coords.put(this.center, nodeCoord);
        int centerWidth = (Integer)this.radialWidth.get(this.center);
        rho += this.layerDistance;
        for (Edge e : this.center.getOutEdges()) {
            if (!this.validEdges.contains(e)) continue;
            Node neighbor = (Node)e.getOpposite((Vertex)this.center);
            int neighborWidth = (Integer)this.radialWidth.get(neighbor);
            alpha2 = alpha1 + Math.PI * 2 * (double)neighborWidth / (double)centerWidth;
            this.RadialSubTreeUndirected(this.center, neighbor, neighborWidth, rho, alpha1, alpha2, this.tree, baseX);
            alpha1 = alpha2;
        }
        for (Node n : this.tree.getNodes()) {
            Point2D loc = (Point2D)this.coords.get(n);
            if (loc == null) continue;
            this.locations.put(n, new Coordinates(loc.getX(), loc.getY()));
        }
        this.done = true;
    }

    protected void RadialSubTreeUndirected(Node forbiddenNeighbor, Node node, double width, double rho, double alpha1, double alpha2, Graph tree, double baseX) {
        Point2D nodeCoord = this.polarToCartesian(rho, (alpha1 + alpha2) / 2.0, baseX);
        this.coords.put(node, nodeCoord);
        double tau = 2.0 * Math.acos(rho / (rho + this.layerDistance));
        double alpha = 0.0;
        double s = 0.0;
        if (tau < alpha2 - alpha1) {
            alpha = (alpha1 + alpha2 - tau) / 2.0;
            s = tau / width;
        } else {
            alpha = alpha1;
            s = (alpha2 - alpha1) / width;
        }
        for (Edge e : node.getOutEdges()) {
            Node neighbor;
            if (!this.validEdges.contains(e) || (neighbor = (Node)e.getOpposite((Vertex)node)) == forbiddenNeighbor) continue;
            int neighborWidth = (Integer)this.radialWidth.get(neighbor);
            if (neighborWidth == 0) {
                System.out.println(neighbor);
            }
            this.RadialSubTreeUndirected(node, neighbor, neighborWidth, rho + this.layerDistance, alpha, alpha += s * (double)neighborWidth, tree, baseX);
        }
    }

    private Point2D polarToCartesian(double rho, double alpha, double Xtranslation) {
        return new Point2D.Double(rho * Math.cos(alpha) + Xtranslation, rho * Math.sin(alpha));
    }

    private int defineWidthProperty(Node center, Node enteringFrom) {
        if (this.radialWidth.containsKey(center)) {
            return (Integer)this.radialWidth.get(center);
        }
        int width = 0;
        Iterator edges = center.getOutEdges().iterator();
        int validNeighbors = 0;
        while (edges.hasNext()) {
            Node goingTo;
            Edge edge = (Edge)edges.next();
            if (!this.validEdges.contains(edge) || enteringFrom == (goingTo = (Node)edge.getOpposite((Vertex)center))) continue;
            ++validNeighbors;
            width += this.defineWidthProperty(goingTo, center);
        }
        if (validNeighbors != 0) {
            this.radialWidth.put(center, new Integer(width));
            return width;
        }
        this.radialWidth.put(center, new Integer(1));
        return 1;
    }

    public double getX(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getX();
    }

    public double getY(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getY();
    }

    public Coordinates getCoordinates(Node v) {
        return (Coordinates)this.locations.get(v);
    }

    public boolean incrementsAreDone() {
        return this.done;
    }

    public void initialize_local_vertex(Vertex v) {
    }

    public void initialize_local() {
    }

    public boolean isIncremental() {
        return false;
    }
}

