/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;

public class RandomGraphLayout
extends AbstractLayout {
    private int pad = 4;
    private Set nodeList;
    private int width;
    private int height;
    private boolean update = true;
    private HashMap locations = new HashMap();
    public boolean done = false;

    public RandomGraphLayout(Graph g, int width, int height) {
        super((edu.uci.ics.jung.graph.Graph)g);
        this.width = width;
        this.height = height;
        this.nodeList = g.getNodes();
    }

    public void setPad(int p) {
        this.pad = p;
    }

    public void advancePositions() {
        if (this.done) {
            return;
        }
        Random r = new Random();
        if (this.update) {
            for (Node node : this.nodeList) {
                this.locations.put(node, new Coordinates((double)r.nextInt(this.width - this.pad), (double)r.nextInt(this.height)));
            }
        }
        this.done = true;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setUpdate(boolean doUpdate) {
        this.update = doUpdate;
    }

    public double getX(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getX();
    }

    public double getY(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getY();
    }

    public Coordinates getCoordinates(Node v) {
        return (Coordinates)this.locations.get(v);
    }

    public boolean incrementsAreDone() {
        return this.done;
    }

    public void initialize_local_vertex(Vertex v) {
    }

    public void initialize_local() {
    }

    public boolean isIncremental() {
        return false;
    }
}

