/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Rescale
extends AbstractLayout {
    private int width = 1000;
    private int height = 1000;
    private int pad = 20;
    private final boolean SQUARE = true;
    private final boolean RATIO = false;
    private boolean ltype = true;
    Graph g = null;
    HashMap locations = new HashMap();
    private double xpercent = 0.5;
    private double ypercent = 0.5;
    public boolean done = false;

    public Rescale(Graph g, int width, int height) {
        super((edu.uci.ics.jung.graph.Graph)g);
        this.width = width;
        this.height = height;
        this.g = g;
    }

    public Rescale(Graph g, double xpercent) {
        super((edu.uci.ics.jung.graph.Graph)g);
        this.g = g;
        this.ltype = false;
        this.xpercent = xpercent;
        this.ypercent = xpercent;
    }

    public Rescale(Graph g, double xpercent, double ypercent) {
        super((edu.uci.ics.jung.graph.Graph)g);
        this.g = g;
        this.ltype = false;
        this.xpercent = xpercent;
        this.ypercent = ypercent;
    }

    public void advancePositions() {
        if (this.done) {
            return;
        }
        if (this.ltype) {
            this.rescalePositions(this.g.getNodes(), this.width, this.height, 0);
        } else {
            this.rescalePositions(this.g.getNodes(), this.xpercent, this.ypercent, 0);
        }
        this.done = true;
    }

    public void rescalePositions(Set nodes, int width, int height, int pad) {
        int nNodes = nodes.size();
        if (nNodes <= 1) {
            return;
        }
        double[] xPos = new double[nNodes];
        double[] yPos = new double[nNodes];
        Node[] nlist = new Node[nNodes];
        double xMax = Double.MIN_VALUE;
        double yMax = Double.MIN_VALUE;
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        Iterator it = nodes.iterator();
        int i = 0;
        while (it.hasNext()) {
            nlist[i] = (Node)it.next();
            xPos[i] = nlist[i].getX();
            yPos[i] = nlist[i].getY();
            xMax = Math.max(xMax, xPos[i]);
            yMax = Math.max(yMax, yPos[i]);
            xMin = Math.min(xMin, xPos[i]);
            yMin = Math.min(yMin, yPos[i]);
            ++i;
        }
        for (i = 0; i < nNodes; ++i) {
            xPos[i] = (xPos[i] - xMin) / (xMax - xMin) * (double)(width - pad);
            yPos[i] = (yPos[i] - yMin) / (yMax - yMin) * (double)(height - pad);
            this.locations.put(nlist[i], new Coordinates(xPos[i], yPos[i]));
        }
    }

    public void rescalePositions(Set nodes, double xpercent, int pad) {
        this.rescalePositions(nodes, xpercent, xpercent, pad);
    }

    public void rescalePositions(Set nodes, double xpercent, double ypercent, int pad) {
        int nNodes = nodes.size();
        if (nNodes <= 1) {
            return;
        }
        double[] xPos = new double[nNodes];
        double[] yPos = new double[nNodes];
        Node[] nlist = new Node[nNodes];
        double xMax = Double.MIN_VALUE;
        double yMax = Double.MIN_VALUE;
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        Iterator it = nodes.iterator();
        int i = 0;
        while (it.hasNext()) {
            nlist[i] = (Node)it.next();
            xPos[i] = nlist[i].getX();
            yPos[i] = nlist[i].getY();
            xMax = Math.max(xMax, xPos[i]);
            yMax = Math.max(yMax, yPos[i]);
            xMin = Math.min(xMin, xPos[i]);
            yMin = Math.min(yMin, yPos[i]);
            ++i;
        }
        double width = (xMax - xMin) * xpercent;
        double height = (yMax - yMin) * ypercent;
        if (width == 0.0 || height == 0.0) {
            throw new Error("can't rescale, width or height = 0");
        }
        for (i = 0; i < nNodes; ++i) {
            xPos[i] = (xPos[i] - xMin) / (xMax - xMin) * (width - (double)pad);
            yPos[i] = (yPos[i] - yMin) / (yMax - yMin) * (height - (double)pad);
            this.locations.put(nlist[i], new Coordinates(xPos[i], yPos[i]));
        }
    }

    public double getX(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getX();
    }

    public double getY(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getY();
    }

    public Coordinates getCoordinates(Node v) {
        return (Coordinates)this.locations.get(v);
    }

    public boolean incrementsAreDone() {
        return this.done;
    }

    public void initialize_local_vertex(Vertex v) {
    }

    public void initialize_local() {
    }

    public boolean isIncremental() {
        return false;
    }

    public static void rescalePositions(Set nodes, double percent, int pad, Map locations) {
        int nNodes = nodes.size();
        if (nNodes <= 1) {
            return;
        }
        double[] xPos = new double[nNodes];
        double[] yPos = new double[nNodes];
        Node[] nlist = new Node[nNodes];
        double xMax = Double.MIN_VALUE;
        double yMax = Double.MIN_VALUE;
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        Iterator it = nodes.iterator();
        int i = 0;
        while (it.hasNext()) {
            nlist[i] = (Node)it.next();
            Coordinates c = (Coordinates)locations.get(nlist[i]);
            xPos[i] = c.getX();
            yPos[i] = c.getY();
            xMax = Math.max(xMax, xPos[i]);
            yMax = Math.max(yMax, yPos[i]);
            xMin = Math.min(xMin, xPos[i]);
            yMin = Math.min(yMin, yPos[i]);
            ++i;
        }
        double width = (xMax - xMin) * percent;
        double height = (yMax - yMin) * percent;
        if (width == 0.0 || height == 0.0) {
            throw new Error("can't rescale, width or height = 0");
        }
        for (i = 0; i < nNodes; ++i) {
            xPos[i] = (xPos[i] - xMin) / (xMax - xMin) * (width - (double)pad);
            yPos[i] = (yPos[i] - yMin) / (yMax - yMin) * (height - (double)pad);
            locations.put(nlist[i], new Coordinates(xPos[i], yPos[i]));
        }
    }

    public static void rescalePositions(Set nodes, int width, int height, Map locations) {
        int pad = 0;
        int nNodes = nodes.size();
        if (nNodes <= 1) {
            return;
        }
        double[] xPos = new double[nNodes];
        double[] yPos = new double[nNodes];
        Node[] nlist = new Node[nNodes];
        double xMax = Double.MIN_VALUE;
        double yMax = Double.MIN_VALUE;
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        Iterator it = nodes.iterator();
        int i = 0;
        while (it.hasNext()) {
            nlist[i] = (Node)it.next();
            Coordinates c = (Coordinates)locations.get(nlist[i]);
            xPos[i] = c.getX();
            yPos[i] = c.getY();
            xMax = Math.max(xMax, xPos[i]);
            yMax = Math.max(yMax, yPos[i]);
            xMin = Math.min(xMin, xPos[i]);
            yMin = Math.min(yMin, yPos[i]);
            ++i;
        }
        for (i = 0; i < nNodes; ++i) {
            xPos[i] = (xPos[i] - xMin) / (xMax - xMin) * (double)(width - pad);
            yPos[i] = (yPos[i] - yMin) / (yMax - yMin) * (double)(height - pad);
            locations.put(nlist[i], new Coordinates(xPos[i], yPos[i]));
        }
    }
}

