/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class SMDS
extends AbstractLayout {
    private static final double MIN_EIGENVALUE = 1.0E-5;
    private static int debug = 0;
    Graph g = null;
    HashMap locations = new HashMap();
    public boolean done = false;

    public SMDS(Graph g) {
        super((edu.uci.ics.jung.graph.Graph)g);
        this.g = g;
        for (Node n : g.getNodes()) {
            this.locations.put(n, new Coordinates(n.getX(), n.getY()));
        }
    }

    public void advancePositions() {
        if (this.done) {
            return;
        }
        int nodecount = this.g.getNodes().size();
        double[][] dp = new double[nodecount][nodecount];
        for (int i = 0; i < nodecount; ++i) {
            for (int j = 0; j < nodecount; ++j) {
                dp[i][j] = 1.0;
            }
        }
        Hashtable<Node, Integer> index = new Hashtable<Node, Integer>();
        ArrayList<Node> al = new ArrayList<Node>(nodecount);
        for (Edge e : this.g.getEdges()) {
            Node n2;
            Node n1 = e.getNode1();
            if (n1 == (n2 = e.getNode2())) continue;
            int i1 = 0;
            if (!index.containsKey(n1)) {
                al.add(n1);
                i1 = al.size() - 1;
                index.put(n1, new Integer(i1));
            } else {
                i1 = (Integer)index.get(n1);
            }
            int i2 = 0;
            if (!index.containsKey(n2)) {
                al.add(n2);
                i2 = al.size() - 1;
                index.put(n2, new Integer(i2));
            } else {
                i2 = (Integer)index.get(n2);
            }
            if (e instanceof UndirectedEdge) {
                dp[i1][i2] = e.edgeWeight();
                dp[i2][i1] = e.edgeWeight();
                continue;
            }
            dp[i1][i2] = e.edgeWeight();
        }
        double[][] xp = new double[nodecount][2];
        SMDS.d_to_x(nodecount, dp, xp, 2);
        for (int i = 0; i < al.size(); ++i) {
            double x = xp[i][0] * 1000.0;
            double y = xp[i][1] * 1000.0;
            Node n = (Node)al.get(i);
            Coordinates c = new Coordinates(x, y);
            this.locations.put(n, c);
        }
    }

    private static void eigensystem(double[][] ap, int n, double[][] vp, double[] dp) {
        int nrotations = SMDS.jacobi(ap, n, dp, vp);
        SMDS.eigsrt(dp, vp, n);
    }

    public static void d_to_b(int n, double[][] d, double[][] b) {
        int j;
        int i;
        double dsq = 0.0;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                dsq += d[i][j] * d[i][j];
            }
        }
        dsq /= (double)(n * n);
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                int k;
                double ai = 0.0;
                for (k = 0; k < n; ++k) {
                    ai += d[i][k] * d[i][k];
                }
                double aj = 0.0;
                for (k = 0; k < n; ++k) {
                    aj += d[k][j] * d[k][j];
                }
                double d2 = d[i][j] * d[i][j];
                b[i][j] = -0.5 * (d2 - ai / (double)n - aj / (double)n + dsq);
            }
        }
    }

    public static void b_to_x(int n, double[][] b, double[][] x, int xdim) {
        int j;
        double[][] v = new double[n][n];
        double[] d = new double[n];
        SMDS.eigensystem(b, n, v, d);
        for (j = 0; j < n; ++j) {
            if (d[j] < 1.0E-5) {
                if (debug > 0) {
                    System.err.println("truncationg eigenvalue + " + d[j] + "\n");
                }
                d[j] = 0.0;
            }
            d[j] = Math.sqrt(d[j]);
        }
        for (int i = 0; i < n; ++i) {
            for (j = 0; j < xdim; ++j) {
                x[i][j] = d[j] * v[i][j];
            }
        }
    }

    public static void dumpmat(double[][] mat, int n, int m) {
        String out = "";
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                out = "" + mat[i][j];
                if (mat[i][j] < 0.0) {
                    if (out.length() > 6) {
                        out = out.substring(0, 6);
                    }
                } else if (out.length() > 5) {
                    out = out.substring(0, 5);
                }
                System.out.print(out + "\t");
            }
            System.out.println("");
        }
        System.out.println("\n\n");
    }

    public static void dumpvec(double[] vec, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(vec[i] + "\t");
        }
        System.out.println("\n\n");
    }

    public static void d_to_x(int n, double[][] d, double[][] x, int xdim) {
        double[][] b = new double[n][n];
        if (debug > 1) {
            System.err.println("In d_to_x\n");
        }
        SMDS.d_to_b(n, d, b);
        if (debug > 1) {
            System.err.println("B:\n");
            SMDS.dumpmat(b, n, n);
        }
        SMDS.b_to_x(n, b, x, xdim);
    }

    private static int jacobi(double[][] a, int n, double[] d, double[][] v) {
        int iq;
        int ip;
        double[] b = new double[n];
        double[] z = new double[n];
        for (ip = 0; ip < n; ++ip) {
            for (iq = 0; iq < n; ++iq) {
                v[ip][iq] = 0.0;
            }
            v[ip][ip] = 1.0;
        }
        for (ip = 0; ip < n; ++ip) {
            b[ip] = d[ip] = a[ip][ip];
            z[ip] = 0.0;
        }
        int nrot = 0;
        for (int i = 0; i < 50; ++i) {
            if (debug > 1) {
                System.out.println("a");
                SMDS.dumpmat(a, n, n);
                System.out.println("v");
                SMDS.dumpmat(v, n, n);
            }
            double sm = 0.0;
            for (ip = 0; ip < n - 1; ++ip) {
                for (iq = ip + 1; iq < n; ++iq) {
                    sm += Math.abs(a[ip][iq]);
                }
            }
            if (sm == 0.0) {
                return nrot;
            }
            double tresh = i < 4 ? 0.2 * sm / (double)(n * n) : 0.0;
            for (ip = 0; ip <= n - 1; ++ip) {
                for (iq = ip + 1; iq < n; ++iq) {
                    int j;
                    double t;
                    double g = 100.0 * Math.abs(a[ip][iq]);
                    if (i > 4 && Math.abs(d[ip]) + g == Math.abs(d[ip]) && Math.abs(d[iq]) + g == Math.abs(d[iq])) {
                        a[ip][iq] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(a[ip][iq]) > tresh)) continue;
                    double h = d[iq] - d[ip];
                    if (Math.abs(h) + g == Math.abs(h)) {
                        t = a[ip][iq] / h;
                    } else {
                        double theta = 0.5 * h / a[ip][iq];
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                        if (theta < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = t * c;
                    double tau = s / (1.0 + c);
                    h = t * a[ip][iq];
                    int n2 = ip;
                    z[n2] = z[n2] - h;
                    int n3 = iq;
                    z[n3] = z[n3] + h;
                    int n4 = ip;
                    d[n4] = d[n4] - h;
                    int n5 = iq;
                    d[n5] = d[n5] + h;
                    a[ip][iq] = 0.0;
                    for (j = 0; j < ip - 1; ++j) {
                        g = a[j][ip];
                        h = a[j][iq];
                        a[j][ip] = g - s * (h + g * tau);
                        a[j][iq] = h + s * (g - h * tau);
                    }
                    for (j = ip + 1; j < iq - 1; ++j) {
                        g = a[ip][j];
                        h = a[j][iq];
                        a[ip][j] = g - s * (h + g * tau);
                        a[j][iq] = h + s * (g - h * tau);
                    }
                    for (j = iq + 1; j < n; ++j) {
                        g = a[ip][j];
                        h = a[iq][j];
                        a[ip][j] = g - s * (h + g * tau);
                        a[iq][j] = h + s * (g - h * tau);
                    }
                    for (j = 0; j < n; ++j) {
                        g = v[j][ip];
                        h = v[j][iq];
                        v[j][ip] = g - s * (h + g * tau);
                        v[j][iq] = h + s * (g - h * tau);
                    }
                    ++nrot;
                }
            }
            for (ip = 0; ip < n; ++ip) {
                int n6 = ip;
                b[n6] = b[n6] + z[ip];
                d[ip] = b[ip];
                z[ip] = 0.0;
            }
        }
        System.err.println("Too many iterations in routine JACOBI\n");
        return nrot;
    }

    private static void eigsrt(double[] d, double[][] v, int n) {
        for (int i = 0; i < n; ++i) {
            int j;
            int k = i;
            double p = d[k];
            for (j = i + 1; j < n; ++j) {
                if (!(d[j] >= p)) continue;
                k = j;
                p = d[k];
            }
            if (k == i) continue;
            d[k] = d[i];
            d[i] = p;
            for (j = 0; j < n; ++j) {
                p = v[j][i];
                v[j][i] = v[j][k];
                v[j][k] = p;
            }
        }
    }

    public double getX(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getX();
    }

    public double getY(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getY();
    }

    public Coordinates getCoordinates(Node v) {
        return (Coordinates)this.locations.get(v);
    }

    public boolean incrementsAreDone() {
        return this.done;
    }

    public void initialize_local_vertex(Vertex v) {
    }

    public void initialize_local() {
    }

    public boolean isIncremental() {
        return false;
    }
}

