/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.awt.geom.Point2D;
import java.util.HashMap;

public class Spring
extends AbstractLayout {
    public static double SPRING_NATURAL_LENGTH = 30.0;
    public static double SPRING_STIFFNESS = 150.0;
    public static double GRAVITY_REPULSION = 2.0;
    private int width = 10000;
    private int height = 10000;
    private int loops = 10000;
    private int pad = 20;
    private Graph g = null;
    private int iters = 0;
    private HashMap locations = new HashMap();
    private HashMap dxdys = new HashMap();
    public boolean done = false;

    public Spring(Graph g) {
        super((edu.uci.ics.jung.graph.Graph)g);
        this.g = g;
        for (Node n : g.getNodes()) {
            this.locations.put(n, new Coordinates(n.getX(), n.getY()));
            this.dxdys.put(n, new Coordinates(0.0, 0.0));
        }
    }

    public void advancePositions() {
        if (this.done) {
            return;
        }
        if (this.iters >= this.loops) {
            this.done = true;
            return;
        }
        long start = System.currentTimeMillis();
        for (Edge e : this.g.getEdges()) {
            Node node2;
            Node node = e.getNode1();
            if (node == (node2 = e.getNode2())) continue;
            Coordinates c1 = (Coordinates)this.locations.get(node);
            Coordinates c2 = (Coordinates)this.locations.get(node2);
            double len = Point2D.distance(c1.getX(), c1.getY(), c2.getX(), c2.getY());
            double vx = c2.getX() - c1.getX();
            double vy = c2.getY() - c1.getY();
            double f = (len - SPRING_NATURAL_LENGTH) / SPRING_STIFFNESS;
            double dx = f * vx;
            double dy = f * vy;
            Coordinates dxdy1 = (Coordinates)this.dxdys.get(node);
            dxdy1.setX(dxdy1.getX() + dx);
            dxdy1.setY(dxdy1.getY() + dy);
            dxdy1 = (Coordinates)this.dxdys.get(node2);
            dxdy1.setX(dxdy1.getX() - dx);
            dxdy1.setY(dxdy1.getY() - dy);
        }
        for (Node node : this.g.getNodes()) {
            double dx = 0.0;
            double dy = 0.0;
            Coordinates l1 = (Coordinates)this.locations.get(node);
            for (Node node2 : this.g.getNodes()) {
                double vy;
                if (node == node2) continue;
                Coordinates l2 = (Coordinates)this.locations.get(node2);
                double vx = l1.getX() - l2.getX();
                double len_sq = vx * vx + (vy = l1.getY() - l2.getY()) * vy;
                if (len_sq == 0.0) {
                    dx += Math.random();
                    dy += Math.random();
                    continue;
                }
                if (!(len_sq < 10000.0)) continue;
                dx += GRAVITY_REPULSION * vx / len_sq;
                dy += GRAVITY_REPULSION * vy / len_sq;
            }
            dy = l1.getY() > 0.0 ? (dy += GRAVITY_REPULSION / l1.getY()) : (dy += GRAVITY_REPULSION);
            dy = l1.getY() < (double)this.height ? (dy += -GRAVITY_REPULSION / ((double)this.height - l1.getY())) : (dy += -GRAVITY_REPULSION);
            dx = l1.getX() > 0.0 ? (dx += GRAVITY_REPULSION / l1.getX()) : (dx += GRAVITY_REPULSION);
            dx = l1.getX() < (double)this.width ? (dx += -GRAVITY_REPULSION / ((double)this.width - l1.getX())) : (dx += -GRAVITY_REPULSION);
            double dlen_sq = dx * dx + dy * dy;
            if (!(dlen_sq > 0.0)) continue;
            double dlen = Math.sqrt(dlen_sq) / 10.0;
            Coordinates dxdy1 = (Coordinates)this.dxdys.get(node);
            dxdy1.setX(dxdy1.getX() + dx / dlen);
            dxdy1.setY(dxdy1.getY() + dy / dlen);
        }
        for (Node node : this.g.getNodes()) {
            Coordinates l1 = (Coordinates)this.locations.get(node);
            Coordinates dxdy1 = (Coordinates)this.dxdys.get(node);
            if (dxdy1.getX() != 0.0 || dxdy1.getY() != 0.0) {
                double newX = l1.getX() + Math.max(-5.0, Math.min(5.0, dxdy1.getX())) + 1.0;
                double newY = l1.getY() + Math.max(-5.0, Math.min(5.0, dxdy1.getY())) + 1.0;
                l1.setX(newX);
                l1.setY(newY);
            }
            dxdy1.setX(dxdy1.getX() / 2.0);
            dxdy1.setY(dxdy1.getY() / 2.0);
        }
    }

    public double getX(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getX();
    }

    public double getY(Vertex n) {
        Coordinates d2d = (Coordinates)this.locations.get(n);
        return d2d.getY();
    }

    public Coordinates getCoordinates(Node v) {
        return (Coordinates)this.locations.get(v);
    }

    public boolean incrementsAreDone() {
        return this.done;
    }

    public void initialize_local_vertex(Vertex v) {
    }

    public void initialize_local() {
    }

    public boolean isIncremental() {
        return true;
    }
}

