/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import edu.uci.ics.jung.algorithms.transformation.EadesGreedyDAG;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class Sugiyama2 {
    Graph originalGraph;
    List nodeLevels;
    boolean vertical;
    protected Point spacing = new Point(250, 150);
    protected int gridAreaSize = Integer.MIN_VALUE;
    HashSet visited = new HashSet();
    HashMap wrappers = new HashMap();

    private Rectangle2D getBounds(Vertex v) {
        Node n = (Node)v.getEqualVertex((ArchetypeGraph)this.originalGraph);
        if (n == null) {
            return null;
        }
        return new Rectangle2D.Double(n.getX(), n.getY(), n.getWidth(), n.getHeight());
    }

    public Sugiyama2(Graph view) {
        Vector roots;
        this.originalGraph = view;
        this.vertical = true;
        this.originalGraph = this.originalGraph;
        DirectedGraph graph = (DirectedGraph)EadesGreedyDAG.eadesGreedyDAG((edu.uci.ics.jung.graph.Graph)this.originalGraph);
        Node[] selectedCellViews = new Node[graph.getVertices().size()];
        Iterator it = graph.getVertices().iterator();
        for (int i = 0; i < selectedCellViews.length; ++i) {
            selectedCellViews[i] = (Vertex)it.next();
        }
        Node[] dynamic_cells = selectedCellViews;
        Node[] static_cells = selectedCellViews;
        Rectangle2D.Double maxBounds = new Rectangle2D.Double();
        for (int i = 0; i < selectedCellViews.length; ++i) {
            Rectangle2D bounds = this.getBounds((Vertex)selectedCellViews[i]);
            maxBounds.setFrame(0.0, 0.0, Math.max(bounds.getWidth(), ((RectangularShape)maxBounds).getWidth()), Math.max(bounds.getHeight(), ((RectangularShape)maxBounds).getHeight()));
        }
        if (this.spacing.x == 0) {
            this.spacing.x = (int)((RectangularShape)maxBounds).getWidth();
        }
        if (this.spacing.y == 0) {
            this.spacing.y = (int)(2.0 * ((RectangularShape)maxBounds).getHeight());
        }
        if ((roots = this.searchRoots(graph, (Vertex[])selectedCellViews)).size() == 0) {
            return;
        }
        HashMap vToWrapper = new HashMap();
        Vector levels = this.fillLevels(graph, (Vertex[])selectedCellViews, roots, vToWrapper);
        ArrayList newLevels = new ArrayList();
        for (Vector lv : levels) {
            ArrayList<ArchetypeVertex> newlv = new ArrayList<ArchetypeVertex>();
            for (Vertex v : lv) {
                if (v.getEqualVertex((ArchetypeGraph)this.originalGraph) == null) continue;
                newlv.add(v.getEqualVertex((ArchetypeGraph)this.originalGraph));
            }
            newLevels.add(newlv);
        }
        this.layout(newLevels, this.vertical);
    }

    protected Vector searchRoots(DirectedGraph jgraph, Vertex[] selectedCellViews) {
        int i;
        Vector<Vertex> vertexViews = new Vector<Vertex>(selectedCellViews.length);
        Vector<Vertex> roots = new Vector<Vertex>();
        for (i = 0; i < selectedCellViews.length; ++i) {
            this.visited.remove(selectedCellViews[i]);
            vertexViews.add(selectedCellViews[i]);
        }
        for (i = 0; i < vertexViews.size(); ++i) {
            Vertex vertexView = (Vertex)vertexViews.get(i);
            Set inEdges = vertexView.getInEdges();
            if (inEdges.size() != 0) continue;
            roots.add(vertexView);
        }
        if (roots.size() == 0) {
            throw new IllegalArgumentException("The Graph is not a DAG. Can't use Sugiyama Algorithm!");
        }
        return roots;
    }

    protected Vector fillLevels(DirectedGraph jgraph, Vertex[] selectedCellViews, Vector rootNodes, HashMap vToL) {
        Vector levels = new Vector();
        for (int i = 0; i < selectedCellViews.length; ++i) {
            Vertex cellView = selectedCellViews[i];
            if (cellView == null) continue;
            this.visited.remove(cellView);
        }
        Enumeration enumRoots = rootNodes.elements();
        while (enumRoots.hasMoreElements()) {
            Vertex vertexView = (Vertex)enumRoots.nextElement();
            this.fillLevels(jgraph, levels, 0, vertexView, vToL);
        }
        return levels;
    }

    protected void fillLevels(DirectedGraph jgraph, Vector levels, int level, Vertex vertexView, HashMap vToL) {
        if (vertexView == null) {
            return;
        }
        if (levels.size() == level) {
            levels.insertElementAt(new Vector(), level);
        }
        if (this.visited.contains(vertexView)) {
            return;
        }
        this.visited.add(vertexView);
        Vector vecForTheCurrentLevel = (Vector)levels.get(level);
        int numberForTheEntry = vecForTheCurrentLevel.size();
        vecForTheCurrentLevel.add(vertexView);
        for (DirectedEdge e : vertexView.getOutEdges()) {
            Vertex n2;
            Vertex n1 = e.getSource();
            if (n1 == (n2 = e.getDest())) continue;
            Vertex targetVertex = null;
            targetVertex = vertexView == n1 ? n2 : n1;
            this.fillLevels(jgraph, levels, level + 1, targetVertex, vToL);
        }
        if (vecForTheCurrentLevel.size() > this.gridAreaSize) {
            this.gridAreaSize = vecForTheCurrentLevel.size();
        }
    }

    public void setNodeLevels(List levels) {
        this.nodeLevels = levels;
    }

    public void layout(List levels, boolean vertical) {
        if (levels != null) {
            Iterator outer = levels.iterator();
            int i = 0;
            int j = 0;
            while (outer.hasNext()) {
                List list = (List)outer.next();
                Iterator inner = list.iterator();
                j = 0;
                while (inner.hasNext()) {
                    Node node = (Node)inner.next();
                    System.err.println("In list #" + i + ", inner Node #" + j + " is named: " + node);
                    ++j;
                }
                ++i;
            }
            this.nodeLevels = levels;
            this.vertical = vertical;
            this.layout();
        } else {
            System.err.println("In Sugiyama, list of list of nodes == null");
        }
    }

    public void layout() {
        Iterator level_iterator = this.nodeLevels.iterator();
        double major = 0.0;
        int numLevels = this.nodeLevels.size();
        for (int i = 0; i < numLevels; ++i) {
            List nextTier;
            List thisTier;
            if (i == numLevels - 1) {
                thisTier = (List)this.nodeLevels.get(i);
                nextTier = null;
            } else {
                thisTier = (List)this.nodeLevels.get(i);
                nextTier = (List)this.nodeLevels.get(i + 1);
            }
            System.err.println("tier = " + i);
            this.layoutLevel(thisTier, nextTier, major);
            major += 200.0;
        }
        level_iterator = this.nodeLevels.iterator();
        while (level_iterator.hasNext()) {
            this.layoutBends((List)level_iterator.next());
        }
    }

    public void layoutBends(List nodes) {
        for (Node from : nodes) {
            for (Node to : from.getNeighbors()) {
                if (nodes.contains(to)) continue;
                double from_x = from.getX();
                double from_y = from.getY();
                double to_x = to.getX();
                double to_y = to.getY();
                double from_width = from.getWidth();
                double from_height = from.getHeight();
                double to_width = to.getWidth();
                double to_height = to.getHeight();
                double mid_x = Math.abs(from_x + to_x) / 2.0;
                double mid_y = Math.abs(from_y + to_y) / 2.0;
                Iterator eit = from.getOutEdges().iterator();
                GeneralPath gp = new GeneralPath();
                while (eit.hasNext()) {
                    Point2D.Double to_point;
                    Point2D.Double from_point;
                    Edge edge_view = (Edge)eit.next();
                    if (!this.vertical) {
                        if (to_y > from_y) {
                            from_point = new Point2D.Double(mid_x + from_x + from_width / 2.0, mid_y + from_height / 2.0);
                            to_point = new Point2D.Double(mid_x + to_width / 2.0, mid_y + to_height / 2.0);
                        } else {
                            from_point = new Point2D.Double(mid_x + from_x + from_width / 2.0, mid_y + from_height / 2.0);
                            to_point = new Point2D.Double(mid_x + to_width / 2.0, mid_y + to_height / 2.0);
                        }
                    } else if (to_x > from_x) {
                        from_point = new Point2D.Double(mid_x + from_x + from_width / 2.0, mid_y + from_height / 2.0);
                        to_point = new Point2D.Double(mid_x + to_width / 2.0, mid_y + to_height / 2.0);
                    } else {
                        from_point = new Point2D.Double(mid_x + from_x + from_width / 2.0, mid_y + from_height / 2.0);
                        to_point = new Point2D.Double(mid_x + to_width / 2.0, mid_y + to_height / 2.0);
                    }
                    System.out.println(edge_view + " " + to_point);
                    gp.moveTo((float)(from.getX() + from.getWidth() / 2.0), (float)(from.getY() + from.getHeight() / 2.0));
                    gp.lineTo((float)(to.getX() + to.getWidth() / 2.0), (float)(to.getY() + to.getHeight() / 2.0));
                }
            }
        }
    }

    public void layoutLevel(List nodes, List children, double major) {
        Iterator member_iterator = nodes.iterator();
        Node node_view = null;
        double minor = 0.0;
        double loop = 1.0;
        double prevWidth = 0.0;
        int compWidth = 200;
        System.err.println("compWidth = " + compWidth);
        if (children != null) {
            System.err.println("children != null");
            boolean allHaveChildren = true;
            int numChildlessNodes = 0;
            while (member_iterator.hasNext()) {
                Node thisNode = (Node)member_iterator.next();
                System.err.println("currently checking Node " + thisNode + " for children");
                Iterator childIterator = children.iterator();
                boolean hasChild = false;
                while (childIterator.hasNext()) {
                    Node child = (Node)childIterator.next();
                    System.err.println("\tchecking node " + child);
                    if (thisNode.findEdge((Vertex)child) == null) continue;
                    System.err.println("\t" + thisNode + " is " + child + "'s parent");
                    hasChild = true;
                }
                if (hasChild) continue;
                allHaveChildren = false;
                ++numChildlessNodes;
            }
            if (allHaveChildren) {
                System.err.println("allHaveChildren == true");
                int numChildren = children.size();
                member_iterator = nodes.iterator();
                while (member_iterator.hasNext()) {
                    Iterator childrenIterator = children.iterator();
                    Node parent = (Node)member_iterator.next();
                    int childCount = 0;
                    while (childrenIterator.hasNext()) {
                        Node child = (Node)childrenIterator.next();
                        if (parent.findEdge((Vertex)child) == null) continue;
                        ++childCount;
                    }
                    System.err.println("Node " + parent + " has " + childCount + " children");
                    double widthFactor = (double)childCount / (double)numChildren;
                    double nodeSpaceWidth = widthFactor * (double)compWidth;
                    double midpoint = nodeSpaceWidth / 2.0;
                    minor = prevWidth + midpoint;
                    System.err.println("widthFactor = " + widthFactor + "\tnodeSpaceWidth = " + nodeSpaceWidth);
                    System.err.println("midpoint = " + midpoint + "\tminor = " + minor);
                    node_view = parent;
                    if (!this.vertical) {
                        node_view.setX(major);
                        node_view.setY(minor);
                    } else {
                        double nodeWidth = node_view.getWidth();
                        node_view.setX(minor - nodeWidth / 2.0);
                        node_view.setY(major);
                    }
                    System.err.println("new prevWidth = " + (prevWidth += nodeSpaceWidth));
                    System.err.println("--------------------------------");
                }
            } else {
                System.err.println("allHaveChildren == false");
                for (Node parent : nodes) {
                    int numChildren = children.size();
                    double numNodes = (double)numChildlessNodes + (double)numChildren;
                    double widthFactor = 1.0 / numNodes;
                    System.err.println("***there are " + children.size() + " children, and " + numChildlessNodes + " childless nodes");
                    System.err.println("***numNodes = " + numNodes);
                    double nodeSpaceWidth = widthFactor * (double)compWidth;
                    double midpoint = nodeSpaceWidth / 2.0;
                    minor = prevWidth + midpoint;
                    System.err.println("widthFactor = " + widthFactor + "\tnodeSpaceWidth = " + nodeSpaceWidth);
                    System.err.println("midpoint = " + midpoint + "\tminor = " + minor);
                    node_view = parent;
                    if (!this.vertical) {
                        node_view.setX(major);
                        node_view.setY(minor);
                    } else {
                        double nodeWidth = node_view.getWidth();
                        node_view.setX(minor - nodeWidth / 2.0);
                        node_view.setY(major);
                    }
                    System.err.println("new prevWidth = " + (prevWidth += nodeSpaceWidth));
                    System.err.println("--------------------------------");
                }
            }
        } else {
            System.err.println("Children == null");
            int numNodes = nodes.size();
            while (member_iterator.hasNext()) {
                Node n;
                node_view = n = (Node)member_iterator.next();
                minor = loop / (double)(numNodes + 1) * (double)compWidth;
                System.err.println("numNodes = " + numNodes + "\twidth = " + compWidth + "\tminor = " + minor);
                if (!this.vertical) {
                    node_view.setX(major);
                    node_view.setY(minor);
                } else {
                    node_view.setX(minor);
                    node_view.setY(major);
                }
                loop += 1.0;
            }
        }
    }
}

