/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.layout;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.piccolo.GuessPEdge;
import com.hp.hpl.guess.ui.ExceptionWindow;
import edu.uci.ics.jung.algorithms.transformation.EadesGreedyDAG;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.SimpleSparseVertex;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SugiyamaLayout {
    public static final String SUGIYAMA_VISITED = "SugiyamaVisited";
    public static final String SUGIYAMA_CELL_WRAPPER = "SugiyamaCellWrapper";
    protected int gridAreaSize = Integer.MIN_VALUE;
    Vector movements = null;
    int movementsCurrentLoop = -1;
    int movementsMax = Integer.MIN_VALUE;
    int iteration = 0;
    protected boolean vertical = true;
    protected Point spacing = new Point(250, 150);
    private Graph originalGraph = null;
    HashMap vToWrapper = new HashMap();
    HashSet visited = new HashSet();
    HashMap wrappers = new HashMap();

    public String toString() {
        return "Sugiyama";
    }

    public String getHint() {
        return "Ignores selection";
    }

    private Rectangle2D getBounds(Vertex v) {
        Node n = (Node)v.getEqualVertex((ArchetypeGraph)this.originalGraph);
        if (n == null) {
            return null;
        }
        return new Rectangle2D.Double(n.getX(), n.getY(), n.getWidth(), n.getHeight());
    }

    public SugiyamaLayout(Graph originalGraph, boolean bends) {
        Vector roots;
        this.originalGraph = originalGraph;
        DirectedGraph graph = (DirectedGraph)EadesGreedyDAG.eadesGreedyDAG((edu.uci.ics.jung.graph.Graph)originalGraph);
        Node[] selectedCellViews = new Node[graph.getVertices().size()];
        Iterator<Object> it = graph.getVertices().iterator();
        for (int i = 0; i < selectedCellViews.length; ++i) {
            selectedCellViews[i] = (Vertex)it.next();
        }
        Node[] dynamic_cells = selectedCellViews;
        Node[] static_cells = selectedCellViews;
        Rectangle2D.Double maxBounds = new Rectangle2D.Double();
        for (int i = 0; i < selectedCellViews.length; ++i) {
            Rectangle2D bounds = this.getBounds((Vertex)selectedCellViews[i]);
            maxBounds.setFrame(0.0, 0.0, Math.max(bounds.getWidth(), ((RectangularShape)maxBounds).getWidth()), Math.max(bounds.getHeight(), ((RectangularShape)maxBounds).getHeight()));
        }
        if (this.spacing.x == 0) {
            this.spacing.x = (int)((RectangularShape)maxBounds).getWidth();
        }
        if (this.spacing.y == 0) {
            this.spacing.y = (int)(2.0 * ((RectangularShape)maxBounds).getHeight());
        }
        if ((roots = this.searchRoots(graph, (Vertex[])selectedCellViews)).size() == 0) {
            return;
        }
        Vector levels = this.fillLevels(graph, (Vertex[])selectedCellViews, roots, this.vToWrapper);
        HashMap edgeToFunkyPath = new HashMap();
        if (bends) {
            int lev = 0;
            it = levels.iterator();
            Vector<CellWrapper> toAdd = new Vector<CellWrapper>();
            while (it.hasNext()) {
                Vector curLev = (Vector)it.next();
                for (CellWrapper cw : curLev) {
                    Vertex topV = cw.getNode();
                    HashSet tempSet = new HashSet();
                    tempSet.addAll(topV.getOutEdges());
                    for (DirectedEdge e : tempSet) {
                        int botLev;
                        Vertex botV = e.getDest();
                        if (!this.vToWrapper.containsKey(botV) || (botLev = ((CellWrapper)this.vToWrapper.get((Object)botV)).level) <= lev + 1) continue;
                        Vector<DirectedSparseEdge> funky = new Vector<DirectedSparseEdge>();
                        graph.removeEdge((edu.uci.ics.jung.graph.Edge)e);
                        Vertex prev = topV;
                        for (int i = lev + 1; i < botLev; ++i) {
                            SimpleSparseVertex dummy = new SimpleSparseVertex();
                            Vector levToMod = (Vector)levels.elementAt(i);
                            int vSi = levToMod.size();
                            CellWrapper newCW = new CellWrapper(i, vSi, (Vertex)dummy, true);
                            this.vToWrapper.put(dummy, newCW);
                            levToMod.add(newCW);
                            toAdd.insertElementAt(newCW, 0);
                            graph.addVertex((Vertex)dummy);
                            DirectedSparseEdge dse = new DirectedSparseEdge(prev, (Vertex)dummy);
                            graph.addEdge((edu.uci.ics.jung.graph.Edge)dse);
                            prev = dummy;
                            funky.addElement(dse);
                        }
                        DirectedSparseEdge dse = new DirectedSparseEdge(prev, botV);
                        graph.addEdge((edu.uci.ics.jung.graph.Edge)dse);
                        funky.addElement(dse);
                        edgeToFunkyPath.put(e, funky);
                    }
                }
                ++lev;
            }
        }
        this.solveEdgeCrosses(graph, levels);
        this.moveToBarycenter(graph, (Vertex[])selectedCellViews, levels);
        Point min = this.findMinimumAndSpacing((Vertex[])selectedCellViews, this.spacing);
        this.drawGraph(graph, levels, min, this.spacing);
        this.shiftLayers(levels);
        for (DirectedSparseEdge dse : edgeToFunkyPath.keySet()) {
            DirectedEdge de;
            Vertex nxt;
            CellWrapper cw;
            Node dest;
            Vector path = (Vector)edgeToFunkyPath.get(dse);
            DirectedSparseEdge first = (DirectedSparseEdge)path.elementAt(0);
            DirectedSparseEdge last = (DirectedSparseEdge)path.elementAt(path.size() - 1);
            Node source = (Node)first.getSource().getEqualVertex((ArchetypeGraph)originalGraph);
            Edge originalEdge = (Edge)source.findEdge((Vertex)(dest = (Node)last.getDest().getEqualVertex((ArchetypeGraph)originalGraph)));
            if (originalEdge == null) {
                originalEdge = (Edge)dest.findEdge((Vertex)source);
            }
            GeneralPath gp = new GeneralPath();
            gp.moveTo((float)(source.getX() + source.getWidth() / 2.0), (float)(source.getY() + source.getHeight() / 2.0));
            Iterator pathIt = path.iterator();
            while (pathIt.hasNext() && (cw = (CellWrapper)this.vToWrapper.get(nxt = (de = (DirectedEdge)pathIt.next()).getDest())) != null) {
                gp.lineTo((float)cw.x, (float)cw.y);
            }
            gp.lineTo((float)(dest.getX() + dest.getWidth() / 2.0), (float)(dest.getY() + dest.getHeight() / 2.0));
            ((GuessPEdge)originalEdge.getRep()).setShape(gp);
        }
    }

    public void shiftLayers(Vector levels) {
        int j;
        double cur;
        double sign;
        double left;
        double right;
        double amtShifted;
        double prev;
        Vector curLayer;
        int i;
        for (i = 0; i < levels.size(); ++i) {
            curLayer = (Vector)levels.elementAt(i);
            prev = this.averageTension(curLayer);
            this.shiftLayer(curLayer, 5.0);
            amtShifted = 5.0;
            right = this.averageTension(curLayer);
            this.shiftLayer(curLayer, -10.0);
            amtShifted += -10.0;
            left = this.averageTension(curLayer);
            sign = 1.0;
            if (left < right) {
                sign *= -1.0;
            }
            cur = prev;
            while (true) {
                this.shiftLayer(curLayer, sign * 5.0);
                amtShifted += sign * 5.0;
                cur = this.averageTension(curLayer);
                if (cur > prev) {
                    this.shiftLayer(curLayer, sign * -1.0 * 5.0);
                    amtShifted += -1.0 * sign * 5.0;
                    break;
                }
                prev = cur;
            }
            for (j = i - 1; j >= 0; --j) {
                curLayer = (Vector)levels.elementAt(j);
                this.shiftLayer(curLayer, amtShifted);
            }
        }
        for (i = levels.size() - 1; i > 0; --i) {
            curLayer = (Vector)levels.elementAt(i);
            prev = this.averageTension(curLayer);
            this.shiftLayer(curLayer, 5.0);
            amtShifted = 5.0;
            right = this.averageTension(curLayer);
            this.shiftLayer(curLayer, -10.0);
            amtShifted += -10.0;
            left = this.averageTension(curLayer);
            sign = 1.0;
            if (left < right) {
                sign *= -1.0;
            }
            cur = prev;
            while (true) {
                this.shiftLayer(curLayer, sign * 5.0);
                amtShifted += sign * 5.0;
                cur = this.averageTension(curLayer);
                if (cur > prev) {
                    this.shiftLayer(curLayer, sign * -1.0 * 5.0);
                    amtShifted += -1.0 * sign * 5.0;
                    break;
                }
                prev = cur;
            }
            for (j = i + 1; j < levels.size(); ++j) {
                curLayer = (Vector)levels.elementAt(j);
                this.shiftLayer(curLayer, amtShifted);
            }
        }
        for (CellWrapper cw : this.vToWrapper.values()) {
            Vertex v = (Vertex)cw.getNode().getEqualVertex((ArchetypeGraph)this.originalGraph);
            if (v == null) continue;
            ((Node)v).setX(cw.x);
            ((Node)v).setY(cw.y);
        }
    }

    public void shiftLayer(Vector curLayer, double inc) {
        if (curLayer == null) {
            return;
        }
        for (int n = 0; n < curLayer.size(); ++n) {
            CellWrapper nh = (CellWrapper)curLayer.elementAt(n);
            nh.x += inc;
        }
    }

    public double averageTension(Vector curLayer) {
        int segments = 0;
        double totallength = 0.0;
        for (int n = 0; n < curLayer.size(); ++n) {
            CellWrapper nh = (CellWrapper)curLayer.elementAt(n);
            Vertex v = nh.getNode();
            Iterator it = v.getNeighbors().iterator();
            while (it.hasNext()) {
                CellWrapper neig = (CellWrapper)this.vToWrapper.get(it.next());
                if (neig == null) continue;
                double length = Math.sqrt((nh.x - neig.x) * (nh.x - neig.x) + (nh.y - neig.y) * (nh.y - neig.y));
                totallength += length;
                ++segments;
            }
        }
        if (segments == 0) {
            return 0.0;
        }
        return totallength / (double)segments;
    }

    protected Vector searchRoots(DirectedGraph jgraph, Vertex[] selectedCellViews) {
        int i;
        Vector<Vertex> vertexViews = new Vector<Vertex>(selectedCellViews.length);
        Vector<Vertex> roots = new Vector<Vertex>();
        for (i = 0; i < selectedCellViews.length; ++i) {
            this.visited.remove(selectedCellViews[i]);
            vertexViews.add(selectedCellViews[i]);
        }
        for (i = 0; i < vertexViews.size(); ++i) {
            Vertex vertexView = (Vertex)vertexViews.get(i);
            Set inEdges = vertexView.getInEdges();
            if (inEdges.size() != 0) continue;
            roots.add(vertexView);
        }
        if (roots.size() == 0) {
            throw new IllegalArgumentException("The Graph is not a DAG. Can't use Sugiyama Algorithm!");
        }
        return roots;
    }

    protected Vector fillLevels(DirectedGraph jgraph, Vertex[] selectedCellViews, Vector rootNodes, HashMap vToL) {
        Vector levels = new Vector();
        for (int i = 0; i < selectedCellViews.length; ++i) {
            Vertex cellView = selectedCellViews[i];
            if (cellView == null) continue;
            this.visited.remove(cellView);
        }
        Enumeration enumRoots = rootNodes.elements();
        while (enumRoots.hasMoreElements()) {
            Vertex vertexView = (Vertex)enumRoots.nextElement();
            this.fillLevels(jgraph, levels, 0, vertexView, vToL);
        }
        return levels;
    }

    protected void fillLevels(DirectedGraph jgraph, Vector levels, int level, Vertex vertexView, HashMap vToL) {
        if (vertexView == null) {
            return;
        }
        if (levels.size() == level) {
            levels.insertElementAt(new Vector(), level);
        }
        if (this.visited.contains(vertexView)) {
            return;
        }
        this.visited.add(vertexView);
        Vector vecForTheCurrentLevel = (Vector)levels.get(level);
        int numberForTheEntry = vecForTheCurrentLevel.size();
        CellWrapper wrapper = new CellWrapper(level, numberForTheEntry, vertexView);
        vToL.put(vertexView, wrapper);
        vecForTheCurrentLevel.add(wrapper);
        this.wrappers.put(vertexView, wrapper);
        for (DirectedEdge e : vertexView.getOutEdges()) {
            Vertex n2;
            Vertex n1 = e.getSource();
            if (n1 == (n2 = e.getDest())) continue;
            Vertex targetVertex = null;
            targetVertex = vertexView == n1 ? n2 : n1;
            this.fillLevels(jgraph, levels, level + 1, targetVertex, vToL);
        }
        if (vecForTheCurrentLevel.size() > this.gridAreaSize) {
            this.gridAreaSize = vecForTheCurrentLevel.size();
        }
    }

    protected Point findMinimumAndSpacing(Vertex[] graphCellViews, Point spacing) {
        try {
            int min_x = 1000000;
            int min_y = 1000000;
            for (int i = 0; i < graphCellViews.length; ++i) {
                Vertex cellView = graphCellViews[i];
                if (cellView == null) continue;
                Rectangle2D cellViewBounds = this.getBounds(cellView);
                try {
                    if ((int)cellViewBounds.getX() < min_x) {
                        min_x = (int)cellViewBounds.getX();
                    }
                    if ((int)cellViewBounds.getY() >= min_y) continue;
                    min_y = (int)cellViewBounds.getY();
                    continue;
                }
                catch (Exception e) {
                    ExceptionWindow.getExceptionWindow(e);
                }
            }
            return new Point(min_x, min_y);
        }
        catch (Exception e) {
            ExceptionWindow.getExceptionWindow(e);
            return null;
        }
    }

    protected void updateProgress4Movements() {
        this.movements.add(new Integer(this.movementsCurrentLoop));
        ++this.iteration;
        if (this.movementsCurrentLoop > this.movementsMax) {
            this.movementsMax = this.movementsCurrentLoop;
        }
    }

    protected void solveEdgeCrosses(DirectedGraph jgraph, Vector levels) {
        this.movements = new Vector(100);
        this.movementsCurrentLoop = -1;
        this.movementsMax = Integer.MIN_VALUE;
        this.iteration = 0;
        while (this.movementsCurrentLoop != 0) {
            int i;
            this.movementsCurrentLoop = 0;
            for (i = 0; i < levels.size() - 1; ++i) {
                this.movementsCurrentLoop += this.solveEdgeCrosses(jgraph, true, levels, i);
            }
            for (i = levels.size() - 1; i >= 1; --i) {
                this.movementsCurrentLoop += this.solveEdgeCrosses(jgraph, false, levels, i);
            }
            this.updateProgress4Movements();
        }
    }

    protected int solveEdgeCrosses(DirectedGraph jgraph, boolean down, Vector levels, int levelIndex) {
        int j;
        Vector currentLevel = (Vector)levels.get(levelIndex);
        int movements = 0;
        Object[] levelSortBefore = currentLevel.toArray();
        Collections.sort(currentLevel);
        for (j = 0; j < levelSortBefore.length; ++j) {
            if (((CellWrapper)levelSortBefore[j]).getEdgeCrossesIndicator() == ((CellWrapper)currentLevel.get(j)).getEdgeCrossesIndicator()) continue;
            ++movements;
        }
        for (j = currentLevel.size() - 1; j >= 0; --j) {
            CellWrapper sourceWrapper = (CellWrapper)currentLevel.get(j);
            Vertex sourceView = sourceWrapper.getNode();
            for (DirectedEdge e : sourceView.getOutEdges()) {
                Vertex n2;
                Vertex n1 = e.getSource();
                if (n1 == (n2 = e.getDest())) continue;
                Vertex targetVertex = null;
                targetVertex = sourceView == n1 ? n2 : n1;
                CellWrapper targetWrapper = (CellWrapper)this.wrappers.get(targetVertex);
                if (down && targetWrapper != null && targetWrapper.getLevel() > levelIndex) {
                    targetWrapper.addToEdgeCrossesIndicator(sourceWrapper.getEdgeCrossesIndicator());
                }
                if (down || targetWrapper == null || targetWrapper.getLevel() >= levelIndex) continue;
                targetWrapper.addToEdgeCrossesIndicator(sourceWrapper.getEdgeCrossesIndicator());
            }
        }
        return movements;
    }

    protected void moveToBarycenter(DirectedGraph jgraph, Vertex[] allSelectedViews, Vector levels) {
        int i;
        for (i = 0; i < allSelectedViews.length; ++i) {
            Vertex vertexView = allSelectedViews[i];
            CellWrapper currentwrapper = (CellWrapper)this.wrappers.get(vertexView);
            for (DirectedEdge e : vertexView.getOutEdges()) {
                Vertex n2;
                Vertex n1 = e.getSource();
                if (n1 == (n2 = e.getDest())) continue;
                Vertex neighborVertex = null;
                neighborVertex = vertexView == n1 ? n2 : n1;
                if (neighborVertex == null || neighborVertex == vertexView) continue;
                CellWrapper neighborWrapper = (CellWrapper)this.wrappers.get(neighborVertex);
                if (currentwrapper == null || neighborWrapper == null || currentwrapper.level == neighborWrapper.level) continue;
                ++currentwrapper.priority;
            }
        }
        for (int j = 0; j < levels.size(); ++j) {
            Vector level = (Vector)levels.get(j);
            for (int i2 = 0; i2 < level.size(); ++i2) {
                CellWrapper wrapper = (CellWrapper)level.get(i2);
                wrapper.setGridPosition(i2);
            }
        }
        this.movements = new Vector(100);
        this.movementsCurrentLoop = -1;
        this.movementsMax = Integer.MIN_VALUE;
        this.iteration = 0;
        while (this.movementsCurrentLoop != 0) {
            this.movementsCurrentLoop = 0;
            for (i = 1; i < levels.size(); ++i) {
                this.movementsCurrentLoop += this.moveToBarycenter(jgraph, levels, i);
            }
            for (i = levels.size() - 1; i >= 0; --i) {
                this.movementsCurrentLoop += this.moveToBarycenter(jgraph, levels, i);
            }
            this.updateProgress4Movements();
        }
    }

    protected int moveToBarycenter(DirectedGraph jgraph, Vector levels, int levelIndex) {
        int movements = 0;
        Vector currentLevel = (Vector)levels.get(levelIndex);
        for (int currentIndexInTheLevel = 0; currentIndexInTheLevel < currentLevel.size(); ++currentIndexInTheLevel) {
            CellWrapper sourceWrapper = (CellWrapper)currentLevel.get(currentIndexInTheLevel);
            float gridPositionsSum = 0.0f;
            float countNodes = 0.0f;
            Vertex vertexView = sourceWrapper.getNode();
            for (DirectedEdge e : vertexView.getOutEdges()) {
                CellWrapper targetWrapper;
                Vertex n2;
                Vertex n1 = e.getSource();
                if (n1 == (n2 = e.getDest())) continue;
                Vertex neighborVertex = null;
                neighborVertex = vertexView == n1 ? n2 : n1;
                if (neighborVertex == null || (targetWrapper = (CellWrapper)this.wrappers.get(neighborVertex)) == sourceWrapper || targetWrapper == null || targetWrapper.getLevel() == levelIndex) continue;
                gridPositionsSum += (float)targetWrapper.getGridPosition();
                countNodes += 1.0f;
            }
            if (!(countNodes > 0.0f)) continue;
            float tmp = gridPositionsSum / countNodes;
            int newGridPosition = Math.round(tmp);
            boolean toRight = newGridPosition > sourceWrapper.getGridPosition();
            boolean moved = true;
            while (newGridPosition != sourceWrapper.getGridPosition() && moved) {
                int tmpGridPos = sourceWrapper.getGridPosition();
                moved = this.move(toRight, currentLevel, currentIndexInTheLevel, sourceWrapper.getPriority());
                if (!moved) continue;
                ++movements;
            }
        }
        return movements;
    }

    protected boolean move(boolean toRight, Vector currentLevel, int currentIndexInTheLevel, int currentPriority) {
        CellWrapper currentWrapper = (CellWrapper)currentLevel.get(currentIndexInTheLevel);
        boolean moved = false;
        int neighborIndexInTheLevel = currentIndexInTheLevel + (toRight ? 1 : -1);
        int newGridPosition = currentWrapper.getGridPosition() + (toRight ? 1 : -1);
        if (0 > newGridPosition || newGridPosition >= this.gridAreaSize) {
            return false;
        }
        if (toRight && currentIndexInTheLevel == currentLevel.size() - 1 || !toRight && currentIndexInTheLevel == 0) {
            moved = true;
        } else {
            CellWrapper neighborWrapper = (CellWrapper)currentLevel.get(neighborIndexInTheLevel);
            int neighborPriority = neighborWrapper.getPriority();
            if (neighborWrapper.getGridPosition() == newGridPosition) {
                if (neighborPriority >= currentPriority) {
                    return false;
                }
                moved = this.move(toRight, currentLevel, neighborIndexInTheLevel, currentPriority);
            } else {
                moved = true;
            }
        }
        if (moved) {
            currentWrapper.setGridPosition(newGridPosition);
        }
        return moved;
    }

    protected HashMap drawGraph(DirectedGraph jgraph, Vector levels, Point min, Point spacing) {
        Hashtable viewMap = new Hashtable();
        HashMap dummyLocs = new HashMap();
        for (int rowCellCount = 0; rowCellCount < levels.size(); ++rowCellCount) {
            Vector level = (Vector)levels.get(rowCellCount);
            for (int colCellCount = 0; colCellCount < level.size(); ++colCellCount) {
                CellWrapper wrapper = (CellWrapper)level.get(colCellCount);
                Vertex view = wrapper.vertexView;
                if (view == null) continue;
                Rectangle2D rect = this.getBounds(view);
                if (rect == null) {
                    rect = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
                }
                Rectangle bounds = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
                bounds.x = min.x + spacing.x * (this.vertical ? wrapper.getGridPosition() : rowCellCount);
                bounds.y = min.y + spacing.y * (this.vertical ? rowCellCount : wrapper.getGridPosition());
                wrapper.x = bounds.x;
                wrapper.y = bounds.y;
                Vertex vx = (Vertex)view.getEqualVertex((ArchetypeGraph)this.originalGraph);
                if (vx == null) continue;
                ((Node)vx).setX(bounds.x);
                ((Node)vx).setY(bounds.y);
            }
        }
        return dummyLocs;
    }

    public Point getSpacing() {
        return this.spacing;
    }

    public void setSpacing(Point spacing) {
        this.spacing = spacing;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    class CellWrapper
    implements Comparable {
        private double edgeCrossesIndicator = 0.0;
        private int additions = 0;
        int level = 0;
        int gridPosition = 0;
        int priority = 0;
        Vertex vertexView = null;
        boolean dummy = false;
        public double x = 0.0;
        public double y = 0.0;

        CellWrapper(int level, double edgeCrossesIndicator, Vertex vertexView) {
            this(level, edgeCrossesIndicator, vertexView, false);
        }

        CellWrapper(int level, double edgeCrossesIndicator, Vertex vertexView, boolean dummy) {
            this.level = level;
            this.edgeCrossesIndicator = edgeCrossesIndicator;
            this.vertexView = vertexView;
            ++this.additions;
            this.dummy = dummy;
        }

        Vertex getNode() {
            return this.vertexView;
        }

        void resetEdgeCrossesIndicator() {
            this.edgeCrossesIndicator = 0.0;
            this.additions = 0;
        }

        double getEdgeCrossesIndicator() {
            if (this.additions == 0) {
                return 0.0;
            }
            return this.edgeCrossesIndicator / (double)this.additions;
        }

        void addToEdgeCrossesIndicator(double addValue) {
            this.edgeCrossesIndicator += addValue;
            ++this.additions;
        }

        int getLevel() {
            return this.level;
        }

        int getGridPosition() {
            return this.gridPosition;
        }

        void setGridPosition(int pos) {
            this.gridPosition = pos;
        }

        void incrementPriority() {
            ++this.priority;
        }

        int getPriority() {
            return this.priority;
        }

        public int compareTo(Object compare) {
            if (((CellWrapper)compare).getEdgeCrossesIndicator() == this.getEdgeCrossesIndicator()) {
                return 0;
            }
            double compareValue = ((CellWrapper)compare).getEdgeCrossesIndicator() - this.getEdgeCrossesIndicator();
            return (int)(compareValue * 1000.0);
        }
    }
}

