/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.mascopt;

import com.hp.hpl.guess.DirectedEdge;
import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Node;
import java.util.HashMap;
import java.util.Vector;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.algos.digraph.KShortestPaths;
import mascoptLib.graphs.Arc;
import mascoptLib.graphs.ArcSet;
import mascoptLib.graphs.DiGraph;
import mascoptLib.graphs.Vertex;
import mascoptLib.graphs.VertexSet;

public class MascoptDiGraphProxy
extends DiGraph {
    public HashMap g2m = new HashMap();
    public HashMap m2g = new HashMap();

    public static MascoptDiGraphProxy createProxy(Graph g) {
        HashMap<GraphElement, Object> g2m = new HashMap<GraphElement, Object>();
        HashMap<Object, GraphElement> m2g = new HashMap<Object, GraphElement>();
        VertexSet vs = new VertexSet();
        for (Node node : g.getNodes()) {
            Vertex v = (Vertex)g2m.get(node);
            if (v == null) {
                v = new Vertex();
                g2m.put(node, v);
                m2g.put(v, node);
            }
            vs.add(v);
        }
        ArcSet as = new ArcSet(vs);
        as.setValue("poids", "1");
        KShortestPaths.NAME_OF_VALUE = "poids";
        for (Edge e : g.getEdges()) {
            double weight = (Double)e.__getattr__("weight");
            if (g2m.containsKey(e)) {
                Object o = g2m.get(e);
                if (o instanceof Arc) {
                    ((Arc)o).setDouValue("poids", weight);
                    as.add((Arc)o);
                    continue;
                }
                Arc[] aset = (Arc[])o;
                Arc a1 = aset[0];
                Arc a2 = aset[1];
                a1.setDouValue("poids", weight);
                as.add(a1);
                a2.setDouValue("poids", weight);
                as.add(a2);
                continue;
            }
            if (e instanceof DirectedEdge) {
                Vertex head = (Vertex)g2m.get(((DirectedEdge)e).getDestination());
                Vertex tail = (Vertex)g2m.get(((DirectedEdge)e).getSource());
                Arc a = new Arc((AbstractVertex)tail, (AbstractVertex)head);
                a.setDouValue("poids", weight);
                System.out.println(a + " " + weight);
                g2m.put(e, a);
                m2g.put(a, e);
                as.add(a);
                continue;
            }
            Arc[] aset = new Arc[2];
            Vertex head = (Vertex)g2m.get(e.getNode1());
            Vertex tail = (Vertex)g2m.get(e.getNode2());
            Arc a1 = new Arc((AbstractVertex)tail, (AbstractVertex)head);
            a1.setDouValue("poids", weight);
            aset[0] = a1;
            Arc a2 = new Arc((AbstractVertex)head, (AbstractVertex)tail);
            a2.setDouValue("poids", weight);
            aset[0] = a2;
            g2m.put(e, aset);
            m2g.put(a1, e);
            m2g.put(a2, e);
            as.add(a1);
            as.add(a2);
        }
        MascoptDiGraphProxy toRet = new MascoptDiGraphProxy(vs, as);
        toRet.m2g = m2g;
        toRet.g2m = g2m;
        return toRet;
    }

    public MascoptDiGraphProxy(VertexSet vs, ArcSet as) {
        super(vs, as);
    }

    public Vector kShortestPaths(int k, Node s, Node t) {
        return this.kShortestPaths(k, s, t, null);
    }

    public Vector kShortestPaths(int k, Node s, Node t, HashMap weights) {
        Vector paths = new Vector();
        KShortestPaths ksp = new KShortestPaths((DiGraph)this, k);
        ksp.run((Vertex)this.g2m.get(s), (Vertex)this.g2m.get(t));
        for (int i = 0; i < ksp.numberOfComputedPaths(); ++i) {
            ArcSet as = ksp.getShortestPath(i).getArcSet();
            Vector path = new Vector();
            for (Arc a : as) {
                path.add(this.m2g.get(a));
            }
            paths.add(path);
            if (weights == null) continue;
            weights.put(path, new Double(ksp.getWeight(i)));
        }
        return paths;
    }
}

