/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.pajek;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Graph;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.ui.Colors;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashSet;
import java.util.Random;
import java.util.Vector;

public class GuessPajekReader {
    private static Random rand = new Random();
    private static HashSet shapes = new HashSet();
    private static Vector nds = new Vector();

    public static void readFile(Graph g, String filename) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(filename));
            boolean vert = false;
            boolean edges = false;
            boolean arcs = false;
            boolean partition = false;
            int nodes = -1;
            String part_name = "";
            int partIndex = -1;
            while (br.ready()) {
                String line = br.readLine();
                if ((line = line.trim()).equals("")) continue;
                if (line.startsWith("*Vertices")) {
                    if (partition) continue;
                    vert = true;
                    edges = false;
                    arcs = false;
                    partition = false;
                    int space = (int)Math.max((double)line.lastIndexOf(32), (double)line.lastIndexOf(9));
                    nodes = Integer.parseInt(line.substring(space + 1));
                    continue;
                }
                if (line.startsWith("*Arcs")) {
                    vert = false;
                    edges = false;
                    arcs = true;
                    partition = false;
                    continue;
                }
                if (line.startsWith("*Edges")) {
                    vert = false;
                    edges = true;
                    arcs = false;
                    partition = false;
                    continue;
                }
                if (line.startsWith("*Partition")) {
                    vert = false;
                    edges = false;
                    arcs = false;
                    partition = true;
                    partIndex = -1;
                    int space = (int)Math.max((double)line.lastIndexOf(32), (double)line.lastIndexOf(9));
                    part_name = line.substring(space + 1);
                    g.addNodeField(part_name, -7, Boolean.FALSE);
                    continue;
                }
                if (vert) {
                    GuessPajekReader.processVert(g, line);
                    continue;
                }
                if (edges) {
                    GuessPajekReader.processEdge(g, line, false);
                    continue;
                }
                if (arcs) {
                    GuessPajekReader.processEdge(g, line, true);
                    continue;
                }
                if (!partition) continue;
                Node n = (Node)nds.elementAt(++partIndex);
                if (!line.startsWith("1")) continue;
                n.__setattr__(part_name, Boolean.TRUE);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void processVert(Graph g, String line) {
        int quoteS = line.indexOf("\"");
        int quoteE = line.lastIndexOf("\"");
        String label = null;
        String id = null;
        String[] rest = null;
        int pointer = 0;
        if (quoteS != quoteE) {
            label = line.substring(quoteS + 1, quoteE);
            String[] result = line.split("\\s+");
            id = result[0];
            line = line.substring(quoteE + 1, line.length()).trim();
            rest = line.split("\\s+");
        } else {
            rest = line.split("\\s+");
            id = rest[0];
            label = rest[1];
            pointer = 2;
        }
        double x = rand.nextDouble() * 1000.0;
        double y = rand.nextDouble() * 1000.0;
        if (rest.length > pointer) {
            try {
                x = 1000.0 * Double.parseDouble(rest[pointer]);
                y = 1000.0 * Double.parseDouble(rest[pointer + 1]);
                pointer += 2;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (rest.length > pointer) {
            try {
                double whatisthis = Double.parseDouble(rest[pointer]);
                ++pointer;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        String shape = "circle";
        if (rest.length > pointer && shapes.contains((shape = rest[pointer]).toLowerCase())) {
            ++pointer;
        }
        double s_size = 10.0;
        double x_fact = 1.0;
        double y_fact = 1.0;
        boolean rounded = false;
        String color = "cornflowerblue";
        String labelcolor = null;
        for (int i = pointer; i < rest.length - 1; i += 2) {
            String key = rest[i].toLowerCase();
            String value = rest[i + 1];
            if (key.equals("x_fact")) {
                x_fact = Double.parseDouble(value);
                continue;
            }
            if (key.equals("y_fact")) {
                y_fact = Double.parseDouble(value);
                continue;
            }
            if (key.equals("sh")) {
                shape = value;
                continue;
            }
            if (key.equals("r")) {
                if (value.equals("0")) continue;
                rounded = true;
                continue;
            }
            if (key.equals("phi") || key.equals("q")) continue;
            if (key.equals("ic")) {
                color = value;
                continue;
            }
            if (key.equals("bc") || key.equals("bw")) continue;
            if (key.equals("lc")) {
                labelcolor = value;
                continue;
            }
            if (!key.equals("la") && !key.equals("lr") && !key.equals("lphi") && !key.equals("fos") && !key.equals("font") && !key.equals("hooks")) continue;
        }
        double width = s_size * x_fact;
        double height = s_size * y_fact;
        int style = 2;
        if (shape.equals("box")) {
            style = 1;
            if (rounded) {
                style = 3;
            }
        } else if (shape.equals("ellipse")) {
            style = 2;
        }
        Node n = g.addNode("pajek" + id);
        n.__setattr__("style", new Integer(style));
        n.__setattr__("x", new Double(x));
        n.__setattr__("y", new Double(y));
        n.__setattr__("width", new Double(width));
        n.__setattr__("height", new Double(height));
        n.__setattr__("color", color);
        n.__setattr__("strokecolor", "cadetblue");
        n.__setattr__("label", label);
        nds.addElement(n);
    }

    public static void processEdge(Graph g, String line, boolean directed) {
        Node t;
        String[] rest = line.split("\\s+");
        String source = "pajek" + rest[0];
        String target = "pajek" + rest[1];
        Node s = g.getNodeByName(source);
        if (s == null) {
            s = g.addNode(source);
        }
        if ((t = g.getNodeByName(target)) == null) {
            t = g.addNode(target);
        }
        String label = null;
        Edge e = null;
        e = directed ? g.addDirectedEdge(s, t) : g.addUndirectedEdge(s, t);
        double weight = 1.0;
        int pointer = 2;
        if (rest.length > pointer) {
            try {
                weight = Double.parseDouble(rest[pointer]);
                ++pointer;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        String color = "dandelion";
        String labelcolor = null;
        double width = 2.0;
        for (int i = pointer; i < rest.length - 1; i += 2) {
            int j;
            String key = rest[i].toLowerCase();
            String value = rest[i + 1];
            if (key.equals("c")) {
                color = value;
                continue;
            }
            if (key.equals("width")) {
                width = Double.parseDouble(value);
                continue;
            }
            if (key.equals("lc")) {
                labelcolor = value;
                continue;
            }
            if (key.equals("l")) {
                if (!value.startsWith("\"") || value.endsWith("\"")) continue;
                j = 2;
                value = rest[i + j];
                while (!value.endsWith("\"")) {
                    value = rest[i + ++j];
                }
                i += j - 1;
                continue;
            }
            if (!key.equals("label")) continue;
            if (value.startsWith("\"")) {
                if (value.endsWith("\"")) {
                    label = value.substring(1, value.length() - 1);
                    continue;
                }
                label = value.substring(1, value.length());
                j = 2;
                value = rest[i + j];
                while (!value.endsWith("\"")) {
                    label = label + " " + value;
                    value = rest[i + ++j];
                }
                label = label + " " + value.substring(0, value.length() - 1);
                i += j - 1;
                continue;
            }
            label = value;
        }
        e.__setattr__("width", new Double(width));
        e.__setattr__("color", Colors.getColor(color, Color.darkGray));
        e.__setattr__("weight", new Double(weight));
        if (label != null) {
            e.__setattr__("label", label);
        }
    }

    public static void main(String[] args) {
        GuessPajekReader.readFile(null, args[0]);
    }

    static {
        shapes.add("box");
        shapes.add("ellipse");
        shapes.add("triangle");
    }
}

