/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.ui.VisFactory;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.HashMap;

public class Arrow {
    public static final int CLASSIC = 1;
    public static final int SLEEK = 2;
    protected static int m_arrowLength = -1;
    protected static int m_arrowWidth = -1;
    static HashMap arrowCache = new HashMap();
    static GeneralPath classic = Arrow.getClassicArrow();

    public static void overrideArrowLength(int length) {
        m_arrowLength = length;
        VisFactory.getFactory().getDisplay().repaint();
    }

    public static void overrideArrowWidth(int width) {
        m_arrowWidth = width;
        VisFactory.getFactory().getDisplay().repaint();
    }

    public static double distance(Point2D p1, Point2D p2) {
        return Math.sqrt(Math.pow(p1.getX() - p2.getX(), 2.0) + Math.pow(p1.getY() - p2.getY(), 2.0));
    }

    public static double getArrowLength(double x1, double y1, double x2, double y2, double width) {
        double dist;
        int m_arrowLength = Arrow.m_arrowLength;
        if (m_arrowLength < 0) {
            m_arrowLength = (int)Math.max(4.0, width * 2.0);
        }
        if ((double)m_arrowLength > (dist = Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0))) / 2.0) {
            m_arrowLength = (int)(dist / 2.0);
        }
        return m_arrowLength;
    }

    public static void drawArrow(Graphics2D g2d, Point2D point1, Point2D point2, int type, double width) {
        double dist;
        int m_arrowLength;
        int m_arrowWidth = Arrow.m_arrowWidth;
        if (m_arrowWidth < 0) {
            m_arrowWidth = (int)Math.max(2.0, width * 4.0);
        }
        if ((m_arrowLength = Arrow.m_arrowLength) < 0) {
            m_arrowLength = (int)Math.max(4.0, width * 2.0);
        }
        if ((double)m_arrowLength > (dist = Arrow.distance(point1, point2)) / 2.0) {
            m_arrowLength = (int)(dist / 2.0);
        }
        double thetaRadians = Math.atan2(point1.getY() - point2.getY(), point1.getX() - point2.getX()) + Math.PI;
        AffineTransform at = new AffineTransform();
        at.translate(point2.getX(), point2.getY());
        at.rotate(thetaRadians);
        Shape arrow = null;
        arrow = type == 2 ? at.createTransformedShape(Arrow.getSleekArrow(m_arrowWidth, m_arrowLength)) : at.createTransformedShape(classic);
        g2d.fill(arrow);
    }

    protected static GeneralPath getSleekArrow(int m_arrowWidth, int m_arrowLength) {
        Dimension d = new Dimension(m_arrowWidth, m_arrowLength);
        if (arrowCache.containsKey(d)) {
            return (GeneralPath)arrowCache.get(d);
        }
        GeneralPath arrowhead = new GeneralPath();
        float distance = 0.0f;
        int width = (int)((float)m_arrowWidth / 2.0f);
        arrowhead.moveTo(0.0f, 0.0f);
        arrowhead.lineTo(-m_arrowLength, width);
        arrowhead.lineTo(-m_arrowLength, -width);
        arrowhead.lineTo(0.0f, 0.0f);
        arrowCache.put(d, arrowhead);
        return arrowhead;
    }

    protected static GeneralPath getClassicArrow() {
        GeneralPath arrowhead = new GeneralPath();
        float distance = 0.0f;
        int width = (int)((float)m_arrowWidth / 2.0f);
        arrowhead.moveTo(distance, 0.0f);
        arrowhead.lineTo(distance - (float)m_arrowLength, width);
        arrowhead.lineTo(distance - (float)m_arrowLength, -width);
        arrowhead.lineTo(distance, 0.0f);
        return arrowhead;
    }
}

