/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.piccolo.GuessPNode;
import com.hp.hpl.guess.ui.Colors;
import com.hp.hpl.guess.ui.ConvexHull;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class ConvexHullNode
extends PPath
implements ConvexHull {
    public static final int REGULAR = 0;
    public static final int ROUNDED_RECTANGLE = 1;
    public static final int RECTANGLE = 2;
    public static final int ELLIPSE = 3;
    ArrayList nodes = null;
    Color myColor = null;
    private boolean dirtyBit = true;
    private boolean frozen = false;
    private float[] x3Points = null;
    private float[] y3Points = null;
    private int style = 0;
    static HullComp hc = new HullComp();

    public float[] getX3() {
        return this.x3Points;
    }

    public float[] getY3() {
        return this.y3Points;
    }

    public void setFrozen(boolean state) {
        this.frozen = state;
        if (!this.frozen) {
            this.refreshHull();
        }
    }

    public String toString() {
        if (this.nodes == null) {
            return null;
        }
        return "hull:" + this.nodes.toString();
    }

    public ConvexHullNode(Collection nds, Color c) {
        Iterator it = nds.iterator();
        while (it.hasNext()) {
            GuessPNode gpn = (GuessPNode)((Node)it.next()).getRep();
            gpn.addHullListener(this);
        }
        this.nodes = new ArrayList(nds.size());
        this.nodes.addAll(nds);
        this.myColor = c;
        this.refreshHull();
    }

    @Override
    public void addNodes(Collection s) {
        Iterator it = s.iterator();
        while (it.hasNext()) {
            GuessPNode gpn = (GuessPNode)((Node)it.next()).getRep();
            gpn.addHullListener(this);
        }
        this.nodes.addAll(s);
        this.refreshHull();
    }

    @Override
    public void removeNodes(Collection s) {
        Iterator it = s.iterator();
        while (it.hasNext()) {
            GuessPNode gpn = (GuessPNode)((Node)it.next()).getRep();
            gpn.removeHullListener(this);
        }
        this.nodes.removeAll(s);
        this.refreshHull();
    }

    @Override
    public void addNode(Node n) {
        this.nodes.add(n);
        GuessPNode gpn = (GuessPNode)n.getRep();
        gpn.addHullListener(this);
        this.refreshHull();
    }

    @Override
    public void removeNode(Node n) {
        this.nodes.remove(n);
        GuessPNode gpn = (GuessPNode)n.getRep();
        gpn.removeHullListener(this);
        this.refreshHull();
    }

    public void destroyHull() {
        this.removeFromParent();
        Iterator it = this.nodes.iterator();
        while (it.hasNext()) {
            GuessPNode gpn = (GuessPNode)((Node)it.next()).getRep();
            gpn.removeHullListener(this);
        }
        this.nodes.clear();
    }

    @Override
    public Collection getNodes() {
        return this.nodes;
    }

    @Override
    public void setColor(Object color) {
        this.myColor = color instanceof Color ? (Color)color : Colors.getColor((String)color, (Color)this.getPaint());
        super.setPaint((Paint)this.myColor);
    }

    @Override
    public String getColor() {
        return Colors.toString(this.myColor);
    }

    public void setStyle(int style) {
        if (this.style != style) {
            this.style = style;
            this.dirtyBit = true;
            this.refreshHull();
        }
    }

    private void refreshHull() {
        if (this.dirtyBit) {
            Node[] hull = ConvexHullNode.convexHull(this.nodes);
            if (hull == null || hull.length == 0) {
                return;
            }
            if (this.style == 0) {
                this.x3Points = new float[hull.length];
                this.y3Points = new float[hull.length];
                for (int i = 0; i < hull.length; ++i) {
                    Node gn = hull[i];
                    this.x3Points[i] = (float)ConvexHullNode.getNodeX(gn);
                    this.y3Points[i] = (float)ConvexHullNode.getNodeY(gn);
                }
                this.setPathToPolyline(this.x3Points, this.y3Points);
            } else {
                double minx = Double.MAX_VALUE;
                double miny = Double.MAX_VALUE;
                double maxx = Double.MIN_VALUE;
                double maxy = Double.MIN_VALUE;
                for (int i = 0; i < hull.length; ++i) {
                    Node gn = hull[i];
                    minx = Math.min(minx, ConvexHullNode.getNodeX(gn));
                    miny = Math.min(miny, ConvexHullNode.getNodeY(gn));
                    maxx = Math.max(maxx, ConvexHullNode.getNodeX(gn));
                    maxy = Math.max(maxy, ConvexHullNode.getNodeY(gn));
                }
                minx -= 10.0;
                miny -= 10.0;
                maxx += 10.0;
                maxy += 10.0;
                if (this.style == 1) {
                    this.setPathTo(new RoundRectangle2D.Double(minx, miny, maxx - minx, maxy - miny, 15.0, 15.0));
                } else if (this.style == 2) {
                    this.setPathTo(new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny));
                } else {
                    this.setPathTo(new Ellipse2D.Double(minx, miny, maxx - minx, maxy - miny));
                }
            }
            this.setPaint(this.myColor);
            this.setStrokePaint(null);
            this.repaint();
            this.dirtyBit = false;
        }
    }

    public void nodeMoved(PNode moved) {
        this.dirtyBit = true;
        if (!this.frozen) {
            this.refreshHull();
        }
    }

    private static double getNodeY(Node n) {
        return n.getY() + n.getHeight() / 2.0;
    }

    private static double getNodeX(Node n) {
        return n.getX() + n.getWidth() / 2.0;
    }

    public static Node[] convexHull(List nodes) {
        HullNode hn;
        int i;
        if (nodes.size() <= 2) {
            return null;
        }
        Node min = (Node)nodes.get(0);
        Vector<HullNode> v = new Vector<HullNode>();
        for (i = 1; i < nodes.size(); ++i) {
            Node g = (Node)nodes.get(i);
            if (!((PNode)g.getRep()).getVisible() || !(ConvexHullNode.getNodeY(g) < ConvexHullNode.getNodeY(min))) continue;
            min = g;
        }
        for (i = 0; i < nodes.size(); ++i) {
            Node gi = (Node)nodes.get(i);
            if (!((PNode)gi.getRep()).getVisible() || min == gi) continue;
            double angle = Math.atan2(ConvexHullNode.getNodeX(gi) - ConvexHullNode.getNodeX(min), ConvexHullNode.getNodeY(gi) - ConvexHullNode.getNodeY(min));
            hn = new HullNode();
            hn.n = gi;
            hn.angle = angle;
            v.addElement(hn);
        }
        Collections.sort(v, hc);
        for (i = 0; i < v.size(); ++i) {
            HullNode hn2 = (HullNode)v.elementAt(i);
        }
        Stack<HullNode> s = new Stack<HullNode>();
        HullNode minhn = new HullNode();
        minhn.n = min;
        minhn.angle = 0.0;
        s.push(minhn);
        if (v.size() < 2) {
            return null;
        }
        s.push((HullNode)v.elementAt(0));
        s.push((HullNode)v.elementAt(1));
        for (int i2 = 2; i2 < v.size(); ++i2) {
            HullNode pi = (HullNode)v.elementAt(i2);
            HullNode top = null;
            HullNode nexttotop = null;
            if (!s.isEmpty()) {
                top = (HullNode)s.pop();
            }
            if (!s.isEmpty()) {
                nexttotop = (HullNode)s.peek();
            }
            if (top == null || nexttotop == null) break;
            s.push(top);
            while (ConvexHullNode.isLeft(pi, top, nexttotop)) {
                s.pop();
                if (s.isEmpty()) break;
                top = (HullNode)s.pop();
                if (s.isEmpty()) {
                    s.push(top);
                    break;
                }
                nexttotop = (HullNode)s.peek();
                s.push(top);
            }
            s.push(pi);
        }
        Node[] toRet = new Node[s.size()];
        int i3 = 0;
        while (!s.isEmpty()) {
            hn = (HullNode)s.pop();
            toRet[i3] = hn.n;
            ++i3;
        }
        return toRet;
    }

    public static boolean isLeft(HullNode p0, HullNode p1, HullNode p2) {
        double x = (ConvexHullNode.getNodeX(p1.n) - ConvexHullNode.getNodeX(p0.n)) * (ConvexHullNode.getNodeY(p2.n) - ConvexHullNode.getNodeY(p0.n)) - (ConvexHullNode.getNodeX(p2.n) - ConvexHullNode.getNodeX(p0.n)) * (ConvexHullNode.getNodeY(p1.n) - ConvexHullNode.getNodeY(p0.n));
        return x > 0.0;
    }

    static class HullComp
    implements Comparator {
        HullComp() {
        }

        public int compare(Object o1, Object o2) {
            if (((HullNode)o1).angle < ((HullNode)o2).angle) {
                return 1;
            }
            if (((HullNode)o1).angle > ((HullNode)o2).angle) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return true;
        }
    }

    public static class HullNode {
        Node n;
        double angle = 0.0;
    }
}

