/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.piccolo;

import com.hp.hpl.guess.piccolo.GFrame;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;

public class CursorFactory {
    private static GFrame frame = null;
    public static final int STANDARD = 1;
    public static final int ZOOM = 2;
    public static final int MOVE = 3;
    private static Cursor normalC = new Cursor(0);
    private static Cursor moveC = new Cursor(13);
    private static Cursor zoomC = new Cursor(13);

    private CursorFactory() {
    }

    public static void init(GFrame f) {
        frame = f;
    }

    public static void setCursor(int ctype) {
        if (frame != null) {
            if (ctype == 2) {
                frame.setCursor(zoomC);
            } else if (ctype == 3) {
                frame.setCursor(moveC);
            } else {
                frame.setCursor(normalC);
            }
        }
    }

    public static Cursor getCursor(int id) {
        if (id == 1) {
            return normalC;
        }
        if (id == 2) {
            return zoomC;
        }
        if (id == 3) {
            return moveC;
        }
        return null;
    }

    static {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getBestCursorSize(32, 32);
        int colors = tk.getMaximumCursorColors();
        if (!d.equals(new Dimension(0, 0)) && colors != 0) {
            CursorFactory c = new CursorFactory();
            URL uImage = c.getClass().getResource("/images/zoom.gif");
            Image image = tk.getImage(uImage);
            if (image != null) {
                try {
                    zoomC = tk.createCustomCursor(image, new Point(16, 16), "crosshair cursor");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((image = tk.getImage(uImage = c.getClass().getResource("/images/move.gif"))) != null) {
                try {
                    moveC = tk.createCustomCursor(image, new Point(16, 16), "crosshair cursor");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

